/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.jobs;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sakaiproject.api.app.scheduler.ScheduledInvocationCommand;
import org.sakaiproject.delegatedaccess.dao.DelegatedAccessDao;
import org.sakaiproject.delegatedaccess.logic.ProjectLogic;
import org.sakaiproject.delegatedaccess.logic.SakaiProxy;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedAccessAddToolToMyWorkspacesJob
implements ScheduledInvocationCommand {
    private static final Logger log = LoggerFactory.getLogger(DelegatedAccessAddToolToMyWorkspacesJob.class);
    private DelegatedAccessDao dao;
    private ProjectLogic projectLogic;
    private SakaiProxy sakaiProxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String nodeId) {
        log.info("DelegatedAccessAddToolToMyWorkspacesJob started");
        long startTime = System.currentTimeMillis();
        List<String> userIds = this.dao.getDelegatedAccessUsers();
        if (userIds != null) {
            ArrayList<String> userWorkspaceIds = new ArrayList<String>();
            for (String string : userIds) {
                if ("120dv0f43cv90sdf0asv9".equals(string) || "777dv0f43bd90sdf012uf".equals(string)) continue;
                userWorkspaceIds.add("~" + string);
            }
            List<String> sitesWithDelegatedAccess = this.dao.getSitesWithDelegatedAccessTool(userWorkspaceIds.toArray(new String[userWorkspaceIds.size()]));
            for (String string : sitesWithDelegatedAccess) {
                userWorkspaceIds.remove(string);
            }
            String string = this.sakaiProxy.getCurrentUserId();
            try {
                for (String siteId : userWorkspaceIds) {
                    this.sakaiProxy.setSessionUserId(siteId.substring(1));
                    Site workspace = this.sakaiProxy.getSiteById(siteId);
                    if (workspace == null) continue;
                    SitePage page = workspace.addPage();
                    page.addTool("sakai.delegatedaccess");
                    ToolConfiguration tool = workspace.getToolForCommonId("sakai.su");
                    if (tool == null && this.projectLogic.hasAllowBecomeUserPerm(siteId.substring(1))) {
                        SitePage suPage = workspace.addPage();
                        suPage.addTool("sakai.su");
                    }
                    this.sakaiProxy.saveSite(workspace);
                }
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
            finally {
                this.sakaiProxy.setSessionUserId(string);
            }
        }
        this.projectLogic.updateAddDAMyworkspaceJobStatus("" + new Date().getTime());
        log.info("DelegatedAccessAddToolToMyWorkspacesJob finished in " + (System.currentTimeMillis() - startTime) + " ms");
    }

    public DelegatedAccessDao getDao() {
        return this.dao;
    }

    public void setDao(DelegatedAccessDao dao) {
        this.dao = dao;
    }

    public ProjectLogic getProjectLogic() {
        return this.projectLogic;
    }

    public void setProjectLogic(ProjectLogic projectLogic) {
        this.projectLogic = projectLogic;
    }

    public SakaiProxy getSakaiProxy() {
        return this.sakaiProxy;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }
}

