/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.logic;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import org.sakaiproject.api.app.scheduler.DelayedInvocation;
import org.sakaiproject.api.app.scheduler.ScheduledInvocationManager;
import org.sakaiproject.delegatedaccess.dao.DelegatedAccessDao;
import org.sakaiproject.delegatedaccess.logic.ProjectLogic;
import org.sakaiproject.delegatedaccess.logic.SakaiProxy;
import org.sakaiproject.delegatedaccess.model.AccessNode;
import org.sakaiproject.delegatedaccess.model.AccessSearchResult;
import org.sakaiproject.delegatedaccess.model.HierarchyNodeSerialized;
import org.sakaiproject.delegatedaccess.model.ListOptionSerialized;
import org.sakaiproject.delegatedaccess.model.NodeModel;
import org.sakaiproject.delegatedaccess.model.SearchResult;
import org.sakaiproject.delegatedaccess.model.SiteSearchResult;
import org.sakaiproject.delegatedaccess.model.SiteSerialized;
import org.sakaiproject.delegatedaccess.util.DelegatedAccessConstants;
import org.sakaiproject.delegatedaccess.util.DelegatedAccessMutableTreeNode;
import org.sakaiproject.hierarchy.HierarchyService;
import org.sakaiproject.hierarchy.model.HierarchyNode;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.memory.api.MemoryService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.user.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectLogicImpl
implements ProjectLogic {
    private static final Logger log = LoggerFactory.getLogger(ProjectLogicImpl.class);
    private SakaiProxy sakaiProxy;
    private HierarchyService hierarchyService;
    private DelegatedAccessDao dao;
    private MemoryService memoryService;
    private Cache nodeCache;
    private Cache restrictedAuthToolsCache;
    private ScheduledInvocationManager scheduledInvocationManager;
    private TimeService timeService;
    private Cache restrictedPublicToolsCache;
    private Cache hierarchySearchCache;
    private List<String> accessNodes = new ArrayList<String>();
    private List<String> shoppingPeriodAdminNodes = new ArrayList<String>();
    private List<String> accessAdminNodes = new ArrayList<String>();

    public void init() {
        log.info("init");
        this.nodeCache = this.memoryService.newCache("org.sakaiproject.delegatedaccess.logic.ProjectLogic.nodeCache");
        this.restrictedAuthToolsCache = this.memoryService.newCache("org.sakaiproject.delegatedaccess.logic.ProjectLogic.restrictedAuthToolsCache");
        this.restrictedPublicToolsCache = this.memoryService.newCache("org.sakaiproject.delegatedaccess.logic.ProjectLogic.restrictedPublicToolsCache");
        this.hierarchySearchCache = this.memoryService.newCache("org.sakaiproject.delegatedaccess.logic.ProjectLogic.hierarchySearchCache");
    }

    public HierarchyNodeSerialized getNode(String id) {
        return new HierarchyNodeSerialized(this.hierarchyService.getNodeById(id));
    }

    public Map<String, HierarchyNodeSerialized> getNodes(String[] ids) {
        HashMap<String, HierarchyNodeSerialized> returnNodes = new HashMap<String, HierarchyNodeSerialized>();
        Map nodes = this.hierarchyService.getNodesByIds(ids);
        for (Map.Entry entry : nodes.entrySet()) {
            returnNodes.put((String)entry.getKey(), new HierarchyNodeSerialized((HierarchyNode)entry.getValue()));
        }
        return returnNodes;
    }

    public void updateNodePermissionsForUser(DefaultMutableTreeNode node, String userId) {
        this.updateNodePermissionsForUser((NodeModel)node.getUserObject(), userId);
    }

    public void updateNodePermissionsForUser(NodeModel nodeModel, String userId) {
        this.removeAllUserPermissions(nodeModel.getNodeId(), userId);
        this.saveAccessAdmin(nodeModel.isAccessAdmin(), nodeModel.getNodeId(), userId);
        this.saveShoppingPeriodAdmin(nodeModel.isShoppingPeriodAdmin(), nodeModel.getNodeId(), userId);
        if (nodeModel.isDirectAccess()) {
            this.hierarchyService.assignUserNodePerm(userId, nodeModel.getNodeId(), "site.visit", false);
            this.saveRealmAndRoleAccess(userId, nodeModel.getRealm(), nodeModel.getRole(), nodeModel.getNodeId());
            ArrayList<String> restrictedAuthTools = new ArrayList<String>();
            for (ListOptionSerialized tool : nodeModel.getRestrictedAuthTools()) {
                if (!tool.isSelected()) continue;
                restrictedAuthTools.add(tool.getId());
            }
            if (!restrictedAuthTools.isEmpty()) {
                this.saveRestrictedAuthToolsForUser(userId, nodeModel.getNodeId(), restrictedAuthTools);
            }
            ArrayList<String> restrictedPublicTools = new ArrayList<String>();
            for (ListOptionSerialized tool : nodeModel.getRestrictedPublicTools()) {
                if (!tool.isSelected()) continue;
                restrictedPublicTools.add(tool.getId());
            }
            if (!restrictedPublicTools.isEmpty()) {
                this.saveRestrictedPublicToolsForUser(userId, nodeModel.getNodeId(), restrictedPublicTools);
            }
            if (nodeModel.isInstructorEdited()) {
                this.saveInstructorEdited(nodeModel.isInstructorEdited(), userId, nodeModel.getNodeId());
            }
            if ("120dv0f43cv90sdf0asv9".equals(userId)) {
                this.saveShoppingPeriodStartDate(nodeModel.getShoppingPeriodStartDate(), nodeModel.getNodeId());
                this.saveShoppingPeriodEndDate(nodeModel.getShoppingPeriodEndDate(), nodeModel.getNodeId());
                this.saveShoppingPeriodRevokeInstructorEditable(nodeModel.isShoppingPeriodRevokeInstructorEditable(), nodeModel.getNodeId());
                this.saveShoppingPeriodRevokeInstructorPublicOpt(nodeModel.isShoppingPeriodRevokeInstructorPublicOpt(), nodeModel.getNodeId());
            } else {
                this.saveAllowBecomeUser(nodeModel.isAllowBecomeUser(), userId, nodeModel.getNodeId());
            }
        }
        if (nodeModel.isDirectAccess() || nodeModel.isShoppingPeriodAdmin() || nodeModel.isAccessAdmin()) {
            this.saveModifiedData(userId, nodeModel.getNodeId());
            this.sakaiProxy.postEvent("dac.nodeperms.modified", "/user/" + userId + "/node/" + nodeModel.getNodeId() + "/realm/" + nodeModel.getRealm() + "/role/" + nodeModel.getRole(), true);
        }
        if (nodeModel.isDirectAccess() != nodeModel.isDirectAccessOrig()) {
            if (nodeModel.isDirectAccess()) {
                this.sakaiProxy.postEvent("dac.nodeperms.add", "/user/" + userId + "/node/" + nodeModel.getNodeId() + "/realm/" + nodeModel.getRealm() + "/role/" + nodeModel.getRole(), true);
            } else {
                this.sakaiProxy.postEvent("dac.nodeperms.delete", "/user/" + userId + "/node/" + nodeModel.getNodeId(), true);
            }
        }
        if (!"120dv0f43cv90sdf0asv9".equals(userId) && nodeModel.isShoppingPeriodAdmin() != nodeModel.isShoppingPeriodAdminOrig()) {
            this.saveShoppingPeriodAdminModifiedData(userId, nodeModel.getNodeId());
            if (nodeModel.isShoppingPeriodAdmin()) {
                this.sakaiProxy.postEvent("dac.shoppingAdmin.add", "/user/" + userId + "/node/" + nodeModel.getNodeId(), true);
            } else {
                this.sakaiProxy.postEvent("dac.shoppingAdmin.delete", "/user/" + userId + "/node/" + nodeModel.getNodeId(), true);
            }
        } else if (!"120dv0f43cv90sdf0asv9".equals(userId) && nodeModel.getShoppingAdminModified() != null && (nodeModel.isDirectAccess() || nodeModel.isShoppingPeriodAdmin() || nodeModel.isAccessAdmin())) {
            this.hierarchyService.assignUserNodePerm(userId, nodeModel.getNodeId(), "shoppingAdminModified:" + nodeModel.getShoppingAdminModified().getTime(), false);
            this.hierarchyService.assignUserNodePerm(userId, nodeModel.getNodeId(), "shoppingAdminModifiedBy:" + nodeModel.getShoppingAdminModifiedBy(), false);
        }
        if (nodeModel.isAccessAdmin() != nodeModel.isAccessAdminOrig()) {
            if (nodeModel.isAccessAdmin()) {
                this.sakaiProxy.postEvent("dac.accessAdmin.add", "/user/" + userId + "/node/" + nodeModel.getNodeId(), true);
            } else {
                this.sakaiProxy.postEvent("dac.accessAdmin.delete", "/user/" + userId + "/node/" + nodeModel.getNodeId(), true);
            }
        }
        if ("120dv0f43cv90sdf0asv9".equals(userId)) {
            DelayedInvocation[] fdi = this.scheduledInvocationManager.findDelayedInvocations("org.sakaiproject.delegatedaccess.jobs.DelegatedAccessShoppingPeriodJob", nodeModel.getNode().id);
            if (fdi != null && fdi.length > 0) {
                for (DelayedInvocation d : fdi) {
                    this.scheduledInvocationManager.deleteDelayedInvocation(d.uuid);
                }
            }
            this.scheduledInvocationManager.createDelayedInvocation(this.timeService.newTime(), "org.sakaiproject.delegatedaccess.jobs.DelegatedAccessShoppingPeriodJob", nodeModel.getNode().id);
        }
    }

    private void saveShoppingPeriodAdmin(boolean admin, String nodeId, String userId) {
        if (admin && !"120dv0f43cv90sdf0asv9".equals(userId)) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "shoppingAdmin", false);
        }
    }

    private void saveAccessAdmin(boolean accessAdmin, String nodeId, String userId) {
        if (accessAdmin && !"120dv0f43cv90sdf0asv9".equals(userId)) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "accessAdmin", false);
        }
    }

    private void saveShoppingPeriodAdminModifiedData(String userId, String nodeId) {
        this.hierarchyService.assignUserNodePerm(userId, nodeId, "shoppingAdminModified:" + new Date().getTime(), false);
        this.hierarchyService.assignUserNodePerm(userId, nodeId, "shoppingAdminModifiedBy:" + this.sakaiProxy.getCurrentUserId(), false);
    }

    private void saveModifiedData(String userId, String nodeId) {
        this.hierarchyService.assignUserNodePerm(userId, nodeId, "modified:" + new Date().getTime(), false);
        this.hierarchyService.assignUserNodePerm(userId, nodeId, "modifiedBy:" + this.sakaiProxy.getCurrentUserId(), false);
    }

    private void saveShoppingPeriodStartDate(Date startDate, String nodeId) {
        if (startDate != null) {
            this.hierarchyService.assignUserNodePerm("120dv0f43cv90sdf0asv9", nodeId, "shoppingStartDate:" + startDate.getTime(), false);
        }
    }

    private void saveShoppingPeriodEndDate(Date endDate, String nodeId) {
        if (endDate != null) {
            this.hierarchyService.assignUserNodePerm("120dv0f43cv90sdf0asv9", nodeId, "shoppingEndDate:" + endDate.getTime(), false);
        }
    }

    private void saveShoppingPeriodRevokeInstructorEditable(boolean shoppingPeriodRevokeInstructorEditable, String nodeId) {
        if (shoppingPeriodRevokeInstructorEditable) {
            this.hierarchyService.assignUserNodePerm("120dv0f43cv90sdf0asv9", nodeId, "shoppingRevokeInstructorEditable", false);
        }
    }

    private void saveShoppingPeriodRevokeInstructorPublicOpt(boolean bool, String nodeId) {
        if (bool) {
            this.hierarchyService.assignUserNodePerm("120dv0f43cv90sdf0asv9", nodeId, "shoppingRevokeInstructorPublicOpt", false);
        }
    }

    private void saveAllowBecomeUser(boolean bool, String userId, String nodeId) {
        if (bool) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "allowBecomeUser", false);
        }
    }

    private void saveInstructorEdited(boolean bool, String userId, String nodeId) {
        if (bool) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "instructorEdited", false);
        }
    }

    public void saveHierarchyJobLastRunDate(Date runDate, String nodeId) {
        if (runDate != null) {
            this.clearHierarchyJobLastRunDate(nodeId);
            this.hierarchyService.assignUserNodePerm("777dv0f43bd90sdf012uf", nodeId, "siteHierarchyJobLastRunDate:" + runDate.getTime(), false);
        }
    }

    private void clearHierarchyJobLastRunDate(String nodeId) {
        for (String perm : this.hierarchyService.getPermsForUserNodes("777dv0f43bd90sdf012uf", new String[]{nodeId})) {
            if (!perm.startsWith("siteHierarchyJobLastRunDate:")) continue;
            this.hierarchyService.removeUserNodePerm("777dv0f43bd90sdf012uf", nodeId, perm, false);
        }
    }

    public Date getHierarchyJobLastRunDate(String nodeId) {
        Date returnDate = null;
        for (String perm : this.hierarchyService.getPermsForUserNodes("777dv0f43bd90sdf012uf", new String[]{nodeId})) {
            if (!perm.startsWith("siteHierarchyJobLastRunDate:")) continue;
            try {
                returnDate = new Date(Long.parseLong(perm.substring("siteHierarchyJobLastRunDate:".length())));
            }
            catch (Exception exception) {}
        }
        return returnDate;
    }

    private void removeAllUserPermissions(String nodeId, String userId) {
        block0: for (String perm : this.getPermsForUserNodes(userId, nodeId)) {
            for (String daPerm : DelegatedAccessConstants.NODE_PERMS) {
                if (!perm.startsWith(daPerm)) continue;
                this.hierarchyService.removeUserNodePerm(userId, nodeId, perm, false);
                continue block0;
            }
        }
    }

    public Set<HierarchyNodeSerialized> getAllNodesForUser(String userId) {
        Set<HierarchyNodeSerialized> accessNodes = this.getAccessNodesForUser(userId);
        Set<HierarchyNodeSerialized> adminNodes = this.getShoppingPeriodAdminNodesForUser(userId);
        Set<HierarchyNodeSerialized> accessAdminNodes = this.getAccessAdminNodesForUser(userId);
        accessNodes.addAll(adminNodes);
        accessNodes.addAll(accessAdminNodes);
        return accessNodes;
    }

    public Set<HierarchyNodeSerialized> getAccessNodesForUser(String userId) {
        this.accessNodes = new ArrayList<String>();
        Set<HierarchyNodeSerialized> directAccessNodes = this.convertToSerializedNodeSet(this.hierarchyService.getNodesForUserPerm(userId, "site.visit"));
        for (HierarchyNodeSerialized node : directAccessNodes) {
            this.accessNodes.add(node.id);
        }
        return directAccessNodes;
    }

    public Set<HierarchyNodeSerialized> getShoppingPeriodAdminNodesForUser(String userId) {
        this.shoppingPeriodAdminNodes = new ArrayList<String>();
        Set<HierarchyNodeSerialized> adminNodes = this.convertToSerializedNodeSet(this.hierarchyService.getNodesForUserPerm(userId, "shoppingAdmin"));
        for (HierarchyNodeSerialized node : adminNodes) {
            this.shoppingPeriodAdminNodes.add(node.id);
        }
        return adminNodes;
    }

    public Set<HierarchyNodeSerialized> getAccessAdminNodesForUser(String userId) {
        this.accessAdminNodes = new ArrayList<String>();
        Set<HierarchyNodeSerialized> adminNodes = this.convertToSerializedNodeSet(this.hierarchyService.getNodesForUserPerm(userId, "accessAdmin"));
        for (HierarchyNodeSerialized node : adminNodes) {
            this.accessAdminNodes.add(node.id);
        }
        return adminNodes;
    }

    private Set<HierarchyNodeSerialized> convertToSerializedNodeSet(Set<HierarchyNode> nodeSet) {
        HashSet<HierarchyNodeSerialized> nodesForUserSerialized = new HashSet<HierarchyNodeSerialized>();
        if (nodeSet != null) {
            for (HierarchyNode node : nodeSet) {
                nodesForUserSerialized.add(new HierarchyNodeSerialized(node));
            }
        }
        return nodesForUserSerialized;
    }

    public void initializeDelegatedAccessSession() {
        String userId = this.sakaiProxy.getCurrentUserId();
        if (userId != null && !"".equals(userId)) {
            Session session = this.sakaiProxy.getCurrentSession();
            Set<HierarchyNodeSerialized> accessNodes = this.getAccessNodesForUser(userId);
            if (accessNodes != null && accessNodes.size() > 0) {
                Object elPub;
                session.setAttribute("delegatedaccess.accessmapflag", (Object)true);
                Object el = this.restrictedAuthToolsCache.get((Object)userId);
                if (el != null) {
                    session.setAttribute("delegatedaccess.deniedToolsMap", el);
                }
                if ((elPub = this.restrictedPublicToolsCache.get((Object)userId)) != null) {
                    session.setAttribute("delegatedaccess.deniedToolsMap2", elPub);
                }
            }
        }
    }

    private List<NodeModel> getSiteNodes(DefaultMutableTreeNode treeNode) {
        ArrayList<NodeModel> returnList = new ArrayList<NodeModel>();
        if (treeNode != null) {
            if (((NodeModel)treeNode.getUserObject()).getNode().title.startsWith("/site/")) {
                returnList.add((NodeModel)treeNode.getUserObject());
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                returnList.addAll(this.getSiteNodes((DefaultMutableTreeNode)treeNode.getChildAt(i)));
            }
        }
        return returnList;
    }

    private HierarchyNodeSerialized getRootNode() {
        return new HierarchyNodeSerialized(this.hierarchyService.getRootNode("delegatedAccessHierarchyId"));
    }

    public List<SearchResult> searchUsers(String search) {
        List searchResult = this.sakaiProxy.searchUsers(search);
        ArrayList<SearchResult> returnList = new ArrayList<SearchResult>();
        for (User user : searchResult) {
            returnList.add(this.getSearchResult(user));
        }
        return returnList;
    }

    private SearchResult getSearchResult(User user) {
        if (user != null) {
            return new SearchResult(user);
        }
        return null;
    }

    private void saveRealmAndRoleAccess(String userId, String realmId, String role, String nodeId) {
        if (!(realmId == null || role == null || "".equals(realmId) || "".equals(role) || "null".equals(realmId) || "null".equals(role))) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "realm:" + realmId, false);
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "role:" + role, false);
        }
    }

    private Set<String> getPermsForUserNodes(String userId, String nodeId) {
        return this.hierarchyService.getPermsForUserNodes(userId, new String[]{nodeId});
    }

    private String[] getAccessRealmRole(Set<String> perms) {
        String realmId = "";
        String roleId = "";
        for (String perm : perms) {
            if (perm.startsWith("realm:")) {
                realmId = perm.substring("realm:".length());
                continue;
            }
            if (!perm.startsWith("role:")) continue;
            roleId = perm.substring("role:".length());
        }
        return new String[]{realmId, roleId};
    }

    public List<ListOptionSerialized> getRestrictedAuthToolSerializedList(Set<String> perms) {
        return this.getRestrictedAuthToolSerializedList(perms, this.getEntireToolsList());
    }

    public List<ListOptionSerialized> getRestrictedPublicToolSerializedList(Set<String> perms) {
        return this.getRestrictedPublicToolSerializedList(perms, this.getEntireToolsList());
    }

    public List<ListOptionSerialized> getRestrictedAuthToolSerializedList(Set<String> perms, List<ListOptionSerialized> blankList) {
        List<String> restrictedTools = this.getRestrictedAuthToolsForUser(perms);
        for (ListOptionSerialized tool : blankList) {
            if (!restrictedTools.contains(tool.getId())) continue;
            tool.setSelected(true);
        }
        return blankList;
    }

    public List<ListOptionSerialized> getRestrictedPublicToolSerializedList(Set<String> perms, List<ListOptionSerialized> blankList) {
        List<String> restrictedTools = this.getRestrictedPublicToolsForUser(perms);
        for (ListOptionSerialized tool : blankList) {
            if (!restrictedTools.contains(tool.getId())) continue;
            tool.setSelected(true);
        }
        return blankList;
    }

    public List<ListOptionSerialized> getEntireToolsList() {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (Tool tool : this.sakaiProxy.getAllTools()) {
            returnList.add(new ListOptionSerialized(tool.getId(), tool.getTitle(), false));
        }
        String[] homeTools = this.sakaiProxy.getHomeTools();
        if (homeTools != null && homeTools.length > 0) {
            returnList.add(new ListOptionSerialized("Home", "Home", false));
        }
        Collections.sort(returnList, new Comparator<ListOptionSerialized>(){

            @Override
            public int compare(ListOptionSerialized arg0, ListOptionSerialized arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return returnList;
    }

    private List<String> getRestrictedAuthToolsForUser(Set<String> userPerms) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String userPerm : userPerms) {
            if (!userPerm.startsWith("denyTool:")) continue;
            returnList.add(userPerm.substring("denyTool:".length()));
        }
        return returnList;
    }

    private List<String> getRestrictedPublicToolsForUser(Set<String> userPerms) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String userPerm : userPerms) {
            if (!userPerm.startsWith("deny2Tool:")) continue;
            returnList.add(userPerm.substring("deny2Tool:".length()));
        }
        return returnList;
    }

    private void saveRestrictedAuthToolsForUser(String userId, String nodeId, List<String> toolIds) {
        for (String newTool : toolIds) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "denyTool:" + newTool, false);
        }
    }

    private void saveRestrictedPublicToolsForUser(String userId, String nodeId, List<String> toolIds) {
        for (String newTool : toolIds) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "deny2Tool:" + newTool, false);
        }
    }

    public List<SiteSearchResult> searchUserSites(String search, Map<String, Object> advancedOptions, boolean shoppingPeriod, boolean activeShoppingData) {
        ArrayList<SiteSearchResult> returnList = new ArrayList<SiteSearchResult>();
        ArrayList<String> resultSiteIds = new ArrayList<String>();
        if (search == null) {
            search = "";
        }
        Collection<SiteSearchResult> siteSubset = null;
        HashMap<String, String> userSortNameCache = new HashMap<String, String>();
        if (!"".equals(search) || advancedOptions != null && advancedOptions.size() > 0) {
            siteSubset = this.searchSites(search, advancedOptions, shoppingPeriod);
            ArrayList<String> siteRefs = new ArrayList<String>();
            for (SiteSearchResult siteResult : siteSubset) {
                siteRefs.add(siteResult.getSiteReference());
            }
            Map<String, AccessNode> accessList = this.grantAccessToSites(siteRefs, shoppingPeriod, activeShoppingData);
            for (SiteSearchResult siteResult : siteSubset) {
                AccessNode access = accessList.get(siteResult.getSiteReference());
                if (access == null) continue;
                siteResult.setAccess(access.getAccess());
                siteResult.setShoppingPeriodStartDate(access.getStartDate());
                siteResult.setShoppingPeriodEndDate(access.getEndDate());
                siteResult.setRestrictedAuthTools(access.getDeniedAuthTools());
                siteResult.setRestrictedPublicTools(access.getDeniedPublicTools());
                siteResult.setModified(access.getModified());
                siteResult.setModifiedBy(access.getModifiedBy());
                if (!userSortNameCache.containsKey(access.getModifiedBy())) {
                    User user = this.sakaiProxy.getUser(access.getModifiedBy());
                    String sortName = "";
                    if (user != null) {
                        sortName = user.getSortName();
                    }
                    userSortNameCache.put(access.getModifiedBy(), sortName);
                }
                siteResult.setModifiedBySortName((String)userSortNameCache.get(access.getModifiedBy()));
                returnList.add(siteResult);
                resultSiteIds.add(siteResult.getSiteId());
            }
        }
        if (advancedOptions == null || !advancedOptions.containsKey("termField") || advancedOptions.get("termField") == null || "".equals(advancedOptions.get("termField").toString().trim())) {
            String termField = this.sakaiProxy.getTermField();
            Map<String, Map<String, String>> termProps = this.dao.searchSitesForProp(new String[]{termField}, resultSiteIds.toArray(new String[resultSiteIds.size()]));
            for (SiteSearchResult result : returnList) {
                if (!termProps.containsKey(result.getSiteId())) continue;
                result.getSite().setTerm(termProps.get(result.getSiteId()).get(termField));
            }
        }
        return returnList;
    }

    public Collection<SiteSearchResult> searchSites(String search, Map<String, Object> advancedOptions, boolean publishedSitesOnly) {
        List<Object[]> siteResults;
        if ("".equals(search)) {
            search = null;
        }
        HashMap<String, SiteSearchResult> sites = new HashMap<String, SiteSearchResult>();
        Site searchByIdSite = this.sakaiProxy.getSiteById(search);
        String termField = this.sakaiProxy.getTermField();
        String termValue = "";
        HashMap<String, String> propsMap = new HashMap<String, String>();
        if (advancedOptions != null && advancedOptions.containsKey("termField") && advancedOptions.get("termField") != null && !"".equals(advancedOptions.get("termField").toString().trim())) {
            termValue = advancedOptions.get("termField").toString();
            propsMap.put(termField, termValue);
            if (searchByIdSite == null || searchByIdSite.getProperties() == null || searchByIdSite.getProperties().getProperty(termField) == null || !searchByIdSite.getProperties().getProperty(termField).toLowerCase().contains(advancedOptions.get("termField").toString())) {
                searchByIdSite = null;
            }
        }
        if (advancedOptions != null && advancedOptions.containsKey("hierarchyFields") && advancedOptions.get("hierarchyFields") != null && advancedOptions.get("hierarchyFields") instanceof Map) {
            Map hierarchyParams = (Map)advancedOptions.get("hierarchyFields");
            for (Map.Entry entry : hierarchyParams.entrySet()) {
                propsMap.put((String)entry.getKey(), (String)entry.getValue());
                if (searchByIdSite != null && searchByIdSite.getProperties() != null && searchByIdSite.getProperties().getProperty((String)entry.getKey()) != null && searchByIdSite.getProperties().getProperty((String)entry.getKey()).toLowerCase().contains((CharSequence)entry.getValue())) continue;
                searchByIdSite = null;
            }
        }
        HashMap<String, User> instructorMap = new HashMap<String, User>();
        if (advancedOptions != null && advancedOptions.containsKey("instructorField") && advancedOptions.get("instructorField") != null && !"".equals(advancedOptions.get("instructorField").toString().trim())) {
            List searchUsers = this.sakaiProxy.searchUsers(advancedOptions.get("instructorField").toString());
            boolean foundSearchByIdMember = searchByIdSite == null;
            for (User user : searchUsers) {
                if (!foundSearchByIdMember && searchByIdSite.getMember(user.getId()) != null) {
                    foundSearchByIdMember = true;
                }
                instructorMap.put(user.getId(), user);
            }
            if (!foundSearchByIdMember && searchByIdSite != null) {
                searchByIdSite = null;
            }
        }
        String instructorType = "";
        if (advancedOptions != null && advancedOptions.containsKey("instructorFieldType")) {
            instructorType = advancedOptions.get("instructorFieldType").toString();
        }
        if ((siteResults = this.dao.searchSites(search, propsMap, instructorMap.keySet().toArray(new String[instructorMap.keySet().size()]), instructorType, publishedSitesOnly)) != null && siteResults.size() > 0) {
            String[] siteIds = new String[siteResults.size()];
            int i = 0;
            for (Object[] site : siteResults) {
                siteIds[i] = (String)site[0];
                ++i;
            }
            Map<String, Map<String, String>> termProps = this.dao.searchSitesForProp(new String[]{termField}, siteIds);
            for (Object[] site : siteResults) {
                ArrayList instructors = new ArrayList();
                if (site.length == 4) {
                    instructors.add(instructorMap.get(site[3]));
                }
                sites.put((String)site[0], new SiteSearchResult(new SiteSerialized((String)site[0], (String)site[1], termValue, ((Boolean)site[2]).booleanValue()), instructors, termField));
            }
        }
        if (!(searchByIdSite == null || sites.containsKey(searchByIdSite.getId()) || publishedSitesOnly && !searchByIdSite.isPublished())) {
            sites.put(searchByIdSite.getId(), new SiteSearchResult(searchByIdSite, new ArrayList(), termField));
        }
        return sites.values();
    }

    private List<Site> getUserUpdatePermissionMembership(String userId, String search, Map<String, String> propsMap) {
        String currentUserId = this.sakaiProxy.getCurrentUserId();
        Session sakaiSession = this.sakaiProxy.getCurrentSession();
        sakaiSession.setUserId(userId);
        sakaiSession.setUserEid(userId);
        List siteList = this.sakaiProxy.getSites(SiteService.SelectionType.UPDATE, search, propsMap);
        sakaiSession.setUserId(currentUserId);
        sakaiSession.setUserEid(currentUserId);
        return siteList;
    }

    private String[] convertToArray(List<String> list) {
        String[] returnArray = new String[]{};
        if (!list.isEmpty()) {
            returnArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                returnArray[i] = list.get(i);
            }
        }
        return returnArray;
    }

    public TreeModel createEntireTreeModelForUser(String userId, boolean addDirectChildren, boolean cascade) {
        ArrayList<String> accessAdminNodeIds = null;
        Set<HierarchyNodeSerialized> accessAdminNodeSet = null;
        ArrayList<String> subAdminsSiteAccessNodes = null;
        Set<HierarchyNodeSerialized> subAdminSiteAccessNodesSet = null;
        if (!this.sakaiProxy.isSuperUser()) {
            String[] subAdminOrderedRealmRoles;
            accessAdminNodeSet = this.getAccessAdminNodesForUser(this.sakaiProxy.getCurrentUserId());
            accessAdminNodeIds = new ArrayList<String>();
            if (accessAdminNodeSet != null) {
                for (HierarchyNodeSerialized hierarchyNodeSerialized : accessAdminNodeSet) {
                    accessAdminNodeIds.add(hierarchyNodeSerialized.id);
                }
            }
            if ((subAdminOrderedRealmRoles = this.sakaiProxy.getSubAdminOrderedRealmRoles()) != null && subAdminOrderedRealmRoles.length > 0) {
                subAdminSiteAccessNodesSet = this.getAccessNodesForUser(this.sakaiProxy.getCurrentUserId());
                subAdminsSiteAccessNodes = new ArrayList<String>();
                if (subAdminSiteAccessNodesSet != null) {
                    for (HierarchyNodeSerialized node : subAdminSiteAccessNodesSet) {
                        subAdminsSiteAccessNodes.add(node.id);
                    }
                }
            }
        }
        Set<HierarchyNodeSerialized> userNodes = this.getAllNodesForUser(userId);
        if (accessAdminNodeSet != null) {
            userNodes.addAll(accessAdminNodeSet);
        }
        if (subAdminSiteAccessNodesSet != null) {
            userNodes.addAll(subAdminSiteAccessNodesSet);
        }
        List<List> list = this.getTreeListForUser(userId, addDirectChildren, cascade, userNodes);
        this.orderTreeModel(list);
        return this.convertToTreeModel(list, userId, this.getEntireToolsList(), addDirectChildren, accessAdminNodeIds, subAdminsSiteAccessNodes, false);
    }

    public TreeModel createAccessTreeModelForUser(String userId, boolean addDirectChildren, boolean cascade) {
        boolean shoppingPeriodTool = "120dv0f43cv90sdf0asv9".equals(userId);
        this.accessNodes = new ArrayList<String>();
        this.shoppingPeriodAdminNodes = new ArrayList<String>();
        this.accessAdminNodes = new ArrayList<String>();
        List<List> l1 = this.getTreeListForUser(userId, addDirectChildren, cascade, this.getAccessNodesForUser(userId));
        if (l1 != null) {
            HierarchyNode hierarchyRoot = this.hierarchyService.getRootNode("delegatedAccessHierarchyId");
            String hierarchyRootId = "-1";
            if (hierarchyRoot != null) {
                hierarchyRootId = hierarchyRoot.id;
            }
            Iterator<List> iterator = l1.iterator();
            while (iterator.hasNext()) {
                List list = iterator.next();
                if (hierarchyRootId.equals(((HierarchyNodeSerialized)list.get((int)0)).id)) continue;
                iterator.remove();
            }
        }
        this.orderTreeModel(l1);
        return this.convertToTreeModel(l1, userId, this.getEntireToolsList(), addDirectChildren, null, null, shoppingPeriodTool);
    }

    public TreeModel getEntireTreePlusUserPerms(String userId) {
        this.getAllNodesForUser(userId);
        HashSet<HierarchyNodeSerialized> rootSet = new HashSet<HierarchyNodeSerialized>();
        rootSet.add(this.getRootNode());
        List<List> l1 = this.getTreeListForUser(userId, false, true, rootSet);
        this.orderTreeModel(l1);
        return this.convertToTreeModel(l1, userId, this.getEntireToolsList(), false, null, null, false);
    }

    public TreeModel createTreeModelForShoppingPeriod(String userId) {
        List<List> l1 = this.getTreeListForUser("120dv0f43cv90sdf0asv9", false, false, this.getShoppingPeriodAdminNodesForUser(userId));
        this.orderTreeModel(l1);
        TreeModel treeModel = this.convertToTreeModel(l1, "120dv0f43cv90sdf0asv9", this.getEntireToolsList(), false, null, null, false);
        if (this.sakaiProxy.isActiveSiteFlagEnabled() && treeModel != null && treeModel.getRoot() != null) {
            this.setActiveFlagForSiteNodes((DefaultMutableTreeNode)treeModel.getRoot());
        }
        return treeModel;
    }

    private void setActiveFlagForSiteNodes(DefaultMutableTreeNode node) {
        HashSet<String> siteNodes = new HashSet<String>();
        this.populateSiteNodes(node, siteNodes);
        List<String> activeSites = this.dao.findActiveSites(siteNodes.toArray(new String[siteNodes.size()]));
        this.setActiveSiteFlag(node, activeSites, siteNodes);
    }

    private void populateSiteNodes(DefaultMutableTreeNode node, Set<String> siteNodes) {
        if (node != null) {
            if (((NodeModel)node.getUserObject()).isSiteNode()) {
                siteNodes.add(((NodeModel)node.getUserObject()).getNode().title.substring(6));
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.populateSiteNodes((DefaultMutableTreeNode)node.getChildAt(i), siteNodes);
            }
        }
    }

    private void setActiveSiteFlag(DefaultMutableTreeNode node, List<String> activeSites, Set<String> checkSites) {
        if (node != null) {
            if (((NodeModel)node.getUserObject()).isSiteNode() && checkSites.contains(((NodeModel)node.getUserObject()).getNode().title.substring(6)) && !activeSites.contains(((NodeModel)node.getUserObject()).getNode().title.substring(6))) {
                ((NodeModel)node.getUserObject()).setActive(false);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.setActiveSiteFlag((DefaultMutableTreeNode)node.getChildAt(i), activeSites, checkSites);
            }
        }
    }

    private TreeModel convertToTreeModel(List<List> map, String userId, List<ListOptionSerialized> blankRestrictedTools, boolean addDirectChildren, List<String> accessAdminNodeIds, List<String> subAdminsSiteAccessNodes, boolean shoppingPeriodTool) {
        DefaultTreeModel model = null;
        if (!map.isEmpty() && map.size() == 1) {
            DefaultMutableTreeNode rootNode = this.add(null, map, userId, blankRestrictedTools, addDirectChildren, accessAdminNodeIds, subAdminsSiteAccessNodes, shoppingPeriodTool);
            model = new DefaultTreeModel(rootNode);
        }
        return model;
    }

    private Date getShoppingStartDate(Set<String> perms) {
        Date returnDate = null;
        for (String perm : perms) {
            if (!perm.startsWith("shoppingStartDate:")) continue;
            try {
                returnDate = new Date(Long.parseLong(perm.substring("shoppingStartDate:".length())));
            }
            catch (Exception exception) {}
        }
        return returnDate;
    }

    private Date getShoppingEndDate(Set<String> perms) {
        Date returnDate = null;
        for (String perm : perms) {
            if (!perm.startsWith("shoppingEndDate:")) continue;
            try {
                returnDate = new Date(Long.parseLong(perm.substring("shoppingEndDate:".length())));
            }
            catch (Exception exception) {}
        }
        return returnDate;
    }

    private Date getPermDate(Set<String> perms, String permName) {
        Date returnDate = null;
        for (String perm : perms) {
            if (!perm.startsWith(permName)) continue;
            try {
                returnDate = new Date(Long.parseLong(perm.substring(permName.length())));
            }
            catch (Exception exception) {}
        }
        return returnDate;
    }

    private String getShoppingAdminModifiedBy(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.startsWith("shoppingAdminModifiedBy:")) continue;
            return perm.substring("shoppingAdminModifiedBy:".length());
        }
        return null;
    }

    private String getModifiedBy(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.startsWith("modifiedBy:")) continue;
            return perm.substring("modifiedBy:".length());
        }
        return null;
    }

    private boolean isShoppingPeriodAdmin(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.equals("shoppingAdmin")) continue;
            return true;
        }
        return false;
    }

    private boolean isShoppingPeriodRevokeInstructorEditable(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.startsWith("shoppingRevokeInstructorEditable")) continue;
            return true;
        }
        return false;
    }

    private boolean isShoppingPeriodRevokeInstructorPublicOpt(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.startsWith("shoppingRevokeInstructorPublicOpt")) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowBecomeUser(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.startsWith("allowBecomeUser")) continue;
            return true;
        }
        return false;
    }

    private boolean isInstructorEdited(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.startsWith("instructorEdited")) continue;
            return true;
        }
        return false;
    }

    private boolean getIsDirectAccess(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.equals("site.visit")) continue;
            return true;
        }
        return false;
    }

    private boolean getIsAccessAdmin(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.equals("accessAdmin")) continue;
            return true;
        }
        return false;
    }

    private List<ListOptionSerialized> copyListOptions(List<ListOptionSerialized> options) {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (ListOptionSerialized option : options) {
            returnList.add(new ListOptionSerialized(option.getId(), option.getName(), option.isSelected()));
        }
        return returnList;
    }

    private DefaultMutableTreeNode add(DefaultMutableTreeNode parent, List<List> sub, String userId, List<ListOptionSerialized> blankRestrictedTools, boolean addDirectChildren, List<String> accessAdminNodeIds, List<String> subAdminsSiteAccessNodes, boolean shoppingPeriodTool) {
        DelegatedAccessMutableTreeNode root = null;
        for (List nodeList : sub) {
            HierarchyNodeSerialized node = (HierarchyNodeSerialized)nodeList.get(0);
            List children = (List)nodeList.get(1);
            String realm = "";
            String role = "";
            boolean directAccess = false;
            Date startDate = null;
            Date endDate = null;
            Date shoppingAdminModified = null;
            String shoppingAdminModifiedBy = null;
            Date modified = null;
            String modifiedBy = null;
            boolean shoppingPeriodRevokeInstructorEditable = false;
            boolean shoppingPeriodRevokeInstructorPublicOpt = false;
            boolean allowBecomeUser = false;
            boolean instructorEdited = false;
            List<ListOptionSerialized> restrictedAuthTools = this.copyListOptions(blankRestrictedTools);
            List<ListOptionSerialized> restrictedPublicTools = this.copyListOptions(blankRestrictedTools);
            boolean accessAdmin = this.accessAdminNodes.contains(node.id);
            boolean shoppingPeriodAdmin = this.shoppingPeriodAdminNodes.contains(node.id);
            Set<String> perms = null;
            if (!shoppingPeriodTool && "120dv0f43cv90sdf0asv9".equals(userId) || this.accessNodes.contains(node.id) || this.shoppingPeriodAdminNodes.contains(node.id)) {
                perms = this.getPermsForUserNodes(userId, node.id);
                String[] realmRole = this.getAccessRealmRole(perms);
                realm = realmRole[0];
                role = realmRole[1];
                startDate = this.getShoppingStartDate(perms);
                endDate = this.getShoppingEndDate(perms);
                restrictedAuthTools = this.getRestrictedAuthToolSerializedList(perms, restrictedAuthTools);
                restrictedPublicTools = this.getRestrictedPublicToolSerializedList(perms, restrictedPublicTools);
                directAccess = this.getIsDirectAccess(perms);
                shoppingAdminModified = this.getPermDate(perms, "shoppingAdminModified:");
                shoppingAdminModifiedBy = this.getShoppingAdminModifiedBy(perms);
                modified = this.getPermDate(perms, "modified:");
                modifiedBy = this.getModifiedBy(perms);
                shoppingPeriodRevokeInstructorEditable = this.isShoppingPeriodRevokeInstructorEditable(perms);
                shoppingPeriodRevokeInstructorPublicOpt = this.isShoppingPeriodRevokeInstructorPublicOpt(perms);
                allowBecomeUser = this.isAllowBecomeUser(perms);
                instructorEdited = this.isInstructorEdited(perms);
            }
            NodeModel parentNodeModel = null;
            if (parent != null) {
                parentNodeModel = (NodeModel)parent.getUserObject();
            }
            DelegatedAccessMutableTreeNode child = new DelegatedAccessMutableTreeNode();
            NodeModel childNodeModel = new NodeModel(node.id, node, directAccess, realm, role, parentNodeModel, restrictedAuthTools, restrictedPublicTools, startDate, endDate, addDirectChildren && !children.isEmpty(), shoppingPeriodAdmin, modifiedBy, modified, shoppingAdminModified, shoppingAdminModifiedBy, accessAdmin, shoppingPeriodRevokeInstructorEditable, shoppingPeriodRevokeInstructorPublicOpt, allowBecomeUser, instructorEdited);
            if (accessAdminNodeIds != null) {
                childNodeModel.setEditable(false);
                boolean found = false;
                for (String nodeId : accessAdminNodeIds) {
                    if (!nodeId.equals(node.id)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    childNodeModel.setEditable(true);
                }
            }
            if (subAdminsSiteAccessNodes != null && subAdminsSiteAccessNodes.size() > 0) {
                for (String nodeId : subAdminsSiteAccessNodes) {
                    if (!childNodeModel.getNodeId().equals(nodeId)) continue;
                    Set<String> permsSubAdmin = this.getPermsForUserNodes(this.sakaiProxy.getCurrentUserId(), nodeId);
                    String[] realmRole = this.getAccessRealmRole(permsSubAdmin);
                    childNodeModel.setSubAdminSiteAccess(realmRole);
                }
            }
            child.setUserObject(childNodeModel);
            if (parent == null) {
                root = child;
            } else if (!"120dv0f43cv90sdf0asv9".equals(userId) || !shoppingPeriodTool || childNodeModel.getNode().title == null || !childNodeModel.isSiteNode() || perms == null || this.isShoppingAvailable(perms)) {
                parent.add((MutableTreeNode)child);
            }
            if (children.isEmpty()) continue;
            this.add((DefaultMutableTreeNode)child, children, userId, blankRestrictedTools, addDirectChildren, accessAdminNodeIds, subAdminsSiteAccessNodes, shoppingPeriodTool);
        }
        return root;
    }

    private void orderTreeModel(List<List> hierarchy) {
        if (hierarchy != null) {
            for (List nodeList : hierarchy) {
                this.orderTreeModel((List)nodeList.get(1));
            }
            Collections.sort(hierarchy, new NodeListComparator());
        }
    }

    private List<String> getOrderedParentsList(HierarchyNodeSerialized node) {
        String directParentId = null;
        if (node.directParentNodeIds != null && node.directParentNodeIds.size() > 0) {
            directParentId = node.directParentNodeIds.toArray(new String[node.directParentNodeIds.size()])[0];
            return this.getOrderedParentsListHelper(this.getCachedNode(directParentId));
        }
        ArrayList<String> orderedParents = new ArrayList<String>();
        return orderedParents;
    }

    private List<String> getOrderedParentsListHelper(HierarchyNodeSerialized node) {
        if (node.directParentNodeIds == null || node.directParentNodeIds.size() == 0) {
            ArrayList<String> returnList = new ArrayList<String>();
            returnList.add(node.id);
            return returnList;
        }
        List<String> parents = this.getOrderedParentsListHelper(this.getCachedNode(node.directParentNodeIds.toArray(new String[node.directParentNodeIds.size()])[0]));
        parents.add(node.id);
        return parents;
    }

    private List<List> getTreeListForUser(String userId, boolean addDirectChildren, boolean cascade, Set<HierarchyNodeSerialized> nodes) {
        HierarchyNodeSerialized root;
        ArrayList<List> l1 = new ArrayList<List>();
        List<List> currentLevel = l1;
        for (HierarchyNodeSerialized node : nodes) {
            List<String> parents = this.getOrderedParentsList(node);
            Map<String, HierarchyNodeSerialized> cachedNodes = this.getCachedNodes(parents.toArray(new String[parents.size()]));
            for (String parentId : parents) {
                HierarchyNodeSerialized parentNode = cachedNodes.get(parentId);
                if (parentNode == null) continue;
                if (!this.hasNode(parentNode, currentLevel)) {
                    ArrayList<Object> newNode = new ArrayList<Object>();
                    newNode.add(parentNode);
                    newNode.add(new ArrayList());
                    currentLevel.add(newNode);
                }
                currentLevel = this.getChildrenForNode(parentNode.id, currentLevel);
                if (!addDirectChildren) continue;
                for (List nodeList : this.getDirectChildren(parentNode)) {
                    if (this.hasNode((HierarchyNodeSerialized)nodeList.get(0), currentLevel)) continue;
                    currentLevel.add(nodeList);
                }
            }
            if (!this.hasNode(node, currentLevel)) {
                ArrayList<Object> child = new ArrayList<Object>();
                child.add(node);
                child.add(new ArrayList());
                currentLevel.add(child);
            }
            if (cascade) {
                this.getCascadingChildren(node, this.getChildrenForNode(node.id, currentLevel));
            }
            currentLevel = l1;
        }
        if (l1.isEmpty() && addDirectChildren && (root = this.getRootNode()) != null && root.id != null && !"".equals(root.id)) {
            ArrayList<Object> child = new ArrayList<Object>();
            child.add(root);
            child.add(this.getDirectChildren(root));
            l1.add(child);
        }
        return l1;
    }

    public HierarchyNodeSerialized getCachedNode(String id) {
        Object el = this.nodeCache.get((Object)id);
        HierarchyNodeSerialized node = null;
        if (el == null) {
            node = this.getNode(id);
            try {
                this.nodeCache.put((Object)id, (Object)node);
            }
            catch (Exception e) {
                log.error("getCachedNode: " + id, (Throwable)e);
            }
        } else if (el instanceof HierarchyNodeSerialized) {
            node = (HierarchyNodeSerialized)el;
        }
        return node;
    }

    public Map<String, HierarchyNodeSerialized> getCachedNodes(String[] ids) {
        HashMap<String, HierarchyNodeSerialized> returnNodes = new HashMap<String, HierarchyNodeSerialized>();
        HashSet<String> lookupNodes = new HashSet<String>();
        for (String id : ids) {
            Object el = this.nodeCache.get((Object)id);
            Object node = null;
            if (el == null) {
                lookupNodes.add(id);
                continue;
            }
            if (!(el instanceof HierarchyNodeSerialized)) continue;
            returnNodes.put(id, (HierarchyNodeSerialized)el);
        }
        Map<String, HierarchyNodeSerialized> lookupMap = this.getNodes(lookupNodes.toArray(new String[lookupNodes.size()]));
        for (Map.Entry<String, HierarchyNodeSerialized> entry : lookupMap.entrySet()) {
            returnNodes.put(entry.getKey(), entry.getValue());
            this.nodeCache.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return returnNodes;
    }

    private List<List> getChildrenForNode(String id, List<List> level) {
        for (List nodeList : level) {
            HierarchyNodeSerialized n = (HierarchyNodeSerialized)nodeList.get(0);
            if (!n.id.equals(id)) continue;
            return (List)nodeList.get(1);
        }
        return null;
    }

    private List<List> getDirectChildren(HierarchyNodeSerialized parent) {
        ArrayList<List> returnList = new ArrayList<List>();
        if (parent != null) {
            Set parentChildren = parent.directChildNodeIds;
            Map<String, HierarchyNodeSerialized> childreNodes = this.getCachedNodes(parentChildren.toArray(new String[parentChildren.size()]));
            for (String childId : parentChildren) {
                if (!childreNodes.containsKey(childId)) continue;
                ArrayList<Object> child = new ArrayList<Object>();
                child.add(childreNodes.get(childId));
                child.add(new ArrayList());
                returnList.add(child);
            }
        }
        return returnList;
    }

    private List<List> getCascadingChildren(HierarchyNodeSerialized parent, List<List> children) {
        Set parentChildren = parent.directChildNodeIds;
        Map<String, HierarchyNodeSerialized> childreNodes = this.getCachedNodes(parentChildren.toArray(new String[parentChildren.size()]));
        for (String childId : parentChildren) {
            if (!childreNodes.containsKey(childId)) continue;
            HierarchyNodeSerialized childNode = childreNodes.get(childId);
            List<List> childMap = this.getChildrenForNode(childNode.id, children);
            if (childMap == null) {
                childMap = new ArrayList<List>();
            }
            childMap = this.getCascadingChildren(childNode, childMap);
            if (this.hasNode(childNode, children)) continue;
            ArrayList<Object> childList = new ArrayList<Object>();
            childList.add(childNode);
            childList.add(childMap);
            children.add(childList);
        }
        return children;
    }

    private boolean hasNode(HierarchyNodeSerialized node, List<List> level) {
        for (List nodeList : level) {
            HierarchyNodeSerialized n = (HierarchyNodeSerialized)nodeList.get(0);
            if (!n.id.equals(node.id)) continue;
            return true;
        }
        return false;
    }

    public boolean addChildrenNodes(Object node, String userId, List<ListOptionSerialized> blankRestrictedTools, boolean onlyAccessNodes, List<String> accessAdminNodes, boolean shopping, boolean shoppingPeriodTool) {
        boolean anyAdded = false;
        HashSet<String> addedSites = new HashSet<String>();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node;
        NodeModel nodeModel = (NodeModel)((DefaultMutableTreeNode)node).getUserObject();
        if (nodeModel.getNode() != null) {
            List<List> childrenNodes = this.getDirectChildren(nodeModel.getNode());
            Collections.sort(childrenNodes, new NodeListComparator());
            for (List childList : childrenNodes) {
                if (accessAdminNodes != null && !((NodeModel)parentNode.getUserObject()).isNodeEditable() && !accessAdminNodes.contains(((HierarchyNodeSerialized)childList.get((int)0)).id)) continue;
                boolean newlyAdded = this.addChildNodeToTree((HierarchyNodeSerialized)childList.get(0), parentNode, userId, blankRestrictedTools, onlyAccessNodes, shoppingPeriodTool);
                boolean bl = anyAdded = anyAdded || newlyAdded;
                if (!newlyAdded || !((HierarchyNodeSerialized)childList.get((int)0)).title.startsWith("/site/")) continue;
                addedSites.add(((HierarchyNodeSerialized)childList.get((int)0)).title.substring(6));
            }
        }
        if (shopping && addedSites.size() > 0 && this.sakaiProxy.isActiveSiteFlagEnabled()) {
            List<String> activeSites = this.dao.findActiveSites(addedSites.toArray(new String[addedSites.size()]));
            this.setActiveSiteFlag(parentNode, activeSites, addedSites);
        }
        return anyAdded;
    }

    private boolean addChildNodeToTree(HierarchyNodeSerialized childNode, DefaultMutableTreeNode parentNode, String userId, List<ListOptionSerialized> blankRestrictedTools, boolean onlyAccessNodes, boolean shoppingPeriodTool) {
        boolean added = false;
        if (!this.doesChildExist(childNode.id, parentNode)) {
            String realm = "";
            String role = "";
            boolean selected = false;
            Date startDate = null;
            Date endDate = null;
            List<ListOptionSerialized> restrictedAuthTools = this.copyListOptions(blankRestrictedTools);
            List<ListOptionSerialized> restrictedPublicTools = this.copyListOptions(blankRestrictedTools);
            boolean shoppingPeriodAdmin = false;
            boolean directAccess = false;
            Date shoppingAdminModified = null;
            String shoppingAdminModifiedBy = null;
            Date modified = null;
            String modifiedBy = null;
            boolean accessAdmin = false;
            boolean shoppingPeriodRevokeInstructorEditable = false;
            boolean shoppingPeriodRevokeInstructorPublicOpt = false;
            boolean allowBecomeUser = false;
            boolean instructorEdited = false;
            DelegatedAccessMutableTreeNode child = new DelegatedAccessMutableTreeNode();
            if (!shoppingPeriodTool && "120dv0f43cv90sdf0asv9".equals(userId)) {
                Set<String> perms = this.getPermsForUserNodes(userId, childNode.id);
                String[] realmRole = this.getAccessRealmRole(perms);
                realm = realmRole[0];
                role = realmRole[1];
                startDate = this.getShoppingStartDate(perms);
                endDate = this.getShoppingEndDate(perms);
                restrictedAuthTools = this.getRestrictedAuthToolSerializedList(perms, restrictedAuthTools);
                restrictedPublicTools = this.getRestrictedPublicToolSerializedList(perms, restrictedPublicTools);
                directAccess = this.getIsDirectAccess(perms);
                shoppingAdminModified = this.getPermDate(perms, "shoppingAdminModified:");
                shoppingAdminModifiedBy = this.getShoppingAdminModifiedBy(perms);
                modified = this.getPermDate(perms, "modified:");
                modifiedBy = this.getModifiedBy(perms);
                accessAdmin = this.getIsAccessAdmin(perms);
                shoppingPeriodRevokeInstructorEditable = this.isShoppingPeriodRevokeInstructorEditable(perms);
                shoppingPeriodRevokeInstructorPublicOpt = this.isShoppingPeriodRevokeInstructorPublicOpt(perms);
                allowBecomeUser = this.isAllowBecomeUser(perms);
                instructorEdited = this.isInstructorEdited(perms);
            }
            NodeModel node = new NodeModel(childNode.id, childNode, directAccess, realm, role, (NodeModel)parentNode.getUserObject(), restrictedAuthTools, restrictedPublicTools, startDate, endDate, false, shoppingPeriodAdmin, modifiedBy, modified, shoppingAdminModified, shoppingAdminModifiedBy, accessAdmin, shoppingPeriodRevokeInstructorEditable, shoppingPeriodRevokeInstructorPublicOpt, allowBecomeUser, instructorEdited);
            child.setUserObject(node);
            boolean shoppingAvailable = true;
            if (shoppingPeriodTool && node.isSiteNode() && !this.isShoppingPeriodOpenForSite(node.getNodeShoppingPeriodStartDate(), node.getNodeShoppingPeriodEndDate(), node.getNodeAccessRealmRole(), node.getNodeRestrictedAuthTools(), node.getNodeRestrictedPublicTools())) {
                shoppingAvailable = false;
            }
            if (shoppingAvailable && (!onlyAccessNodes || node.getNodeAccess())) {
                parentNode.add((MutableTreeNode)child);
                added = true;
            }
        }
        return added;
    }

    private boolean doesChildExist(String childNodeId, DefaultMutableTreeNode parentNode) {
        boolean exists = false;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            if (!childNodeId.equals(((NodeModel)child.getUserObject()).getNodeId())) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public NodeModel getNodeModel(String nodeId, String userId) {
        HierarchyNodeSerialized node = this.getCachedNode(nodeId);
        NodeModel parentNodeModel = null;
        if (node.directParentNodeIds != null && node.directParentNodeIds.size() > 0) {
            List<String> orderedParents = this.getOrderedParentsList(node);
            parentNodeModel = this.getNodeModel(orderedParents.get(orderedParents.size() - 1), userId);
        }
        Set nodePerms = this.hierarchyService.getPermsForUserNodes(userId, new String[]{nodeId});
        Set<String> perms = this.getPermsForUserNodes(userId, node.id);
        String[] realmRole = this.getAccessRealmRole(perms);
        String realm = realmRole[0];
        String role = realmRole[1];
        Date startDate = this.getShoppingStartDate(perms);
        Date endDate = this.getShoppingEndDate(perms);
        List<ListOptionSerialized> restrictedAuthTools = this.getRestrictedAuthToolSerializedList(perms, this.getEntireToolsList());
        List<ListOptionSerialized> restrictedPublicTools = this.getRestrictedPublicToolSerializedList(perms, this.getEntireToolsList());
        boolean direct = this.getIsDirectAccess(perms);
        boolean shoppingPeriodAdmin = this.isShoppingPeriodAdmin(perms);
        boolean accessAdmin = this.getIsAccessAdmin(perms);
        Date shoppingAdminModified = this.getPermDate(perms, "shoppingAdminModified:");
        String shoppingAdminModifiedBy = this.getShoppingAdminModifiedBy(perms);
        Date modified = this.getPermDate(perms, "modified:");
        String modifiedBy = this.getModifiedBy(perms);
        boolean shoppingPeriodRevokeInstructorEditable = this.isShoppingPeriodRevokeInstructorEditable(perms);
        boolean shoppingPeriodRevokeInstructorPublicOpt = this.isShoppingPeriodRevokeInstructorPublicOpt(perms);
        boolean allowBecomeUser = this.isAllowBecomeUser(perms);
        boolean instructorEdited = this.isInstructorEdited(perms);
        NodeModel nodeModel = new NodeModel(node.id, node, this.getIsDirectAccess(nodePerms), realm, role, parentNodeModel, restrictedAuthTools, restrictedPublicTools, startDate, endDate, false, shoppingPeriodAdmin, modifiedBy, modified, shoppingAdminModified, shoppingAdminModifiedBy, accessAdmin, shoppingPeriodRevokeInstructorEditable, shoppingPeriodRevokeInstructorPublicOpt, allowBecomeUser, instructorEdited);
        return nodeModel;
    }

    public void assignUserNodePerm(String userId, String nodeId, String perm, boolean cascade) {
        this.hierarchyService.assignUserNodePerm(userId, nodeId, perm, false);
    }

    public void removeNode(String nodeId) {
        this.removeNode(this.hierarchyService.getNodeById(nodeId));
    }

    public void removeNode(HierarchyNode node) {
        if (node != null) {
            if (node.childNodeIds != null && !node.childNodeIds.isEmpty()) {
                for (String childId : node.childNodeIds) {
                    this.removeNode(this.hierarchyService.getNodeById(childId));
                }
            }
            this.hierarchyService.removeNode(node.id);
            Set userIds = this.hierarchyService.getUserIdsForNodesPerm(new String[]{node.id}, "site.visit");
            for (String userId : userIds) {
                this.removeAllUserPermissions(node.id, userId);
            }
            this.hierarchyService.setNodeDisabled(node.id, Boolean.valueOf(true));
        }
    }

    public void deleteEmptyNonSiteNodes(String hierarchyId) {
        List<String> emptyNodes = this.dao.getEmptyNonSiteNodes(hierarchyId);
        for (int loopProtection = 1; emptyNodes != null && emptyNodes.size() > 0 && loopProtection < 1000000; ++loopProtection) {
            for (String id : emptyNodes) {
                this.removeNode(this.hierarchyService.getNodeById(id));
            }
            emptyNodes = this.dao.getEmptyNonSiteNodes(hierarchyId);
        }
    }

    public Map<String, String> getRealmRoleDisplay(boolean shopping) {
        if (shopping) {
            return this.convertRealmRoleToSingleList(this.sakaiProxy.getShoppingRealmOptions());
        }
        return this.convertRealmRoleToSingleList(this.sakaiProxy.getDelegatedAccessRealmOptions());
    }

    private Map<String, String> convertRealmRoleToSingleList(Map<String, List<String>> realmMap) {
        ArrayList<String> allRoles = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : realmMap.entrySet()) {
            for (String role : entry.getValue()) {
                allRoles.add(role);
            }
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : realmMap.entrySet()) {
            String realm = entry.getKey();
            Iterator<String> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                String role;
                String roleTitle = role = iterator.next();
                if (this.countNumOfOccurances(allRoles, role) > 1) {
                    roleTitle = roleTitle + " (" + realm + ")";
                }
                returnMap.put(realm + ":" + role, roleTitle);
            }
        }
        return returnMap;
    }

    private int countNumOfOccurances(List<String> list, String str) {
        int i = 0;
        for (String check : list) {
            if (!check.equals(str)) continue;
            ++i;
        }
        return i;
    }

    public boolean hasShoppingPeriodAdminNodes(String userId) {
        if (userId == null || "".equals(userId)) {
            return false;
        }
        Set shoppingAdminNodes = this.hierarchyService.getNodesForUserPerm(userId, "shoppingAdmin");
        return shoppingAdminNodes != null && shoppingAdminNodes.size() > 0;
    }

    public boolean hasDelegatedAccessNodes(String userId) {
        if (userId == null || "".equals(userId)) {
            return false;
        }
        Set delegatedAccessNodes = this.hierarchyService.getNodesForUserPerm(userId, "site.visit");
        return delegatedAccessNodes != null && delegatedAccessNodes.size() > 0;
    }

    public boolean hasAccessAdminNodes(String userId) {
        if (userId == null || "".equals(userId)) {
            return false;
        }
        Set accessAdminNodes = this.hierarchyService.getNodesForUserPerm(userId, "accessAdmin");
        return accessAdminNodes != null && accessAdminNodes.size() > 0;
    }

    public boolean hasAllowBecomeUserPerm(String userId) {
        if (userId == null || "".equals(userId)) {
            return false;
        }
        Set accessAdminNodes = this.hierarchyService.getNodesForUserPerm(userId, "allowBecomeUser");
        return accessAdminNodes != null && accessAdminNodes.size() > 0;
    }

    public Map<String, List<String>> getNodesBySiteRef(String[] siteRefs, String hierarchyId) {
        return this.dao.getNodesBySiteRef(siteRefs, hierarchyId);
    }

    public void clearNodeCache() {
        this.nodeCache.clear();
    }

    public String[] getCurrentUsersAccessToSite(String siteRef) {
        String currentUserId = this.sakaiProxy.getCurrentUserId();
        if (currentUserId == null || "".equals(currentUserId)) {
            return null;
        }
        if (this.sakaiProxy.getCurrentSession().getAttribute("delegatedaccess.accessmap") != null && ((Map)this.sakaiProxy.getCurrentSession().getAttribute("delegatedaccess.accessmap")).containsKey(siteRef)) {
            return (String[])((Map)this.sakaiProxy.getCurrentSession().getAttribute("delegatedaccess.accessmap")).get(siteRef);
        }
        ArrayList<String> siteRefs = new ArrayList<String>();
        siteRefs.add(siteRef);
        Map<String, AccessNode> accessNodes = this.grantAccessToSites(siteRefs, false, false);
        if (accessNodes != null && accessNodes.containsKey(siteRef) && accessNodes.get(siteRef) != null) {
            return accessNodes.get(siteRef).getAccess();
        }
        return null;
    }

    private Map<String, AccessNode> grantAccessToSites(List<String> siteRefs, boolean shoppingPeriod, boolean activeShoppingData) {
        String userId = this.sakaiProxy.getCurrentUserId();
        if (shoppingPeriod) {
            userId = "120dv0f43cv90sdf0asv9";
        }
        return this.grantAccessToSites(siteRefs, shoppingPeriod, activeShoppingData, userId);
    }

    private Map<String, AccessNode> grantAccessToSites(List<String> siteRefs, boolean shoppingPeriod, boolean activeShoppingData, String userId) {
        Map<String, List<String>> siteRefToNodeMap;
        Object sessionaccessMap;
        Object sessionDeniedTools2Map;
        Object sessionDeniedToolsMap;
        HashMap<String, AccessNode> returnNodes = new HashMap<String, AccessNode>();
        if (!shoppingPeriod && (userId == null || "".equals(userId))) {
            return returnNodes;
        }
        boolean useSession = userId != null && userId.equals(this.sakaiProxy.getCurrentUserId());
        Session session = null;
        if (useSession) {
            session = this.sakaiProxy.getCurrentSession();
        }
        Map<String, String[]> deniedAuthToolsMap = new ConcurrentHashMap();
        if (useSession && (sessionDeniedToolsMap = session.getAttribute("delegatedaccess.deniedToolsMap")) != null) {
            deniedAuthToolsMap = (Map)sessionDeniedToolsMap;
        }
        Map<String, String[]> deniedPublicToolsMap = new ConcurrentHashMap();
        if (useSession && (sessionDeniedTools2Map = session.getAttribute("delegatedaccess.deniedToolsMap2")) != null) {
            deniedPublicToolsMap = (Map)sessionDeniedTools2Map;
        }
        Map<String, String[]> accessMap = new ConcurrentHashMap();
        if (useSession && (sessionaccessMap = session.getAttribute("delegatedaccess.accessmap")) != null) {
            accessMap = (Map)sessionaccessMap;
        }
        Iterator<String> iterator = siteRefs.iterator();
        while (iterator.hasNext()) {
            String siteRef = iterator.next();
            if (!shoppingPeriod && accessMap.containsKey(siteRef) && accessMap.get(siteRef) == null) {
                returnNodes.put(siteRef, null);
                iterator.remove();
                continue;
            }
            deniedAuthToolsMap.put(siteRef, new String[0]);
            deniedPublicToolsMap.put(siteRef, new String[0]);
            accessMap.put(siteRef, new String[0]);
        }
        String hierarchyId = "delegatedAccessHierarchyId";
        if (shoppingPeriod) {
            userId = "120dv0f43cv90sdf0asv9";
        }
        Object dAMapFlag = null;
        if (useSession) {
            dAMapFlag = session.getAttribute("delegatedaccess.accessmapflag");
        }
        if (!(dAMapFlag == null && useSession || (siteRefToNodeMap = this.getNodesBySiteRef(siteRefs.toArray(new String[siteRefs.size()]), hierarchyId)) == null)) {
            HashSet<String> nodeIds = new HashSet<String>();
            for (List<String> nodeIdsList : siteRefToNodeMap.values()) {
                nodeIds.addAll(nodeIdsList);
            }
            Map siteNodes = this.hierarchyService.getNodesByIds(nodeIds.toArray(new String[nodeIds.size()]));
            HashSet<String> subSetNodeIds = new HashSet<String>();
            if (siteNodes != null) {
                for (HierarchyNode node : siteNodes.values()) {
                    subSetNodeIds.add(node.id);
                    if (node.parentNodeIds == null) continue;
                    for (String pId : node.parentNodeIds) {
                        subSetNodeIds.add(pId);
                    }
                }
            }
            Map<String, Set<String>> userNodesAndPerms = this.dao.getNodesAndPermsForUser(userId, subSetNodeIds.toArray(new String[subSetNodeIds.size()]));
            Map memberRoles = new HashMap();
            if (!shoppingPeriod) {
                memberRoles = this.sakaiProxy.isUserMember(userId, siteRefs);
            }
            if (userNodesAndPerms != null) {
                block8: for (String siteRef : siteRefs) {
                    if (siteRefToNodeMap == null || !siteRefToNodeMap.containsKey(siteRef) || siteRefToNodeMap.get(siteRef) == null || siteRefToNodeMap.get(siteRef).size() <= 0) continue;
                    String nodeId = siteRefToNodeMap.get(siteRef).get(0);
                    while (nodeId != null && !"".equals(nodeId)) {
                        Set<String> perms = userNodesAndPerms.get(nodeId);
                        if (perms != null && this.getIsDirectAccess(perms)) {
                            if (!shoppingPeriod && memberRoles.get(siteRef) != null) {
                                returnNodes.put(siteRef, null);
                            } else {
                                String[] access;
                                if (shoppingPeriod && activeShoppingData) {
                                    String siteId = siteRef.substring(6);
                                    if (!this.isShoppingAvailable(perms)) continue block8;
                                }
                                if ((access = this.getAccessRealmRole(perms)) == null || access.length != 2 || access[0] == null || access[1] == null || "".equals(access[0]) || "".equals(access[1]) || "null".equals(access[0]) || "null".equals(access[1])) {
                                    access = new String[]{"", ""};
                                }
                                accessMap.put(siteRef, access);
                                List<String> deniedAuthTools = this.getRestrictedAuthToolsForUser(perms);
                                String[] deniedAuthToolsArr = deniedAuthTools.toArray(new String[deniedAuthTools.size()]);
                                if (deniedAuthToolsArr != null) {
                                    deniedAuthToolsMap.put(siteRef, deniedAuthToolsArr);
                                } else {
                                    deniedAuthToolsMap.put(siteRef, new String[0]);
                                }
                                List<String> deniedPublicTools = this.getRestrictedPublicToolsForUser(perms);
                                String[] deniedPublicToolsArr = deniedPublicTools.toArray(new String[deniedPublicTools.size()]);
                                if (deniedPublicToolsArr != null) {
                                    deniedPublicToolsMap.put(siteRef, deniedPublicToolsArr);
                                } else {
                                    deniedPublicToolsMap.put(siteRef, new String[0]);
                                }
                                Date startDate = this.getShoppingStartDate(perms);
                                Date endDate = this.getShoppingEndDate(perms);
                                Date modified = this.getPermDate(perms, "modified:");
                                String modifiedBy = this.getModifiedBy(perms);
                                AccessNode returnNode = new AccessNode(userId, siteRef, access, deniedAuthToolsArr, deniedPublicToolsArr, startDate, endDate, modified, modifiedBy);
                                returnNodes.put(siteRef, returnNode);
                            }
                            nodeId = null;
                            continue block8;
                        }
                        Set parentIds = null;
                        parentIds = siteNodes != null && siteNodes.containsKey(nodeId) ? ((HierarchyNode)siteNodes.get((Object)nodeId)).parentNodeIds : this.getCachedNode((String)nodeId).parentNodeIds;
                        nodeId = this.getFirstAccessParent(parentIds, userNodesAndPerms);
                    }
                }
            }
        }
        if (useSession) {
            session.setAttribute("delegatedaccess.deniedToolsMap", deniedAuthToolsMap);
            session.setAttribute("delegatedaccess.deniedToolsMap2", deniedPublicToolsMap);
            session.setAttribute("delegatedaccess.accessmap", accessMap);
            try {
                this.restrictedAuthToolsCache.put((Object)userId, deniedAuthToolsMap);
            }
            catch (Exception e) {
                log.error("grantAccessToSite: " + userId, (Throwable)e);
            }
            try {
                this.restrictedPublicToolsCache.put((Object)userId, deniedPublicToolsMap);
            }
            catch (Exception e) {
                log.error("grantAccessToSite: " + userId, (Throwable)e);
            }
        }
        return returnNodes;
    }

    private String getFirstAccessParent(Set<String> parentIds, Map<String, Set<String>> userNodesAndPerms) {
        String accessParent = null;
        ArrayList<String> accessParents = new ArrayList<String>();
        for (String parent : parentIds) {
            for (Map.Entry<String, Set<String>> entry : userNodesAndPerms.entrySet()) {
                if (!parent.equals(entry.getKey()) || !this.getIsDirectAccess(entry.getValue())) continue;
                accessParents.add(parent);
            }
        }
        if (accessParents.size() == 1) {
            accessParent = (String)accessParents.get(0);
        } else if (accessParents.size() > 1) {
            Collections.reverse(accessParents);
            Map<String, HierarchyNodeSerialized> cachedNodes = this.getCachedNodes(accessParents.toArray(new String[accessParents.size()]));
            for (String parent : accessParents) {
                HierarchyNodeSerialized pNode = cachedNodes.get(parent);
                if (pNode == null) continue;
                boolean foundAccessChild = false;
                for (String child : pNode.childNodeIds) {
                    for (String childCheck : accessParents) {
                        if (!childCheck.equals(child)) continue;
                        foundAccessChild = true;
                        break;
                    }
                    if (!foundAccessChild) continue;
                    break;
                }
                if (foundAccessChild) continue;
                accessParent = parent;
                break;
            }
        }
        return accessParent;
    }

    private boolean isShoppingAvailable(Set<String> perms) {
        Date startDate = this.getShoppingStartDate(perms);
        Date endDate = this.getShoppingEndDate(perms);
        String[] nodeAccessRealmRole = this.getAccessRealmRole(perms);
        List<String> restrictedAuthTools = this.getRestrictedAuthToolsForUser(perms);
        String[] restrictedAuthToolsArr = null;
        if (restrictedAuthTools != null) {
            restrictedAuthToolsArr = restrictedAuthTools.toArray(new String[restrictedAuthTools.size()]);
        }
        List<String> restrictedPublicTools = this.getRestrictedPublicToolsForUser(perms);
        String[] restrictedPublicToolsArr = null;
        if (restrictedPublicTools != null) {
            restrictedPublicToolsArr = restrictedPublicTools.toArray(new String[restrictedPublicTools.size()]);
        }
        return this.isShoppingPeriodOpenForSite(startDate, endDate, nodeAccessRealmRole, restrictedAuthToolsArr, restrictedPublicToolsArr);
    }

    public boolean isShoppingPeriodOpenForSite(Date startDate, Date endDate, String[] nodeAccessRealmRole, String[] restrictedAuthTools, String[] restrictedPublicTools) {
        Date now = new Date();
        boolean isOpen = false;
        if (startDate != null && endDate != null) {
            isOpen = startDate.before(now) && endDate.after(now);
        } else if (startDate != null) {
            isOpen = startDate.before(now);
        } else if (endDate != null) {
            isOpen = endDate.after(now);
        }
        isOpen = nodeAccessRealmRole != null && nodeAccessRealmRole.length == 2 && !"".equals(nodeAccessRealmRole[0]) && !"".equals(nodeAccessRealmRole[1]) && !"null".equals(nodeAccessRealmRole[0]) && !"null".equals(nodeAccessRealmRole[1]) ? isOpen : false;
        isOpen = !(restrictedAuthTools != null && restrictedAuthTools.length != 0 || restrictedPublicTools != null && restrictedPublicTools.length != 0) ? false : isOpen;
        return isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncMyworkspaceToolForUser(String userId) {
        if (this.sakaiProxy.getSyncMyworkspaceTool()) {
            String currentUserId = this.sakaiProxy.getCurrentUserId();
            Site workspace = null;
            try {
                this.sakaiProxy.setSessionUserId(userId);
                workspace = this.sakaiProxy.getSiteById("~" + userId);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.sakaiProxy.setSessionUserId(currentUserId);
            }
            if (workspace != null) {
                boolean hasAnyAccess = false;
                hasAnyAccess = this.hasDelegatedAccessNodes(userId);
                boolean hasAllowBecomeUserPerm = false;
                if (hasAnyAccess) {
                    hasAllowBecomeUserPerm = this.hasAllowBecomeUserPerm(userId);
                }
                if (!hasAnyAccess) {
                    hasAnyAccess = this.hasShoppingPeriodAdminNodes(userId);
                }
                if (!hasAnyAccess) {
                    hasAnyAccess = this.hasAccessAdminNodes(userId);
                }
                ToolConfiguration tool = workspace.getToolForCommonId("sakai.delegatedaccess");
                if (hasAnyAccess && tool == null) {
                    SitePage page = workspace.addPage();
                    page.addTool("sakai.delegatedaccess");
                    this.sakaiProxy.saveSite(workspace);
                } else if (!hasAnyAccess && tool != null) {
                    workspace.removePage(tool.getContainingPage());
                    this.sakaiProxy.saveSite(workspace);
                }
                ToolConfiguration becomeUserTool = workspace.getToolForCommonId("sakai.su");
                if (hasAnyAccess && hasAllowBecomeUserPerm && becomeUserTool == null) {
                    SitePage page = workspace.addPage();
                    page.addTool("sakai.su");
                    this.sakaiProxy.saveSite(workspace);
                } else if (!(hasAnyAccess && hasAllowBecomeUserPerm || becomeUserTool == null)) {
                    workspace.removePage(becomeUserTool.getContainingPage());
                    this.sakaiProxy.saveSite(workspace);
                }
            }
        }
    }

    public Map<String, AccessNode> getUserAccessForSite(String siteRef) {
        HashMap<String, AccessNode> returnMap = new HashMap<String, AccessNode>();
        Map<String, List<String>> siteNodeMap = this.getNodesBySiteRef(new String[]{siteRef}, "delegatedAccessHierarchyId");
        if (siteNodeMap != null && siteNodeMap.containsKey(siteRef) && siteNodeMap.get(siteRef) != null && siteNodeMap.get(siteRef).size() > 0) {
            HierarchyNodeSerialized node = this.getCachedNode(siteNodeMap.get(siteRef).get(0));
            Set nodeIds = node.parentNodeIds;
            nodeIds.add(node.id);
            Map userPerms = this.hierarchyService.getUsersAndPermsForNodes(nodeIds.toArray(new String[nodeIds.size()]));
            ArrayList<String> siteRefs = new ArrayList<String>();
            siteRefs.add(siteRef);
            HashSet<String> usersWithAccess = new HashSet<String>();
            for (Map nodeUsers : userPerms.values()) {
                for (String userId : nodeUsers.keySet()) {
                    if ("120dv0f43cv90sdf0asv9".equals(userId)) continue;
                    usersWithAccess.add(userId);
                }
            }
            for (String userId : usersWithAccess) {
                Map<String, AccessNode> userAccess = this.grantAccessToSites(siteRefs, false, false, userId);
                if (userAccess == null || !userAccess.containsKey(siteRef) || userAccess.get(siteRef) == null) continue;
                returnMap.put(userId, userAccess.get(siteRef));
            }
        }
        return returnMap;
    }

    public Map<String, String> updateShoppingPeriodSettings(DefaultMutableTreeNode node) {
        HashMap<String, String> errors = new HashMap<String, String>();
        ArrayList<String> removeAnonAuthRefs = new ArrayList<String>();
        HashMap<String, Map<String, List<String>>> realmRoleCopy = new HashMap<String, Map<String, List<String>>>();
        ArrayList<String> removeAuthToolsSiteProp = new ArrayList<String>();
        ArrayList<String> removePublicToolsSiteProp = new ArrayList<String>();
        HashMap<String, List<String>> updateAuthToolsSiteProp = new HashMap<String, List<String>>();
        HashMap<String, List<String>> updatePublicToolsSiteProp = new HashMap<String, List<String>>();
        this.updateShoppingPeriodSettingsHelper(node, this.getEntireToolsList(), errors, removeAnonAuthRefs, realmRoleCopy, removeAuthToolsSiteProp, removePublicToolsSiteProp, updateAuthToolsSiteProp, updatePublicToolsSiteProp);
        if (removeAnonAuthRefs.size() > 0) {
            this.dao.removeAnonAndAuthRoles(removeAnonAuthRefs.toArray(new String[removeAnonAuthRefs.size()]));
        }
        if (realmRoleCopy.size() > 0) {
            for (Map.Entry e : realmRoleCopy.entrySet()) {
                String[] realmRole = ((String)e.getKey()).split(":");
                if (realmRole.length != 2) continue;
                for (Map.Entry e2 : ((Map)e.getValue()).entrySet()) {
                    this.dao.copyRole(realmRole[0], realmRole[1], ((List)e2.getValue()).toArray(new String[((List)e2.getValue()).size()]), (String)e2.getKey());
                }
            }
        }
        if (removeAuthToolsSiteProp.size() > 0) {
            this.dao.removeSiteProperty(removeAuthToolsSiteProp.toArray(new String[removeAuthToolsSiteProp.size()]), "shopping-period-auth-tools");
        }
        if (removePublicToolsSiteProp.size() > 0) {
            this.dao.removeSiteProperty(removePublicToolsSiteProp.toArray(new String[removePublicToolsSiteProp.size()]), "shopping-period-public-tools");
        }
        for (Map.Entry e : updateAuthToolsSiteProp.entrySet()) {
            this.dao.updateSiteProperty(((List)e.getValue()).toArray(new String[((List)e.getValue()).size()]), "shopping-period-auth-tools", (String)e.getKey());
        }
        for (Map.Entry e : updatePublicToolsSiteProp.entrySet()) {
            this.dao.updateSiteProperty(((List)e.getValue()).toArray(new String[((List)e.getValue()).size()]), "shopping-period-public-tools", (String)e.getKey());
        }
        return errors;
    }

    private void updateShoppingPeriodSettingsHelper(DefaultMutableTreeNode node, List<ListOptionSerialized> blankRestrictedTools, Map<String, String> errors, List<String> removeAnonAuthRefs, Map<String, Map<String, List<String>>> realmRoleCopy, List<String> removeAuthToolsSiteProp, List<String> removePublicToolsSiteProp, Map<String, List<String>> updateAuthToolsSiteProp, Map<String, List<String>> updatePublicToolsSiteProp) {
        if (node != null) {
            NodeModel nodeModel = (NodeModel)node.getUserObject();
            if (nodeModel.isSiteNode()) {
                try {
                    List<String> siteRefs;
                    ShoppingPeriodUpdateStruct struct = this.updateShoppingPeriodSettings(nodeModel);
                    removeAnonAuthRefs.add(nodeModel.getNode().title);
                    if (struct != null && struct.getRealmRole() != null && struct.getRealmRole().length == 2 && (struct.isAnon() || struct.isAuth())) {
                        List<String> siteRefs2;
                        String fromRealmRole = struct.getRealmRole()[0] + ":" + struct.getRealmRole()[1];
                        Map<String, List<String>> copyTo = realmRoleCopy.get(fromRealmRole);
                        if (copyTo == null) {
                            copyTo = new HashMap<String, List<String>>();
                        }
                        if (struct.isAuth()) {
                            siteRefs2 = copyTo.get(".auth");
                            if (siteRefs2 == null) {
                                siteRefs2 = new ArrayList<String>();
                            }
                            siteRefs2.add(struct.getSiteRef());
                            copyTo.put(".auth", siteRefs2);
                        }
                        if (struct.isAnon()) {
                            siteRefs2 = copyTo.get(".anon");
                            if (siteRefs2 == null) {
                                siteRefs2 = new ArrayList<String>();
                            }
                            siteRefs2.add(struct.getSiteRef());
                            copyTo.put(".anon", siteRefs2);
                        }
                        realmRoleCopy.put(fromRealmRole, copyTo);
                    }
                    if (struct.getRestrictedAuthToolsList() == null || "".equals(struct.getRestrictedAuthToolsList()) || ";".equals(struct.getRestrictedAuthToolsList())) {
                        removeAuthToolsSiteProp.add(struct.getSiteRef().substring(6));
                    } else {
                        siteRefs = updateAuthToolsSiteProp.get(struct.getRestrictedAuthToolsList());
                        if (siteRefs == null) {
                            siteRefs = new ArrayList<String>();
                        }
                        siteRefs.add(struct.getSiteRef().substring(6));
                        updateAuthToolsSiteProp.put(struct.getRestrictedAuthToolsList(), siteRefs);
                    }
                    if (struct.getRestrictedPublicToolsList() == null || "".equals(struct.getRestrictedPublicToolsList()) || ";".equals(struct.getRestrictedPublicToolsList())) {
                        removePublicToolsSiteProp.add(struct.getSiteRef().substring(6));
                    } else {
                        siteRefs = updatePublicToolsSiteProp.get(struct.getRestrictedPublicToolsList());
                        if (siteRefs == null) {
                            siteRefs = new ArrayList<String>();
                        }
                        siteRefs.add(struct.getSiteRef().substring(6));
                        updatePublicToolsSiteProp.put(struct.getRestrictedPublicToolsList(), siteRefs);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    errors.put(nodeModel.getNode().title, sw.toString());
                }
            }
            if (!nodeModel.isAddedDirectChildrenFlag()) {
                this.addChildrenNodes(node, "120dv0f43cv90sdf0asv9", blankRestrictedTools, false, null, true, false);
                nodeModel.setAddedDirectChildrenFlag(true);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.updateShoppingPeriodSettingsHelper((DefaultMutableTreeNode)node.getChildAt(i), blankRestrictedTools, errors, removeAnonAuthRefs, realmRoleCopy, removeAuthToolsSiteProp, removePublicToolsSiteProp, updateAuthToolsSiteProp, updatePublicToolsSiteProp);
            }
        }
    }

    private ShoppingPeriodUpdateStruct updateShoppingPeriodSettings(NodeModel node) {
        ShoppingPeriodUpdateStruct returnStruct = null;
        boolean auth = false;
        boolean anon = false;
        Date startDate = null;
        Date endDate = null;
        Date now = new Date();
        startDate = node.getNodeShoppingPeriodStartDate();
        endDate = node.getNodeShoppingPeriodEndDate();
        String[] nodeAccessRealmRole = node.getNodeAccessRealmRole();
        String[] restrictedAuthcTools = node.getNodeRestrictedAuthTools();
        String[] restrictedPublicTools = node.getNodeRestrictedPublicTools();
        String siteId = node.getNode().title.substring(6);
        boolean addAuth = this.isShoppingPeriodOpenForSite(startDate, endDate, nodeAccessRealmRole, restrictedAuthcTools, restrictedPublicTools);
        String restrictedAuthToolsList = "";
        String restrictedPublicToolsList = "";
        if (addAuth) {
            String[] homeTools;
            String homeToolsVal;
            restrictedAuthToolsList = ";";
            for (String tool : node.getNodeRestrictedAuthTools()) {
                if ("Home".equals(tool)) {
                    homeToolsVal = "";
                    for (String toolId : homeTools = this.sakaiProxy.getHomeTools()) {
                        if (!"".equals(homeToolsVal)) {
                            homeToolsVal = homeToolsVal + ";";
                        }
                        homeToolsVal = homeToolsVal + toolId;
                    }
                    restrictedAuthToolsList = restrictedAuthToolsList + homeToolsVal;
                } else {
                    restrictedAuthToolsList = restrictedAuthToolsList + tool;
                }
                restrictedAuthToolsList = restrictedAuthToolsList + ";";
            }
            restrictedPublicToolsList = ";";
            for (String tool : node.getNodeRestrictedPublicTools()) {
                if (!"".equals(restrictedPublicToolsList)) {
                    restrictedPublicToolsList = restrictedPublicToolsList + ";";
                }
                if ("Home".equals(tool)) {
                    homeToolsVal = "";
                    for (String toolId : homeTools = this.sakaiProxy.getHomeTools()) {
                        if (!"".equals(homeToolsVal)) {
                            homeToolsVal = homeToolsVal + ";";
                        }
                        homeToolsVal = homeToolsVal + toolId;
                    }
                    restrictedPublicToolsList = restrictedPublicToolsList + homeToolsVal;
                    continue;
                }
                restrictedPublicToolsList = restrictedPublicToolsList + tool;
            }
            auth = restrictedAuthcTools != null && restrictedAuthcTools.length > 0;
            anon = restrictedPublicTools != null && restrictedPublicTools.length > 0;
        }
        returnStruct = new ShoppingPeriodUpdateStruct(auth, anon, nodeAccessRealmRole, node.getNode().title, restrictedPublicToolsList, restrictedAuthToolsList);
        return returnStruct;
    }

    private void copyNewRole(String siteRef, String copyRealm, String copyRole, boolean auth, boolean anon) {
        if (auth) {
            log.debug("Copying " + copyRole + " to .auth for " + siteRef);
            this.sakaiProxy.copyNewRole(siteRef, copyRealm, copyRole, ".auth");
        }
        if (anon) {
            log.debug("Copying " + copyRole + " to .anon for " + siteRef);
            this.sakaiProxy.copyNewRole(siteRef, copyRealm, copyRole, ".anon");
        }
    }

    public String getAddDAMyworkspaceJobStatus() {
        HierarchyNode root = this.hierarchyService.getRootNode("delegatedAccessHierarchyId");
        if (root != null) {
            Set perms = this.hierarchyService.getPermsForUserNodes("777dv0f43bd90sdf012uf", new String[]{root.id});
            return this.getAddDAMyworkspaceJobStatus(perms);
        }
        return null;
    }

    private String getAddDAMyworkspaceJobStatus(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.startsWith("wsjstatus:")) continue;
            return perm.substring("wsjstatus:".length());
        }
        return null;
    }

    public void updateAddDAMyworkspaceJobStatus(String status) {
        HierarchyNode root = this.hierarchyService.getRootNode("delegatedAccessHierarchyId");
        if (root != null) {
            String currentStatus = this.getAddDAMyworkspaceJobStatus();
            if (currentStatus != null) {
                this.hierarchyService.removeUserNodePerm("777dv0f43bd90sdf012uf", root.id, "wsjstatus:" + currentStatus, false);
            }
            this.hierarchyService.assignUserNodePerm("777dv0f43bd90sdf012uf", root.id, "wsjstatus:" + status, false);
        }
    }

    public void scheduleAddDAMyworkspaceJobStatus() {
        DelayedInvocation[] fdi = this.scheduledInvocationManager.findDelayedInvocations("org.sakaiproject.delegatedaccess.jobs.DelegatedAccessAddToolToMyWorkspacesJob", "");
        if (fdi != null && fdi.length > 0) {
            for (DelayedInvocation d : fdi) {
                this.scheduledInvocationManager.deleteDelayedInvocation(d.uuid);
            }
        }
        this.scheduledInvocationManager.createDelayedInvocation(this.timeService.newTime(), "org.sakaiproject.delegatedaccess.jobs.DelegatedAccessAddToolToMyWorkspacesJob", "");
        this.updateAddDAMyworkspaceJobStatus("0");
    }

    public boolean isUserAllowBecomeUser(String userId, String siteRef) {
        Map<String, List<String>> nodeIds = this.getNodesBySiteRef(new String[]{siteRef}, "delegatedAccessHierarchyId");
        if (nodeIds != null && nodeIds.containsKey(siteRef) && nodeIds.get(siteRef) != null && nodeIds.get(siteRef).size() == 1) {
            String nodeId = nodeIds.get(siteRef).get(0);
            NodeModel model = this.getNodeModel(nodeId, userId);
            if (model != null) {
                return model.getNodeAccess() && model.getNodeAllowBecomeUser();
            }
            return false;
        }
        return false;
    }

    public HierarchyNodeSerialized getRootNodeId() {
        return new HierarchyNodeSerialized(this.hierarchyService.getRootNode("delegatedAccessHierarchyId"));
    }

    public Set<HierarchyNodeSerialized> getDirectNodes(String nodeId) {
        HierarchyNodeSerialized node = this.getCachedNode(nodeId);
        HashSet<HierarchyNodeSerialized> returnSet = new HashSet<HierarchyNodeSerialized>();
        if (node != null && node.directChildNodeIds != null) {
            Map<String, HierarchyNodeSerialized> cachedNodes = this.getCachedNodes(node.directChildNodeIds.toArray(new String[node.directChildNodeIds.size()]));
            for (String id : node.directChildNodeIds) {
                if (!cachedNodes.containsKey(id)) continue;
                returnSet.add(cachedNodes.get(id));
            }
        }
        return returnSet;
    }

    public List<AccessSearchResult> getAccessForUser(User user) {
        ArrayList<AccessSearchResult> returnSet = new ArrayList<AccessSearchResult>();
        if (user != null) {
            boolean isAdmin = this.sakaiProxy.isSuperUser();
            HashSet<String> accessAdminNodesArr = new HashSet<String>();
            if (!isAdmin) {
                Set<HierarchyNodeSerialized> accessAdminNodes = this.getAccessAdminNodesForUser(this.sakaiProxy.getCurrentUserId());
                for (HierarchyNodeSerialized hierarchyNodeSerialized : accessAdminNodes) {
                    accessAdminNodesArr.add(hierarchyNodeSerialized.id);
                    accessAdminNodesArr.addAll(hierarchyNodeSerialized.childNodeIds);
                }
            }
            Set<HierarchyNodeSerialized> accessNodes = this.getAccessNodesForUser(user.getId());
            for (HierarchyNodeSerialized hierarchyNodeSerialized : accessNodes) {
                boolean canEdit = false;
                if (isAdmin || accessAdminNodesArr.contains(hierarchyNodeSerialized.id)) {
                    canEdit = true;
                }
                AccessSearchResult r = new AccessSearchResult();
                r.setId(user.getId());
                r.setEid(user.getEid());
                r.setSortName(user.getDisplayName());
                r.setType(1);
                int level = 0;
                if (hierarchyNodeSerialized.parentNodeIds != null) {
                    level = hierarchyNodeSerialized.parentNodeIds.size();
                }
                r.setLevel(level);
                r.setHierarchyNodes(this.getHierarchyForNode(hierarchyNodeSerialized));
                r.setNodeId(hierarchyNodeSerialized.id);
                r.setCanEdit(canEdit);
                Set<String> perms = this.getPermsForUserNodes(user.getId(), hierarchyNodeSerialized.id);
                r.setAccess(this.getAccessRealmRole(perms));
                r.setRestrictedTools(this.getRestrictedAuthToolsForUser(perms));
                returnSet.add(r);
            }
            Set<HierarchyNodeSerialized> shoppingAdminNodes = this.getShoppingPeriodAdminNodesForUser(user.getId());
            for (HierarchyNodeSerialized n : shoppingAdminNodes) {
                boolean canEdit = false;
                if (isAdmin || accessAdminNodesArr.contains(n.id)) {
                    canEdit = true;
                }
                AccessSearchResult r = new AccessSearchResult();
                r.setId(user.getId());
                r.setEid(user.getEid());
                r.setSortName(user.getDisplayName());
                r.setType(2);
                int level = 0;
                if (n.parentNodeIds != null) {
                    level = n.parentNodeIds.size();
                }
                r.setLevel(level);
                r.setHierarchyNodes(this.getHierarchyForNode(n));
                r.setNodeId(n.id);
                r.setCanEdit(canEdit);
                returnSet.add(r);
            }
            Set<HierarchyNodeSerialized> set = this.getAccessAdminNodesForUser(user.getId());
            for (HierarchyNodeSerialized n : set) {
                boolean canEdit = false;
                if (isAdmin || accessAdminNodesArr.contains(n.id)) {
                    canEdit = true;
                }
                AccessSearchResult r = new AccessSearchResult();
                r.setId(user.getId());
                r.setEid(user.getEid());
                r.setDisplayName(user.getDisplayName());
                r.setSortName(user.getSortName());
                r.setType(4);
                int level = 0;
                if (n.parentNodeIds != null) {
                    level = n.parentNodeIds.size();
                }
                r.setLevel(level);
                r.setHierarchyNodes(this.getHierarchyForNode(n));
                r.setNodeId(n.id);
                r.setCanEdit(canEdit);
                returnSet.add(r);
            }
        }
        return returnSet;
    }

    private List<String> getHierarchyForNode(HierarchyNodeSerialized node) {
        ArrayList<String> returnList = new ArrayList<String>();
        List<String> parentList = this.getOrderedParentsList(node);
        Map<String, HierarchyNodeSerialized> cachedNodes = this.getCachedNodes(parentList.toArray(new String[parentList.size()]));
        for (String parentId : parentList) {
            HierarchyNodeSerialized parentNode = cachedNodes.get(parentId);
            if (parentNode == null) continue;
            returnList.add(parentNode.description);
        }
        returnList.add(node.description);
        return returnList;
    }

    public List<AccessSearchResult> getAccessAtLevel(List<String> nodeSelectOrder, boolean includeLowerPerms) {
        boolean isAdmin = this.sakaiProxy.isSuperUser();
        HashSet<String> accessAdminNodesArr = new HashSet<String>();
        if (!isAdmin) {
            Set<HierarchyNodeSerialized> accessAdminNodes = this.getAccessAdminNodesForUser(this.sakaiProxy.getCurrentUserId());
            for (HierarchyNodeSerialized n : accessAdminNodes) {
                accessAdminNodesArr.add(n.id);
                accessAdminNodesArr.addAll(n.childNodeIds);
            }
        }
        ArrayList<AccessSearchResult> returnSet = new ArrayList<AccessSearchResult>();
        if ((isAdmin || accessAdminNodesArr.size() > 0) && nodeSelectOrder != null && nodeSelectOrder.size() > 0) {
            HashSet<String> searchNodes = new HashSet<String>();
            if (includeLowerPerms) {
                HierarchyNode searchNode = this.hierarchyService.getNodeById(nodeSelectOrder.get(nodeSelectOrder.size() - 1));
                searchNodes.add(searchNode.id);
                searchNodes.addAll(searchNode.childNodeIds);
            }
            searchNodes.addAll(nodeSelectOrder);
            Map usersAndPerms = this.hierarchyService.getUsersAndPermsForNodes(searchNodes.toArray(new String[searchNodes.size()]));
            if (usersAndPerms != null) {
                for (Map.Entry usersAndPermsForNode : usersAndPerms.entrySet()) {
                    String nodeId = (String)usersAndPermsForNode.getKey();
                    boolean canEdit = false;
                    if (isAdmin || accessAdminNodesArr.contains(nodeId)) {
                        canEdit = true;
                    }
                    for (Map.Entry userAndPerms : ((Map)usersAndPermsForNode.getValue()).entrySet()) {
                        AccessSearchResult r;
                        User u = this.sakaiProxy.getUser((String)userAndPerms.getKey());
                        if (u == null) continue;
                        boolean hasAccess = this.getIsDirectAccess((Set)userAndPerms.getValue());
                        boolean hasShoppingAdmin = this.isShoppingPeriodAdmin((Set)userAndPerms.getValue());
                        boolean hasAccessAdmin = this.getIsAccessAdmin((Set)userAndPerms.getValue());
                        if (!hasAccess && !hasShoppingAdmin && !hasAccessAdmin) continue;
                        String id = u.getId();
                        String eid = u.getEid();
                        String displayName = u.getDisplayName();
                        String sortName = u.getSortName();
                        HierarchyNodeSerialized node = this.getCachedNode(nodeId);
                        int level = 0;
                        if (node.parentNodeIds != null) {
                            level = node.parentNodeIds.size();
                        }
                        List<String> hierarchy = this.getHierarchyForNode(node);
                        if (hasAccess) {
                            r = new AccessSearchResult();
                            r.setId(id);
                            r.setEid(eid);
                            r.setDisplayName(displayName);
                            r.setSortName(sortName);
                            r.setType(1);
                            r.setLevel(level);
                            r.setHierarchyNodes(hierarchy);
                            r.setNodeId(nodeId);
                            r.setCanEdit(canEdit);
                            r.setAccess(this.getAccessRealmRole((Set)userAndPerms.getValue()));
                            r.setRestrictedTools(this.getRestrictedAuthToolsForUser((Set)userAndPerms.getValue()));
                            returnSet.add(r);
                        }
                        if (hasShoppingAdmin) {
                            r = new AccessSearchResult();
                            r.setId(id);
                            r.setEid(eid);
                            r.setDisplayName(displayName);
                            r.setSortName(sortName);
                            r.setType(2);
                            r.setLevel(level);
                            r.setHierarchyNodes(hierarchy);
                            r.setNodeId(nodeId);
                            r.setCanEdit(canEdit);
                            returnSet.add(r);
                        }
                        if (!hasAccessAdmin) continue;
                        r = new AccessSearchResult();
                        r.setId(id);
                        r.setEid(eid);
                        r.setDisplayName(displayName);
                        r.setSortName(sortName);
                        r.setType(4);
                        r.setLevel(level);
                        r.setHierarchyNodes(hierarchy);
                        r.setNodeId(nodeId);
                        r.setCanEdit(canEdit);
                        returnSet.add(r);
                    }
                }
            }
        }
        return returnSet;
    }

    public void removeAccess(String nodeId, String userId, int accessType) {
        NodeModel model = this.getNodeModel(nodeId, userId);
        if (model != null) {
            switch (accessType) {
                case 1: {
                    model.setDirectAccess(false);
                    break;
                }
                case 2: {
                    model.setShoppingPeriodAdmin(false);
                    break;
                }
                case 4: {
                    model.setAccessAdmin(false);
                }
            }
            this.updateNodePermissionsForUser(model, userId);
            this.syncMyworkspaceToolForUser(userId);
        }
    }

    public void removeAllPermsForUser(String userId) {
        boolean updated = false;
        for (HierarchyNodeSerialized n : this.getAllNodesForUser(userId)) {
            NodeModel model = this.getNodeModel(n.id, userId);
            if (model == null) continue;
            model.setDirectAccess(false);
            model.setShoppingPeriodAdmin(false);
            model.setAccessAdmin(false);
            this.updateNodePermissionsForUser(model, userId);
            updated = true;
        }
        this.syncMyworkspaceToolForUser(userId);
    }

    public Map<String, Set<String>> getHierarchySearchOptions(Map<String, String> hierarchySearchMap) {
        ArrayList<String> orderedKeys = new ArrayList<String>(hierarchySearchMap.keySet());
        Collections.sort(orderedKeys);
        String key = "";
        for (String k : orderedKeys) {
            key = key + k + ";" + (hierarchySearchMap.get(k) == null ? "" : hierarchySearchMap.get(k)) + ";";
        }
        Map results = null;
        if (this.hierarchySearchCache.containsKey((Object)key) && (results = (Map)this.hierarchySearchCache.get((Object)key)) != null) {
            return results;
        }
        results = this.dao.getHierarchySearchOptions(hierarchySearchMap);
        this.hierarchySearchCache.put((Object)key, (Object)results);
        return results;
    }

    public Set<String> filterShoppingPeriodEditNodes(Set<String> nodeIds) {
        return this.filterShoppingPeriodEditNodes(nodeIds, this.sakaiProxy.getCurrentUserId());
    }

    public Set<String> filterShoppingPeriodEditNodes(Set<String> nodeIds, String userId) {
        HashSet<String> returnNodes = new HashSet<String>();
        Set nodes = this.hierarchyService.getNodesForUserPerm(userId, "shoppingAdmin");
        block0: for (String nodeId : nodeIds) {
            for (HierarchyNode node : nodes) {
                if (!nodeId.equals(node.id) && !node.childNodeIds.contains(nodeId)) continue;
                returnNodes.add(nodeId);
                continue block0;
            }
        }
        return returnNodes;
    }

    public SakaiProxy getSakaiProxy() {
        return this.sakaiProxy;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public HierarchyService getHierarchyService() {
        return this.hierarchyService;
    }

    public void setHierarchyService(HierarchyService hierarchyService) {
        this.hierarchyService = hierarchyService;
    }

    public DelegatedAccessDao getDao() {
        return this.dao;
    }

    public void setDao(DelegatedAccessDao dao) {
        this.dao = dao;
    }

    public MemoryService getMemoryService() {
        return this.memoryService;
    }

    public void setMemoryService(MemoryService memoryService) {
        this.memoryService = memoryService;
    }

    public ScheduledInvocationManager getScheduledInvocationManager() {
        return this.scheduledInvocationManager;
    }

    public void setScheduledInvocationManager(ScheduledInvocationManager scheduledInvocationManager) {
        this.scheduledInvocationManager = scheduledInvocationManager;
    }

    public TimeService getTimeService() {
        return this.timeService;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    private class ShoppingPeriodUpdateStruct {
        private boolean auth = false;
        private boolean anon = true;
        private String[] realmRole;
        private String siteRef;
        private String restrictedPublicToolsList;
        private String restrictedAuthToolsList;

        public ShoppingPeriodUpdateStruct(boolean auth, boolean anon, String[] realmRole, String siteRef, String restrictedPublicToolsList, String restrictedAuthToolsList) {
            this.anon = anon;
            this.auth = auth;
            this.realmRole = realmRole;
            this.siteRef = siteRef;
            this.restrictedAuthToolsList = restrictedAuthToolsList;
            this.restrictedPublicToolsList = restrictedPublicToolsList;
        }

        public boolean isAuth() {
            return this.auth;
        }

        public void setAuth(boolean auth) {
            this.auth = auth;
        }

        public boolean isAnon() {
            return this.anon;
        }

        public void setAnon(boolean anon) {
            this.anon = anon;
        }

        public String[] getRealmRole() {
            return this.realmRole;
        }

        public void setRealmRole(String[] realmRole) {
            this.realmRole = realmRole;
        }

        public String getSiteRef() {
            return this.siteRef;
        }

        public void setSiteRef(String siteRef) {
            this.siteRef = siteRef;
        }

        public String getRestrictedPublicToolsList() {
            return this.restrictedPublicToolsList;
        }

        public void setRestrictedPublicToolsList(String restrictedPublicToolsList) {
            this.restrictedPublicToolsList = restrictedPublicToolsList;
        }

        public String getRestrictedAuthToolsList() {
            return this.restrictedAuthToolsList;
        }

        public void setRestrictedAuthToolsList(String restrictedAuthToolsList) {
            this.restrictedAuthToolsList = restrictedAuthToolsList;
        }
    }

    private class NodeListComparator
    implements Comparator<List> {
        private NodeListComparator() {
        }

        @Override
        public int compare(List o1, List o2) {
            if (((HierarchyNodeSerialized)o1.get((int)0)).description == null && ((HierarchyNodeSerialized)o2.get((int)0)).description == null) {
                return 0;
            }
            if (((HierarchyNodeSerialized)o1.get((int)0)).description != null && ((HierarchyNodeSerialized)o2.get((int)0)).description == null) {
                return 1;
            }
            if (((HierarchyNodeSerialized)o1.get((int)0)).description == null && ((HierarchyNodeSerialized)o2.get((int)0)).description != null) {
                return -1;
            }
            return ((HierarchyNodeSerialized)o1.get((int)0)).description.compareToIgnoreCase(((HierarchyNodeSerialized)o2.get((int)0)).description);
        }
    }
}

