/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.dao.impl;

import java.util.Arrays;
import java.util.List;
import org.quartz.JobExecutionException;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.delegatedaccess.jobs.DelegatedAccessSiteHierarchyJob;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.event.api.UsageSessionService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserAlreadyDefinedException;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserIdInvalidException;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.api.UserPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedAccessSampleDataLoader {
    private SiteService siteService;
    private DelegatedAccessSiteHierarchyJob delegatedAccessSiteHierarchyJob;
    private SecurityService securityService;
    private AuthzGroupService authzGroupService;
    private EventTrackingService eventTrackingService;
    private UsageSessionService usageSessionService;
    private SessionManager sessionManager;
    private UserDirectoryService userDirectoryService;
    private static final Logger log = LoggerFactory.getLogger(DelegatedAccessSampleDataLoader.class);
    private List<String> schools = Arrays.asList("MUSIC", "MEDICINE", "EDUCATION");
    private List<String> depts = Arrays.asList("DEPT1", "DEPT2", "DEPT3");
    private List<String> subjs = Arrays.asList("SUBJ1", "SUBJ2", "SUBJ3");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.siteService == null || this.securityService == null || this.delegatedAccessSiteHierarchyJob == null) {
            return;
        }
        SecurityAdvisor yesMan = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        try {
            this.loginToSakai();
            this.securityService.pushAdvisor(yesMan);
            AuthzGroup templateGroup = this.authzGroupService.getAuthzGroup("!site.template.course");
            for (String school : this.schools) {
                for (String dept : this.depts) {
                    for (String subject : this.subjs) {
                        for (int courseNum = 101; courseNum < 600; courseNum += 25) {
                            String siteid;
                            String title = siteid = "DAC-" + school + "-" + dept + "-" + subject + "-" + courseNum;
                            String description = siteid;
                            String shortdesc = siteid;
                            Site siteEdit = null;
                            try {
                                siteEdit = this.siteService.addSite(siteid, "course");
                                siteEdit.setTitle(title);
                                siteEdit.setDescription(description);
                                siteEdit.setShortDescription(shortdesc);
                                siteEdit.setPublished(true);
                                siteEdit.setType("course");
                                if (siteEdit.getTool("sakai.siteinfo") == null) {
                                    SitePage page = siteEdit.addPage();
                                    page.setTitle("Tests & Quizzes");
                                    page.addTool("sakai.samigo");
                                    page = siteEdit.addPage();
                                    page.setTitle("Assignments");
                                    page.addTool("sakai.assignment.grades");
                                    page = siteEdit.addPage();
                                    page.setTitle("Forums");
                                    page.addTool("sakai.forums");
                                    page = siteEdit.addPage();
                                    page.setTitle("Messages");
                                    page.addTool("sakai.messages");
                                    page = siteEdit.addPage();
                                    page.setTitle("Syllabus");
                                    page.addTool("sakai.syllabus");
                                    page = siteEdit.addPage();
                                    page.setTitle("Announcements");
                                    page.addTool("sakai.announcements");
                                    page = siteEdit.addPage();
                                    page.setTitle("Gradebook");
                                    page.addTool("sakai.gradebook.tool");
                                    page = siteEdit.addPage();
                                    page.setTitle("Schedule");
                                    page.addTool("sakai.schedule");
                                    page = siteEdit.addPage();
                                    page.setTitle("Resources");
                                    page.addTool("sakai.resources");
                                    page = siteEdit.addPage();
                                    page.setTitle("Roster");
                                    page.addTool("sakai.site.roster2");
                                    page = siteEdit.addPage();
                                    page.setTitle("Lessons");
                                    page.addTool("sakai.lessonbuildertool");
                                    page = siteEdit.addPage();
                                    page.setTitle("Site Info");
                                    page.addTool("sakai.siteinfo");
                                }
                                ResourcePropertiesEdit propEdit = siteEdit.getPropertiesEdit();
                                propEdit.addProperty("School", school);
                                propEdit.addProperty("Department", dept);
                                propEdit.addProperty("Subject", subject);
                                this.siteService.save(siteEdit);
                                AuthzGroup group = this.authzGroupService.getAuthzGroup(siteEdit.getReference());
                                group.removeMembers();
                                group.removeRoles();
                                for (Role role : templateGroup.getRoles()) {
                                    group.addRole(role.getId(), role);
                                }
                                group.addMember("datest", group.getMaintainRole(), true, false);
                                this.authzGroupService.save(group);
                                continue;
                            }
                            catch (IdInvalidException | PermissionException e) {
                                log.warn(e.getMessage(), e);
                                continue;
                            }
                            catch (Exception e) {
                                log.warn(e.getMessage(), (Throwable)e);
                                this.securityService.popAdvisor(yesMan);
                                this.logoutFromSakai();
                                return;
                            }
                        }
                    }
                }
            }
            try {
                this.delegatedAccessSiteHierarchyJob.execute(null);
            }
            catch (JobExecutionException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            this.securityService.popAdvisor(yesMan);
            this.logoutFromSakai();
        }
    }

    private void loginToSakai() {
        User user = null;
        try {
            user = this.userDirectoryService.getUserByEid("datest");
        }
        catch (UserNotDefinedException e) {
            try {
                user = this.userDirectoryService.addUser("datest", "datest", "DA", "Test", "", "datest", "", null);
            }
            catch (UserIdInvalidException e1) {
                e1.printStackTrace();
            }
            catch (UserAlreadyDefinedException e1) {
                e1.printStackTrace();
            }
            catch (UserPermissionException e1) {
                e1.printStackTrace();
            }
        }
        if (user != null) {
            Session sakaiSession = this.sessionManager.getCurrentSession();
            sakaiSession.setUserId(user.getId());
            sakaiSession.setUserEid(user.getEid());
            this.usageSessionService.startSession(user.getId(), "127.0.0.1", "DAtest");
            this.authzGroupService.refreshUser(user.getId());
            this.eventTrackingService.post(this.eventTrackingService.newEvent("user.login", null, true));
        }
    }

    private void logoutFromSakai() {
        Session sakaiSession = this.sessionManager.getCurrentSession();
        sakaiSession.invalidate();
        this.eventTrackingService.post(this.eventTrackingService.newEvent("user.logout", null, true));
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public DelegatedAccessSiteHierarchyJob getDelegatedAccessSiteHierarchyJob() {
        return this.delegatedAccessSiteHierarchyJob;
    }

    public void setDelegatedAccessSiteHierarchyJob(DelegatedAccessSiteHierarchyJob delegatedAccessSiteHierarchyJob) {
        this.delegatedAccessSiteHierarchyJob = delegatedAccessSiteHierarchyJob;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public AuthzGroupService getAuthzGroupService() {
        return this.authzGroupService;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public UsageSessionService getUsageSessionService() {
        return this.usageSessionService;
    }

    public void setUsageSessionService(UsageSessionService usageSessionService) {
        this.usageSessionService = usageSessionService;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }
}

