/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.AuthzPermissionException;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.RoleAlreadyDefinedException;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.coursemanagement.api.AcademicSession;
import org.sakaiproject.coursemanagement.api.CourseManagementService;
import org.sakaiproject.delegatedaccess.dao.DelegatedAccessDao;
import org.sakaiproject.delegatedaccess.logic.SakaiProxy;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.javax.PagingPosition;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SakaiProxyImpl
implements SakaiProxy {
    private static final Logger log = LoggerFactory.getLogger(SakaiProxyImpl.class);
    private AuthzGroupService authzGroupService;
    private SessionManager sessionManager;
    private UserDirectoryService userDirectoryService;
    private SecurityService securityService;
    private EventTrackingService eventTrackingService;
    private ServerConfigurationService serverConfigurationService;
    private SiteService siteService;
    private EntityManager entityManager;
    private ToolManager toolManager;
    private DelegatedAccessDao dao;
    private CourseManagementService cms;
    private EmailService emailService;
    private List<String[]> terms;

    public void init() {
    }

    public String getCurrentUserId() {
        return this.sessionManager.getCurrentSessionUserId();
    }

    public boolean isSuperUser() {
        return this.securityService.isSuperUser();
    }

    public Session getCurrentSession() {
        return this.sessionManager.getCurrentSession();
    }

    public List<Site> getAllSites() {
        return this.siteService.getSites(SiteService.SelectionType.NON_USER, null, null, null, null, null);
    }

    public List<Site> getAllSitesByPages(Map<String, String> propsMap, int page, int pageMax, boolean orderByModifiedDate) {
        PagingPosition pp = new PagingPosition(page, pageMax);
        return this.siteService.getSites(SiteService.SelectionType.NON_USER, null, null, propsMap, (SiteService.SortType)(orderByModifiedDate ? SiteService.SortType.MODIFIED_ON_DESC : null), pp);
    }

    public void postEvent(String event, String reference, boolean modify) {
        this.eventTrackingService.post(this.eventTrackingService.newEvent(event, reference, modify));
    }

    public Set<Tool> getAllTools() {
        String[] excludedTools;
        Set<Tool> toolSet = new HashSet();
        String[] toolsList = null;
        String siteType = this.serverConfigurationService.getString("delegatedaccess.toolslist.sitetype");
        if (siteType != null && !"".equals(siteType)) {
            toolSet = this.toolManager.findTools(new HashSet<String>(Arrays.asList(siteType)), null);
        }
        if (toolSet.size() == 0 && (toolsList = this.serverConfigurationService.getStrings("delegatedaccess.toolslist")) != null && toolsList.length > 0) {
            for (String toolId : toolsList) {
                Tool tool = this.toolManager.getTool(toolId);
                if (tool == null) continue;
                toolSet.add(tool);
            }
        }
        if (toolSet.size() == 0) {
            toolSet = this.toolManager.findTools(new HashSet(), null);
        }
        if ((excludedTools = this.serverConfigurationService.getStrings("delegatedaccess.toolslistexclude")) != null && excludedTools.length > 0) {
            block1: for (String excludedTool : excludedTools) {
                Iterator iterator = toolSet.iterator();
                while (iterator.hasNext()) {
                    Tool tool = (Tool)iterator.next();
                    if (!excludedTool.equals(tool.getId())) continue;
                    iterator.remove();
                    continue block1;
                }
            }
        }
        return toolSet;
    }

    public Tool getTool(String toolId) {
        return this.toolManager.getTool(toolId);
    }

    public String[] getHomeTools() {
        return this.serverConfigurationService.getStrings("delegatedaccess.hometools");
    }

    public String getSkinRepoProperty() {
        return this.serverConfigurationService.getString("skin.repo");
    }

    public String getToolSkinCSS(String skinRepo) {
        String skin = this.siteService.findTool(this.sessionManager.getCurrentToolSession().getPlacementId()).getSkin();
        if (skin == null) {
            skin = this.serverConfigurationService.getString("skin.default");
        }
        return skinRepo + "/" + skin + "/tool.css";
    }

    public List<User> searchUsers(String search) {
        ArrayList<User> returnList = new ArrayList<User>();
        returnList.addAll(this.userDirectoryService.searchExternalUsers(search, -1, -1));
        returnList.addAll(this.userDirectoryService.searchUsers(search, 1, Integer.MAX_VALUE));
        return returnList;
    }

    public User getUser(String id) {
        try {
            return this.userDirectoryService.getUser(id);
        }
        catch (UserNotDefinedException e) {
            return null;
        }
    }

    public User getUserByEid(String eid) {
        try {
            return this.userDirectoryService.getUserByEid(eid);
        }
        catch (UserNotDefinedException e) {
            return null;
        }
    }

    public Site getSiteByRef(String siteRef) {
        Site site = null;
        Reference r = this.entityManager.newReference(siteRef);
        if (r.getType().equals("sakai:site")) {
            try {
                site = this.siteService.getSite(r.getId());
            }
            catch (IdUnusedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return site;
    }

    public Site getSiteById(String siteId) {
        Site site = null;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (IdUnusedException idUnusedException) {
            // empty catch block
        }
        return site;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSite(Site site) {
        SecurityAdvisor yesMan = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        try {
            this.securityService.pushAdvisor(yesMan);
            this.siteService.save(site);
        }
        catch (IdUnusedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (PermissionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.securityService.popAdvisor(yesMan);
        }
    }

    public String getRootName() {
        return this.serverConfigurationService.getString("delegatedaccess.root.title", this.serverConfigurationService.getString("ui.service", "Sakai"));
    }

    public String[] getServerConfigurationStrings(String property) {
        return this.serverConfigurationService.getStrings(property);
    }

    public Map<String, List<String>> getSiteTemplates() {
        HashMap<String, List<String>> returnList = new HashMap<String, List<String>>();
        for (AuthzGroup group : this.authzGroupService.getAuthzGroups("!site.", new PagingPosition(1, 99))) {
            returnList.put(group.getId(), this.getFilteredRoles(group, null));
        }
        return returnList;
    }

    public Map<String, List<String>> getShoppingRealmOptions() {
        String[] authzGroups = this.serverConfigurationService.getStrings("delegatedaccess.realmoptions.shopping");
        if (authzGroups != null && authzGroups.length != 0) {
            String[] filterRoles = this.serverConfigurationService.getStrings("delegatedaccess.roleoptions.shopping");
            return this.getGroupsById(authzGroups, filterRoles);
        }
        return this.getSiteTemplates();
    }

    public Map<String, List<String>> getDelegatedAccessRealmOptions() {
        String[] authzGroups = this.serverConfigurationService.getStrings("delegatedaccess.realmoptions.delegatedaccess");
        if (authzGroups != null && authzGroups.length != 0) {
            String[] filterRoles = this.serverConfigurationService.getStrings("delegatedaccess.roleoptions.delegatedaccess");
            return this.getGroupsById(authzGroups, filterRoles);
        }
        return this.getSiteTemplates();
    }

    private Map<String, List<String>> getGroupsById(String[] groups, String[] filterRoles) {
        HashMap<String, List<String>> returnList = new HashMap<String, List<String>>();
        for (int i = 0; i < groups.length; ++i) {
            try {
                AuthzGroup group = this.authzGroupService.getAuthzGroup(groups[i]);
                if (group == null) continue;
                returnList.put(group.getId(), this.getFilteredRoles(group, filterRoles));
                continue;
            }
            catch (GroupNotDefinedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return returnList;
    }

    private List<String> getFilteredRoles(AuthzGroup group, String[] filterRoles) {
        ArrayList<String> returnRoles = new ArrayList<String>();
        if (group != null) {
            block0: for (Role role : group.getRoles()) {
                if (filterRoles != null) {
                    for (int i = 0; i < filterRoles.length; ++i) {
                        if (!role.getId().equals(filterRoles[i])) continue;
                        returnRoles.add(role.getId());
                        continue block0;
                    }
                    continue;
                }
                returnRoles.add(role.getId());
            }
        }
        return returnRoles;
    }

    public void refreshCurrentUserAuthz() {
        this.authzGroupService.refreshUser(this.getCurrentUserId());
    }

    public Set<String> getUserMembershipForCurrentUser() {
        HashSet<String> returnSet = new HashSet<String>();
        for (Site site : this.siteService.getSites(SiteService.SelectionType.ACCESS, null, null, null, SiteService.SortType.NONE, null)) {
            returnSet.add(site.getReference());
        }
        return returnSet;
    }

    public List<Site> getSites(SiteService.SelectionType type, String search, Map<String, String> propsMap) {
        return this.siteService.getSites(type, null, search, propsMap, SiteService.SortType.NONE, null);
    }

    public boolean isShoppingTool() {
        return "sakai.delegatedaccess.shopping".equals(this.toolManager.getCurrentPlacement().getToolId());
    }

    public AuthzGroup getAuthzGroup(String siteId) {
        AuthzGroup group = null;
        try {
            group = this.authzGroupService.getAuthzGroup(siteId);
        }
        catch (GroupNotDefinedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoleFromAuthzGroup(AuthzGroup group, Role role) {
        SecurityAdvisor yesMan = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        try {
            group.removeRole(role.getId());
            this.securityService.pushAdvisor(yesMan);
            this.authzGroupService.save(group);
        }
        catch (AuthzPermissionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (GroupNotDefinedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.securityService.popAdvisor(yesMan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyNewRole(String siteRef, String copyRealm, String copyRole, String newRole) {
        SecurityAdvisor yesMan = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        try {
            this.securityService.pushAdvisor(yesMan);
            AuthzGroup sourceGroup = this.authzGroupService.getAuthzGroup(copyRealm);
            Role copyFromRole = sourceGroup.getRole(copyRole);
            AuthzGroup destGroup = this.authzGroupService.getAuthzGroup(siteRef);
            destGroup.removeRole(newRole);
            destGroup.addRole(newRole, copyFromRole);
            this.authzGroupService.save(destGroup);
        }
        catch (RoleAlreadyDefinedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (GroupNotDefinedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (AuthzPermissionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.securityService.popAdvisor(yesMan);
        }
    }

    public SecurityAdvisor addSiteUpdateSecurityAdvisor() {
        SecurityAdvisor yesMan = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                if ("site.upd".equals(function)) {
                    return SecurityAdvisor.SecurityAdvice.ALLOWED;
                }
                return SecurityAdvisor.SecurityAdvice.PASS;
            }
        };
        this.securityService.pushAdvisor(yesMan);
        return yesMan;
    }

    public void popSecurityAdvisor(SecurityAdvisor advisor) {
        this.securityService.popAdvisor(advisor);
    }

    public String getTermField() {
        return this.serverConfigurationService.getString("delegatedaccess.termfield", "term_eid");
    }

    public boolean useCourseManagementApiForTerms() {
        return this.serverConfigurationService.getBoolean("delegatedaccess.term.useCourseManagementApi", true);
    }

    public int showLatestXTerms() {
        return this.serverConfigurationService.getInt("delegatedaccess.term.showLatestXTerms", -1);
    }

    public List<String[]> getTerms() {
        if (this.terms == null) {
            int showLatestXTerms;
            this.terms = new ArrayList<String[]>();
            if (!this.useCourseManagementApiForTerms()) {
                List<String> termsList = this.dao.getDistinctSiteTerms(this.getTermField());
                String[] termOrder = this.serverConfigurationService.getStrings("portal.term.order");
                ArrayList termOrderList = new ArrayList();
                if (termOrder != null && termOrder.length > 0) {
                    Collections.addAll(termOrderList, termOrder);
                    for (String term : termOrderList) {
                        if (!termsList.contains(term)) continue;
                        this.terms.add(new String[]{term, term});
                    }
                }
                for (String term : termsList) {
                    if (termOrderList != null && termOrderList.size() != 0 && termOrderList.contains(term)) continue;
                    this.terms.add(new String[]{term, term});
                }
            } else {
                List academicSessions = this.cms.getAcademicSessions();
                if (academicSessions != null) {
                    Collections.sort(academicSessions, new Comparator<AcademicSession>(){

                        @Override
                        public int compare(AcademicSession o1, AcademicSession o2) {
                            if (o1.getStartDate() == null) {
                                return -1;
                            }
                            if (o2.getStartDate() == null) {
                                return 1;
                            }
                            return o2.getStartDate().compareTo(o1.getStartDate());
                        }
                    });
                    for (AcademicSession session : academicSessions) {
                        String termId = session.getEid();
                        if (!"term_eid".equals(this.getTermField())) {
                            termId = session.getTitle();
                        }
                        this.terms.add(new String[]{termId, session.getTitle()});
                    }
                }
            }
            if ((showLatestXTerms = this.showLatestXTerms()) != -1) {
                showLatestXTerms = showLatestXTerms < this.terms.size() ? showLatestXTerms : this.terms.size();
                this.terms = this.terms.subList(0, showLatestXTerms);
            }
        }
        return this.terms;
    }

    public void sendEmail(String subject, String body) {
        String toAddress;
        String fromAddress = toAddress = this.serverConfigurationService.getString("delegatedaccess.email.errors");
        if (toAddress != null && !"".equals(toAddress)) {
            this.emailService.send(fromAddress, toAddress, subject, body, null, null, null);
        }
    }

    public boolean getDisableUserTreeView() {
        return this.serverConfigurationService.getBoolean("delegatedaccess.disable.user.tree.view", false);
    }

    public boolean getDisableShoppingTreeView() {
        return this.serverConfigurationService.getBoolean("delegatedaccess.disable.shopping.tree.view", false);
    }

    public boolean isUserInstructor(String userId, String siteId) {
        Site site = this.getSiteById(siteId);
        return this.isUserInstructor(userId, site);
    }

    private boolean isUserInstructor(String userId, Site site) {
        return site != null && site.getMember(userId) != null && this.securityService.unlock(userId, "site.upd", this.siteService.siteReference(site.getId()));
    }

    public List<User> getInstructorsForSite(String siteId) {
        ArrayList<User> instructors = new ArrayList<User>();
        Site site = this.getSiteById(siteId);
        if (site != null) {
            for (Member member : site.getMembers()) {
                if (!this.isUserInstructor(member.getUserId(), site)) continue;
                try {
                    instructors.add(this.userDirectoryService.getUser(member.getUserId()));
                }
                catch (UserNotDefinedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return instructors;
    }

    public boolean isUserMember(String userId, String siteRef) {
        return this.authzGroupService.getUserRole(userId, siteRef) != null;
    }

    public Map<String, String> isUserMember(String userId, Collection<String> siteRefs) {
        return this.authzGroupService.getUserRoles(userId, siteRefs);
    }

    public boolean isShoppingPeriodInstructorEditable() {
        return this.serverConfigurationService.getBoolean("delegatedaccess.shopping.instructorEditable", false);
    }

    public boolean getSyncMyworkspaceTool() {
        return this.serverConfigurationService.getBoolean("delegatedaccess.sync.myworkspacetool", true);
    }

    public String[] getHideRolesForInstructorViewAccess() {
        return this.serverConfigurationService.getStrings("delegatedaccess.siteaccess.instructorViewable.hiddenRoles");
    }

    public String[] getSubAdminOrderedRealmRoles() {
        return this.serverConfigurationService.getStrings("delegatedaccess.subadmin.realmrole.order");
    }

    public boolean isActiveSiteFlagEnabled() {
        return this.serverConfigurationService.getBoolean("delegatedaccess.enable.active.site.flag", false);
    }

    public void setSessionUserId(String userId) {
        this.sessionManager.getCurrentSession().setUserId(userId);
    }

    public boolean allowAccessAdminsSetBecomeUserPerm() {
        return this.serverConfigurationService.getBoolean("delegatedaccess.allow.accessadmin.set.allowBecomeUser", true);
    }

    public String siteReference(String context) {
        return this.siteService.siteReference(context);
    }

    public Placement getCurrentPlacement() {
        return this.toolManager.getCurrentPlacement();
    }

    public boolean isProviderIdLookupEnabled() {
        return this.serverConfigurationService.getBoolean("delegatedaccess.enableProviderIdLookup", false);
    }

    public String getProviderId(String siteRef) {
        try {
            return this.authzGroupService.getAuthzGroup(siteRef).getProviderGroupId();
        }
        catch (GroupNotDefinedException e) {
            return "";
        }
    }

    public String getHierarchySearchLabel(String hierarchyLevel) {
        return this.serverConfigurationService.getString("delegatedaccess.search.hierarchyLabel." + hierarchyLevel, hierarchyLevel);
    }

    public boolean isSearchHideTerm() {
        return this.serverConfigurationService.getBoolean("delegatedaccess.search.hideTerm", false);
    }

    public AuthzGroupService getAuthzGroupService() {
        return this.authzGroupService;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public DelegatedAccessDao getDao() {
        return this.dao;
    }

    public void setDao(DelegatedAccessDao dao) {
        this.dao = dao;
    }

    public CourseManagementService getCms() {
        return this.cms;
    }

    public void setCms(CourseManagementService cms) {
        this.cms = cms;
    }

    public EmailService getEmailService() {
        return this.emailService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }
}

