/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.dao.impl;

import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.InvariantReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Logger;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.delegatedaccess.dao.DelegatedAccessDao;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class DelegatedAccessDaoImpl
extends JdbcDaoSupport
implements DelegatedAccessDao {
    private static final Logger log = Logger.getLogger(DelegatedAccessDaoImpl.class);
    private PropertiesConfiguration statements;
    private static int ORACLE_IN_CLAUSE_SIZE_LIMIT = 1000;

    public void init() {
        log.info((Object)"init()");
        String vendor = ServerConfigurationService.getInstance().getString("vendor@org.sakaiproject.db.api.SqlService", null);
        this.initStatements(vendor);
    }

    private void initStatements(String vendor) {
        URL url = this.getClass().getClassLoader().getResource(vendor + ".properties");
        try {
            this.statements = new PropertiesConfiguration();
            this.statements.setReloadingStrategy((ReloadingStrategy)new InvariantReloadingStrategy());
            this.statements.setThrowExceptionOnMissing(true);
            this.statements.setDelimiterParsingDisabled(true);
            this.statements.load(url);
        }
        catch (ConfigurationException e) {
            log.error((Object)(((Object)((Object)e)).getClass() + ": " + e.getMessage()));
            return;
        }
    }

    private String getStatement(String key) {
        try {
            return this.statements.getString(key);
        }
        catch (NoSuchElementException e) {
            log.error((Object)("Statement: '" + key + "' could not be found in: " + this.statements.getFileName()));
            return null;
        }
    }

    @Override
    public List<String> getDistinctSiteTerms(String termField) {
        try {
            return this.getJdbcTemplate().query(this.getStatement("select.distinctTerms"), (Object[])new String[]{termField}, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString(1);
                }
            });
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public String getSiteProperty(String propertyName, String siteId) {
        try {
            return (String)this.getJdbcTemplate().queryForObject(this.getStatement("select.siteProperty"), new Object[]{propertyName, siteId}, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString("VALUE");
                }
            });
        }
        catch (DataAccessException ex) {
            return null;
        }
    }

    @Override
    public Map<String, List<String>> getNodesBySiteRef(String[] siteRefs, String hierarchyId) {
        try {
            int subArraySize;
            HashMap<String, List<String>> returnMap = new HashMap<String, List<String>>();
            int subArrayIndex = 0;
            do {
                if (subArrayIndex + (subArraySize = ORACLE_IN_CLAUSE_SIZE_LIMIT) > siteRefs.length) {
                    subArraySize = siteRefs.length - subArrayIndex;
                }
                String[] subSiteRefs = Arrays.copyOfRange(siteRefs, subArrayIndex, subArrayIndex + subArraySize);
                String query = this.getStatement("select.hierarchyNode");
                String inParams = "(";
                for (int i = 0; i < subSiteRefs.length; ++i) {
                    inParams = inParams + "'" + subSiteRefs[i] + "'";
                    if (i >= subSiteRefs.length - 1) continue;
                    inParams = inParams + ",";
                }
                inParams = inParams + ")";
                query = query.replace("(?)", inParams);
                List results = this.getJdbcTemplate().query(query, new Object[]{hierarchyId}, new RowMapper(){

                    public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                        return new String[]{resultSet.getString("title"), resultSet.getString("ID")};
                    }
                });
                if (results == null) continue;
                for (String[] result : results) {
                    if (result == null || result.length != 2) continue;
                    if (!returnMap.containsKey(result[0])) {
                        returnMap.put(result[0], new ArrayList());
                    }
                    ((List)returnMap.get(result[0])).add(result[1]);
                }
            } while ((subArrayIndex += subArraySize) < siteRefs.length);
            return returnMap;
        }
        catch (DataAccessException ex) {
            return null;
        }
    }

    @Override
    public List<String> getEmptyNonSiteNodes(String hierarchyId) {
        try {
            return this.getJdbcTemplate().query(this.getStatement("select.emptyNodes"), new Object[]{hierarchyId}, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString("ID");
                }
            });
        }
        catch (DataAccessException ex) {
            return null;
        }
    }

    @Override
    public void addSiteProperty(String siteId, String propertyName, String propertyValue) {
        try {
            this.getJdbcTemplate().update(this.getStatement("insert.siteProperty"), new Object[]{siteId, propertyName, propertyValue});
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()));
        }
    }

    @Override
    public void updateSiteProperty(String siteId, String propertyName, String propertyValue) {
        try {
            this.getJdbcTemplate().update(this.getStatement("update.siteProperty"), new Object[]{propertyValue, propertyName, siteId});
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()));
        }
    }

    @Override
    public void removeSiteProperty(String siteId, String propertyName) {
        try {
            this.getJdbcTemplate().update(this.getStatement("delete.siteProperty"), new Object[]{propertyName, siteId});
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()));
        }
    }
}

