/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sakaiproject.delegatedaccess.entity.DelegatedAccessEntityProvider;
import org.sakaiproject.delegatedaccess.logic.ProjectLogic;
import org.sakaiproject.delegatedaccess.logic.SakaiProxy;
import org.sakaiproject.delegatedaccess.model.AccessNode;
import org.sakaiproject.delegatedaccess.model.ListOptionSerialized;
import org.sakaiproject.delegatedaccess.model.NodeModel;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.PropertyProvideable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestAware;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestStorable;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestGetter;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestStorage;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.user.api.User;

public class DelegatedAccessEntityProviderImpl
implements DelegatedAccessEntityProvider,
CoreEntityProvider,
AutoRegisterEntityProvider,
PropertyProvideable,
RequestStorable,
RESTful,
RequestAware {
    private ProjectLogic projectLogic;
    private SakaiProxy sakaiProxy;

    public String getEntityPrefix() {
        return "delegated_access";
    }

    private String getFirstNodeId(String siteRef, String hierarchyId) {
        Map nodeIds = this.projectLogic.getNodesBySiteRef(new String[]{siteRef}, hierarchyId);
        if (nodeIds != null && nodeIds.containsKey(siteRef) && nodeIds.get(siteRef) != null && ((List)nodeIds.get(siteRef)).size() == 1) {
            return (String)((List)nodeIds.get(siteRef)).get(0);
        }
        return null;
    }

    public boolean entityExists(String id) {
        String firstNodeId = this.getFirstNodeId("/site/" + id, "delegatedAccessHierarchyId");
        return firstNodeId != null;
    }

    public String getPropertyValue(String reference, String name) {
        return this.getProperties(reference).get(name);
    }

    public Map<String, String> getProperties(String reference) {
        String siteRef = "/site/" + reference.substring(reference.lastIndexOf("/") + 1);
        String nodeId = this.getFirstNodeId(siteRef, "delegatedAccessHierarchyId");
        if (nodeId == null) {
            throw new IllegalArgumentException("NodeId: " + reference + " doesn't exist");
        }
        NodeModel node = this.projectLogic.getNodeModel(nodeId, "120dv0f43cv90sdf0asv9");
        if (node == null) {
            throw new IllegalArgumentException("NodeId: " + nodeId + " doesn't exist");
        }
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("shoppingAuth", node.getNodeShoppingPeriodAuth());
        valuesMap.put("shoppingStartDate", Long.toString(node.getNodeShoppingPeriodStartDate().getTime()));
        valuesMap.put("shoppingEndDate", Long.toString(node.getNodeShoppingPeriodEndDate().getTime()));
        valuesMap.put("shoppingRealm", node.getNodeAccessRealmRole()[0]);
        valuesMap.put("shoppingRole", node.getNodeAccessRealmRole()[1]);
        valuesMap.put("directAccess", "" + node.isDirectAccess());
        return valuesMap;
    }

    public void setPropertyValue(String reference, String name, String value) {
    }

    public List<String> findEntityRefs(String[] prefixes, String[] name, String[] searchValue, boolean exactMatch) {
        return null;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        return null;
    }

    public Object getSampleEntity() {
        return null;
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        NodeModel node;
        if (!(this.sakaiProxy.isSuperUser() || this.sakaiProxy.isUserInstructor(this.sakaiProxy.getCurrentUserId(), ref.getId()) && this.sakaiProxy.isShoppingPeriodInstructorEditable())) {
            throw new IllegalArgumentException("User: " + this.sakaiProxy.getCurrentUserId() + " is not a member of the site with site.upd permission or an admin");
        }
        String siteRef = "/site/" + ref.getId();
        String nodeId = this.getFirstNodeId(siteRef, "delegatedAccessHierarchyId");
        if (nodeId == null) {
            throw new IllegalArgumentException("Node doesn't exist or has multiple instances: " + ref.getId());
        }
        String shoppingAuth = (String)params.get("shoppingAuth");
        String shoppingStartDateStr = (String)params.get("shoppingStartDate");
        String shoppingEndDateStr = (String)params.get("shoppingEndDate");
        String role = (String)params.get("shoppingRole");
        String realm = (String)params.get("shoppingRealm");
        Object toolList = params.get("shoppingShowTools");
        boolean directAccess = true;
        if (params.get("directAccess") != null) {
            directAccess = Boolean.valueOf("" + params.get("directAccess"));
        }
        String[] tools = null;
        if (toolList != null) {
            if (toolList instanceof String[]) {
                tools = (String[])params.get("shoppingShowTools");
            } else if (toolList instanceof String && !"".equals(toolList)) {
                tools = new String[]{(String)toolList};
            }
        }
        Date shoppingStartDate = null;
        Date shoppingEndDate = null;
        if (shoppingStartDateStr != null && !"".equals(shoppingStartDateStr)) {
            try {
                shoppingStartDate = new Date(Long.parseLong(shoppingStartDateStr));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("shoppingStartDate: " + shoppingStartDateStr + " is not a valid date time.");
            }
        }
        if (shoppingEndDateStr != null && !"".equals(shoppingEndDateStr)) {
            try {
                shoppingEndDate = new Date(Long.parseLong(shoppingEndDateStr));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("shoppingEndDate: " + shoppingEndDateStr + " is not a valid date time.");
            }
        }
        if ((node = this.projectLogic.getNodeModel(nodeId, "120dv0f43cv90sdf0asv9")).getNodeShoppingPeriodRevokeInstructorEditable()) {
            throw new IllegalArgumentException("This node has the ability for an instructor to make edits to the shopping period settings revoked.  Node: " + node.getNodeId() + ", ref: " + ref.getId());
        }
        if (!directAccess) {
            node.setDirectAccess(false);
            this.projectLogic.updateNodePermissionsForUser(node, "120dv0f43cv90sdf0asv9");
            return;
        }
        boolean directAccessOrig = node.isDirectAccess();
        String authOrig = node.getNodeShoppingPeriodAuth();
        Date startDateOrig = node.getNodeShoppingPeriodStartDate();
        Date endDateOrig = node.getNodeShoppingPeriodEndDate();
        String realmOrig = node.getNodeAccessRealmRole()[0];
        String roleOrig = node.getNodeAccessRealmRole()[1];
        String[] toolsOrig = node.getNodeRestrictedTools();
        node.setShoppingPeriodAuth(shoppingAuth);
        node.setShoppingPeriodStartDate(shoppingStartDate);
        node.setShoppingPeriodEndDate(shoppingEndDate);
        node.setRealm(realm);
        node.setRole(role);
        node.setRestrictedTools(this.projectLogic.getEntireToolsList());
        if (tools != null) {
            for (String toolId : tools) {
                node.setToolRestricted(toolId, true);
            }
        }
        node.setDirectAccess(directAccess);
        String authNew = node.getNodeShoppingPeriodAuth();
        Date startDateNew = node.getNodeShoppingPeriodStartDate();
        Date endDateNew = node.getNodeShoppingPeriodEndDate();
        String realmNew = node.getNodeAccessRealmRole()[0];
        String roleNew = node.getNodeAccessRealmRole()[1];
        String[] toolsNew = node.getNodeRestrictedTools();
        if (directAccessOrig != directAccess || node.isModified(authOrig, authNew, startDateOrig, startDateNew, endDateOrig, endDateNew, realmOrig, realmNew, roleOrig, roleNew, toolsOrig, toolsNew)) {
            this.projectLogic.updateNodePermissionsForUser(node, "120dv0f43cv90sdf0asv9");
        }
    }

    public Object getEntity(EntityReference ref) {
        String siteRef = "/site/" + ref.getId();
        String nodeId = this.getFirstNodeId(siteRef, "delegatedAccessHierarchyId");
        if (nodeId == null) {
            throw new IllegalArgumentException("NodeId for Site: " + ref + " doesn't exist");
        }
        NodeModel node = this.projectLogic.getNodeModel(nodeId, "120dv0f43cv90sdf0asv9");
        if (node == null) {
            throw new IllegalArgumentException("NodeId: " + nodeId + " doesn't exist");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("shoppingAuth", node.getNodeShoppingPeriodAuth());
        valuesMap.put("shoppingStartDate", node.getNodeShoppingPeriodStartDate());
        valuesMap.put("shoppingEndDate", node.getNodeShoppingPeriodEndDate());
        valuesMap.put("shoppingRealm", node.getNodeAccessRealmRole()[0]);
        valuesMap.put("shoppingRole", node.getNodeAccessRealmRole()[1]);
        valuesMap.put("directAccess", node.isDirectAccess());
        valuesMap.put("revokeInstructorEditable", node.getNodeShoppingPeriodRevokeInstructorEditable());
        valuesMap.put("shoppingShowTools", node.getNodeRestrictedTools());
        return valuesMap;
    }

    @EntityCustomAction(action="shoppingOptions", viewKey="list")
    public List<?> getShoppingOptions(EntityView view, Map<String, Object> params) {
        String option = view.getPathSegment(2);
        if (option == null || "".equals(option)) {
            throw new IllegalArgumentException("An option is required:  shoppingOptions/roles, shoppingOptions/tools, shoppingOptions/authorization");
        }
        if ("roles".equals(option)) {
            return this.convertMapToSerializedList(this.projectLogic.getRealmRoleDisplay(true));
        }
        if ("tools".equals(option)) {
            return this.convertListToSerializedList(this.projectLogic.getEntireToolsList());
        }
        if ("authorization".equals(option)) {
            return this.convertListToSerializedList(this.projectLogic.getAuthorizationOptions());
        }
        throw new IllegalArgumentException("A valid option is required:  shoppingOptions/roles, shoppingOptions/tools, shoppingOptions/authorization");
    }

    private List<GenericOutputSerialized> convertListToSerializedList(List<ListOptionSerialized> list) {
        ArrayList<GenericOutputSerialized> returnList = new ArrayList<GenericOutputSerialized>();
        for (ListOptionSerialized l : list) {
            returnList.add(new GenericOutputSerialized(l.getId(), l.getName()));
        }
        this.sortGenericOutputList(returnList);
        return returnList;
    }

    private List<GenericOutputSerialized> convertMapToSerializedList(Map<String, String> map) {
        ArrayList<GenericOutputSerialized> returnList = new ArrayList<GenericOutputSerialized>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            returnList.add(new GenericOutputSerialized(entry.getKey(), entry.getValue()));
        }
        this.sortGenericOutputList(returnList);
        return returnList;
    }

    private void sortGenericOutputList(List<GenericOutputSerialized> l) {
        Collections.sort(l, new Comparator<GenericOutputSerialized>(){

            @Override
            public int compare(GenericOutputSerialized arg0, GenericOutputSerialized arg1) {
                return arg0.getValue().compareToIgnoreCase(arg1.getValue());
            }
        });
    }

    @EntityCustomAction(action="initialize", viewKey="list")
    public List initializeAccessForSite(EntityView view, Map<String, Object> params) {
        String option = view.getPathSegment(2);
        if (option == null || "".equals(option)) {
            throw new IllegalArgumentException("Expected url path is /initialize/site/{id}");
        }
        if ("site".equals(option)) {
            String siteId = view.getPathSegment(3);
            if (siteId != null && !"".equals(siteId)) {
                return Arrays.asList(this.projectLogic.getCurrentUsersAccessToSite("/site/" + siteId));
            }
            throw new IllegalArgumentException("Expected url path is /initialize/site/{id}");
        }
        throw new IllegalArgumentException("Expected url path is /initialize/site/{id}");
    }

    @EntityCustomAction(action="access", viewKey="list")
    public List getUsersWithAccessToSite(EntityView view, Map<String, Object> params) {
        String option = view.getPathSegment(2);
        if (option == null || "".equals(option)) {
            throw new IllegalArgumentException("Expected url path is /access/site/{id}");
        }
        if ("site".equals(option)) {
            String siteId = view.getPathSegment(3);
            if (siteId != null && !"".equals(siteId)) {
                if (!this.sakaiProxy.isSuperUser() && !this.sakaiProxy.isUserInstructor(this.sakaiProxy.getCurrentUserId(), siteId)) {
                    throw new IllegalArgumentException("You must be an instructor or admin user to view this information.");
                }
                ArrayList returnList = new ArrayList();
                for (AccessNode node : this.projectLogic.getUserAccessForSite("/site/" + siteId).values()) {
                    HashMap<String, Object> accessMap = new HashMap<String, Object>();
                    accessMap.put("realm", "");
                    accessMap.put("role", "");
                    if (node.getAccess() != null && node.getAccess().length == 2) {
                        accessMap.put("realm", node.getAccess()[0]);
                        accessMap.put("role", node.getAccess()[1]);
                    }
                    accessMap.put("deniedTools", node.getDeniedTools());
                    accessMap.put("userId", node.getUserId());
                    User user = this.sakaiProxy.getUser(node.getUserId());
                    accessMap.put("userEid", "");
                    accessMap.put("userDisplayName", "");
                    if (user != null) {
                        accessMap.put("userEid", user.getEid());
                        accessMap.put("userDisplayName", user.getDisplayName());
                    }
                    String deniedToolsNames = "";
                    if (node.getDeniedTools() != null) {
                        for (String toolId : node.getDeniedTools()) {
                            Tool tool = this.sakaiProxy.getTool(toolId);
                            if (tool == null) continue;
                            if (!deniedToolsNames.equals("")) {
                                deniedToolsNames = deniedToolsNames + ", ";
                            }
                            deniedToolsNames = deniedToolsNames + tool.getTitle();
                        }
                    }
                    accessMap.put("deniedToolsNames", deniedToolsNames);
                    returnList.add(accessMap);
                }
                String[] hiddenRoles = this.sakaiProxy.getHideRolesForInstructorViewAccess();
                if (hiddenRoles != null) {
                    Iterator iterator = returnList.iterator();
                    block2: while (iterator.hasNext()) {
                        Map map = (Map)iterator.next();
                        for (String role : hiddenRoles) {
                            if (!map.containsKey("role") || !role.equals(map.get("role"))) continue;
                            iterator.remove();
                            continue block2;
                        }
                    }
                }
                return returnList;
            }
            throw new IllegalArgumentException("Expected url path is /access/site/{id}");
        }
        throw new IllegalArgumentException("Expected url path is /access/site/{id}");
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        return null;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"html", "xml", "json"};
    }

    public String[] getHandledInputFormats() {
        return null;
    }

    public void setRequestGetter(RequestGetter requestGetter) {
    }

    public void setRequestStorage(RequestStorage requestStorage) {
    }

    public ProjectLogic getProjectLogic() {
        return this.projectLogic;
    }

    public void setProjectLogic(ProjectLogic projectLogic) {
        this.projectLogic = projectLogic;
    }

    public SakaiProxy getSakaiProxy() {
        return this.sakaiProxy;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public class GenericOutputSerialized
    implements Serializable {
        public String key;
        public String value;

        public GenericOutputSerialized(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

