/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.jobs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.delegatedaccess.dao.DelegatedAccessDao;
import org.sakaiproject.delegatedaccess.logic.ProjectLogic;
import org.sakaiproject.delegatedaccess.logic.SakaiProxy;
import org.sakaiproject.delegatedaccess.model.NodeModel;
import org.sakaiproject.hierarchy.HierarchyService;
import org.sakaiproject.hierarchy.model.HierarchyNode;

public class DelegatedAccessShoppingPeriodJob
implements StatefulJob {
    private static final Logger log = Logger.getLogger(DelegatedAccessShoppingPeriodJob.class);
    private ProjectLogic projectLogic;
    private SakaiProxy sakaiProxy;
    private HierarchyService hierarchyService;
    private DelegatedAccessDao dao;
    private Map<String, String> migratedHierarchyIds;
    private static boolean semaphore = false;
    private Map<String, String> errors = new HashMap<String, String>();

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        if (semaphore) {
            log.warn((Object)"Stopping job since this job is already running");
            return;
        }
        semaphore = true;
        try {
            this.errors = new HashMap<String, String>();
            log.info((Object)"DelegatedAccessShoppingPeriodJob started");
            long startTime = System.currentTimeMillis();
            SecurityAdvisor advisor = this.sakaiProxy.addSiteUpdateSecurityAdvisor();
            this.migratedHierarchyIds = new HashMap<String, String>();
            TreeModel treeModel = this.projectLogic.getEntireTreePlusUserPerms("120dv0f43cv90sdf0asv9");
            if (treeModel != null && treeModel.getRoot() != null) {
                try {
                    this.hierarchyService.destroyHierarchy("shoppingPeriodHierarchyId");
                }
                catch (Exception e) {
                    // empty catch block
                }
                HierarchyNode delegatedRootNode = this.hierarchyService.getRootNode("delegatedAccessHierarchyId");
                HierarchyNode rootNode = this.hierarchyService.createHierarchy("shoppingPeriodHierarchyId");
                this.hierarchyService.saveNodeMetaData(rootNode.id, delegatedRootNode.title, delegatedRootNode.description, null);
                for (String perm : this.hierarchyService.getPermsForUserNodes("120dv0f43cv90sdf0asv9", new String[]{delegatedRootNode.id})) {
                    this.hierarchyService.assignUserNodePerm("120dv0f43cv90sdf0asv9", rootNode.id, perm, false);
                }
                this.migratedHierarchyIds.put(delegatedRootNode.id, rootNode.id);
                this.treeModelShoppingPeriodTraverser((DefaultMutableTreeNode)treeModel.getRoot());
            }
            this.sakaiProxy.popSecurityAdvisor(advisor);
            log.info((Object)("DelegatedAccessShoppingPeriodJob finished in " + (System.currentTimeMillis() - startTime) + " ms"));
            if (this.errors.size() > 0) {
                String warning = "The following sites had errors: \n\n";
                for (Map.Entry<String, String> entry : this.errors.entrySet()) {
                    warning = warning + entry.getKey() + ": " + entry.getValue() + "\n";
                }
                log.warn((Object)warning);
                this.sakaiProxy.sendEmail("DelegatedAccessShoppingPeriodJob error", warning);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.sakaiProxy.sendEmail("DelegatedAccessShoppingPeriodJob error", sw.toString());
        }
        finally {
            semaphore = false;
        }
    }

    private void treeModelShoppingPeriodTraverser(DefaultMutableTreeNode node) {
        if (node != null) {
            NodeModel nodeModel = (NodeModel)node.getUserObject();
            if (nodeModel.getNode().title.startsWith("/site/")) {
                try {
                    this.shoppingPeriodRoleHelper(nodeModel);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    this.errors.put(nodeModel.getNode().title, sw.toString());
                }
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.treeModelShoppingPeriodTraverser((DefaultMutableTreeNode)node.getChildAt(i));
            }
        }
    }

    private void shoppingPeriodRoleHelper(NodeModel node) {
        Date startDate = null;
        Date endDate = null;
        Date now = new Date();
        String auth = node.getNodeShoppingPeriodAuth();
        startDate = node.getNodeShoppingPeriodStartDate();
        endDate = node.getNodeShoppingPeriodEndDate();
        String[] nodeAccessRealmRole = node.getNodeAccessRealmRole();
        String siteId = node.getNode().title.substring(6);
        boolean addAuth = this.projectLogic.isShoppingPeriodOpenForSite(startDate, endDate, nodeAccessRealmRole, auth);
        String restrictedToolsList = "";
        if (addAuth) {
            restrictedToolsList = ";";
            for (String tool : node.getNodeRestrictedTools()) {
                if (!"".equals(restrictedToolsList)) {
                    restrictedToolsList = restrictedToolsList + ";";
                }
                if ("Home".equals(tool)) {
                    String[] homeTools;
                    String homeToolsVal = "";
                    for (String toolId : homeTools = this.sakaiProxy.getHomeTools()) {
                        if (!"".equals(homeToolsVal)) {
                            homeToolsVal = homeToolsVal + ";";
                        }
                        homeToolsVal = homeToolsVal + toolId;
                    }
                    restrictedToolsList = restrictedToolsList + homeToolsVal;
                    continue;
                }
                restrictedToolsList = restrictedToolsList + tool;
            }
            this.removeAnonAndAuthRoles(node.getNode().title);
            this.copyNewRole(node.getNode().title, nodeAccessRealmRole[0], nodeAccessRealmRole[1], auth);
            this.checkAndAddNode(node);
        } else {
            this.removeAnonAndAuthRoles(node.getNode().title);
        }
        if (restrictedToolsList == null || "".equals(restrictedToolsList) || ";".equals(restrictedToolsList)) {
            this.dao.removeSiteProperty(siteId, "shopping-period-restricted-tools");
        } else {
            String sitePropRestrictedTools = this.dao.getSiteProperty("shopping-period-restricted-tools", siteId);
            if (sitePropRestrictedTools != null) {
                this.dao.updateSiteProperty(siteId, "shopping-period-restricted-tools", restrictedToolsList);
            } else {
                this.dao.addSiteProperty(siteId, "shopping-period-restricted-tools", restrictedToolsList);
            }
        }
    }

    private void removeAnonAndAuthRoles(String siteRef) {
        AuthzGroup ag = this.sakaiProxy.getAuthzGroup(siteRef);
        log.debug((Object)("Removing .auth and.anon roles for " + siteRef));
        for (Role role : ag.getRoles()) {
            if (!role.getId().equals(".auth") && !role.getId().equals(".anon")) continue;
            this.sakaiProxy.removeRoleFromAuthzGroup(ag, role);
        }
    }

    private void copyNewRole(String siteRef, String copyRealm, String copyRole, String newRole) {
        log.debug((Object)("Copying " + copyRole + " to " + newRole + " for " + siteRef));
        this.sakaiProxy.copyNewRole(siteRef, copyRealm, copyRole, newRole);
    }

    private void checkAndAddNode(NodeModel node) {
        NodeModel parent = node.getParentNode();
        if (parent != null) {
            this.checkAndAddNode(parent);
        }
        if (!this.migratedHierarchyIds.containsKey(node.getNodeId()) && parent != null && this.migratedHierarchyIds.containsKey(parent.getNodeId())) {
            HierarchyNode newNode = this.hierarchyService.addNode("shoppingPeriodHierarchyId", this.migratedHierarchyIds.get(parent.getNodeId()));
            this.hierarchyService.saveNodeMetaData(newNode.id, node.getNode().title, node.getNode().description, null);
            this.hierarchyService.addChildRelation(this.migratedHierarchyIds.get(parent.getNodeId()), newNode.id);
            for (String perm : this.hierarchyService.getPermsForUserNodes("120dv0f43cv90sdf0asv9", new String[]{node.getNodeId()})) {
                this.hierarchyService.assignUserNodePerm("120dv0f43cv90sdf0asv9", newNode.id, perm, false);
            }
            this.migratedHierarchyIds.put(node.getNodeId(), newNode.id);
        }
    }

    public ProjectLogic getProjectLogic() {
        return this.projectLogic;
    }

    public void setProjectLogic(ProjectLogic projectLogic) {
        this.projectLogic = projectLogic;
    }

    public SakaiProxy getSakaiProxy() {
        return this.sakaiProxy;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public HierarchyService getHierarchyService() {
        return this.hierarchyService;
    }

    public void setHierarchyService(HierarchyService hierarchyService) {
        this.hierarchyService = hierarchyService;
    }

    public DelegatedAccessDao getDao() {
        return this.dao;
    }

    public void setDao(DelegatedAccessDao dao) {
        this.dao = dao;
    }
}

