/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.tool.pages;

import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.tree.AbstractTree;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.sakaiproject.delegatedaccess.model.NodeModel;
import org.sakaiproject.delegatedaccess.tool.pages.BasePage;
import org.sakaiproject.delegatedaccess.tool.pages.BaseTreePage;

public abstract class BaseTreePage
extends BasePage {
    protected abstract AbstractTree getTree();

    protected void updateNodeAccess(String userId, String[] defaultRole) {
        DefaultMutableTreeNode rootNode;
        if (this.getTree() != null && (rootNode = (DefaultMutableTreeNode)this.getTree().getModelObject().getRoot()) != null) {
            this.updateNodeAccessHelper(rootNode, userId, defaultRole);
        }
    }

    private void updateNodeAccessHelper(DefaultMutableTreeNode node, String userId, String[] defaultRole) {
        if (node.getUserObject() != null) {
            NodeModel nodeModel = (NodeModel)node.getUserObject();
            if (defaultRole != null && defaultRole.length == 2) {
                nodeModel.setRealm(defaultRole[0]);
                nodeModel.setRole(defaultRole[1]);
            }
            if (nodeModel.isModified()) {
                this.projectLogic.updateNodePermissionsForUser(nodeModel, userId);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.updateNodeAccessHelper((DefaultMutableTreeNode)node.getChildAt(i), userId, defaultRole);
            }
        }
    }

    protected void collapseEmptyFolders() {
        this.collapseEmptyFoldersHelper((DefaultMutableTreeNode)this.getTree().getModelObject().getRoot());
    }

    protected void collapseEmptyFoldersHelper(DefaultMutableTreeNode node) {
        if (node != null) {
            if (!node.isLeaf() && node.getChildCount() == 0) {
                this.getTree().getTreeState().collapseNode((Object)node);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.collapseEmptyFoldersHelper((DefaultMutableTreeNode)node.getChildAt(i));
            }
        }
    }

    protected AjaxLink getExpandCollapseLink() {
        Label expandCollapse = new Label("expandCollapse", (IModel)new StringResourceModel("exapndNodes", null));
        expandCollapse.setOutputMarkupId(true);
        1 expandLink = new /* Unavailable Anonymous Inner Class!! */;
        expandLink.add(new Component[]{expandCollapse});
        return expandLink;
    }

    private void createInheritedSpan() {
        WebMarkupContainer inheritedSpan = new WebMarkupContainer("inheritedSpan");
        inheritedSpan.setOutputMarkupId(true);
        String inheritedSpanId = inheritedSpan.getMarkupId();
        this.add(new Component[]{inheritedSpan});
        2 inheritedRestrictedToolsModel = new /* Unavailable Anonymous Inner Class!! */;
        3 inheritedListView = new /* Unavailable Anonymous Inner Class!! */;
        inheritedListView.setOutputMarkupId(true);
        inheritedSpan.add(new Component[]{inheritedListView});
        4 closeInheritedSpanLink = new /* Unavailable Anonymous Inner Class!! */;
        inheritedSpan.add(new Component[]{closeInheritedSpanLink});
        Label inheritedNodeTitle = new Label("inheritedNodeTitle", "");
        inheritedSpan.add(new Component[]{inheritedNodeTitle});
        Label noInheritedToolsLabel = new Label("noToolsInherited", (IModel)new StringResourceModel("inheritedNothing", null));
        inheritedSpan.add(new Component[]{noInheritedToolsLabel});
    }
}

