/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.tool.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.PropertyTreeColumn;
import org.apache.wicket.extensions.markup.html.tree.table.TreeTable;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.tree.AbstractTree;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.sakaiproject.delegatedaccess.model.HierarchyNodeSerialized;
import org.sakaiproject.delegatedaccess.model.SearchResult;
import org.sakaiproject.delegatedaccess.tool.pages.BaseTreePage;
import org.sakaiproject.delegatedaccess.tool.pages.UserEditPage;
import org.sakaiproject.delegatedaccess.utils.PropertyEditableColumnCheckbox;
import org.sakaiproject.delegatedaccess.utils.PropertyEditableColumnDropdown;
import org.sakaiproject.delegatedaccess.utils.PropertyEditableColumnList;

public class UserEditPage
extends BaseTreePage {
    private TreeTable tree;
    private static final Logger log = Logger.getLogger(UserEditPage.class);
    private String[] defaultRole = null;
    List<String> accessAdminNodeIds = null;

    protected AbstractTree getTree() {
        return this.tree;
    }

    public UserEditPage(SearchResult searchResult) {
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        String formFeedbackId = formFeedback.getMarkupId();
        this.add(new Component[]{formFeedback});
        Label formFeedback2 = new Label("formFeedback2");
        formFeedback2.setOutputMarkupPlaceholderTag(true);
        String formFeedback2Id = formFeedback2.getMarkupId();
        this.add(new Component[]{formFeedback2});
        this.add(new Component[]{new Label("userName", searchResult.getDisplayName())});
        Form form = new Form("form");
        this.add(new Component[]{form});
        form.add(new Component[]{this.getExpandCollapseLink()});
        Map roleMap = this.projectLogic.getRealmRoleDisplay(false);
        String largestRole = "";
        for (String role : roleMap.values()) {
            if (role.length() <= largestRole.length()) continue;
            largestRole = role;
        }
        int roleColumnSize = 40 + largestRole.length() * 6;
        if (roleColumnSize < 115) {
            roleColumnSize = 115;
        }
        boolean singleRoleOptions = false;
        if (roleMap.size() == 1) {
            String[] split = null;
            for (String key : roleMap.keySet()) {
                split = key.split(":");
            }
            if (split != null && split.length == 2) {
                singleRoleOptions = true;
                this.defaultRole = split;
            }
        }
        ArrayList<Object> columnsList = new ArrayList<Object>();
        columnsList.add(new PropertyTreeColumn(new ColumnLocation(ColumnLocation.Alignment.MIDDLE, 100, ColumnLocation.Unit.PROPORTIONAL), "", "userObject.node.description"));
        if (this.sakaiProxy.isSuperUser()) {
            columnsList.add(new PropertyEditableColumnCheckbox(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 70, ColumnLocation.Unit.PX), new StringResourceModel("accessAdmin", null).getString(), "userObject.accessAdmin", 4));
        }
        columnsList.add(new PropertyEditableColumnCheckbox(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 70, ColumnLocation.Unit.PX), new StringResourceModel("shoppingPeriodAdmin", null).getString(), "userObject.shoppingPeriodAdmin", 3));
        columnsList.add(new PropertyEditableColumnCheckbox(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 55, ColumnLocation.Unit.PX), new StringResourceModel("siteAccess", null).getString(), "userObject.directAccess", 1));
        if (!singleRoleOptions) {
            columnsList.add(new PropertyEditableColumnDropdown(new ColumnLocation(ColumnLocation.Alignment.RIGHT, roleColumnSize, ColumnLocation.Unit.PX), new StringResourceModel("userBecomes", null).getString(), "userObject.roleOption", roleMap, 1));
        }
        columnsList.add(new PropertyEditableColumnList(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 96, ColumnLocation.Unit.PX), new StringResourceModel("restrictedToolsHeader", null).getString(), "userObject.restrictedTools", 1, 1));
        if (this.sakaiProxy.isShowTermColumnAccess() && this.projectLogic.getEntireTermsList().size() > 0) {
            columnsList.add(new PropertyEditableColumnList(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 65, ColumnLocation.Unit.PX), new StringResourceModel("termHeader", null).getString(), "userObject.terms", 1, 2));
        }
        IColumn[] columns = columnsList.toArray(new IColumn[columnsList.size()]);
        if (!this.sakaiProxy.isSuperUser()) {
            Set accessAdminNodes = this.projectLogic.getAccessAdminNodesForUser(this.sakaiProxy.getCurrentUserId());
            this.accessAdminNodeIds = new ArrayList();
            if (accessAdminNodes != null) {
                for (HierarchyNodeSerialized node : accessAdminNodes) {
                    this.accessAdminNodeIds.add(node.id);
                }
            }
        }
        TreeModel treeModel = this.projectLogic.createEntireTreeModelForUser(searchResult.getId(), true, false);
        List blankRestrictedTools = this.projectLogic.getEntireToolsList();
        List blankTerms = this.projectLogic.getEntireTermsList();
        this.tree = new /* Unavailable Anonymous Inner Class!! */;
        if (singleRoleOptions) {
            this.tree.add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"noRoles")), " ")});
        }
        form.add(new Component[]{this.tree});
        2 updateButton = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{updateButton});
        3 cancelButton = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{cancelButton});
    }

    static /* synthetic */ TreeTable access$000(UserEditPage x0) {
        return x0.tree;
    }

    static /* synthetic */ String[] access$100(UserEditPage x0) {
        return x0.defaultRole;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }
}

