/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.tool.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.sakaiproject.delegatedaccess.model.ListOptionSerialized;
import org.sakaiproject.delegatedaccess.model.NodeModel;
import org.sakaiproject.delegatedaccess.model.SelectOption;
import org.sakaiproject.delegatedaccess.model.SiteSearchResult;
import org.sakaiproject.delegatedaccess.tool.pages.BasePage;
import org.sakaiproject.delegatedaccess.tool.pages.UserPageSiteSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPageSiteSearch
extends BasePage {
    private int orderBy = 1;
    private boolean orderAsc = true;
    private SiteSearchResultDataProvider provider;
    private String search = "";
    private String instructorField = "";
    private SelectOption termField;
    private List<SelectOption> termOptions;
    private boolean statistics = false;
    private boolean currentStatisticsFlag = false;
    private Map<String, String> toolsMap;

    public UserPageSiteSearch(String search, Map<String, String> advancedFields, boolean statistics, boolean currentStatisticsFlag) {
        this.search = search;
        this.statistics = statistics;
        this.currentStatisticsFlag = currentStatisticsFlag;
        if (statistics) {
            this.disableLink(this.shoppingStatsLink);
        }
        List blankRestrictedTools = this.projectLogic.getEntireToolsList();
        this.toolsMap = new HashMap();
        for (ListOptionSerialized option : blankRestrictedTools) {
            this.toolsMap.put(option.getId(), option.getName());
        }
        1 currentLink = new /* Unavailable Anonymous Inner Class!! */;
        currentLink.add(new Component[]{new Label("currentLinkLabel", (IModel)new ResourceModel("link.current")).setRenderBodyOnly(true)});
        currentLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.current.tooltip"))});
        this.add(new Component[]{currentLink});
        if (currentStatisticsFlag) {
            this.disableLink((Link)currentLink);
        }
        2 allLink = new /* Unavailable Anonymous Inner Class!! */;
        allLink.add(new Component[]{new Label("allLinkLabel", (IModel)new ResourceModel("link.all")).setRenderBodyOnly(true)});
        allLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.all.tooltip"))});
        this.add(new Component[]{allLink});
        if (!currentStatisticsFlag) {
            this.disableLink((Link)allLink);
        }
        this.termOptions = new ArrayList();
        for (String[] stringArray : this.sakaiProxy.getTerms()) {
            this.termOptions.add(new SelectOption(stringArray[1], stringArray[0]));
        }
        if (advancedFields != null) {
            block2: for (Map.Entry entry : advancedFields.entrySet()) {
                if ("instructorField".equals(entry.getKey())) {
                    this.instructorField = (String)entry.getValue();
                }
                if (!"termField".equals(entry.getKey())) continue;
                for (SelectOption option : this.termOptions) {
                    if (!((String)entry.getValue()).equals(option.getValue())) continue;
                    this.termField = option;
                    continue block2;
                }
            }
        }
        PropertyModel searchModel = new PropertyModel((Object)this, "search");
        PropertyModel propertyModel = new PropertyModel((Object)this, "instructorField");
        PropertyModel termFieldModel = new PropertyModel((Object)this, "termField");
        3 searchStringModel = new /* Unavailable Anonymous Inner Class!! */;
        4 form = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{new TextField("search", (IModel)searchModel)});
        form.add(new Component[]{new TextField("instructorField", (IModel)propertyModel)});
        ChoiceRenderer choiceRenderer = new ChoiceRenderer("label", "value");
        DropDownChoice termFieldDropDown = new DropDownChoice("termField", (IModel)termFieldModel, this.termOptions, (IChoiceRenderer)choiceRenderer);
        termFieldDropDown.setNullValid(true);
        form.add(new Component[]{termFieldDropDown});
        this.add(new Component[]{form});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        7 siteTitleSort = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{siteTitleSort});
        8 siteIdSort = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{siteIdSort});
        9 termSort = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{termSort});
        10 instructorSort = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{instructorSort});
        11 authorizationSort = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{authorizationSort});
        12 accessSort = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{accessSort});
        13 startDateSort = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{startDateSort});
        14 endDateSort = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{endDateSort});
        15 accessModifiedBySort = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{accessModifiedBySort});
        16 accessModifiedOnSort = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{accessModifiedOnSort});
        this.provider = new SiteSearchResultDataProvider(this, null);
        17 dataView = new /* Unavailable Anonymous Inner Class!! */;
        dataView.setItemReuseStrategy((IItemReuseStrategy)new DefaultItemReuseStrategy());
        dataView.setItemsPerPage(20);
        this.add(new Component[]{dataView});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private String getAuthString(SiteSearchResult siteSearchResult) {
        String auth = siteSearchResult.getShoppingPeriodAuth();
        if (auth != null && !"".equals(auth)) {
            return new StringResourceModel(auth, null).getString();
        }
        return "";
    }

    private String getToolsString(NodeModel nodeModel) {
        String restrictedTools = "";
        for (String tool : nodeModel.getNodeRestrictedTools()) {
            String toolName;
            if (!"".equals(restrictedTools)) {
                restrictedTools = restrictedTools + ", ";
            }
            if (this.toolsMap.containsKey(toolName = tool)) {
                toolName = (String)this.toolsMap.get(toolName);
            }
            restrictedTools = restrictedTools + toolName;
        }
        return restrictedTools;
    }

    private void changeOrder(int sortByColumn) {
        if (sortByColumn == this.orderBy) {
            this.orderAsc = !this.orderAsc;
        } else {
            this.orderBy = sortByColumn;
        }
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public boolean isStatistics() {
        return this.statistics;
    }

    public void setStatistics(boolean statistics) {
        this.statistics = statistics;
    }

    static /* synthetic */ SiteSearchResultDataProvider access$000(UserPageSiteSearch x0) {
        return x0.provider;
    }

    static /* synthetic */ void access$100(UserPageSiteSearch x0, int x1) {
        x0.changeOrder(x1);
    }

    static /* synthetic */ String access$200(UserPageSiteSearch x0) {
        return x0.instructorField;
    }

    static /* synthetic */ String access$400(UserPageSiteSearch x0, SiteSearchResult x1) {
        return x0.getAuthString(x1);
    }

    static /* synthetic */ Map access$500(UserPageSiteSearch x0) {
        return x0.toolsMap;
    }

    static /* synthetic */ SelectOption access$600(UserPageSiteSearch x0) {
        return x0.termField;
    }

    static /* synthetic */ String access$700(UserPageSiteSearch x0) {
        return x0.search;
    }

    static /* synthetic */ String access$702(UserPageSiteSearch x0, String x1) {
        x0.search = x1;
        return x0.search;
    }

    static /* synthetic */ boolean access$800(UserPageSiteSearch x0) {
        return x0.statistics;
    }

    static /* synthetic */ boolean access$900(UserPageSiteSearch x0) {
        return x0.currentStatisticsFlag;
    }

    static /* synthetic */ boolean access$1000(UserPageSiteSearch x0) {
        return x0.orderAsc;
    }

    static /* synthetic */ int access$1100(UserPageSiteSearch x0) {
        return x0.orderBy;
    }
}

