/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.tool.pages;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.delegatedaccess.logic.ProjectLogic;
import org.sakaiproject.delegatedaccess.logic.SakaiProxy;

public class BasePage
extends WebPage
implements IHeaderContributor {
    private static final Logger log = Logger.getLogger(BasePage.class);
    @SpringBean(name="org.sakaiproject.delegatedaccess.logic.SakaiProxy")
    protected SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.delegatedaccess.logic.ProjectLogic")
    protected ProjectLogic projectLogic;
    Link<Void> accessPageLink;
    Link<Void> shoppingAdminLink;
    Link<Void> shoppingStatsLink;
    Link<Void> searchUsersLink;
    Link<Void> administrateLink;
    boolean hasShoppingAdmin;
    boolean hasDelegatedAccess;
    boolean hasAccessAdmin;
    FeedbackPanel feedbackPanel;
    boolean shoppingPeriodTool = false;

    public BasePage() {
        log.debug((Object)"BasePage()");
        this.shoppingPeriodTool = this.sakaiProxy.isShoppingTool();
        this.hasShoppingAdmin = this.projectLogic.hasShoppingPeriodAdminNodes(this.sakaiProxy.getCurrentUserId());
        this.hasDelegatedAccess = this.projectLogic.hasDelegatedAccessNodes(this.sakaiProxy.getCurrentUserId());
        this.hasAccessAdmin = this.projectLogic.hasAccessAdminNodes(this.sakaiProxy.getCurrentUserId());
        this.accessPageLink = new /* Unavailable Anonymous Inner Class!! */;
        if (this.shoppingPeriodTool) {
            this.accessPageLink.add(new Component[]{new Label("firstLinkLabel", (IModel)new ResourceModel("link.first.shopping")).setRenderBodyOnly(true)});
            this.accessPageLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.first.tooltip.shopping"))});
        } else {
            this.accessPageLink.add(new Component[]{new Label("firstLinkLabel", (IModel)new ResourceModel("link.first")).setRenderBodyOnly(true)});
            this.accessPageLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.first.tooltip"))});
        }
        this.add(new Component[]{this.accessPageLink});
        this.shoppingAdminLink = new /* Unavailable Anonymous Inner Class!! */;
        this.shoppingAdminLink.add(new Component[]{new Label("secondLinkLabel", (IModel)new ResourceModel("link.second")).setRenderBodyOnly(true)});
        this.shoppingAdminLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.second.tooltip"))});
        this.add(new Component[]{this.shoppingAdminLink});
        this.shoppingStatsLink = new /* Unavailable Anonymous Inner Class!! */;
        this.shoppingStatsLink.add(new Component[]{new Label("shoppingStatsLinkLabel", (IModel)new ResourceModel("link.shoppingStats")).setRenderBodyOnly(true)});
        this.shoppingStatsLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.shoppingStats.tooltip"))});
        this.add(new Component[]{this.shoppingStatsLink});
        this.searchUsersLink = new /* Unavailable Anonymous Inner Class!! */;
        this.searchUsersLink.add(new Component[]{new Label("thirdLinkLabel", (IModel)new ResourceModel("link.third")).setRenderBodyOnly(true)});
        this.searchUsersLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.third.tooltip"))});
        this.add(new Component[]{this.searchUsersLink});
        this.administrateLink = new /* Unavailable Anonymous Inner Class!! */;
        this.administrateLink.add(new Component[]{new Label("administrateLinkLabel", (IModel)new ResourceModel("link.administrate")).setRenderBodyOnly(true)});
        this.administrateLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.administrate.tooltip"))});
        this.add(new Component[]{this.administrateLink});
        this.feedbackPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{this.feedbackPanel});
        if (!this.shoppingPeriodTool && this.sakaiProxy.getCurrentSession().getAttribute("delegatedaccess.accessmapflag") == null) {
            this.projectLogic.initializeDelegatedAccessSession();
        }
    }

    public void clearFeedback(FeedbackPanel f) {
        if (!f.hasFeedbackMessage()) {
            f.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)"")});
        }
    }

    public void renderHead(IHeaderResponse response) {
        String skinRepo = this.sakaiProxy.getSkinRepoProperty();
        String toolCSS = this.sakaiProxy.getToolSkinCSS(skinRepo);
        String toolBaseCSS = skinRepo + "/tool_base.css";
        response.renderJavascriptReference("/library/js/headscripts.js");
        response.renderCSSReference(toolBaseCSS);
        response.renderCSSReference(toolCSS);
        response.renderOnLoadJavascript("setMainFrameHeight( window.name )");
        response.renderString((CharSequence)"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        response.renderJavascriptReference("/library/js/jquery-latest.min.js");
        response.renderCSSReference("css/flora.datepicker.css");
        response.renderJavascriptReference("javascript/jquery.ui.core-1.5.2.min.js");
        response.renderJavascriptReference("javascript/jquery.datepicker-1.5.2.min.js");
    }

    protected void disableLink(Link<Void> l) {
        l.add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"current")), " ")});
        l.setRenderBodyOnly(true);
        l.setEnabled(false);
    }

    protected boolean isShoppingPeriodTool() {
        return this.shoppingPeriodTool;
    }
}

