/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.tool.pages;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.tree.AbstractTree;
import org.apache.wicket.markup.html.tree.BaseTree;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.sakaiproject.delegatedaccess.model.NodeModel;
import org.sakaiproject.delegatedaccess.model.SelectOption;
import org.sakaiproject.delegatedaccess.tool.pages.BaseTreePage;
import org.sakaiproject.delegatedaccess.tool.pages.SearchUsersPage;
import org.sakaiproject.delegatedaccess.tool.pages.ShoppingEditPage;
import org.sakaiproject.delegatedaccess.tool.pages.UserPage;

public class UserPage
extends BaseTreePage {
    private BaseTree tree;
    boolean expand = true;
    private String search = "";
    private String instructorField = "";
    private SelectOption termField;
    private TreeModel treeModel = null;
    private String userId;

    protected AbstractTree getTree() {
        return this.tree;
    }

    public UserPage() {
        DefaultMutableTreeNode node;
        this.disableLink(this.accessPageLink);
        if (this.isShoppingPeriodTool()) {
            this.userId = "120dv0f43cv90sdf0asv9";
        } else {
            if (!this.hasDelegatedAccess) {
                if (this.hasShoppingAdmin) {
                    this.setResponsePage((Page)new ShoppingEditPage());
                } else if (this.hasAccessAdmin) {
                    this.setResponsePage((Page)new SearchUsersPage());
                }
            }
            this.userId = this.sakaiProxy.getCurrentUserId();
        }
        Label title = new Label("title");
        if (this.isShoppingPeriodTool()) {
            title.setDefaultModel((IModel)new StringResourceModel("shoppingTitle", null));
        } else {
            title.setDefaultModel((IModel)new StringResourceModel("delegatedAccessTitle", null));
        }
        this.add(new Component[]{title});
        Label description = new Label("description");
        if (this.isShoppingPeriodTool()) {
            description.setDefaultModel((IModel)new StringResourceModel("shoppingInstruction", null));
        } else {
            description.setDefaultModel((IModel)new StringResourceModel("delegatedAccessInstructions", null));
        }
        this.add(new Component[]{description});
        this.setTreeModel(this.userId, false);
        List blankRestrictedTools = this.projectLogic.getEntireToolsList();
        if (this.treeModel != null && ((NodeModel)(node = (DefaultMutableTreeNode)this.treeModel.getRoot()).getUserObject()).isDirectAccess()) {
            this.projectLogic.addChildrenNodes((Object)node, this.userId, blankRestrictedTools, true, null, false, this.isShoppingPeriodTool());
        }
        this.tree = new /* Unavailable Anonymous Inner Class!! */;
        this.tree.setRootLess(true);
        this.add(new Component[]{this.tree});
        this.tree.getTreeState().collapseAll();
        2 noAccessLabel = new /* Unavailable Anonymous Inner Class!! */;
        if (this.isShoppingPeriodTool()) {
            noAccessLabel.setDefaultModel((IModel)new StringResourceModel("noShoppingSites", null));
        } else {
            noAccessLabel.setDefaultModel((IModel)new StringResourceModel("noDelegatedAccess", null));
        }
        this.add(new Component[]{noAccessLabel});
        PropertyModel messageModel = new PropertyModel((Object)this, "search");
        PropertyModel instructorFieldModel = new PropertyModel((Object)this, "instructorField");
        PropertyModel termFieldModel = new PropertyModel((Object)this, "termField");
        3 form = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{new TextField("search", (IModel)messageModel)});
        form.add(new Component[]{new TextField("instructorField", (IModel)instructorFieldModel)});
        ArrayList<SelectOption> termOptions = new ArrayList<SelectOption>();
        for (String[] entry : this.sakaiProxy.getTerms()) {
            termOptions.add(new SelectOption(entry[1], entry[0]));
        }
        ChoiceRenderer choiceRenderer = new ChoiceRenderer("label", "value");
        DropDownChoice termFieldDropDown = new DropDownChoice("termField", (IModel)termFieldModel, termOptions, (IChoiceRenderer)choiceRenderer);
        termFieldDropDown.setNullValid(true);
        form.add(new Component[]{termFieldDropDown});
        form.add(new Component[]{new WebMarkupContainer("searchHeader")});
        form.add(new Component[]{new Button("submitButton")});
        this.add(new Component[]{form});
    }

    private void setTreeModel(String userId, boolean cascade) {
        if (this.isShoppingPeriodTool()) {
            if (this.sakaiProxy.getDisableShoppingTreeView()) {
                this.treeModel = null;
            } else {
                this.treeModel = this.projectLogic.createAccessTreeModelForUser("120dv0f43cv90sdf0asv9", false, cascade);
                if (this.treeModel != null && ((DefaultMutableTreeNode)this.treeModel.getRoot()).getChildCount() == 0) {
                    this.treeModel = null;
                }
            }
        } else {
            this.treeModel = this.sakaiProxy.getDisableUserTreeView() ? null : this.projectLogic.createAccessTreeModelForUser(userId, false, cascade);
        }
    }

    static /* synthetic */ TreeModel access$000(UserPage x0) {
        return x0.treeModel;
    }

    static /* synthetic */ String access$100(UserPage x0) {
        return x0.userId;
    }

    static /* synthetic */ BaseTree access$200(UserPage x0) {
        return x0.tree;
    }

    static /* synthetic */ SelectOption access$300(UserPage x0) {
        return x0.termField;
    }

    static /* synthetic */ String access$400(UserPage x0) {
        return x0.instructorField;
    }

    static /* synthetic */ String access$500(UserPage x0) {
        return x0.search;
    }
}

