/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.service.gradebook.shared;

import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.sakaiproject.service.gradebook.shared.AssessmentNotFoundException;
import org.sakaiproject.service.gradebook.shared.Assignment;
import org.sakaiproject.service.gradebook.shared.AssignmentHasIllegalPointsException;
import org.sakaiproject.service.gradebook.shared.CategoryDefinition;
import org.sakaiproject.service.gradebook.shared.CommentDefinition;
import org.sakaiproject.service.gradebook.shared.ConflictingAssignmentNameException;
import org.sakaiproject.service.gradebook.shared.ConflictingExternalIdException;
import org.sakaiproject.service.gradebook.shared.GradeDefinition;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.InvalidGradeException;
import org.sakaiproject.service.gradebook.shared.StaleObjectModificationException;

public interface GradebookService {
    public static final int GRADE_TYPE_POINTS = 1;
    public static final int GRADE_TYPE_PERCENTAGE = 2;
    public static final int GRADE_TYPE_LETTER = 3;
    public static final int CATEGORY_TYPE_NO_CATEGORY = 1;
    public static final int CATEGORY_TYPE_ONLY_CATEGORY = 2;
    public static final int CATEGORY_TYPE_WEIGHTED_CATEGORY = 3;
    public static final String[] validLetterGrade = new String[]{"a+", "a", "a-", "b+", "b", "b-", "c+", "c", "c-", "d+", "d", "d-", "f"};
    public static final String gradePermission = "grade";
    public static final String viewPermission = "view";
    public static final String enableLetterGradeString = "gradebook_enable_letter_grade";
    public static final MathContext MATH_CONTEXT = new MathContext(10, RoundingMode.HALF_DOWN);
    public static final Comparator lettergradeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (((String)o1).toLowerCase().charAt(0) == ((String)o2).toLowerCase().charAt(0)) {
                if (((String)o1).length() == 2 && ((String)o2).length() == 2) {
                    if (((String)o1).charAt(1) == '+') {
                        return 0;
                    }
                    return 1;
                }
                if (((String)o1).length() == 1 && ((String)o2).length() == 2) {
                    if (((String)o2).charAt(1) == '+') {
                        return 1;
                    }
                    return 0;
                }
                if (((String)o1).length() == 2 && ((String)o2).length() == 1) {
                    if (((String)o1).charAt(1) == '+') {
                        return 0;
                    }
                    return 1;
                }
                return 0;
            }
            return ((String)o1).toLowerCase().compareTo(((String)o2).toLowerCase());
        }
    };

    public boolean isGradebookDefined(String var1);

    public boolean isUserAbleToGradeItemForStudent(String var1, Long var2, String var3);

    public boolean isUserAbleToGradeItemForStudent(String var1, String var2, String var3);

    public boolean isUserAbleToViewItemForStudent(String var1, Long var2, String var3);

    public boolean isUserAbleToViewItemForStudent(String var1, String var2, String var3);

    public String getGradeViewFunctionForUserForStudentForItem(String var1, Long var2, String var3);

    public String getGradeViewFunctionForUserForStudentForItem(String var1, String var2, String var3);

    public List getAssignments(String var1) throws GradebookNotFoundException;

    public Assignment getAssignment(String var1, String var2) throws GradebookNotFoundException;

    public Assignment getAssignment(String var1, Long var2) throws AssessmentNotFoundException;

    public Double getAssignmentScore(String var1, String var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public Double getAssignmentScore(String var1, Long var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public GradeDefinition getGradeDefinitionForStudentForItem(String var1, Long var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public CommentDefinition getAssignmentScoreComment(String var1, String var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public CommentDefinition getAssignmentScoreComment(String var1, Long var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public void setAssignmentScore(String var1, String var2, String var3, Double var4, String var5) throws GradebookNotFoundException, AssessmentNotFoundException;

    public void setAssignmentScoreComment(String var1, String var2, String var3, String var4) throws GradebookNotFoundException, AssessmentNotFoundException;

    public boolean isAssignmentDefined(String var1, String var2) throws GradebookNotFoundException;

    public String getGradebookDefinitionXml(String var1);

    public void transferGradebookDefinitionXml(String var1, String var2, String var3);

    public void mergeGradebookDefinitionXml(String var1, String var2);

    public void removeAssignment(Long var1) throws StaleObjectModificationException;

    public List getCategories(Long var1);

    public List<CategoryDefinition> getCategoryDefinitions(String var1);

    public void removeCategory(Long var1) throws StaleObjectModificationException;

    public void addAssignment(String var1, Assignment var2);

    public void updateAssignment(String var1, String var2, Assignment var3);

    public List<Assignment> getViewableAssignmentsForCurrentUser(String var1);

    public Map<String, String> getViewableStudentsForItemForCurrentUser(String var1, Long var2);

    public Map<String, String> getViewableStudentsForItemForUser(String var1, String var2, Long var3);

    public void addGradebook(String var1, String var2);

    public void deleteGradebook(String var1) throws GradebookNotFoundException;

    public void setAvailableGradingScales(Collection var1);

    public void setDefaultGradingScale(String var1);

    public void addExternalAssessment(String var1, String var2, String var3, String var4, Double var5, Date var6, String var7, Boolean var8) throws GradebookNotFoundException, ConflictingAssignmentNameException, ConflictingExternalIdException, AssignmentHasIllegalPointsException;

    public void addExternalAssessment(String var1, String var2, String var3, String var4, double var5, Date var7, String var8) throws GradebookNotFoundException, ConflictingAssignmentNameException, ConflictingExternalIdException, AssignmentHasIllegalPointsException;

    public void updateExternalAssessment(String var1, String var2, String var3, String var4, double var5, Date var7) throws GradebookNotFoundException, AssessmentNotFoundException, ConflictingAssignmentNameException, AssignmentHasIllegalPointsException;

    public void updateExternalAssessment(String var1, String var2, String var3, String var4, Double var5, Date var6) throws GradebookNotFoundException, AssessmentNotFoundException, ConflictingAssignmentNameException, AssignmentHasIllegalPointsException;

    public void removeExternalAssessment(String var1, String var2) throws GradebookNotFoundException, AssessmentNotFoundException;

    public void updateExternalAssessmentScore(String var1, String var2, String var3, Double var4) throws GradebookNotFoundException, AssessmentNotFoundException;

    public void updateExternalAssessmentScores(String var1, String var2, Map var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public boolean isExternalAssignmentDefined(String var1, String var2) throws GradebookNotFoundException;

    public Map getImportCourseGrade(String var1);

    public Map getImportCourseGrade(String var1, boolean var2);

    public Object getGradebook(String var1) throws GradebookNotFoundException;

    public boolean checkStuendsNotSubmitted(String var1);

    public boolean checkStudentsNotSubmitted(String var1);

    public boolean isGradableObjectDefined(Long var1);

    public Map getViewableSectionUuidToNameMap(String var1);

    public boolean currentUserHasGradeAllPerm(String var1);

    public boolean isUserAllowedToGradeAll(String var1, String var2);

    public boolean currentUserHasGradingPerm(String var1);

    public boolean isUserAllowedToGrade(String var1, String var2);

    public boolean currentUserHasEditPerm(String var1);

    public boolean currentUserHasViewOwnGradesPerm(String var1);

    public List<GradeDefinition> getGradesForStudentsForItem(String var1, Long var2, List<String> var3);

    public boolean isGradeValid(String var1, String var2) throws GradebookNotFoundException;

    public List<String> identifyStudentsWithInvalidGrades(String var1, Map<String, String> var2) throws GradebookNotFoundException;

    public void saveGradeAndCommentForStudent(String var1, Long var2, String var3, String var4, String var5) throws InvalidGradeException, GradebookNotFoundException, AssessmentNotFoundException;

    public void saveGradesAndComments(String var1, Long var2, List<GradeDefinition> var3) throws InvalidGradeException, GradebookNotFoundException, AssessmentNotFoundException;

    public Map getFixedGrade(String var1);

    public Map getFixedPoint(String var1);

    public Map getOldPoint(String var1);

    public int getGradeEntryType(String var1) throws GradebookNotFoundException;

    public Map getEnteredCourseGrade(String var1);

    public Map getCalculatedCourseGrade(String var1);

    public Map getCalculatedCourseGrade(String var1, boolean var2);

    public String getAssignmentScoreString(String var1, String var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public String getAssignmentScoreString(String var1, Long var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public void setAssignmentScoreString(String var1, String var2, String var3, String var4, String var5) throws GradebookNotFoundException, AssessmentNotFoundException;

    public void finalizeGrades(String var1) throws GradebookNotFoundException;

    public String getLowestPossibleGradeForGbItem(String var1, Long var2);

    public PointsPossibleValidation isPointsPossibleValid(String var1, Assignment var2, Double var3);

    public static enum PointsPossibleValidation {
        VALID,
        INVALID_NULL_VALUE,
        INVALID_NUMERIC_VALUE,
        INVALID_DECIMAL;

    }
}

