/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.service.gradebook.shared;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.sakaiproject.service.gradebook.shared.Assignment;

public class CategoryDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private Double weight;
    private Integer dropLowest;
    private Integer dropHighest;
    private Integer keepHighest;
    private Boolean extraCredit;
    private Boolean equalWeight;
    private Integer categoryOrder;
    private Boolean dropKeepEnabled;
    public static Comparator<CategoryDefinition> orderComparator = new Comparator<CategoryDefinition>(){

        @Override
        public int compare(CategoryDefinition c1, CategoryDefinition c2) {
            if (c1.getCategoryOrder() == null && c2.getCategoryOrder() == null) {
                return c1.getName().compareTo(c2.getName());
            }
            if (c1.getCategoryOrder() == null) {
                return -1;
            }
            if (c2.getCategoryOrder() == null) {
                return 1;
            }
            return c1.getCategoryOrder().compareTo(c2.getCategoryOrder());
        }
    };
    private List<Assignment> assignmentList;

    public CategoryDefinition() {
    }

    public CategoryDefinition(Long id, String name) {
        this.id = id;
        this.name = name;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public Double getTotalPoints() {
        BigDecimal totalPoints = new BigDecimal(0);
        if (this.getAssignmentList() != null) {
            for (Assignment assignment : this.getAssignmentList()) {
                totalPoints = totalPoints.add(BigDecimal.valueOf(assignment.getPoints()));
            }
        }
        return totalPoints.doubleValue();
    }

    public boolean isAssignmentInThisCategory(String assignmentId) {
        for (Assignment thisAssignment : this.assignmentList) {
            if (thisAssignment.getExternalId() == null || !thisAssignment.getExternalId().equalsIgnoreCase(assignmentId)) continue;
            return true;
        }
        return false;
    }

    public Double getPointsForCategory() {
        if (!this.dropKeepEnabled.booleanValue()) {
            return null;
        }
        Iterator<Assignment> iterator = this.assignmentList.iterator();
        if (iterator.hasNext()) {
            Assignment thisAssignment = iterator.next();
            return thisAssignment.getPoints();
        }
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Integer getDropLowest() {
        return this.dropLowest;
    }

    public void setDropLowest(Integer dropLowest) {
        this.dropLowest = dropLowest;
    }

    public Integer getDropHighest() {
        return this.dropHighest;
    }

    public void setDropHighest(Integer dropHighest) {
        this.dropHighest = dropHighest;
    }

    public Integer getKeepHighest() {
        return this.keepHighest;
    }

    public void setKeepHighest(Integer keepHighest) {
        this.keepHighest = keepHighest;
    }

    public Boolean getExtraCredit() {
        return this.extraCredit;
    }

    public void setExtraCredit(Boolean extraCredit) {
        this.extraCredit = extraCredit;
    }

    public Boolean getEqualWeight() {
        return this.equalWeight;
    }

    public void setEqualWeight(Boolean equalWeight) {
        this.equalWeight = equalWeight;
    }

    public Integer getCategoryOrder() {
        return this.categoryOrder;
    }

    public void setCategoryOrder(Integer categoryOrder) {
        this.categoryOrder = categoryOrder;
    }

    public Boolean getDropKeepEnabled() {
        return this.dropKeepEnabled;
    }

    public void setDropKeepEnabled(Boolean dropKeepEnabled) {
        this.dropKeepEnabled = dropKeepEnabled;
    }

    public List<Assignment> getAssignmentList() {
        return this.assignmentList;
    }

    public void setAssignmentList(List<Assignment> assignmentList) {
        this.assignmentList = assignmentList;
    }
}

