/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.service.gradebook.shared;

import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.service.gradebook.shared.Assignment;
import org.sakaiproject.service.gradebook.shared.AssignmentHasIllegalPointsException;
import org.sakaiproject.service.gradebook.shared.ConflictingAssignmentNameException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.service.gradebook.shared.InvalidGradeItemNameException;

public class GradebookHelper {
    public static String validateGradeItemName(String title) throws InvalidGradeItemNameException, ConflictingAssignmentNameException {
        if (StringUtils.isBlank((CharSequence)(title = StringUtils.trimToNull((String)title)))) {
            throw new ConflictingAssignmentNameException("You cannot save an assignment without a name");
        }
        if (StringUtils.startsWithAny((CharSequence)title, (CharSequence[])GradebookService.INVALID_CHARS_AT_START_OF_GB_ITEM_NAME)) {
            throw new InvalidGradeItemNameException("Grade Item name is invalid: " + title);
        }
        return title;
    }

    public static String validateAssignmentNameAndPoints(Assignment assignmentDefinition) throws InvalidGradeItemNameException, AssignmentHasIllegalPointsException, ConflictingAssignmentNameException {
        Double points = assignmentDefinition.getPoints();
        if (points == null || points <= 0.0) {
            throw new AssignmentHasIllegalPointsException("Points must be > 0");
        }
        return GradebookHelper.validateGradeItemName(assignmentDefinition.getName());
    }
}

