/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.service.gradebook.shared;

import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.service.gradebook.shared.AssessmentNotFoundException;
import org.sakaiproject.service.gradebook.shared.Assignment;
import org.sakaiproject.service.gradebook.shared.CategoryDefinition;
import org.sakaiproject.service.gradebook.shared.CategoryScoreData;
import org.sakaiproject.service.gradebook.shared.CommentDefinition;
import org.sakaiproject.service.gradebook.shared.CourseGrade;
import org.sakaiproject.service.gradebook.shared.GradeDefinition;
import org.sakaiproject.service.gradebook.shared.GradebookInformation;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.GraderPermission;
import org.sakaiproject.service.gradebook.shared.InvalidGradeException;
import org.sakaiproject.service.gradebook.shared.SortType;
import org.sakaiproject.service.gradebook.shared.StaleObjectModificationException;

public interface GradebookService
extends EntityProducer {
    @Deprecated
    public static final int GRADE_TYPE_POINTS = 1;
    @Deprecated
    public static final int GRADE_TYPE_PERCENTAGE = 2;
    @Deprecated
    public static final int GRADE_TYPE_LETTER = 3;
    public static final int CATEGORY_TYPE_NO_CATEGORY = 1;
    public static final int CATEGORY_TYPE_ONLY_CATEGORY = 2;
    public static final int CATEGORY_TYPE_WEIGHTED_CATEGORY = 3;
    public static final String REFERENCE_ROOT = "/gbassignment";
    public static final String SAKAI_GBASSIGNMENT = "sakai:gbassignment";
    public static final String[] validLetterGrade = new String[]{"a+", "a", "a-", "b+", "b", "b-", "c+", "c", "c-", "d+", "d", "d-", "f"};
    @Deprecated
    public static final String gradePermission = GraderPermission.GRADE.toString();
    @Deprecated
    public static final String viewPermission = GraderPermission.VIEW.toString();
    @Deprecated
    public static final String noPermission = GraderPermission.NONE.toString();
    public static final String enableLetterGradeString = "gradebook_enable_letter_grade";
    public static final MathContext MATH_CONTEXT = new MathContext(10, RoundingMode.HALF_DOWN);
    public static final String[] INVALID_CHARS_AT_START_OF_GB_ITEM_NAME = new String[]{"#", "*", "["};
    public static final Comparator<String> lettergradeComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1.toLowerCase().charAt(0) == o2.toLowerCase().charAt(0)) {
                String s1 = StringUtils.trim((String)StringUtils.left((String)o1, (int)2));
                String s2 = StringUtils.trim((String)StringUtils.left((String)o2, (int)2));
                if (s1.length() == 2 && s2.length() == 2) {
                    if (s1.charAt(1) == '+') {
                        return -1;
                    }
                    return 1;
                }
                if (s1.length() == 1 && s2.length() == 2) {
                    if (o2.charAt(1) == '+') {
                        return 1;
                    }
                    return -1;
                }
                if (s1.length() == 2 && s2.length() == 1) {
                    if (s1.charAt(1) == '+') {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    };

    public boolean isGradebookDefined(String var1);

    public boolean isUserAbleToGradeItemForStudent(String var1, Long var2, String var3);

    public boolean isUserAbleToViewItemForStudent(String var1, Long var2, String var3);

    public String getGradeViewFunctionForUserForStudentForItem(String var1, Long var2, String var3);

    public List<Assignment> getAssignments(String var1) throws GradebookNotFoundException;

    public List<Assignment> getAssignments(String var1, SortType var2) throws GradebookNotFoundException;

    public Assignment getAssignment(String var1, Long var2) throws AssessmentNotFoundException;

    public Assignment getAssignmentByID(Long var1) throws AssessmentNotFoundException;

    @Deprecated
    public Assignment getAssignment(String var1, String var2) throws AssessmentNotFoundException;

    public Assignment getExternalAssignment(String var1, String var2) throws GradebookNotFoundException;

    public Assignment getAssignmentByNameOrId(String var1, String var2) throws AssessmentNotFoundException;

    public GradeDefinition getGradeDefinitionForStudentForItem(String var1, Long var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public CommentDefinition getAssignmentScoreComment(String var1, Long var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public boolean getIsAssignmentExcused(String var1, Long var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public void setAssignmentScoreComment(String var1, Long var2, String var3, String var4) throws GradebookNotFoundException, AssessmentNotFoundException;

    public boolean isAssignmentDefined(String var1, String var2) throws GradebookNotFoundException;

    public Map<String, String> transferGradebook(GradebookInformation var1, List<Assignment> var2, String var3, String var4);

    public GradebookInformation getGradebookInformation(String var1);

    public void removeAssignment(Long var1) throws StaleObjectModificationException;

    @Deprecated
    public List getCategories(Long var1);

    public List<CategoryDefinition> getCategoryDefinitions(String var1);

    public void removeCategory(Long var1) throws StaleObjectModificationException;

    public Long addAssignment(String var1, Assignment var2);

    public void updateAssignment(String var1, Long var2, Assignment var3);

    public List<Assignment> getViewableAssignmentsForCurrentUser(String var1);

    public List<Assignment> getViewableAssignmentsForCurrentUser(String var1, SortType var2);

    public Map<String, String> getViewableStudentsForItemForCurrentUser(String var1, Long var2);

    public Map<String, String> getViewableStudentsForItemForUser(String var1, String var2, Long var3);

    public Object getGradebook(String var1) throws GradebookNotFoundException;

    public boolean checkStudentsNotSubmitted(String var1);

    public boolean isGradableObjectDefined(Long var1);

    public Map<String, String> getViewableSectionUuidToNameMap(String var1);

    public boolean currentUserHasGradeAllPerm(String var1);

    public boolean isUserAllowedToGradeAll(String var1, String var2);

    public boolean currentUserHasGradingPerm(String var1);

    public boolean isUserAllowedToGrade(String var1, String var2);

    public boolean currentUserHasEditPerm(String var1);

    public boolean currentUserHasViewOwnGradesPerm(String var1);

    public boolean currentUserHasViewStudentNumbersPerm(String var1);

    public List<GradeDefinition> getGradesForStudentsForItem(String var1, Long var2, List<String> var3);

    public Map<Long, List<GradeDefinition>> getGradesWithoutCommentsForStudentsForItems(String var1, List<Long> var2, List<String> var3);

    public boolean isGradeValid(String var1, String var2) throws GradebookNotFoundException;

    public boolean isValidNumericGrade(String var1);

    public List<String> identifyStudentsWithInvalidGrades(String var1, Map<String, String> var2) throws GradebookNotFoundException;

    public void saveGradeAndCommentForStudent(String var1, Long var2, String var3, String var4, String var5) throws InvalidGradeException, GradebookNotFoundException, AssessmentNotFoundException;

    public void saveGradesAndComments(String var1, Long var2, List<GradeDefinition> var3) throws InvalidGradeException, GradebookNotFoundException, AssessmentNotFoundException;

    public void saveGradeAndExcuseForStudent(String var1, Long var2, String var3, String var4, boolean var5) throws InvalidGradeException, GradebookNotFoundException, AssessmentNotFoundException;

    public int getGradeEntryType(String var1) throws GradebookNotFoundException;

    public Map<String, String> getEnteredCourseGrade(String var1);

    public String getAssignmentScoreString(String var1, Long var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    @Deprecated
    public String getAssignmentScoreString(String var1, String var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public String getAssignmentScoreStringByNameOrId(String var1, String var2, String var3) throws GradebookNotFoundException, AssessmentNotFoundException;

    public void setAssignmentScoreString(String var1, Long var2, String var3, String var4, String var5) throws GradebookNotFoundException, AssessmentNotFoundException;

    @Deprecated
    public void setAssignmentScoreString(String var1, String var2, String var3, String var4, String var5) throws GradebookNotFoundException, AssessmentNotFoundException;

    public void finalizeGrades(String var1) throws GradebookNotFoundException;

    public String getLowestPossibleGradeForGbItem(String var1, Long var2);

    public PointsPossibleValidation isPointsPossibleValid(String var1, Assignment var2, Double var3);

    public String getAverageCourseGrade(String var1);

    public void updateAssignmentOrder(String var1, Long var2, Integer var3);

    public List getGradingEvents(String var1, long var2);

    public Optional<CategoryScoreData> calculateCategoryScore(Long var1, String var2, Long var3, boolean var4, int var5, Boolean var6);

    public Optional<CategoryScoreData> calculateCategoryScore(Object var1, String var2, CategoryDefinition var3, List<Assignment> var4, Map<Long, String> var5, boolean var6);

    public CourseGrade getCourseGradeForStudent(String var1, String var2);

    public Map<String, CourseGrade> getCourseGradeForStudents(String var1, List<String> var2);

    public Map<String, CourseGrade> getCourseGradeForStudents(String var1, List<String> var2, Map<String, Double> var3);

    public List getViewableSections(String var1);

    public void updateGradebookSettings(String var1, GradebookInformation var2);

    public Set getGradebookGradeMappings(Long var1);

    public Set getGradebookGradeMappings(String var1);

    public void updateCourseGradeForStudent(String var1, String var2, String var3, String var4);

    public void updateAssignmentCategorizedOrder(String var1, Long var2, Long var3, Integer var4);

    public List getGradingEvents(List<Long> var1, Date var2);

    public static enum PointsPossibleValidation {
        VALID,
        INVALID_NULL_VALUE,
        INVALID_NUMERIC_VALUE,
        INVALID_DECIMAL;

    }
}

