/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook;

import java.math.BigDecimal;
import java.util.Comparator;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.tool.gradebook.AbstractGradeRecord;
import org.sakaiproject.tool.gradebook.Assignment;

public class AssignmentGradeRecord
extends AbstractGradeRecord
implements Cloneable {
    private static final long serialVersionUID = 8259092798479256962L;
    private Double pointsEarned;
    private String letterEarned;
    private String userEnteredGrade;
    private Double percentEarned;
    private boolean userAbleToView;
    private Boolean excludedFromGrade;
    private transient BigDecimal earnedWeightedPercentage;
    private transient BigDecimal overallWeight;
    private transient Boolean isDropped;
    private Boolean droppedFromGrade;
    public static Comparator<AssignmentGradeRecord> numericComparator = new Comparator<AssignmentGradeRecord>(){

        @Override
        public int compare(AssignmentGradeRecord agr1, AssignmentGradeRecord agr2) {
            if (agr1 == null && agr2 == null) {
                return 0;
            }
            if (agr1 == null) {
                return -1;
            }
            if (agr2 == null) {
                return 1;
            }
            Double agr1Points = agr1.getPointsEarned();
            Double agr2Points = agr2.getPointsEarned();
            if (agr1Points == null && agr2Points == null) {
                return 0;
            }
            if (agr1Points == null && agr2Points != null) {
                return -1;
            }
            if (agr1Points != null && agr2Points == null) {
                return 1;
            }
            try {
                return agr1Points.compareTo(agr2Points);
            }
            catch (NumberFormatException e) {
                return agr1Points.compareTo(agr2Points);
            }
        }
    };
    public static Comparator<AssignmentGradeRecord> calcComparator = new Comparator<AssignmentGradeRecord>(){

        @Override
        public int compare(AssignmentGradeRecord agr1, AssignmentGradeRecord agr2) {
            if (agr1 == null && agr2 == null) {
                return 0;
            }
            if (agr1 == null) {
                return -1;
            }
            if (agr2 == null) {
                return 1;
            }
            Double agr1Points = agr1.getPointsEarned();
            Double agr2Points = agr2.getPointsEarned();
            if (agr1Points == null && agr2Points == null) {
                return 0;
            }
            if (agr1Points == null && agr2Points != null) {
                return -1;
            }
            if (agr1Points != null && agr2Points == null) {
                return 1;
            }
            return agr1Points.compareTo(agr2Points);
        }
    };

    public AssignmentGradeRecord() {
    }

    public AssignmentGradeRecord(Assignment assignment, String studentId, Double grade) {
        this.gradableObject = assignment;
        this.studentId = studentId;
        this.pointsEarned = grade;
    }

    public Double getPointsEarned() {
        return this.pointsEarned;
    }

    public void setPointsEarned(Double pointsEarned) {
        this.pointsEarned = pointsEarned;
    }

    public Double getGradeAsPercentage() {
        if (this.pointsEarned == null) {
            return null;
        }
        BigDecimal bdPointsEarned = new BigDecimal(this.pointsEarned.toString());
        BigDecimal bdPossible = new BigDecimal(((Assignment)this.getGradableObject()).getPointsPossible().toString());
        BigDecimal bdPercent = bdPointsEarned.divide(bdPossible, GradebookService.MATH_CONTEXT).multiply(new BigDecimal("100"));
        return bdPercent.doubleValue();
    }

    public boolean isCourseGradeRecord() {
        return false;
    }

    public Assignment getAssignment() {
        return (Assignment)this.getGradableObject();
    }

    public Double getPercentEarned() {
        return this.percentEarned;
    }

    public void setPercentEarned(Double percentEarned) {
        this.percentEarned = percentEarned;
    }

    public String getLetterEarned() {
        return this.letterEarned;
    }

    public void setLetterEarned(String letterEarned) {
        this.letterEarned = letterEarned;
    }

    public boolean isUserAbleToView() {
        return this.userAbleToView;
    }

    public void setUserAbleToView(boolean userAbleToView) {
        this.userAbleToView = userAbleToView;
    }

    public AssignmentGradeRecord clone() {
        AssignmentGradeRecord agr = new AssignmentGradeRecord();
        agr.setDateRecorded(this.dateRecorded);
        agr.setGradableObject(this.gradableObject);
        agr.setGraderId(this.graderId);
        agr.setLetterEarned(this.letterEarned);
        agr.setPointsEarned(this.pointsEarned);
        agr.setPercentEarned(this.percentEarned);
        agr.setStudentId(this.studentId);
        return agr;
    }

    public Boolean isExcludedFromGrade() {
        return this.excludedFromGrade;
    }

    public void setExcludedFromGrade(Boolean isExcludedFromGrade) {
        this.excludedFromGrade = isExcludedFromGrade;
    }

    public BigDecimal getEarnedWeightedPercentage() {
        return this.earnedWeightedPercentage;
    }

    public void setEarnedWeightedPercentage(BigDecimal earnedWeightedPercentage) {
        this.earnedWeightedPercentage = earnedWeightedPercentage;
    }

    public Boolean isDropped() {
        return this.isDropped;
    }

    public void setDropped(Boolean isDropped) {
        this.isDropped = isDropped;
    }

    public BigDecimal getOverallWeight() {
        return this.overallWeight;
    }

    public void setOverallWeight(BigDecimal overallWeight) {
        this.overallWeight = overallWeight;
    }

    public String getUserEnteredGrade() {
        return this.userEnteredGrade;
    }

    public void setUserEnteredGrade(String userEnteredGrade) {
        this.userEnteredGrade = userEnteredGrade;
    }

    public Boolean getDroppedFromGrade() {
        return this.droppedFromGrade == null ? false : this.droppedFromGrade;
    }

    public void setDroppedFromGrade(Boolean droppedFromGrade) {
        this.droppedFromGrade = droppedFromGrade;
    }
}

