/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradingScale;

public class GradeMapping
implements Serializable,
Comparable {
    protected Log log = LogFactory.getLog(GradeMapping.class);
    protected Long id;
    protected int version;
    protected Gradebook gradebook;
    protected Map<String, Double> gradeMap;
    private GradingScale gradingScale;

    public GradeMapping() {
    }

    public GradeMapping(GradingScale gradingScale) {
        this.setGradingScale(gradingScale);
        this.gradeMap = new HashMap<String, Double>(gradingScale.getDefaultBottomPercents());
    }

    public String getName() {
        return this.getGradingScale().getName();
    }

    public void setDefaultValues() {
        this.gradeMap = new HashMap<String, Double>(this.getDefaultBottomPercents());
    }

    public Map<String, Double> getDefaultBottomPercents() {
        GradingScale gradingScale = this.getGradingScale();
        if (gradingScale != null) {
            return gradingScale.getDefaultBottomPercents();
        }
        HashMap<String, Double> defaultBottomPercents = new HashMap<String, Double>();
        Iterator<Double> defaultValuesIter = this.getDefaultValues().iterator();
        for (String grade : this.getGrades()) {
            Double value = defaultValuesIter.next();
            defaultBottomPercents.put(grade, value);
        }
        return defaultBottomPercents;
    }

    public Collection<String> getGrades() {
        return this.getGradingScale().getGrades();
    }

    public List<Double> getDefaultValues() {
        throw new UnsupportedOperationException("getDefaultValues called for GradeMapping " + this.getName() + " in Gradebook " + this.getGradebook());
    }

    public Double getValue(String grade) {
        return this.gradeMap.get(grade);
    }

    public String getGrade(Double value) {
        if (value == null) {
            return null;
        }
        for (String grade : this.getGrades()) {
            Double mapVal = this.gradeMap.get(grade);
            if (mapVal == null || mapVal.compareTo(value) > 0) continue;
            return grade;
        }
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Map<String, Double> getGradeMap() {
        return this.gradeMap;
    }

    public void setGradeMap(Map<String, Double> gradeMap) {
        this.gradeMap = gradeMap;
    }

    public Gradebook getGradebook() {
        return this.gradebook;
    }

    public void setGradebook(Gradebook gradebook) {
        this.gradebook = gradebook;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((GradeMapping)o).getName());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getName()).append((Object)this.id).toString();
    }

    public String standardizeInputGrade(String inputGrade) {
        String standardizedGrade = null;
        for (String grade : this.getGrades()) {
            if (!grade.equalsIgnoreCase(inputGrade)) continue;
            standardizedGrade = grade;
            break;
        }
        return standardizedGrade;
    }

    public GradingScale getGradingScale() {
        return this.gradingScale;
    }

    public void setGradingScale(GradingScale gradingScale) {
        this.gradingScale = gradingScale;
    }
}

