/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class LetterGradePercentMapping
implements Serializable {
    private Long id;
    private int version;
    private int mappingType;
    private Long gradebookId;
    private Map<String, Double> gradeMap;

    public Double getValue(String grade) {
        if (this.gradeMap != null && this.gradeMap.containsKey(grade)) {
            return this.gradeMap.get(grade);
        }
        return null;
    }

    public String getGrade(Double value) {
        if (this.gradeMap != null) {
            ArrayList<Double> percentList = new ArrayList<Double>();
            Iterator<String> iter = this.gradeMap.keySet().iterator();
            while (iter.hasNext()) {
                percentList.add(this.gradeMap.get(iter.next()));
            }
            Collections.sort(percentList);
            for (int i = 0; i < percentList.size(); ++i) {
                Double mappingDouble = (Double)percentList.get(percentList.size() - 1 - i);
                if (mappingDouble.compareTo(value) > 0) continue;
                return this.getGradeMapping(mappingDouble);
            }
            return this.getGradeMapping((Double)percentList.get(percentList.size() - 1));
        }
        return null;
    }

    private String getGradeMapping(Double value) {
        if (this.gradeMap != null) {
            for (String key : this.gradeMap.keySet()) {
                Double gradeValue = this.gradeMap.get(key);
                if (!gradeValue.equals(value)) continue;
                return key;
            }
            return null;
        }
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Map<String, Double> getGradeMap() {
        return this.gradeMap;
    }

    public void setGradeMap(Map<String, Double> gradeMap) {
        this.gradeMap = gradeMap;
    }

    public int getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(int mappingType) {
        this.mappingType = mappingType;
    }

    public Long getGradebookId() {
        return this.gradebookId;
    }

    public void setGradebookId(Long gradebookId) {
        this.gradebookId = gradebookId;
    }

    public String standardizeInputGrade(String inputGrade) {
        String standardizedGrade = null;
        for (String grade : this.gradeMap.keySet()) {
            if (!grade.equalsIgnoreCase(inputGrade)) continue;
            standardizedGrade = grade;
            break;
        }
        return standardizedGrade;
    }
}

