/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradebookAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GradableObject
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(GradableObject.class);
    protected Long id;
    protected int version;
    protected Gradebook gradebook;
    protected String name;
    protected Integer sortOrder;
    protected Integer categorizedSortOrder;
    protected Double mean;
    protected boolean removed;
    public static Comparator<GradableObject> defaultComparator;
    public static Comparator<GradableObject> sortingComparator;
    public static Comparator<GradebookAssignment> dateComparator;
    public static Comparator<GradableObject> meanComparator;
    public static Comparator<GradableObject> nameComparator;
    public static Comparator<GradableObject> idComparator;
    public static Comparator<GradebookAssignment> categoryComparator;
    private int sortTotalItems = 1;
    private int sortTruePosition = -1;

    public abstract boolean isCourseGrade();

    public abstract boolean isAssignment();

    public abstract boolean getIsCategory();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Gradebook getGradebook() {
        return this.gradebook;
    }

    public void setGradebook(Gradebook gradebook) {
        this.gradebook = gradebook;
    }

    public Double getMean() {
        return this.mean;
    }

    public Double getFormattedMean() {
        if (this.mean == null || this.mean.equals(Double.NaN)) {
            return null;
        }
        return this.mean / 100.0;
    }

    public void setMean(Double mean) {
        this.mean = mean;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("name", (Object)this.name).append("sort", (Object)this.sortOrder).toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof GradableObject)) {
            return false;
        }
        GradableObject go = (GradableObject)other;
        return new EqualsBuilder().append((Object)this.gradebook, (Object)go.getGradebook()).append((Object)this.id, (Object)go.getId()).append((Object)this.name, (Object)go.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.gradebook).append((Object)this.id).append((Object)this.name).toHashCode();
    }

    public void assignSorting(int sortTotalItems, int sortTruePosition) {
        this.sortTotalItems = sortTotalItems;
        this.sortTruePosition = sortTruePosition;
    }

    public boolean isFirst() {
        return this.sortTruePosition == 0;
    }

    public boolean isLast() {
        return this.sortTruePosition >= this.sortTotalItems - 1;
    }

    public int getSortPosition() {
        return this.sortTruePosition;
    }

    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Integer getCategorizedSortOrder() {
        return this.categorizedSortOrder;
    }

    public void setCategorizedSortOrder(Integer value) {
        this.categorizedSortOrder = value;
    }

    static {
        categoryComparator = new Comparator<GradebookAssignment>(){

            @Override
            public int compare(GradebookAssignment one, GradebookAssignment two) {
                if (one.getCategory() == null && two.getCategory() == null) {
                    return 0;
                }
                if (one.getCategory() == null) {
                    return 1;
                }
                if (two.getCategory() == null) {
                    return -1;
                }
                return Category.nameComparator.compare(one.getCategory(), two.getCategory());
            }

            public String toString() {
                return "GradableObject.categoryComparator";
            }
        };
        idComparator = new Comparator<GradableObject>(){

            @Override
            public int compare(GradableObject one, GradableObject two) {
                if (one.getId() == null && two.getId() == null) {
                    return 0;
                }
                if (one.getName() == null) {
                    return 1;
                }
                if (two.getName() == null) {
                    return -1;
                }
                return one.getId().compareTo(two.getId());
            }

            public String toString() {
                return "GradableObject.idComparator";
            }
        };
        nameComparator = new Comparator<GradableObject>(){

            @Override
            public int compare(GradableObject one, GradableObject two) {
                if (one.getName() == null && two.getName() == null) {
                    return idComparator.compare(one, two);
                }
                if (one.getName() == null) {
                    return 1;
                }
                if (two.getName() == null) {
                    return -1;
                }
                return one.getName().toLowerCase().compareTo(two.getName().toLowerCase());
            }

            public String toString() {
                return "GradableObject.nameComparator";
            }
        };
        meanComparator = new Comparator<GradableObject>(){

            @Override
            public int compare(GradableObject one, GradableObject two) {
                if (one.getMean() == null && two.getMean() == null) {
                    return nameComparator.compare(one, two);
                }
                if (one.getMean() == null) {
                    return 1;
                }
                if (two.getMean() == null) {
                    return -1;
                }
                return one.getMean().compareTo(two.getMean());
            }

            public String toString() {
                return "GradableObject.meanComparator";
            }
        };
        dateComparator = new Comparator<GradebookAssignment>(){

            @Override
            public int compare(GradebookAssignment one, GradebookAssignment two) {
                if (one.getDueDate() == null && two.getDueDate() == null) {
                    return nameComparator.compare(one, two);
                }
                if (one.getDueDate() == null) {
                    return 1;
                }
                if (two.getDueDate() == null) {
                    return -1;
                }
                return one.getDueDate().compareTo(two.getDueDate());
            }

            public String toString() {
                return "GradableObject.dateComparator";
            }
        };
        sortingComparator = new Comparator<GradableObject>(){

            @Override
            public int compare(GradableObject one, GradableObject two) {
                if (one.getSortOrder() == null && two.getSortOrder() == null) {
                    if (one.getClass().equals(two.getClass()) && one.getClass().isAssignableFrom(GradebookAssignment.class)) {
                        return dateComparator.compare((GradebookAssignment)one, (GradebookAssignment)two);
                    }
                    return nameComparator.compare(one, two);
                }
                if (one.getSortOrder() == null) {
                    return 1;
                }
                if (two.getSortOrder() == null) {
                    return -1;
                }
                return one.getSortOrder().compareTo(two.getSortOrder());
            }

            public String toString() {
                return "GradableObject.sortingComparator";
            }
        };
        defaultComparator = sortingComparator;
    }
}

