/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import org.sakaiproject.tool.gradebook.CourseGrade;
import org.sakaiproject.tool.gradebook.GradeMapping;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradebookArchive {
    private static final Logger log = LoggerFactory.getLogger(GradebookArchive.class);
    private Gradebook gradebook;
    private GradeMapping selectedGradeMapping;
    private Collection gradeMappings;
    private CourseGrade courseGrade;
    private Collection assignments;

    public GradebookArchive() {
    }

    public GradebookArchive(Gradebook gradebook, GradeMapping selectedGradeMapping, Collection gradeMappings, CourseGrade courseGrade, Collection assignments) {
        this.gradebook = gradebook;
        this.selectedGradeMapping = selectedGradeMapping;
        this.gradeMappings = gradeMappings;
        this.courseGrade = courseGrade;
        this.assignments = assignments;
    }

    public String archive() {
        if (log.isDebugEnabled()) {
            log.debug("GradebookArchive.archive() called");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(baos));
        encoder.writeObject(this);
        encoder.flush();
        String xml = baos.toString();
        if (log.isDebugEnabled()) {
            log.debug("GradebookArchive.archive() finished");
        }
        return xml;
    }

    public void readArchive(String xml) {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(in));
        GradebookArchive archive = (GradebookArchive)decoder.readObject();
        decoder.close();
        this.gradebook = archive.getGradebook();
        this.courseGrade = archive.getCourseGrade();
        this.assignments = archive.getAssignments();
    }

    public Collection getAssignments() {
        return this.assignments;
    }

    public void setAssignments(Collection assignments) {
        this.assignments = assignments;
    }

    public CourseGrade getCourseGrade() {
        return this.courseGrade;
    }

    public void setCourseGrade(CourseGrade courseGrade) {
        this.courseGrade = courseGrade;
    }

    public Gradebook getGradebook() {
        return this.gradebook;
    }

    public void setGradebook(Gradebook gradebook) {
        this.gradebook = gradebook;
    }

    public Collection getGradeMappings() {
        return this.gradeMappings;
    }

    public void setGradeMappings(Collection gradeMappings) {
        this.gradeMappings = gradeMappings;
    }

    public GradeMapping getSelectedGradeMapping() {
        return this.selectedGradeMapping;
    }

    public void setSelectedGradeMapping(GradeMapping selectedGradeMapping) {
        this.selectedGradeMapping = selectedGradeMapping;
    }
}

