/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import org.sakaiproject.service.gradebook.shared.GradebookException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.tool.gradebook.AssignmentGradeRecord;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.GradableObject;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradebookAssignment
extends GradableObject {
    private static final Logger log = LoggerFactory.getLogger(GradebookAssignment.class);
    private static final long serialVersionUID = -526126234461183210L;
    @Deprecated
    public static String SORT_BY_DATE = "dueDate";
    @Deprecated
    public static String SORT_BY_NAME = "name";
    @Deprecated
    public static String SORT_BY_MEAN = "mean";
    @Deprecated
    public static String SORT_BY_POINTS = "pointsPossible";
    @Deprecated
    public static String SORT_BY_RELEASED = "released";
    @Deprecated
    public static String SORT_BY_COUNTED = "counted";
    @Deprecated
    public static String SORT_BY_EDITOR = "gradeEditor";
    @Deprecated
    public static String SORT_BY_SORTING;
    @Deprecated
    public static String DEFAULT_SORT;
    public static String item_type_points;
    public static String item_type_percentage;
    public static String item_type_letter;
    public static String item_type_nonCalc;
    public static String item_type_adjustment;
    public static Comparator dateComparator;
    public static Comparator nameComparator;
    public static Comparator pointsComparator;
    public static Comparator meanComparator;
    public static Comparator releasedComparator;
    public static Comparator countedComparator;
    public static Comparator gradeEditorComparator;
    public static Comparator categoryComparator;
    private Double pointsPossible;
    private Date dueDate;
    private Boolean notCounted;
    private Boolean externallyMaintained;
    private String externalStudentLink;
    private String externalInstructorLink;
    private String externalId;
    private String externalAppName;
    private Boolean released;
    private Category category;
    private Double averageTotal;
    private Boolean ungraded;
    private Boolean extraCredit = Boolean.FALSE;
    private Double assignmentWeighting;
    private Boolean countNullsAsZeros;
    private String itemType;
    public String selectedGradeEntryValue;
    private Boolean hideInAllGradesTable = Boolean.FALSE;

    public GradebookAssignment() {
        this(null, null, null, null, false);
    }

    public GradebookAssignment(Gradebook gradebook, String name, Double pointsPossible, Date dueDate) {
        this(gradebook, name, pointsPossible, dueDate, true);
    }

    public GradebookAssignment(Gradebook gradebook, String name, Double pointsPossible, Date dueDate, boolean released) {
        this.gradebook = gradebook;
        this.name = name;
        this.pointsPossible = pointsPossible;
        this.dueDate = dueDate;
        this.released = released;
        this.extraCredit = Boolean.FALSE;
        this.hideInAllGradesTable = Boolean.FALSE;
    }

    @Override
    public boolean isCourseGrade() {
        return false;
    }

    @Override
    public boolean isAssignment() {
        return true;
    }

    @Override
    public boolean getIsCategory() {
        return false;
    }

    public Date getDateForDisplay() {
        return this.dueDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public boolean isNotCounted() {
        return this.notCounted != null ? this.notCounted : false;
    }

    public void setNotCounted(boolean notCounted) {
        this.notCounted = notCounted;
    }

    public boolean isCounted() {
        return !this.isNotCounted();
    }

    public void setCounted(boolean counted) {
        this.setNotCounted(!counted);
    }

    public String getExternalInstructorLink() {
        return this.externalInstructorLink;
    }

    public void setExternalInstructorLink(String externalInstructorLink) {
        this.externalInstructorLink = externalInstructorLink;
    }

    public boolean isExternallyMaintained() {
        return this.externallyMaintained != null ? this.externallyMaintained : false;
    }

    public void setExternallyMaintained(boolean externallyMaintained) {
        this.externallyMaintained = externallyMaintained;
    }

    public String getExternalStudentLink() {
        return this.externalStudentLink;
    }

    public void setExternalStudentLink(String externalStudentLink) {
        this.externalStudentLink = externalStudentLink;
    }

    public Double getPointsPossible() {
        return this.pointsPossible;
    }

    public void setPointsPossible(Double pointsPossible) {
        this.pointsPossible = pointsPossible;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalAppName() {
        return this.externalAppName;
    }

    public void setExternalAppName(String externalAppName) {
        this.externalAppName = externalAppName;
    }

    public boolean isReleased() {
        return this.released != null ? this.released : false;
    }

    public void setReleased(boolean released) {
        this.released = released;
    }

    public void calculateStatistics(Collection<AssignmentGradeRecord> gradeRecords) {
        int numScored = 0;
        BigDecimal total = new BigDecimal("0");
        BigDecimal pointsTotal = new BigDecimal("0");
        for (AssignmentGradeRecord record : gradeRecords) {
            if (!record.getGradableObject().equals(this)) continue;
            if (record.getDroppedFromGrade() == null) {
                throw new GradebookException("record.droppedFromGrade cannot be null");
            }
            Double score = null;
            if (!this.getUngraded() && this.pointsPossible > 0.0) {
                score = record.getGradeAsPercentage();
            }
            Double points = record.getPointsEarned();
            if (score == null && points == null || record.getDroppedFromGrade().booleanValue()) continue;
            if (score == null) {
                pointsTotal = pointsTotal.add(new BigDecimal(points.toString()));
                ++numScored;
                continue;
            }
            total = total.add(new BigDecimal(score.toString()));
            pointsTotal = pointsTotal.add(new BigDecimal(points.toString()));
            ++numScored;
        }
        if (numScored == 0) {
            this.mean = null;
            this.averageTotal = null;
        } else {
            BigDecimal bdNumScored = new BigDecimal(numScored);
            this.mean = !this.getUngraded() && this.pointsPossible > 0.0 ? Double.valueOf(total.divide(bdNumScored, GradebookService.MATH_CONTEXT).doubleValue()) : null;
            this.averageTotal = pointsTotal.divide(bdNumScored, GradebookService.MATH_CONTEXT).doubleValue();
        }
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public Double getAverageTotal() {
        return this.averageTotal;
    }

    public void setAverageTotal(Double averageTotal) {
        this.averageTotal = averageTotal;
    }

    public boolean getUngraded() {
        return this.ungraded != null ? this.ungraded : false;
    }

    public void setUngraded(boolean ungraded) {
        this.ungraded = ungraded;
    }

    public Boolean getIsExtraCredit() {
        return this.isExtraCredit();
    }

    public void setIsExtraCredit(Boolean isExtraCredit) {
        this.setExtraCredit(isExtraCredit);
    }

    public Boolean isExtraCredit() {
        return this.extraCredit != null ? this.extraCredit : false;
    }

    public void setExtraCredit(Boolean isExtraCredit) {
        this.extraCredit = isExtraCredit;
    }

    public Double getAssignmentWeighting() {
        return this.assignmentWeighting;
    }

    public void setAssignmentWeighting(Double assignmentWeighting) {
        this.assignmentWeighting = assignmentWeighting;
    }

    public String getItemType() {
        Gradebook gb = this.getGradebook();
        if (gb != null) {
            if (this.isExtraCredit() != null && this.isExtraCredit().booleanValue()) {
                this.itemType = item_type_adjustment;
                return this.itemType;
            }
            if (this.getUngraded()) {
                this.itemType = item_type_nonCalc;
                return this.itemType;
            }
            if (gb.getGrade_type() == 1) {
                this.itemType = item_type_points;
            } else if (gb.getGrade_type() == 2) {
                this.itemType = item_type_percentage;
            } else if (gb.getGrade_type() == 3) {
                this.itemType = item_type_letter;
            }
        }
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public Boolean getCountNullsAsZeros() {
        return this.countNullsAsZeros;
    }

    public void setCountNullsAsZeros(Boolean countNullsAsZeros) {
        this.countNullsAsZeros = countNullsAsZeros;
    }

    public String getSelectedGradeEntryValue() {
        return this.selectedGradeEntryValue;
    }

    public void setSelectedGradeEntryValue(String selectedGradeEntryValue) {
        this.selectedGradeEntryValue = selectedGradeEntryValue;
    }

    public boolean isIncludedInCalculations() {
        boolean isIncludedInCalculations = false;
        int categoryType = this.gradebook.getCategory_type();
        if (!this.removed && !this.getUngraded() && this.isCounted() && (this.isExtraCredit().booleanValue() || this.pointsPossible != null && this.pointsPossible > 0.0)) {
            isIncludedInCalculations = true;
        }
        if (categoryType != 1 && this.category == null) {
            isIncludedInCalculations = false;
        }
        return isIncludedInCalculations;
    }

    public boolean isHideInAllGradesTable() {
        return this.hideInAllGradesTable != null ? this.hideInAllGradesTable : false;
    }

    public void setHideInAllGradesTable(boolean hideInAllGradesTable) {
        this.hideInAllGradesTable = hideInAllGradesTable;
    }

    static {
        DEFAULT_SORT = SORT_BY_SORTING = "sorting";
        item_type_points = "Points";
        item_type_percentage = "Percentage";
        item_type_letter = "Letter Grade";
        item_type_nonCalc = "Non-calculating";
        item_type_adjustment = "Adjustment";
        dateComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (log.isDebugEnabled()) {
                    log.debug("Comparing assignment + " + o1 + " to " + o2 + " by date");
                }
                GradebookAssignment one = (GradebookAssignment)o1;
                GradebookAssignment two = (GradebookAssignment)o2;
                if (one.getDueDate() == null && two.getDueDate() == null) {
                    return one.getName().toLowerCase().compareTo(two.getName().toLowerCase());
                }
                if (one.getDueDate() == null) {
                    return 1;
                }
                if (two.getDueDate() == null) {
                    return -1;
                }
                int comp = one.getDueDate().compareTo(two.getDueDate());
                if (comp == 0) {
                    return one.getName().toLowerCase().compareTo(two.getName().toLowerCase());
                }
                return comp;
            }

            public String toString() {
                return "GradebookAssignment.dateComparator";
            }
        };
        nameComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                GradebookAssignment one = (GradebookAssignment)o1;
                GradebookAssignment two = (GradebookAssignment)o2;
                return one.getName().toLowerCase().compareTo(two.getName().toLowerCase());
            }

            public String toString() {
                return "GradebookAssignment.nameComparator";
            }
        };
        pointsComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (log.isDebugEnabled()) {
                    log.debug("Comparing assignment + " + o1 + " to " + o2 + " by points");
                }
                GradebookAssignment one = (GradebookAssignment)o1;
                GradebookAssignment two = (GradebookAssignment)o2;
                int comp = one.getPointsPossible().compareTo(two.getPointsPossible());
                if (comp == 0) {
                    return one.getName().toLowerCase().compareTo(two.getName().toLowerCase());
                }
                return comp;
            }

            public String toString() {
                return "GradebookAssignment.pointsComparator";
            }
        };
        meanComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (log.isDebugEnabled()) {
                    log.debug("Comparing assignment + " + o1 + " to " + o2 + " by mean");
                }
                GradebookAssignment one = (GradebookAssignment)o1;
                GradebookAssignment two = (GradebookAssignment)o2;
                Double mean1 = one.getMean();
                Double mean2 = two.getMean();
                if (mean1 == null && mean2 == null) {
                    return one.getName().toLowerCase().compareTo(two.getName().toLowerCase());
                }
                if (mean1 != null && mean2 == null) {
                    return 1;
                }
                if (mean1 == null && mean2 != null) {
                    return -1;
                }
                int comp = mean1.compareTo(mean2);
                if (comp == 0) {
                    return one.getName().toLowerCase().compareTo(two.getName().toLowerCase());
                }
                return comp;
            }

            public String toString() {
                return "GradebookAssignment.meanComparator";
            }
        };
        releasedComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (log.isDebugEnabled()) {
                    log.debug("Comparing assignment + " + o1 + " to " + o2 + " by release");
                }
                GradebookAssignment one = (GradebookAssignment)o1;
                GradebookAssignment two = (GradebookAssignment)o2;
                int comp = String.valueOf(one.isReleased()).compareTo(String.valueOf(two.isReleased()));
                if (comp == 0) {
                    return one.getName().compareTo(two.getName());
                }
                return comp;
            }

            public String toString() {
                return "GradebookAssignment.releasedComparator";
            }
        };
        countedComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (log.isDebugEnabled()) {
                    log.debug("Comparing assignment + " + o1 + " to " + o2 + " by counted");
                }
                GradebookAssignment one = (GradebookAssignment)o1;
                GradebookAssignment two = (GradebookAssignment)o2;
                int comp = String.valueOf(one.isCounted()).compareTo(String.valueOf(two.isCounted()));
                if (comp == 0) {
                    return one.getName().compareTo(two.getName());
                }
                return comp;
            }

            public String toString() {
                return "GradebookAssignment.countedComparator";
            }
        };
        gradeEditorComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (log.isDebugEnabled()) {
                    log.debug("Comparing assignment + " + o1 + " to " + o2 + " by grade editor");
                }
                GradebookAssignment one = (GradebookAssignment)o1;
                GradebookAssignment two = (GradebookAssignment)o2;
                int comp = String.valueOf(one.getExternalAppName()).compareTo(String.valueOf(two.getExternalAppName()));
                if (comp == 0) {
                    return one.getName().compareTo(two.getName());
                }
                return comp;
            }

            public String toString() {
                return "GradebookAssignment.gradeEditorComparator";
            }
        };
        categoryComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (log.isDebugEnabled()) {
                    log.debug("Comparing assignment + " + o1 + " to " + o2 + " by category ordering");
                }
                GradebookAssignment one = (GradebookAssignment)o1;
                GradebookAssignment two = (GradebookAssignment)o2;
                if (one.getCategory() == null && two.getCategory() == null) {
                    if (one.getSortOrder() == null && two.getSortOrder() == null) {
                        return one.getId().compareTo(two.getId());
                    }
                    if (one.getSortOrder() == null) {
                        return 1;
                    }
                    if (two.getSortOrder() == null) {
                        return -1;
                    }
                    return one.getSortOrder().compareTo(two.getSortOrder());
                }
                if (one.getCategory() == null) {
                    return 1;
                }
                if (two.getCategory() == null) {
                    return -1;
                }
                if (one.getCategory().equals(two.getCategory())) {
                    if (one.getCategorizedSortOrder() == null) {
                        return 1;
                    }
                    if (two.getCategorizedSortOrder() == null) {
                        return -1;
                    }
                    return Integer.compare(one.getCategorizedSortOrder(), two.getCategorizedSortOrder());
                }
                if (one.getCategory().getCategoryOrder() == null && two.getCategory().getCategoryOrder() == null) {
                    if (one.getCategory().getName() == null && two.getCategory().getName() == null) {
                        return one.getCategory().getId().compareTo(two.getCategory().getId());
                    }
                    if (one.getCategory().getName() == null) {
                        return 1;
                    }
                    if (two.getCategory().getName() == null) {
                        return -1;
                    }
                    return one.getCategory().getName().compareTo(two.getCategory().getName());
                }
                if (one.getCategory().getCategoryOrder() == null) {
                    return 1;
                }
                if (two.getCategory().getCategoryOrder() == null) {
                    return -1;
                }
                return one.getCategory().getCategoryOrder().compareTo(two.getCategory().getCategoryOrder());
            }

            public String toString() {
                return "GradebookAssignment.categoryComparator";
            }
        };
    }
}

