/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sakaiproject.service.gradebook.shared.DoubleComparator;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradingScale;

public class GradeMapping
implements Serializable,
Comparable<Object> {
    private static final long serialVersionUID = 1L;
    protected Long id;
    protected int version;
    protected Gradebook gradebook;
    protected Map<String, Double> gradeMap;
    private GradingScale gradingScale;

    public GradeMapping() {
    }

    public GradeMapping(GradingScale gradingScale) {
        this.setGradingScale(gradingScale);
        this.gradeMap = new HashMap<String, Double>(gradingScale.getDefaultBottomPercents());
    }

    public String getName() {
        return this.getGradingScale().getName();
    }

    public void setDefaultValues() {
        this.gradeMap = new HashMap<String, Double>(this.getDefaultBottomPercents());
    }

    public Map<String, Double> getDefaultBottomPercents() {
        GradingScale scale = this.getGradingScale();
        if (scale != null) {
            return scale.getDefaultBottomPercents();
        }
        HashMap<String, Double> defaultBottomPercents = new HashMap<String, Double>();
        Iterator<String> gradesIter = this.getGrades().iterator();
        Iterator<Double> defaultValuesIter = this.getDefaultValues().iterator();
        while (gradesIter.hasNext()) {
            String grade = gradesIter.next();
            Double value = defaultValuesIter.next();
            defaultBottomPercents.put(grade, value);
        }
        return defaultBottomPercents;
    }

    public Collection<String> getGrades() {
        return this.getGradingScale().getGrades();
    }

    @Deprecated
    public List<Double> getDefaultValues() {
        throw new UnsupportedOperationException("getDefaultValues called for GradeMapping " + this.getName() + " in Gradebook " + this.getGradebook());
    }

    public Double getValue(String grade) {
        return this.gradeMap.get(grade);
    }

    public String getMappedGrade(Double value) {
        return GradeMapping.getMappedGrade(this.getGradeMap(), value);
    }

    public static String getMappedGrade(Map<String, Double> gradeMap, Double value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry<String, Double> entry : GradeMapping.sortGradeMapping(gradeMap).entrySet()) {
            String grade = entry.getKey();
            Double mapVal = entry.getValue();
            if (mapVal == null || mapVal.compareTo(value) > 0) continue;
            return grade;
        }
        return null;
    }

    public static Map<String, Double> sortGradeMapping(Map<String, Double> gradeMap) {
        DoubleComparator doubleComparator = new DoubleComparator(gradeMap);
        TreeMap<String, Double> rval = new TreeMap<String, Double>((Comparator<String>)doubleComparator);
        rval.putAll(gradeMap);
        return rval;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Map<String, Double> getGradeMap() {
        return this.gradeMap;
    }

    public void setGradeMap(Map<String, Double> gradeMap) {
        this.gradeMap = gradeMap;
    }

    public Gradebook getGradebook() {
        return this.gradebook;
    }

    public void setGradebook(Gradebook gradebook) {
        this.gradebook = gradebook;
    }

    @Override
    public int compareTo(Object o) {
        GradeMapping other = (GradeMapping)o;
        return new CompareToBuilder().append((Object)this.getName(), (Object)other.getName()).toComparison();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradeMapping other = (GradeMapping)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).isEquals();
    }

    public int hashCode() {
        if (this.getGradingScale() == null || this.getName() == null) {
            return 0;
        }
        return new HashCodeBuilder().append((Object)this.getName()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getName()).append((Object)this.id).toString();
    }

    public String standardizeInputGrade(String inputGrade) {
        String standardizedGrade = null;
        for (String grade : this.getGrades()) {
            if (!grade.equalsIgnoreCase(inputGrade)) continue;
            standardizedGrade = grade;
            break;
        }
        return standardizedGrade;
    }

    public GradingScale getGradingScale() {
        return this.gradingScale;
    }

    public void setGradingScale(GradingScale gradingScale) {
        this.gradingScale = gradingScale;
    }
}

