/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook;

import java.math.BigDecimal;
import java.util.Collection;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.tool.gradebook.CourseGradeRecord;
import org.sakaiproject.tool.gradebook.GradableObject;

public class CourseGrade
extends GradableObject {
    private static final long serialVersionUID = -7607255825842609208L;
    private static final String COURSE_GRADE_NAME = "Course Grade";
    public static String SORT_BY_OVERRIDE_GRADE = "override";
    public static String SORT_BY_CALCULATED_GRADE = "autoCalc";
    public static String SORT_BY_POINTS_EARNED = "pointsEarned";
    private Double averageScore;

    public CourseGrade() {
        this.setName(COURSE_GRADE_NAME);
    }

    @Override
    public boolean isCourseGrade() {
        return true;
    }

    @Override
    public boolean isAssignment() {
        return false;
    }

    @Override
    public boolean getIsCategory() {
        return false;
    }

    public void calculateStatistics(Collection<CourseGradeRecord> gradeRecords, int numEnrollments) {
        int numScored = numEnrollments - gradeRecords.size();
        BigDecimal total = new BigDecimal("0");
        BigDecimal average = new BigDecimal("0");
        for (CourseGradeRecord record : gradeRecords) {
            Double score = record.getGradeAsPercentage();
            if (record.getEnteredGrade() != null && score == null) continue;
            if (score != null && record.getPointsEarned() != null) {
                average = average.add(new BigDecimal(record.getPointsEarned().toString()));
                total = total.add(new BigDecimal(score.toString()));
                ++numScored;
            }
            if (score == null || record.getPointsEarned() != null) continue;
            average = average.add(new BigDecimal(record.getCalculatedPointsEarned().toString()));
            total = total.add(new BigDecimal(score.toString()));
            ++numScored;
        }
        if (numScored == 0) {
            this.mean = null;
            this.averageScore = null;
        } else {
            this.mean = total.divide(new BigDecimal(numScored), GradebookService.MATH_CONTEXT).doubleValue();
            this.averageScore = average.divide(new BigDecimal(numScored), GradebookService.MATH_CONTEXT).doubleValue();
        }
    }

    public Double getAverageScore() {
        return this.averageScore;
    }

    public void setAverageScore(Double averageScore) {
        this.averageScore = averageScore;
    }
}

