/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.tool.gradebook.AssignmentGradeRecord;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradebookAssignment;

public class Category
implements Serializable {
    private static final long serialVersionUID = 2609776646548825870L;
    private Long id;
    private int version;
    private Gradebook gradebook;
    private String name;
    private Double weight;
    private Integer dropLowest;
    private Integer dropHighest;
    private Integer keepHighest;
    private boolean removed;
    private Double averageTotalPoints;
    private Double averageScore;
    private Double mean;
    private Double totalPointsEarned;
    private Double totalPointsPossible;
    private List assignmentList;
    private int assignmentCount;
    private Boolean extraCredit = false;
    private Boolean unweighted;
    private Boolean equalWeightAssignments = false;
    private Integer categoryOrder;
    private Boolean enforcePointWeighting;
    public static final Comparator nameComparator;
    public static final Comparator averageScoreComparator;
    public static final Comparator weightComparator;
    public static String SORT_BY_NAME;
    public static String SORT_BY_AVERAGE_SCORE;
    public static String SORT_BY_WEIGHT;

    public Integer getDropHighest() {
        return this.dropHighest == null ? 0 : this.dropHighest;
    }

    public void setDropHighest(Integer dropHighest) {
        this.dropHighest = dropHighest;
    }

    public Integer getKeepHighest() {
        return this.keepHighest == null ? 0 : this.keepHighest;
    }

    public void setKeepHighest(Integer keepHighest) {
        this.keepHighest = keepHighest;
    }

    public boolean isDropScores() {
        return this.getDropLowest() > 0 || this.getDropHighest() > 0 || this.getKeepHighest() > 0;
    }

    public Double getItemValue() {
        if (this.isAssignmentsEqual()) {
            Double returnVal = 0.0;
            List assignments = this.getAssignmentList();
            if (assignments != null) {
                for (Object obj : assignments) {
                    GradebookAssignment assignment;
                    if (!(obj instanceof GradebookAssignment) || GradebookAssignment.item_type_adjustment.equals((assignment = (GradebookAssignment)obj).getItemType())) continue;
                    returnVal = assignment.getPointsPossible();
                    return returnVal;
                }
            }
            return returnVal;
        }
        return 0.0;
    }

    public Integer getDropLowest() {
        return this.dropLowest != null ? this.dropLowest : 0;
    }

    public void setDropLowest(Integer lowest) {
        this.dropLowest = lowest;
    }

    public Gradebook getGradebook() {
        return this.gradebook;
    }

    public void setGradebook(Gradebook gradebook) {
        this.gradebook = gradebook;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.substring((String)name, (int)0, (int)249);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public Double getAverageTotalPoints() {
        return this.averageTotalPoints;
    }

    public void setAverageTotalPoints(Double averageTotalPoints) {
        this.averageTotalPoints = averageTotalPoints;
    }

    public Double getAverageScore() {
        return this.averageScore;
    }

    public void setAverageScore(Double averageScore) {
        this.averageScore = averageScore;
    }

    public void calculateStatistics(List<GradebookAssignment> assignmentsWithStats) {
        int numScored = 0;
        int numOfAssignments = 0;
        BigDecimal total = new BigDecimal("0");
        BigDecimal totalPossible = new BigDecimal("0");
        for (GradebookAssignment assign : assignmentsWithStats) {
            Double score = assign.getAverageTotal();
            if (!assign.isCounted() || assign.getUngraded() || assign.getPointsPossible() == null || !(assign.getPointsPossible() > 0.0) || score == null) continue;
            total = total.add(new BigDecimal(score.toString()));
            if (assign.getPointsPossible() != null && !assign.isExtraCredit().booleanValue()) {
                totalPossible = totalPossible.add(new BigDecimal(assign.getPointsPossible().toString()));
                ++numOfAssignments;
            }
            if (assign.isExtraCredit().booleanValue()) continue;
            ++numScored;
        }
        if (numScored == 0 || numOfAssignments == 0) {
            this.averageScore = null;
            this.averageTotalPoints = null;
            this.mean = null;
            this.totalPointsEarned = null;
            this.totalPointsPossible = null;
        } else {
            BigDecimal bdNumScored = new BigDecimal(numScored);
            BigDecimal bdNumAssign = new BigDecimal(numOfAssignments);
            this.averageScore = total.divide(bdNumScored, GradebookService.MATH_CONTEXT).doubleValue();
            this.averageTotalPoints = totalPossible.divide(bdNumAssign, GradebookService.MATH_CONTEXT).doubleValue();
            BigDecimal value = total.divide(bdNumScored, GradebookService.MATH_CONTEXT).divide(new BigDecimal(this.averageTotalPoints), GradebookService.MATH_CONTEXT).multiply(new BigDecimal("100"));
            this.mean = value.doubleValue();
        }
    }

    public void calculateStatisticsPerStudent(List<AssignmentGradeRecord> gradeRecords, String studentUid) {
        this.getGradebook().getGrade_type();
        int numScored = 0;
        int numOfAssignments = 0;
        BigDecimal total = new BigDecimal("0");
        BigDecimal totalPossible = new BigDecimal("0");
        if (gradeRecords == null) {
            this.setAverageScore(null);
            this.setAverageTotalPoints(null);
            this.setMean(null);
            this.setTotalPointsEarned(null);
            this.setTotalPointsPossible(null);
            return;
        }
        for (AssignmentGradeRecord gradeRecord : gradeRecords) {
            Double score;
            Category assignCategory;
            GradebookAssignment assignment;
            if (gradeRecord == null || !gradeRecord.getStudentId().equals(studentUid) || !(assignment = gradeRecord.getAssignment()).isCounted() || assignment.getUngraded() || !(assignment.getPointsPossible() > 0.0) || gradeRecord.getDroppedFromGrade().booleanValue() || (assignCategory = assignment.getCategory()) == null || !assignCategory.getId().equals(this.id) || (score = gradeRecord.getPointsEarned()) == null) continue;
            BigDecimal bdScore = new BigDecimal(score.toString());
            total = total.add(bdScore);
            if (assignment.getPointsPossible() != null && !assignment.isExtraCredit().booleanValue()) {
                BigDecimal bdPointsPossible = new BigDecimal(assignment.getPointsPossible().toString());
                totalPossible = totalPossible.add(bdPointsPossible);
                ++numOfAssignments;
            }
            if (assignment.isExtraCredit().booleanValue()) continue;
            ++numScored;
        }
        if (numScored == 0 || numOfAssignments == 0 || totalPossible.doubleValue() == 0.0) {
            this.averageScore = null;
            this.averageTotalPoints = null;
            this.mean = null;
            this.totalPointsEarned = null;
            this.totalPointsPossible = null;
        } else {
            BigDecimal bdNumScored = new BigDecimal(numScored);
            BigDecimal bdNumAssign = new BigDecimal(numOfAssignments);
            this.averageScore = total.divide(bdNumScored, GradebookService.MATH_CONTEXT).doubleValue();
            this.averageTotalPoints = totalPossible.divide(bdNumAssign, GradebookService.MATH_CONTEXT).doubleValue();
            BigDecimal value = total.divide(bdNumScored, GradebookService.MATH_CONTEXT).divide(totalPossible.divide(bdNumAssign, GradebookService.MATH_CONTEXT), GradebookService.MATH_CONTEXT).multiply(new BigDecimal("100"));
            this.mean = value.doubleValue();
        }
    }

    public List getAssignmentList() {
        return this.assignmentList;
    }

    public void setAssignmentList(List assignmentList) {
        this.assignmentList = assignmentList;
    }

    public boolean getIsCategory() {
        return true;
    }

    public boolean isCourseGrade() {
        return false;
    }

    public boolean isAssignment() {
        return false;
    }

    public Double getMean() {
        return this.mean;
    }

    public void setMean(Double mean) {
        this.mean = mean;
    }

    public int getAssignmentCount() {
        return this.assignmentCount;
    }

    public void setAssignmentCount(int assignmentCount) {
        this.assignmentCount = assignmentCount;
    }

    public Boolean getIsExtraCredit() {
        return this.isExtraCredit();
    }

    public void setIsExtraCredit(Boolean isExtraCredit) {
        this.setExtraCredit(isExtraCredit);
    }

    public Boolean isExtraCredit() {
        return this.extraCredit;
    }

    public void setExtraCredit(Boolean isExtraCredit) {
        this.extraCredit = isExtraCredit;
    }

    public boolean isAssignmentsEqual() {
        boolean isEqual = true;
        Double pointsPossible = null;
        List assignments = this.getAssignmentList();
        if (assignments == null) {
            return isEqual;
        }
        for (Object obj : assignments) {
            if (!(obj instanceof GradebookAssignment)) continue;
            GradebookAssignment assignment = (GradebookAssignment)obj;
            if (pointsPossible == null) {
                if (GradebookAssignment.item_type_adjustment.equals(assignment.getItemType())) continue;
                pointsPossible = assignment.getPointsPossible();
                continue;
            }
            if (assignment.getPointsPossible() == null || GradebookAssignment.item_type_adjustment.equals(assignment.getItemType()) || pointsPossible.equals(assignment.getPointsPossible()) || this.isEqualWeightAssignments().booleanValue()) continue;
            isEqual = false;
            return isEqual;
        }
        return isEqual;
    }

    public Boolean isUnweighted() {
        return this.unweighted;
    }

    public void setUnweighted(Boolean unweighted) {
        this.unweighted = unweighted;
    }

    public Boolean isEqualWeightAssignments() {
        return this.equalWeightAssignments;
    }

    public void setEqualWeightAssignments(Boolean equalWeightAssignments) {
        this.equalWeightAssignments = equalWeightAssignments;
    }

    public Integer getCategoryOrder() {
        return this.categoryOrder;
    }

    public void setCategoryOrder(Integer categoryOrder) {
        this.categoryOrder = categoryOrder;
    }

    public Boolean isEnforcePointWeighting() {
        return this.enforcePointWeighting;
    }

    public void setEnforcePointWeighting(Boolean enforcePointWeighting) {
        this.enforcePointWeighting = enforcePointWeighting;
    }

    public Double getTotalPointsEarned() {
        return this.totalPointsEarned;
    }

    public void setTotalPointsEarned(Double totalPointsEarned) {
        this.totalPointsEarned = totalPointsEarned;
    }

    public Double getTotalPointsPossible() {
        return this.totalPointsPossible;
    }

    public void setTotalPointsPossible(Double totalPointsPossible) {
        this.totalPointsPossible = totalPointsPossible;
    }

    public Double getPointsPossible() {
        return this.totalPointsPossible;
    }

    public void setPointsPossible(Double pointsPossible) {
        this.totalPointsPossible = pointsPossible;
    }

    static {
        SORT_BY_NAME = "name";
        SORT_BY_AVERAGE_SCORE = "averageScore";
        SORT_BY_WEIGHT = "weight";
        nameComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Category)o1).getName().toLowerCase().compareTo(((Category)o2).getName().toLowerCase());
            }
        };
        averageScoreComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Category one = (Category)o1;
                Category two = (Category)o2;
                if (one.getAverageScore() == null && two.getAverageScore() == null) {
                    return one.getName().compareTo(two.getName());
                }
                if (one.getAverageScore() == null) {
                    return -1;
                }
                if (two.getAverageScore() == null) {
                    return 1;
                }
                int comp = one.getAverageScore().compareTo(two.getAverageScore());
                if (comp == 0) {
                    return one.getName().compareTo(two.getName());
                }
                return comp;
            }
        };
        weightComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Category one = (Category)o1;
                Category two = (Category)o2;
                if (one.getWeight() == null && two.getWeight() == null) {
                    return one.getName().compareTo(two.getName());
                }
                if (one.getWeight() == null) {
                    return -1;
                }
                if (two.getWeight() == null) {
                    return 1;
                }
                int comp = one.getWeight().compareTo(two.getWeight());
                if (comp == 0) {
                    return one.getName().compareTo(two.getName());
                }
                return comp;
            }
        };
    }
}

