/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.tool.gradebook.AbstractGradeRecord;
import org.sakaiproject.tool.gradebook.CourseGrade;
import org.sakaiproject.tool.gradebook.GradeMapping;

public class CourseGradeRecord
extends AbstractGradeRecord {
    private static final long serialVersionUID = 1L;
    private String enteredGrade;
    private Double enteredPoints;
    private Double autoCalculatedGrade;
    private Double calculatedPointsEarned;
    private Double totalPointsPossible;
    public static Comparator<CourseGradeRecord> calcComparator = new Comparator<CourseGradeRecord>(){

        @Override
        public int compare(CourseGradeRecord cgr1, CourseGradeRecord cgr2) {
            if (cgr1 == null || cgr2 == null || cgr1.getGradeAsPercentage() == null && cgr2.getGradeAsPercentage() == null) {
                return 0;
            }
            if (cgr1.getGradeAsPercentage() == null) {
                return -1;
            }
            if (cgr2.getGradeAsPercentage() == null) {
                return 1;
            }
            return cgr1.getGradeAsPercentage().compareTo(cgr2.getGradeAsPercentage());
        }
    };

    public static Comparator<CourseGradeRecord> getOverrideComparator(final GradeMapping mapping) {
        return new Comparator<CourseGradeRecord>(){

            @Override
            public int compare(CourseGradeRecord cgr1, CourseGradeRecord cgr2) {
                if (cgr1 == null && cgr2 == null) {
                    return 0;
                }
                if (cgr1 == null) {
                    return -1;
                }
                if (cgr2 == null) {
                    return 1;
                }
                String enteredGrade1 = StringUtils.trimToEmpty((String)cgr1.getEnteredGrade());
                String enteredGrade2 = StringUtils.trimToEmpty((String)cgr2.getEnteredGrade());
                List<String> grades = mapping.getGradingScale().getGrades();
                int gradePos1 = -1;
                int gradePos2 = -1;
                for (int i = 0; i < grades.size() && (gradePos1 == -1 || gradePos2 == -1); ++i) {
                    String grade = grades.get(i);
                    if (grade.equals(enteredGrade1)) {
                        gradePos1 = i;
                    }
                    if (!grade.equals(enteredGrade2)) continue;
                    gradePos2 = i;
                }
                return gradePos2 - gradePos1;
            }
        };
    }

    public CourseGradeRecord(CourseGrade courseGrade, String studentId) {
        this.gradableObject = courseGrade;
        this.studentId = studentId;
    }

    public CourseGradeRecord() {
    }

    @Override
    public Double getGradeAsPercentage() {
        if (this.enteredGrade == null) {
            return this.autoCalculatedGrade;
        }
        return this.getCourseGrade().getGradebook().getSelectedGradeMapping().getValue(this.enteredGrade);
    }

    public CourseGrade getCourseGrade() {
        return (CourseGrade)super.getGradableObject();
    }

    public String getEnteredGrade() {
        return this.enteredGrade;
    }

    public void setEnteredGrade(String enteredGrade) {
        this.enteredGrade = enteredGrade;
    }

    public Double getEnteredPoints() {
        return this.enteredPoints;
    }

    public void setEnteredPoints(Double enteredPoints) {
        this.enteredPoints = enteredPoints;
    }

    public Double getAutoCalculatedGrade() {
        return this.autoCalculatedGrade;
    }

    @Override
    public Double getPointsEarned() {
        return this.calculatedPointsEarned;
    }

    public String getDisplayGrade() {
        if (this.enteredGrade != null) {
            return this.enteredGrade;
        }
        return this.getCourseGrade().getGradebook().getSelectedGradeMapping().getMappedGrade(this.autoCalculatedGrade);
    }

    @Override
    public boolean isCourseGradeRecord() {
        return true;
    }

    public Double getNonNullAutoCalculatedGrade() {
        Double percent = this.getAutoCalculatedGrade();
        if (percent == null) {
            percent = 0.0;
        }
        return percent;
    }

    public void initNonpersistentFields(double totalPointsPossible, double totalPointsEarned) {
        this.totalPointsPossible = totalPointsPossible;
        this.calculatedPointsEarned = totalPointsEarned;
        BigDecimal bdTotalPointsPossible = BigDecimal.valueOf(totalPointsPossible);
        BigDecimal bdTotalPointsEarned = BigDecimal.valueOf(totalPointsEarned);
        if (totalPointsPossible == 0.0) {
            this.autoCalculatedGrade = null;
        } else {
            BigDecimal percentageEarned = bdTotalPointsEarned.divide(bdTotalPointsPossible, GradebookService.MATH_CONTEXT).multiply(new BigDecimal("100"));
            this.autoCalculatedGrade = percentageEarned.doubleValue();
        }
    }

    public void setCalculatedPointsEarned(double literalTotalPointsEarned) {
        this.calculatedPointsEarned = literalTotalPointsEarned;
    }

    public void initNonpersistentFields(double totalPointsPossible, double totalPointsEarned, double literalTotalPointsEarned) {
        this.initNonpersistentFields(totalPointsPossible, totalPointsEarned, literalTotalPointsEarned, 0.0);
    }

    public void initNonpersistentFields(double totalPointsPossible, double totalPointsEarned, double literalTotalPointsEarned, double totalPointsExtra) {
        this.calculatedPointsEarned = literalTotalPointsEarned;
        this.totalPointsPossible = totalPointsPossible;
        BigDecimal bdTotalPointsPossible = BigDecimal.valueOf(totalPointsPossible);
        BigDecimal bdTotalPointsEarned = BigDecimal.valueOf(totalPointsEarned);
        if (totalPointsPossible <= 0.0) {
            this.autoCalculatedGrade = null;
        } else {
            BigDecimal percentageEarned = bdTotalPointsEarned.divide(bdTotalPointsPossible, GradebookService.MATH_CONTEXT).multiply(new BigDecimal("100"));
            BigDecimal percentageExtraEarned = BigDecimal.valueOf(totalPointsExtra).multiply(new BigDecimal("100"), GradebookService.MATH_CONTEXT);
            percentageEarned = percentageEarned.add(percentageExtraEarned, GradebookService.MATH_CONTEXT);
            this.autoCalculatedGrade = percentageEarned.doubleValue();
        }
    }

    public Double getCalculatedPointsEarned() {
        return this.calculatedPointsEarned;
    }

    public void setAutoCalculatedGrade(Double autoCalculatedGrade) {
        this.autoCalculatedGrade = autoCalculatedGrade;
    }

    public Double getTotalPointsPossible() {
        return this.totalPointsPossible;
    }

    public void setTotalPointsPossible(Double totalPointsPossible) {
        this.totalPointsPossible = totalPointsPossible;
    }
}

