/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.sakaiproject.service.gradebook.shared.GradingEventStatus;
import org.sakaiproject.tool.gradebook.GradableObject;

public class GradingEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String graderId;
    private String studentId;
    private GradableObject gradableObject;
    private String grade;
    private Date dateGraded = new Date();
    private GradingEventStatus status;
    public static final Comparator<GradingEvent> compareByDateGraded = Comparator.comparing(GradingEvent::getDateGraded);

    public GradingEvent(GradableObject gradableObject, String graderId, String studentId, Object grade) {
        this.gradableObject = gradableObject;
        this.graderId = graderId;
        this.studentId = studentId;
        if (grade != null) {
            this.grade = grade.toString();
        }
        this.status = GradingEventStatus.GRADE_NONE;
    }

    public Long getId() {
        return this.id;
    }

    public String getGraderId() {
        return this.graderId;
    }

    public String getStudentId() {
        return this.studentId;
    }

    public GradableObject getGradableObject() {
        return this.gradableObject;
    }

    public String getGrade() {
        return this.grade;
    }

    public Date getDateGraded() {
        return this.dateGraded;
    }

    public GradingEventStatus getStatus() {
        return this.status;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGraderId(String graderId) {
        this.graderId = graderId;
    }

    public void setStudentId(String studentId) {
        this.studentId = studentId;
    }

    public void setGradableObject(GradableObject gradableObject) {
        this.gradableObject = gradableObject;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public void setDateGraded(Date dateGraded) {
        this.dateGraded = dateGraded;
    }

    public void setStatus(GradingEventStatus status) {
        this.status = status;
    }

    public String toString() {
        return "GradingEvent(id=" + this.getId() + ", graderId=" + this.getGraderId() + ", studentId=" + this.getStudentId() + ", gradableObject=" + this.getGradableObject() + ", grade=" + this.getGrade() + ", dateGraded=" + this.getDateGraded() + ", status=" + this.getStatus() + ")";
    }

    public GradingEvent() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradingEvent)) {
            return false;
        }
        GradingEvent other = (GradingEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$graderId = this.getGraderId();
        String other$graderId = other.getGraderId();
        if (this$graderId == null ? other$graderId != null : !this$graderId.equals(other$graderId)) {
            return false;
        }
        String this$studentId = this.getStudentId();
        String other$studentId = other.getStudentId();
        if (this$studentId == null ? other$studentId != null : !this$studentId.equals(other$studentId)) {
            return false;
        }
        Date this$dateGraded = this.getDateGraded();
        Date other$dateGraded = other.getDateGraded();
        return !(this$dateGraded == null ? other$dateGraded != null : !((Object)this$dateGraded).equals(other$dateGraded));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GradingEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $graderId = this.getGraderId();
        result = result * 59 + ($graderId == null ? 43 : $graderId.hashCode());
        String $studentId = this.getStudentId();
        result = result * 59 + ($studentId == null ? 43 : $studentId.hashCode());
        Date $dateGraded = this.getDateGraded();
        result = result * 59 + ($dateGraded == null ? 43 : ((Object)$dateGraded).hashCode());
        return result;
    }
}

