/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook.facades.sakai2impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sakaiproject.conditions.api.ConditionProvider;
import org.sakaiproject.conditions.api.ConditionService;
import org.sakaiproject.service.gradebook.shared.Assignment;
import org.sakaiproject.service.gradebook.shared.GradebookService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradebookConditionsProvider
implements ConditionProvider {
    private Map<String, String> eventLookup = new HashMap<String, String>();
    private ConditionService conditionService;
    private GradebookService gbs;

    public void setConditionService(ConditionService conditionService) {
        this.conditionService = conditionService;
    }

    public void setGradebookService(GradebookService gradebookService) {
        this.gbs = gradebookService;
    }

    public void init() {
        this.eventLookup.put("gradebook.updateItemScore", "org.sakaiproject.conditions.impl.AssignmentGrading");
        this.eventLookup.put("gradebook.updateAssignment", "org.sakaiproject.conditions.impl.AssignmentUpdate");
        this.conditionService.registerConditionProvider((ConditionProvider)this);
    }

    public Map<String, String> getEntitiesForContext(String gradebookUid) {
        HashMap<String, String> rv = new HashMap<String, String>();
        if (!this.gbs.isGradebookDefined(gradebookUid)) {
            return rv;
        }
        List assignments = this.gbs.getAssignments(gradebookUid);
        for (Assignment asn : assignments) {
            String assignmentName = asn.getName();
            String assignmentPoints = asn.getPoints().toString();
            boolean isReleasedToStudents = asn.isReleased();
            boolean isUsedInGradeCalculation = asn.isCounted();
            Date dueDate = asn.getDueDate();
            long dueDateMillis = 0L;
            if (dueDate != null) {
                dueDateMillis = dueDate.getTime();
            }
            rv.put("/gradebook/" + gradebookUid + "/" + assignmentName + "/" + assignmentPoints + "/" + dueDateMillis + "/" + isReleasedToStudents + "/" + isUsedInGradeCalculation, assignmentName + " (" + assignmentPoints + " points)");
        }
        return rv;
    }

    public String getId() {
        return "gradebook";
    }

    public Map<String, String> getEventToDomainClassMapping() {
        return this.eventLookup;
    }

    public Map<String, String> getData(String type, String context) {
        HashMap<String, String> rv = new HashMap<String, String>();
        if ("grades".equals(type)) {
            String[] contextParts = context.split("\\|");
            String gradebookId = contextParts[0];
            String assignmentName = contextParts[1];
            String studentId = contextParts[2];
            Long assignmentId = null;
            for (Object assignment : this.gbs.getAssignments(gradebookId)) {
                if (!((Assignment)assignment).getName().equals(assignmentName)) continue;
                assignmentId = ((Assignment)assignment).getId();
                break;
            }
            if (assignmentId != null) {
                String score = this.gbs.getAssignmentScoreString(gradebookId, assignmentId, studentId);
                if (score == null) {
                    score = "";
                }
                rv.put("score", score);
            }
        }
        return rv;
    }
}

