/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.gradebook;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.sakaiproject.component.gradebook.BaseHibernateManager;
import org.sakaiproject.component.gradebook.GradebookDefinition;
import org.sakaiproject.component.gradebook.VersionedExternalizable;
import org.sakaiproject.section.api.coursemanagement.CourseSection;
import org.sakaiproject.section.api.coursemanagement.EnrollmentRecord;
import org.sakaiproject.service.gradebook.shared.AssessmentNotFoundException;
import org.sakaiproject.service.gradebook.shared.Assignment;
import org.sakaiproject.service.gradebook.shared.AssignmentHasIllegalPointsException;
import org.sakaiproject.service.gradebook.shared.CategoryDefinition;
import org.sakaiproject.service.gradebook.shared.CommentDefinition;
import org.sakaiproject.service.gradebook.shared.ConflictingAssignmentNameException;
import org.sakaiproject.service.gradebook.shared.ConflictingExternalIdException;
import org.sakaiproject.service.gradebook.shared.GradeDefinition;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.service.gradebook.shared.GradebookFrameworkService;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.GradebookPermissionService;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.service.gradebook.shared.InvalidGradeException;
import org.sakaiproject.service.gradebook.shared.StaleObjectModificationException;
import org.sakaiproject.tool.gradebook.AssignmentGradeRecord;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.Comment;
import org.sakaiproject.tool.gradebook.CourseGrade;
import org.sakaiproject.tool.gradebook.CourseGradeRecord;
import org.sakaiproject.tool.gradebook.GradableObject;
import org.sakaiproject.tool.gradebook.GradeMapping;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradingEvent;
import org.sakaiproject.tool.gradebook.LetterGradePercentMapping;
import org.sakaiproject.tool.gradebook.facades.Authz;
import org.sakaiproject.util.ResourceLoader;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;

public class GradebookServiceHibernateImpl
extends BaseHibernateManager
implements GradebookService {
    private static final Log log = LogFactory.getLog(GradebookServiceHibernateImpl.class);
    private GradebookFrameworkService frameworkService;
    private GradebookExternalAssessmentService externalAssessmentService;
    private Authz authz;
    private GradebookPermissionService gradebookPermissionService;

    public boolean isAssignmentDefined(final String gradebookUid, final String assignmentName) throws GradebookNotFoundException {
        if (!this.isUserAbleToViewAssignments(gradebookUid)) {
            log.warn((Object)("AUTHORIZATION FAILURE: User " + this.getUserUid() + " in gradebook " + gradebookUid + " attempted to check for assignment " + assignmentName));
            throw new SecurityException("You do not have permission to perform this operation");
        }
        org.sakaiproject.tool.gradebook.Assignment assignment = (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName, session);
            }
        });
        return assignment != null;
    }

    private boolean isUserAbleToViewAssignments(String gradebookUid) {
        Authz authz = this.getAuthz();
        return authz.isUserAbleToEditAssessments(gradebookUid) || authz.isUserAbleToGrade(gradebookUid);
    }

    public boolean isUserAbleToGradeItemForStudent(String gradebookUid, Long itemId, String studentUid) {
        return this.getAuthz().isUserAbleToGradeItemForStudent(gradebookUid, itemId, studentUid);
    }

    public boolean isUserAbleToGradeItemForStudent(String gradebookUid, String itemName, String studentUid) {
        if (itemName == null || studentUid == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookServiceHibernateImpl.isUserAbleToGradeItemForStudent");
        }
        Assignment assignment = this.getAssignment(gradebookUid, itemName);
        if (assignment != null) {
            return this.isUserAbleToGradeItemForStudent(gradebookUid, assignment.getId(), studentUid);
        }
        return false;
    }

    public boolean isUserAbleToViewItemForStudent(String gradebookUid, Long itemId, String studentUid) {
        return this.getAuthz().isUserAbleToViewItemForStudent(gradebookUid, itemId, studentUid);
    }

    public boolean isUserAbleToViewItemForStudent(String gradebookUid, String itemName, String studentUid) {
        if (itemName == null || studentUid == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookServiceHibernateImpl.isUserAbleToGradeItemForStudent");
        }
        Assignment assignment = this.getAssignment(gradebookUid, itemName);
        if (assignment != null) {
            return this.isUserAbleToViewItemForStudent(gradebookUid, assignment.getId(), studentUid);
        }
        return false;
    }

    public String getGradeViewFunctionForUserForStudentForItem(String gradebookUid, Long itemId, String studentUid) {
        return this.getAuthz().getGradeViewFunctionForUserForStudentForItem(gradebookUid, itemId, studentUid);
    }

    public String getGradeViewFunctionForUserForStudentForItem(String gradebookUid, String itemName, String studentUid) {
        if (itemName == null || studentUid == null) {
            throw new IllegalArgumentException("Null parameter(s) in G.isUserAbleToGradeItemForStudent");
        }
        Assignment assignment = this.getAssignment(gradebookUid, itemName);
        if (assignment != null) {
            return this.getGradeViewFunctionForUserForStudentForItem(gradebookUid, assignment.getId(), studentUid);
        }
        return null;
    }

    public List<Assignment> getAssignments(String gradebookUid) throws GradebookNotFoundException {
        if (!this.isUserAbleToViewAssignments(gradebookUid)) {
            log.warn((Object)("AUTHORIZATION FAILURE: User " + this.getUserUid() + " in gradebook " + gradebookUid + " attempted to get assignments list"));
            throw new SecurityException("You do not have permission to perform this operation");
        }
        final Long gradebookId = this.getGradebook(gradebookUid).getId();
        List internalAssignments = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignments(gradebookId, session);
            }
        });
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        for (org.sakaiproject.tool.gradebook.Assignment assignment : internalAssignments) {
            assignments.add(this.getAssignmentDefinition(assignment));
        }
        return assignments;
    }

    public Assignment getAssignment(final String gradebookUid, final String assignmentName) throws GradebookNotFoundException {
        if (!this.isUserAbleToViewAssignments(gradebookUid)) {
            log.warn((Object)("AUTHORIZATION FAILURE: User " + this.getUserUid() + " in gradebook " + gradebookUid + " attempted to get assignment " + assignmentName));
            throw new SecurityException("You do not have permission to perform this operation");
        }
        org.sakaiproject.tool.gradebook.Assignment assignment = (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName, session);
            }
        });
        if (assignment != null) {
            return this.getAssignmentDefinition(assignment);
        }
        return null;
    }

    public Assignment getAssignment(final String gradebookUid, final Long gbItemId) throws AssessmentNotFoundException {
        if (gbItemId == null || gradebookUid == null) {
            throw new IllegalArgumentException("null gbItemId passed to getAssignment");
        }
        if (!this.isUserAbleToViewAssignments(gradebookUid) && !this.currentUserHasViewOwnGradesPerm(gradebookUid)) {
            log.warn((Object)("AUTHORIZATION FAILURE: User " + this.getUserUid() + " in gradebook " + gradebookUid + " attempted to get gb item with id " + gbItemId));
            throw new SecurityException("You do not have permission to perform this operation");
        }
        org.sakaiproject.tool.gradebook.Assignment assignment = (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, gbItemId, session);
            }
        });
        if (assignment == null) {
            throw new AssessmentNotFoundException("No gradebook item exists with gradable object id = " + gbItemId);
        }
        Assignment assnDef = assignment != null ? this.getAssignmentDefinition(assignment) : null;
        return assnDef;
    }

    private Assignment getAssignmentDefinition(org.sakaiproject.tool.gradebook.Assignment internalAssignment) {
        Assignment assignmentDefinition = new Assignment();
        assignmentDefinition.setName(internalAssignment.getName());
        assignmentDefinition.setPoints(internalAssignment.getPointsPossible());
        assignmentDefinition.setDueDate(internalAssignment.getDueDate());
        assignmentDefinition.setCounted(internalAssignment.isCounted());
        assignmentDefinition.setExternallyMaintained(internalAssignment.isExternallyMaintained());
        assignmentDefinition.setExternalAppName(internalAssignment.getExternalAppName());
        assignmentDefinition.setExternalId(internalAssignment.getExternalId());
        assignmentDefinition.setReleased(internalAssignment.isReleased());
        assignmentDefinition.setId(internalAssignment.getId());
        if (internalAssignment.getCategory() != null) {
            assignmentDefinition.setCategoryName(internalAssignment.getCategory().getName());
            assignmentDefinition.setWeight(internalAssignment.getCategory().getWeight());
        }
        assignmentDefinition.setUngraded(internalAssignment.getUngraded());
        return assignmentDefinition;
    }

    public Double getAssignmentScore(final String gradebookUid, final String assignmentName, final String studentUid) throws GradebookNotFoundException, AssessmentNotFoundException {
        final boolean studentRequestingOwnScore = this.authn.getUserUid().equals(studentUid);
        Double assignmentScore = (Double)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.sakaiproject.tool.gradebook.Assignment assignment = GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName, session);
                if (assignment == null) {
                    throw new AssessmentNotFoundException("There is no assignment named " + assignmentName + " in gradebook " + gradebookUid);
                }
                if (!studentRequestingOwnScore && !GradebookServiceHibernateImpl.this.isUserAbleToViewItemForStudent(gradebookUid, assignment.getId(), studentUid)) {
                    log.error((Object)("AUTHORIZATION FAILURE: User " + GradebookServiceHibernateImpl.this.getUserUid() + " in gradebook " + gradebookUid + " attempted to retrieve grade for student " + studentUid + " for assignment " + assignmentName));
                    throw new SecurityException("You do not have permission to perform this operation");
                }
                if (studentRequestingOwnScore && !assignment.isReleased()) {
                    log.error((Object)("AUTHORIZATION FAILURE: Student " + GradebookServiceHibernateImpl.this.getUserUid() + " in gradebook " + gradebookUid + " attempted to retrieve score for unreleased assignment " + assignment.getName()));
                    throw new SecurityException("You do not have permission to perform this operation");
                }
                AssignmentGradeRecord gradeRecord = GradebookServiceHibernateImpl.this.getAssignmentGradeRecord(assignment, studentUid, session);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("gradeRecord=" + gradeRecord));
                }
                if (gradeRecord == null) {
                    return null;
                }
                return gradeRecord.getPointsEarned();
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)("returning " + assignmentScore));
        }
        return assignmentScore;
    }

    public Double getAssignmentScore(final String gradebookUid, final Long gbItemId, String studentUid) {
        if (gradebookUid == null || gbItemId == null || studentUid == null) {
            throw new IllegalArgumentException("null parameter passed to getAssignmentScore");
        }
        org.sakaiproject.tool.gradebook.Assignment assignment = (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, gbItemId, session);
            }
        });
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assignment with the gbItemId " + gbItemId);
        }
        return this.getAssignmentScore(gradebookUid, assignment.getName(), studentUid);
    }

    public GradeDefinition getGradeDefinitionForStudentForItem(final String gradebookUid, final Long gbItemId, final String studentUid) {
        if (gradebookUid == null || gbItemId == null || studentUid == null) {
            throw new IllegalArgumentException("Null gradebookUid or gbItemId or studentUid passed to getGradeDefinitionForStudentForItem");
        }
        final boolean studentRequestingOwnScore = this.authn.getUserUid().equals(studentUid);
        GradeDefinition gradeDef = (GradeDefinition)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.sakaiproject.tool.gradebook.Assignment assignment = GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, gbItemId, session);
                if (assignment == null) {
                    throw new AssessmentNotFoundException("There is no assignment with the gbItemId " + gbItemId + " in gradebook " + gradebookUid);
                }
                if (!studentRequestingOwnScore && !GradebookServiceHibernateImpl.this.isUserAbleToViewItemForStudent(gradebookUid, assignment.getId(), studentUid)) {
                    log.error((Object)("AUTHORIZATION FAILURE: User " + GradebookServiceHibernateImpl.this.getUserUid() + " in gradebook " + gradebookUid + " attempted to retrieve grade for student " + studentUid + " for assignment " + gbItemId));
                    throw new SecurityException("You do not have permission to perform this operation");
                }
                Gradebook gradebook = assignment.getGradebook();
                GradeDefinition gradeDef = new GradeDefinition();
                gradeDef.setStudentUid(studentUid);
                gradeDef.setGradeEntryType(gradebook.getGrade_type());
                gradeDef.setGradeReleased(assignment.isReleased());
                if (studentRequestingOwnScore && !assignment.isReleased()) {
                    gradeDef.setDateRecorded(null);
                    gradeDef.setGrade(null);
                    gradeDef.setGraderUid(null);
                    gradeDef.setGradeComment(null);
                    log.debug((Object)("Student " + GradebookServiceHibernateImpl.this.getUserUid() + " in gradebook " + gradebookUid + " retrieving score for unreleased assignment " + assignment.getName()));
                } else {
                    String commentText;
                    AssignmentGradeRecord gradeRecord = GradebookServiceHibernateImpl.this.getAssignmentGradeRecord(assignment, studentUid, session);
                    CommentDefinition gradeComment = GradebookServiceHibernateImpl.this.getAssignmentScoreComment(gradebookUid, gbItemId, studentUid);
                    String string = commentText = gradeComment != null ? gradeComment.getCommentText() : null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("gradeRecord=" + gradeRecord));
                    }
                    if (gradeRecord == null) {
                        gradeDef.setDateRecorded(null);
                        gradeDef.setGrade(null);
                        gradeDef.setGraderUid(null);
                        gradeDef.setGradeComment(commentText);
                    } else {
                        gradeDef.setDateRecorded(gradeRecord.getDateRecorded());
                        gradeDef.setGraderUid(gradeRecord.getGraderId());
                        gradeDef.setGradeComment(commentText);
                        if (gradebook.getGrade_type() == 3) {
                            ArrayList<AssignmentGradeRecord> gradeList = new ArrayList<AssignmentGradeRecord>();
                            gradeList.add(gradeRecord);
                            GradebookServiceHibernateImpl.this.convertPointsToLetterGrade(gradebook, gradeList);
                            AssignmentGradeRecord gradeRec = (AssignmentGradeRecord)gradeList.get(0);
                            if (gradeRec != null) {
                                gradeDef.setGrade(gradeRec.getLetterEarned());
                            }
                        } else if (gradebook.getGrade_type() == 2) {
                            Double percent = GradebookServiceHibernateImpl.this.calculateEquivalentPercent(assignment.getPointsPossible(), gradeRecord.getPointsEarned());
                            if (percent != null) {
                                gradeDef.setGrade(percent.toString());
                            }
                        } else if (gradeRecord.getPointsEarned() != null) {
                            gradeDef.setGrade(gradeRecord.getPointsEarned().toString());
                        }
                    }
                }
                return gradeDef;
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)("returning grade def for " + studentUid));
        }
        return gradeDef;
    }

    public void setAssignmentScore(final String gradebookUid, final String assignmentName, final String studentUid, final Double score, final String clientServiceDescription) throws GradebookNotFoundException, AssessmentNotFoundException {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.sakaiproject.tool.gradebook.Assignment assignment = GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName, session);
                if (assignment == null) {
                    throw new AssessmentNotFoundException("There is no assignment named " + assignmentName + " in gradebook " + gradebookUid);
                }
                if (assignment.isExternallyMaintained()) {
                    log.error((Object)("AUTHORIZATION FAILURE: User " + GradebookServiceHibernateImpl.this.getUserUid() + " in gradebook " + gradebookUid + " attempted to grade externally maintained assignment " + assignmentName + " from " + clientServiceDescription));
                    throw new SecurityException("You do not have permission to perform this operation");
                }
                if (!GradebookServiceHibernateImpl.this.isUserAbleToGradeItemForStudent(gradebookUid, assignment.getId(), studentUid)) {
                    log.error((Object)("AUTHORIZATION FAILURE: User " + GradebookServiceHibernateImpl.this.getUserUid() + " in gradebook " + gradebookUid + " attempted to grade student " + studentUid + " from " + clientServiceDescription + " for item " + assignmentName));
                    throw new SecurityException("You do not have permission to perform this operation");
                }
                Date now = new Date();
                String graderId = GradebookServiceHibernateImpl.this.getAuthn().getUserUid();
                AssignmentGradeRecord gradeRecord = GradebookServiceHibernateImpl.this.getAssignmentGradeRecord(assignment, studentUid, session);
                if (gradeRecord == null) {
                    gradeRecord = new AssignmentGradeRecord(assignment, studentUid, score);
                } else {
                    gradeRecord.setPointsEarned(score);
                }
                gradeRecord.setGraderId(graderId);
                gradeRecord.setDateRecorded(now);
                session.saveOrUpdate((Object)gradeRecord);
                session.save((Object)new GradingEvent((GradableObject)assignment, graderId, studentUid, (Object)score));
                session.flush();
                session.clear();
                return null;
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)("Score updated in gradebookUid=" + gradebookUid + ", assignmentName=" + assignmentName + " by userUid=" + this.getUserUid() + " from client=" + clientServiceDescription + ", new score=" + score));
        }
    }

    private Comment getInternalComment(String gradebookUid, String assignmentName, String studentUid, Session session) {
        Query q = session.createQuery("from Comment as c where c.studentId=:studentId and c.gradableObject.gradebook.uid=:gradebookUid and c.gradableObject.name=:assignmentName and gradableObject.removed=false");
        q.setParameter("studentId", (Object)studentUid);
        q.setParameter("gradebookUid", (Object)gradebookUid);
        q.setParameter("assignmentName", (Object)assignmentName);
        return (Comment)q.uniqueResult();
    }

    public CommentDefinition getAssignmentScoreComment(final String gradebookUid, final String assignmentName, final String studentUid) throws GradebookNotFoundException, AssessmentNotFoundException {
        CommentDefinition commentDefinition = null;
        Comment comment = (Comment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getInternalComment(gradebookUid, assignmentName, studentUid, session);
            }
        });
        if (comment != null) {
            commentDefinition = new CommentDefinition();
            commentDefinition.setAssignmentName(assignmentName);
            commentDefinition.setCommentText(comment.getCommentText());
            commentDefinition.setDateRecorded(comment.getDateRecorded());
            commentDefinition.setGraderUid(comment.getGraderId());
            commentDefinition.setStudentUid(comment.getStudentId());
        }
        return commentDefinition;
    }

    public CommentDefinition getAssignmentScoreComment(final String gradebookUid, final Long gbItemId, String studentUid) throws GradebookNotFoundException, AssessmentNotFoundException {
        if (gradebookUid == null || gbItemId == null || studentUid == null) {
            throw new IllegalArgumentException("null parameter passed to getAssignmentScoreComment");
        }
        org.sakaiproject.tool.gradebook.Assignment assignment = (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, gbItemId, session);
            }
        });
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assignment with the gbItemId " + gbItemId);
        }
        return this.getAssignmentScoreComment(gradebookUid, assignment.getName(), studentUid);
    }

    public void setAssignmentScoreComment(final String gradebookUid, final String assignmentName, final String studentUid, final String commentText) throws GradebookNotFoundException, AssessmentNotFoundException {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Comment comment = GradebookServiceHibernateImpl.this.getInternalComment(gradebookUid, assignmentName, studentUid, session);
                if (comment == null) {
                    comment = new Comment(studentUid, commentText, (GradableObject)GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName, session));
                } else {
                    comment.setCommentText(commentText);
                }
                comment.setGraderId(GradebookServiceHibernateImpl.this.authn.getUserUid());
                comment.setDateRecorded(new Date());
                session.saveOrUpdate((Object)comment);
                return null;
            }
        });
    }

    public String getGradebookDefinitionXml(String gradebookUid) {
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        Gradebook gradebook = this.getGradebook(gradebookUid);
        GradebookDefinition gradebookDefinition = new GradebookDefinition();
        GradeMapping selectedGradeMapping = gradebook.getSelectedGradeMapping();
        gradebookDefinition.setSelectedGradingScaleUid(selectedGradeMapping.getGradingScale().getUid());
        gradebookDefinition.setSelectedGradingScaleBottomPercents(new HashMap<String, Double>(selectedGradeMapping.getGradeMap()));
        gradebookDefinition.setAssignments(this.getAssignments(gradebookUid));
        gradebookDefinition.setGradeType(gradebook.getGrade_type());
        gradebookDefinition.setCategoryType(gradebook.getCategory_type());
        gradebookDefinition.setCategory(this.getCategories(gradebookId));
        return VersionedExternalizable.toXml(gradebookDefinition);
    }

    public void transferGradebookDefinitionXml(String fromGradebookUid, String toGradebookUid, String fromGradebookXml) {
        block20: {
            String fromGradingScaleUid;
            Gradebook gradebook = this.getGradebook(toGradebookUid);
            Gradebook fromGradebook = this.getGradebook(fromGradebookUid);
            GradebookDefinition gradebookDefinition = (GradebookDefinition)VersionedExternalizable.fromXml(fromGradebookXml);
            gradebook.setCategory_type(gradebookDefinition.getCategoryType());
            gradebook.setGrade_type(gradebookDefinition.getGradeType());
            this.updateGradebook(gradebook);
            List category = this.getCategories(fromGradebook.getId());
            int assignmentsAddedCount = 0;
            Long catId = null;
            int undefined_nb = 0;
            List catList = gradebookDefinition.getCategory();
            ArrayList<Category> catList_tempt = new ArrayList<Category>();
            if (category.size() != 0) {
                Iterator iter = category.iterator();
                while (iter.hasNext()) {
                    int categoryCount = 0;
                    String catName = ((Category)iter.next()).getName();
                    Iterator<Assignment> i$ = gradebookDefinition.getAssignments().iterator();
                    while (i$.hasNext()) {
                        Assignment obj;
                        Assignment assignmentDef = obj = i$.next();
                        boolean newCategory = false;
                        if (assignmentDef.isExternallyMaintained()) continue;
                        if (catName.equals(assignmentDef.getCategoryName())) {
                            newCategory = true;
                            ++categoryCount;
                        }
                        if (assignmentDef.getCategoryName() != null) {
                            if (!newCategory) continue;
                            if (newCategory && categoryCount == 1) {
                                catId = this.createCategory(gradebook.getId(), assignmentDef.getCategoryName(), assignmentDef.getWeight(), 0, 0, 0, null);
                                Category catTempt = this.getCategory(catId);
                                catList_tempt.add(catTempt);
                                this.createAssignmentForCategory(gradebook.getId(), catId, assignmentDef.getName(), assignmentDef.getPoints(), assignmentDef.getDueDate(), true, false);
                                ++assignmentsAddedCount;
                                continue;
                            }
                            this.createAssignmentForCategory(gradebook.getId(), catId, assignmentDef.getName(), assignmentDef.getPoints(), assignmentDef.getDueDate(), true, false);
                            ++assignmentsAddedCount;
                            continue;
                        }
                        if (undefined_nb != 0) continue;
                        this.createAssignment(gradebook.getId(), assignmentDef.getName(), assignmentDef.getPoints(), assignmentDef.getDueDate(), true, false);
                        ++assignmentsAddedCount;
                    }
                    ++undefined_nb;
                }
                Iterator it_tempt = catList_tempt.iterator();
                Iterator it = catList.iterator();
                while (it_tempt.hasNext()) {
                    Category cat_tempt = (Category)it_tempt.next();
                    while (it.hasNext()) {
                        Category cat_cat = (Category)it.next();
                        if (!cat_tempt.getName().equals(cat_cat.getName())) continue;
                        it.remove();
                        it = catList.iterator();
                    }
                    it = catList.iterator();
                }
                for (Category catObj : catList) {
                    this.createCategory(gradebook.getId(), catObj.getName(), catObj.getWeight(), catObj.getDrop_lowest(), catObj.getDropHighest(), catObj.getKeepHighest(), catObj.isExtraCredit());
                }
            } else {
                for (Assignment obj : gradebookDefinition.getAssignments()) {
                    Assignment assignmentDef = obj;
                    if (assignmentDef.isExternallyMaintained()) continue;
                    this.createAssignment(gradebook.getId(), assignmentDef.getName(), assignmentDef.getPoints(), assignmentDef.getDueDate(), true, false);
                    ++assignmentsAddedCount;
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Merge to gradebook " + toGradebookUid + " added " + assignmentsAddedCount + " assignments"));
            }
            if (!StringUtils.isEmpty((String)(fromGradingScaleUid = gradebookDefinition.getSelectedGradingScaleUid()))) {
                for (GradeMapping gradeMapping : gradebook.getGradeMappings()) {
                    if (!gradeMapping.getGradingScale().getUid().equals(fromGradingScaleUid)) continue;
                    Map<String, Double> inputGradePercents = gradebookDefinition.getSelectedGradingScaleBottomPercents();
                    Set<String> gradeCodes = inputGradePercents.keySet();
                    if (gradeCodes.containsAll(gradeMapping.getGradeMap().keySet())) {
                        for (String gradeCode : gradeCodes) {
                            gradeMapping.getGradeMap().put(gradeCode, inputGradePercents.get(gradeCode));
                        }
                        gradebook.setSelectedGradeMapping(gradeMapping);
                        this.updateGradebook(gradebook);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Merge to gradebook " + toGradebookUid + " updated grade mapping"));
                        }
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)("Merge to gradebook " + toGradebookUid + " skipped grade mapping change because the " + fromGradingScaleUid + " grade codes did not match"));
                    }
                    break block20;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Merge to gradebook " + toGradebookUid + " skipped grade mapping change because grading scale " + fromGradingScaleUid + " is not defined"));
                }
            }
        }
    }

    public void mergeGradebookDefinitionXml(String toGradebookUid, String fromGradebookXml) {
        block11: {
            String fromGradingScaleUid;
            final Gradebook gradebook = this.getGradebook(toGradebookUid);
            GradebookDefinition gradebookDefinition = (GradebookDefinition)VersionedExternalizable.fromXml(fromGradebookXml);
            List assignmentNames = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createQuery("select asn.name from Assignment as asn where asn.gradebook.id=? and asn.removed=false").setLong(0, gradebook.getId().longValue()).list();
                }
            });
            int assignmentsAddedCount = 0;
            for (Assignment obj : gradebookDefinition.getAssignments()) {
                Assignment assignmentDef = obj;
                if (assignmentDef.isExternallyMaintained()) continue;
                if (assignmentNames.contains(assignmentDef.getName())) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Merge to gradebook " + toGradebookUid + " skipped duplicate assignment named " + assignmentDef.getName()));
                    continue;
                }
                this.createAssignment(gradebook.getId(), assignmentDef.getName(), assignmentDef.getPoints(), assignmentDef.getDueDate(), true, false);
                ++assignmentsAddedCount;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Merge to gradebook " + toGradebookUid + " added " + assignmentsAddedCount + " assignments"));
            }
            if (!StringUtils.isEmpty((String)(fromGradingScaleUid = gradebookDefinition.getSelectedGradingScaleUid()))) {
                for (GradeMapping gradeMapping : gradebook.getGradeMappings()) {
                    if (!gradeMapping.getGradingScale().getUid().equals(fromGradingScaleUid)) continue;
                    Map<String, Double> inputGradePercents = gradebookDefinition.getSelectedGradingScaleBottomPercents();
                    Set<String> gradeCodes = inputGradePercents.keySet();
                    if (gradeCodes.containsAll(gradeMapping.getGradeMap().keySet())) {
                        for (String gradeCode : gradeCodes) {
                            gradeMapping.getGradeMap().put(gradeCode, inputGradePercents.get(gradeCode));
                        }
                        gradebook.setSelectedGradeMapping(gradeMapping);
                        this.updateGradebook(gradebook);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Merge to gradebook " + toGradebookUid + " updated grade mapping"));
                        }
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)("Merge to gradebook " + toGradebookUid + " skipped grade mapping change because the " + fromGradingScaleUid + " grade codes did not match"));
                    }
                    break block11;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Merge to gradebook " + toGradebookUid + " skipped grade mapping change because grading scale " + fromGradingScaleUid + " is not defined"));
                }
            }
        }
    }

    public void removeAssignment(final Long assignmentId) throws StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.sakaiproject.tool.gradebook.Assignment asn = (org.sakaiproject.tool.gradebook.Assignment)session.load(org.sakaiproject.tool.gradebook.Assignment.class, (Serializable)assignmentId);
                Gradebook gradebook = asn.getGradebook();
                asn.setRemoved(true);
                session.update((Object)asn);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Assignment " + asn.getName() + " has been removed from " + gradebook));
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
    }

    public void addAssignment(String gradebookUid, Assignment assignmentDefinition) {
        if (!this.getAuthz().isUserAbleToEditAssessments(gradebookUid)) {
            log.error((Object)("AUTHORIZATION FAILURE: User " + this.getUserUid() + " in gradebook " + gradebookUid + " attempted to add an assignment"));
            throw new SecurityException("You do not have permission to perform this operation");
        }
        Double points = assignmentDefinition.getPoints();
        if (points == null || points <= 0.0) {
            throw new AssignmentHasIllegalPointsException("Points must be > 0");
        }
        Gradebook gradebook = this.getGradebook(gradebookUid);
        this.createAssignment(gradebook.getId(), assignmentDefinition.getName(), points, assignmentDefinition.getDueDate(), !assignmentDefinition.isCounted(), assignmentDefinition.isReleased());
    }

    public void updateAssignment(final String gradebookUid, final String assignmentName, final Assignment assignmentDefinition) {
        if (!this.getAuthz().isUserAbleToEditAssessments(gradebookUid)) {
            log.error((Object)("AUTHORIZATION FAILURE: User " + this.getUserUid() + " in gradebook " + gradebookUid + " attempted to change the definition of assignment " + assignmentName));
            throw new SecurityException("You do not have permission to perform this operation");
        }
        if (assignmentDefinition.isExternallyMaintained()) {
            log.error((Object)("User " + this.getUserUid() + " in gradebook " + gradebookUid + " attempted to set assignment " + assignmentName + " to be externally maintained"));
            throw new SecurityException("You do not have permission to perform this operation");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.sakaiproject.tool.gradebook.Assignment assignment = GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName, session);
                if (assignment == null) {
                    throw new AssessmentNotFoundException("There is no assignment named " + assignmentName + " in gradebook " + gradebookUid);
                }
                if (assignment.isExternallyMaintained()) {
                    log.error((Object)("AUTHORIZATION FAILURE: User " + GradebookServiceHibernateImpl.this.getUserUid() + " in gradebook " + gradebookUid + " attempted to change the definition of externally maintained assignment " + assignmentName));
                    throw new SecurityException("You do not have permission to perform this operation");
                }
                assignment.setCounted(assignmentDefinition.isCounted());
                assignment.setDueDate(assignmentDefinition.getDueDate());
                assignment.setName(assignmentDefinition.getName().trim());
                assignment.setPointsPossible(assignmentDefinition.getPoints());
                assignment.setReleased(assignmentDefinition.isReleased());
                GradebookServiceHibernateImpl.this.updateAssignment(assignment, session);
                return null;
            }
        });
    }

    public Authz getAuthz() {
        return this.authz;
    }

    public void setAuthz(Authz authz) {
        this.authz = authz;
    }

    public GradebookPermissionService getGradebookPermissionService() {
        return this.gradebookPermissionService;
    }

    public void setGradebookPermissionService(GradebookPermissionService gradebookPermissionService) {
        this.gradebookPermissionService = gradebookPermissionService;
    }

    public void addGradebook(String uid, String name) {
        this.frameworkService.addGradebook(uid, name);
    }

    public void setAvailableGradingScales(Collection gradingScaleDefinitions) {
        this.frameworkService.setAvailableGradingScales(gradingScaleDefinitions);
    }

    public void setDefaultGradingScale(String uid) {
        this.frameworkService.setDefaultGradingScale(uid);
    }

    public void deleteGradebook(String uid) throws GradebookNotFoundException {
        this.frameworkService.deleteGradebook(uid);
    }

    @Override
    public boolean isGradebookDefined(String gradebookUid) {
        return this.frameworkService.isGradebookDefined(gradebookUid);
    }

    public GradebookFrameworkService getFrameworkService() {
        return this.frameworkService;
    }

    public void setFrameworkService(GradebookFrameworkService frameworkService) {
        this.frameworkService = frameworkService;
    }

    public void addExternalAssessment(String gradebookUid, String externalId, String externalUrl, String title, double points, Date dueDate, String externalServiceDescription) throws ConflictingAssignmentNameException, ConflictingExternalIdException, GradebookNotFoundException {
        this.externalAssessmentService.addExternalAssessment(gradebookUid, externalId, externalUrl, title, points, dueDate, externalServiceDescription);
    }

    public void addExternalAssessment(String gradebookUid, String externalId, String externalUrl, String title, Double points, Date dueDate, String externalServiceDescription, Boolean ungraded) throws ConflictingAssignmentNameException, ConflictingExternalIdException, GradebookNotFoundException {
        this.externalAssessmentService.addExternalAssessment(gradebookUid, externalId, externalUrl, title, points, dueDate, externalServiceDescription, ungraded);
    }

    public void updateExternalAssessment(String gradebookUid, String externalId, String externalUrl, String title, double points, Date dueDate) throws GradebookNotFoundException, AssessmentNotFoundException, AssignmentHasIllegalPointsException {
        this.externalAssessmentService.updateExternalAssessment(gradebookUid, externalId, externalUrl, title, Double.valueOf(points), dueDate, Boolean.valueOf(false));
    }

    public void updateExternalAssessment(String gradebookUid, String externalId, String externalUrl, String title, Double points, Date dueDate) throws GradebookNotFoundException, AssessmentNotFoundException, AssignmentHasIllegalPointsException {
        this.externalAssessmentService.updateExternalAssessment(gradebookUid, externalId, externalUrl, title, points, dueDate, Boolean.valueOf(false));
    }

    public void removeExternalAssessment(String gradebookUid, String externalId) throws GradebookNotFoundException, AssessmentNotFoundException {
        this.externalAssessmentService.removeExternalAssessment(gradebookUid, externalId);
    }

    public void updateExternalAssessmentScore(String gradebookUid, String externalId, String studentUid, Double points) throws GradebookNotFoundException, AssessmentNotFoundException {
        String strPoints = points == null ? null : points.toString();
        this.externalAssessmentService.updateExternalAssessmentScore(gradebookUid, externalId, studentUid, strPoints);
    }

    public void updateExternalAssessmentScores(String gradebookUid, String externalId, Map studentUidsToScores) throws GradebookNotFoundException, AssessmentNotFoundException {
        this.externalAssessmentService.updateExternalAssessmentScores(gradebookUid, externalId, studentUidsToScores);
    }

    public boolean isExternalAssignmentDefined(String gradebookUid, String externalId) throws GradebookNotFoundException {
        return this.externalAssessmentService.isExternalAssignmentDefined(gradebookUid, externalId);
    }

    public GradebookExternalAssessmentService getExternalAssessmentService() {
        return this.externalAssessmentService;
    }

    public void setExternalAssessmentService(GradebookExternalAssessmentService externalAssessmentService) {
        this.externalAssessmentService = externalAssessmentService;
    }

    public Map getImportCourseGrade(String gradebookUid) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            Gradebook thisGradebook = this.getGradebook(gradebookUid);
            List assignList = this.getAssignmentsCounted(thisGradebook.getId());
            boolean nonAssignment = false;
            if (assignList == null || assignList.size() < 1) {
                nonAssignment = true;
            }
            Long gradebookId = thisGradebook.getId();
            CourseGrade courseGrade = this.getCourseGrade(gradebookId);
            Map viewableEnrollmentsMap = this.authz.findMatchingEnrollmentsForViewableCourseGrade(gradebookUid, thisGradebook.getCategory_type(), null, null);
            HashMap<String, EnrollmentRecord> enrollmentMap = new HashMap<String, EnrollmentRecord>();
            HashMap<String, EnrollmentRecord> enrollmentMapUid = new HashMap<String, EnrollmentRecord>();
            for (EnrollmentRecord enr : viewableEnrollmentsMap.keySet()) {
                enrollmentMap.put(enr.getUser().getUserUid(), enr);
                enrollmentMapUid.put(enr.getUser().getUserUid(), enr);
            }
            List gradeRecords = this.getPointsEarnedCourseGradeRecords(courseGrade, enrollmentMap.keySet());
            for (CourseGradeRecord gradeRecord : gradeRecords) {
                GradeMapping gradeMap = thisGradebook.getSelectedGradeMapping();
                EnrollmentRecord enr = (EnrollmentRecord)enrollmentMapUid.get(gradeRecord.getStudentId());
                if (enr == null) continue;
                if (gradeRecord.getEnteredGrade() != null && !gradeRecord.getEnteredGrade().equalsIgnoreCase("")) {
                    returnMap.put(enr.getUser().getDisplayId(), gradeRecord.getEnteredGrade());
                    continue;
                }
                if (nonAssignment) continue;
                returnMap.put(enr.getUser().getDisplayId(), gradeMap.getGrade(gradeRecord.getNonNullAutoCalculatedGrade()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnMap;
    }

    @Override
    public CourseGrade getCourseGrade(Long gradebookId) {
        return (CourseGrade)this.getHibernateTemplate().find("from CourseGrade as cg where cg.gradebook.id=?", (Object)gradebookId).get(0);
    }

    public List getPointsEarnedCourseGradeRecords(final CourseGrade courseGrade, final Collection studentUids) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (studentUids == null || studentUids.size() == 0) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Returning no grade records for an empty collection of student UIDs");
                    }
                    return new ArrayList();
                }
                Query q = session.createQuery("from CourseGradeRecord as cgr where cgr.gradableObject.id=:gradableObjectId");
                q.setLong("gradableObjectId", courseGrade.getId().longValue());
                List records = GradebookServiceHibernateImpl.this.filterAndPopulateCourseGradeRecordsByStudents(courseGrade, q.list(), studentUids);
                Long gradebookId = courseGrade.getGradebook().getId();
                Gradebook gradebook = GradebookServiceHibernateImpl.this.getGradebook(gradebookId);
                List cates = GradebookServiceHibernateImpl.this.getCategories(gradebookId);
                Map<String, List<AssignmentGradeRecord>> gradeRecMap = GradebookServiceHibernateImpl.this.getGradeRecordMapForStudents(session, gradebookId, studentUids);
                List<org.sakaiproject.tool.gradebook.Assignment> countedAssigns = GradebookServiceHibernateImpl.this.getCountedAssignments(session, gradebookId);
                for (CourseGradeRecord cgr : records) {
                    List<AssignmentGradeRecord> studentGradeRecs = gradeRecMap.get(cgr.getStudentId());
                    GradebookServiceHibernateImpl.this.applyDropScores(studentGradeRecs);
                    List totalEarned = GradebookServiceHibernateImpl.this.getTotalPointsEarnedInternal(gradebookId, cgr.getStudentId(), session, gradebook, cates, studentGradeRecs);
                    double totalPointsEarned = (Double)totalEarned.get(0);
                    double literalTotalPointsEarned = (Double)totalEarned.get(1);
                    double totalPointsPossible = GradebookServiceHibernateImpl.this.getTotalPointsInternal(gradebookId, session, gradebook, cates, cgr.getStudentId(), studentGradeRecs, countedAssigns);
                    cgr.initNonpersistentFields(totalPointsPossible, totalPointsEarned, literalTotalPointsEarned);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Points earned = " + cgr.getPointsEarned()));
                }
                return records;
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    private List filterAndPopulateCourseGradeRecordsByStudents(CourseGrade courseGrade, Collection gradeRecords, Collection studentUids) {
        ArrayList<CourseGradeRecord> filteredRecords = new ArrayList<CourseGradeRecord>();
        HashSet missingStudents = new HashSet(studentUids);
        for (CourseGradeRecord cgr : gradeRecords) {
            if (!studentUids.contains(cgr.getStudentId())) continue;
            filteredRecords.add(cgr);
            missingStudents.remove(cgr.getStudentId());
        }
        for (String studentUid : missingStudents) {
            CourseGradeRecord cgr = new CourseGradeRecord(courseGrade, studentUid);
            filteredRecords.add(cgr);
        }
        return filteredRecords;
    }

    private double getTotalPointsInternal(Long gradebookId, Session session, Gradebook gradebook, List categories, String studentId, List<AssignmentGradeRecord> studentGradeRecs, List<org.sakaiproject.tool.gradebook.Assignment> countedAssigns) {
        double totalPointsPossible = 0.0;
        List assgnsList = session.createQuery("select asn from Assignment asn where asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false and asn.pointsPossible > 0").setParameter("gbid", (Object)gradebookId).list();
        Iterator scoresIter = session.createQuery("select agr.pointsEarned, asn from AssignmentGradeRecord agr, Assignment asn where agr.gradableObject=asn and agr.studentId=:student and asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false and asn.pointsPossible > 0").setParameter("student", (Object)studentId).setParameter("gbid", (Object)gradebookId).list().iterator();
        HashSet<Long> assignmentsTaken = new HashSet<Long>();
        HashSet<Long> categoryTaken = new HashSet<Long>();
        block0: while (scoresIter.hasNext()) {
            Category cate;
            Object[] returned = (Object[])scoresIter.next();
            Double pointsEarned = (Double)returned[0];
            org.sakaiproject.tool.gradebook.Assignment go = (org.sakaiproject.tool.gradebook.Assignment)returned[1];
            boolean extraCredit = false;
            if (go.isExtraCredit() != null) {
                extraCredit = go.isExtraCredit();
            }
            if (extraCredit || pointsEarned == null) continue;
            boolean skip = false;
            for (AssignmentGradeRecord gr : studentGradeRecs) {
                if (!gr.getAssignment().getId().equals(go.getId())) continue;
                if (!gr.getDroppedFromGrade().booleanValue()) break;
                skip = true;
                break;
            }
            if (skip) continue;
            if (gradebook.getCategory_type() == 1) {
                assignmentsTaken.add(go.getId());
                continue;
            }
            if (gradebook.getCategory_type() == 2 && go != null) {
                for (int i = 0; i < categories.size(); ++i) {
                    cate = (Category)categories.get(i);
                    if (cate == null || cate.isRemoved() || go.getCategory() == null || !cate.getId().equals(go.getCategory().getId()) || (cate.isExtraCredit() == null || cate.isExtraCredit().booleanValue()) && cate.isExtraCredit() != null) continue;
                    assignmentsTaken.add(go.getId());
                }
                continue;
            }
            if (gradebook.getCategory_type() != 3 || go == null || categories == null) continue;
            for (int i = 0; i < categories.size(); ++i) {
                cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || go.getCategory() == null || !cate.getId().equals(go.getCategory().getId()) || (cate.isExtraCredit() == null || cate.isExtraCredit().booleanValue()) && cate.isExtraCredit() != null) continue;
                assignmentsTaken.add(go.getId());
                categoryTaken.add(cate.getId());
                continue block0;
            }
        }
        if (!assignmentsTaken.isEmpty()) {
            if (gradebook.getCategory_type() == 3) {
                for (int i = 0; i < categories.size(); ++i) {
                    Category cate = (Category)categories.get(i);
                    if (cate == null || cate.isRemoved() || !categoryTaken.contains(cate.getId())) continue;
                    totalPointsPossible += cate.getWeight().doubleValue();
                }
                return totalPointsPossible;
            }
            for (org.sakaiproject.tool.gradebook.Assignment asn : assgnsList) {
                if (asn == null) continue;
                Double pointsPossible = asn.getPointsPossible();
                if (gradebook.getCategory_type() == 1 && assignmentsTaken.contains(asn.getId())) {
                    totalPointsPossible += pointsPossible.doubleValue();
                    continue;
                }
                if (gradebook.getCategory_type() != 2 || !assignmentsTaken.contains(asn.getId())) continue;
                totalPointsPossible += pointsPossible.doubleValue();
            }
        } else {
            totalPointsPossible = -1.0;
        }
        return totalPointsPossible;
    }

    private List getTotalPointsEarnedInternal(Long gradebookId, String studentId, Session session, Gradebook gradebook, List categories, List<AssignmentGradeRecord> studentGradeRecs) {
        double totalPointsEarned = 0.0;
        double literalTotalPointsEarned = 0.0;
        Iterator scoresIter = session.createQuery("select agr.pointsEarned, asn from AssignmentGradeRecord agr, Assignment asn where agr.gradableObject=asn and agr.studentId=:student and asn.gradebook.id=:gbid and asn.removed=false and asn.pointsPossible > 0").setParameter("student", (Object)studentId).setParameter("gbid", (Object)gradebookId).list().iterator();
        List assgnsList = session.createQuery("from Assignment as asn where asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false and asn.pointsPossible > 0").setParameter("gbid", (Object)gradebookId).list();
        HashMap<Long, Double> cateScoreMap = new HashMap<Long, Double>();
        HashMap<Long, Double> cateTotalScoreMap = new HashMap<Long, Double>();
        HashSet<Long> assignmentsTaken = new HashSet<Long>();
        block0: while (scoresIter.hasNext()) {
            Object[] returned = (Object[])scoresIter.next();
            Double pointsEarned = (Double)returned[0];
            org.sakaiproject.tool.gradebook.Assignment go = (org.sakaiproject.tool.gradebook.Assignment)returned[1];
            if (go == null || !go.isCounted() || pointsEarned == null) continue;
            boolean skip = false;
            for (AssignmentGradeRecord gr : studentGradeRecs) {
                if (!gr.getAssignment().getId().equals(go.getId())) continue;
                if (!gr.getDroppedFromGrade().booleanValue()) break;
                skip = true;
                break;
            }
            if (skip) continue;
            if (gradebook.getCategory_type() == 1) {
                totalPointsEarned += pointsEarned.doubleValue();
                literalTotalPointsEarned += pointsEarned.doubleValue();
                assignmentsTaken.add(go.getId());
                continue;
            }
            if (gradebook.getCategory_type() == 2 && go != null) {
                totalPointsEarned += pointsEarned.doubleValue();
                literalTotalPointsEarned += pointsEarned.doubleValue();
                assignmentsTaken.add(go.getId());
                continue;
            }
            if (gradebook.getCategory_type() != 3 || go == null || categories == null) continue;
            for (int i = 0; i < categories.size(); ++i) {
                Category cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || go.getCategory() == null || !cate.getId().equals(go.getCategory().getId())) continue;
                assignmentsTaken.add(go.getId());
                literalTotalPointsEarned += pointsEarned.doubleValue();
                if (cateScoreMap.get(cate.getId()) != null) {
                    cateScoreMap.put(cate.getId(), (Double)cateScoreMap.get(cate.getId()) + pointsEarned);
                    continue block0;
                }
                cateScoreMap.put(cate.getId(), pointsEarned);
                continue block0;
            }
        }
        if (gradebook.getCategory_type() == 3 && categories != null) {
            for (org.sakaiproject.tool.gradebook.Assignment asgn : assgnsList) {
                if (!assignmentsTaken.contains(asgn.getId())) continue;
                for (int i = 0; i < categories.size(); ++i) {
                    Category cate = (Category)categories.get(i);
                    if (cate == null || cate.isRemoved() || asgn.getCategory() == null || !cate.getId().equals(asgn.getCategory().getId())) continue;
                    if (cateTotalScoreMap.get(cate.getId()) == null) {
                        cateTotalScoreMap.put(cate.getId(), asgn.getPointsPossible());
                        continue;
                    }
                    cateTotalScoreMap.put(cate.getId(), (Double)cateTotalScoreMap.get(cate.getId()) + asgn.getPointsPossible());
                }
            }
        }
        if (assignmentsTaken.isEmpty()) {
            totalPointsEarned = -1.0;
        }
        if (gradebook.getCategory_type() == 3) {
            for (int i = 0; i < categories.size(); ++i) {
                Category cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || cateScoreMap.get(cate.getId()) == null || cateTotalScoreMap.get(cate.getId()) == null) continue;
                totalPointsEarned += (Double)cateScoreMap.get(cate.getId()) * cate.getWeight() / (Double)cateTotalScoreMap.get(cate.getId());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTotalPointsEarnedInternal for studentId=" + studentId + " returning " + totalPointsEarned));
        }
        ArrayList<Double> returnList = new ArrayList<Double>();
        returnList.add(totalPointsEarned);
        returnList.add(literalTotalPointsEarned);
        return returnList;
    }

    public Gradebook getGradebook(Long id) {
        return (Gradebook)this.getHibernateTemplate().load(Gradebook.class, (Serializable)id);
    }

    protected List getAssignmentsCounted(final Long gradebookId) throws HibernateException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List assignments = session.createQuery("from Assignment as asn where asn.gradebook.id=? and asn.removed=false and asn.notCounted=false").setLong(0, gradebookId.longValue()).list();
                return assignments;
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public boolean checkStudentsNotSubmitted(String gradebookUid) {
        Gradebook gradebook = this.getGradebook(gradebookUid);
        Set studentUids = this.getAllStudentUids(this.getGradebookUid(gradebook.getId()));
        if (gradebook.getCategory_type() == 1 || gradebook.getCategory_type() == 2) {
            List records = this.getAllAssignmentGradeRecords(gradebook.getId(), studentUids);
            List assigns = this.getAssignments(gradebook.getId(), org.sakaiproject.tool.gradebook.Assignment.DEFAULT_SORT, true);
            ArrayList<org.sakaiproject.tool.gradebook.Assignment> filteredAssigns = new ArrayList<org.sakaiproject.tool.gradebook.Assignment>();
            for (org.sakaiproject.tool.gradebook.Assignment assignment : assigns) {
                if (!assignment.isCounted() || assignment.getUngraded()) continue;
                filteredAssigns.add(assignment);
            }
            ArrayList<AssignmentGradeRecord> filteredRecords = new ArrayList<AssignmentGradeRecord>();
            for (AssignmentGradeRecord agr : records) {
                if (agr.isCourseGradeRecord() || !agr.getAssignment().isCounted() || agr.getAssignment().getUngraded()) continue;
                if (agr.getPointsEarned() == null) {
                    return true;
                }
                filteredRecords.add(agr);
            }
            return filteredRecords.size() < filteredAssigns.size() * studentUids.size();
        }
        List assigns = this.getAssignments(gradebook.getId(), org.sakaiproject.tool.gradebook.Assignment.DEFAULT_SORT, true);
        List records = this.getAllAssignmentGradeRecords(gradebook.getId(), studentUids);
        HashSet<Long> filteredAssigns = new HashSet<Long>();
        for (org.sakaiproject.tool.gradebook.Assignment assign : assigns) {
            if (assign == null || !assign.isCounted() || assign.getUngraded() || assign.getCategory() == null || assign.getCategory().isRemoved()) continue;
            filteredAssigns.add(assign.getId());
        }
        ArrayList<AssignmentGradeRecord> filteredRecords = new ArrayList<AssignmentGradeRecord>();
        for (AssignmentGradeRecord agr : records) {
            if (!filteredAssigns.contains(agr.getAssignment().getId()) || agr.isCourseGradeRecord()) continue;
            if (agr.getPointsEarned() == null) {
                return true;
            }
            filteredRecords.add(agr);
        }
        return filteredRecords.size() < filteredAssigns.size() * studentUids.size();
    }

    public List getAllAssignmentGradeRecords(final Long gradebookId, final Collection studentUids) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (studentUids.size() == 0) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"No enrollments were specified.  Returning an empty List of grade records");
                    }
                    return new ArrayList();
                }
                Query q = session.createQuery("from AssignmentGradeRecord as agr where agr.gradableObject.removed=false and agr.gradableObject.gradebook.id=:gradebookId order by agr.pointsEarned");
                q.setLong("gradebookId", gradebookId.longValue());
                return GradebookServiceHibernateImpl.this.filterGradeRecordsByStudents(q.list(), studentUids);
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    private List getAllAssignmentGradeRecordsForGbItem(final Long gradableObjectId, final Collection studentUids) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (studentUids.size() == 0) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"No enrollments were specified.  Returning an empty List of grade records");
                    }
                    return new ArrayList();
                }
                Query q = session.createQuery("from AssignmentGradeRecord as agr where agr.gradableObject.removed=false and agr.gradableObject.id=:gradableObjectId order by agr.pointsEarned");
                q.setLong("gradableObjectId", gradableObjectId.longValue());
                return GradebookServiceHibernateImpl.this.filterGradeRecordsByStudents(q.list(), studentUids);
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List getAssignments(final Long gradebookId, final String sortBy, final boolean ascending) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List assignments = GradebookServiceHibernateImpl.this.getAssignments(gradebookId, session);
                GradebookServiceHibernateImpl.this.sortAssignments(assignments, sortBy, ascending);
                return assignments;
            }
        });
    }

    private void sortAssignments(List assignments, String sortBy, boolean ascending) {
        Comparator comp = org.sakaiproject.tool.gradebook.Assignment.SORT_BY_NAME.equals(sortBy) ? GradableObject.nameComparator : (org.sakaiproject.tool.gradebook.Assignment.SORT_BY_DATE.equals(sortBy) ? GradableObject.dateComparator : (org.sakaiproject.tool.gradebook.Assignment.SORT_BY_MEAN.equals(sortBy) ? GradableObject.meanComparator : (org.sakaiproject.tool.gradebook.Assignment.SORT_BY_POINTS.equals(sortBy) ? org.sakaiproject.tool.gradebook.Assignment.pointsComparator : (org.sakaiproject.tool.gradebook.Assignment.SORT_BY_RELEASED.equals(sortBy) ? org.sakaiproject.tool.gradebook.Assignment.releasedComparator : (org.sakaiproject.tool.gradebook.Assignment.SORT_BY_COUNTED.equals(sortBy) ? org.sakaiproject.tool.gradebook.Assignment.countedComparator : (org.sakaiproject.tool.gradebook.Assignment.SORT_BY_EDITOR.equals(sortBy) ? org.sakaiproject.tool.gradebook.Assignment.gradeEditorComparator : (org.sakaiproject.tool.gradebook.Assignment.SORT_BY_SORTING.equals(sortBy) ? GradableObject.sortingComparator : GradableObject.defaultComparator)))))));
        Collections.sort(assignments, comp);
        if (!ascending) {
            Collections.reverse(assignments);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sortAssignments: ordering by " + sortBy + " (" + comp + "), ascending=" + ascending));
        }
    }

    public List<Assignment> getViewableAssignmentsForCurrentUser(String gradebookUid) throws GradebookNotFoundException {
        List allAssigns;
        List<org.sakaiproject.tool.gradebook.Assignment> viewableAssignments = new ArrayList();
        List<Assignment> assignmentsToReturn = new ArrayList<Assignment>();
        Gradebook gradebook = this.getGradebook(gradebookUid);
        if (this.getAuthz().isUserAbleToGradeAll(gradebookUid)) {
            viewableAssignments = this.getAssignments(gradebook.getId(), null, true);
        } else if (this.getAuthz().isUserAbleToGrade(gradebookUid)) {
            if (!this.getAuthz().isUserHasGraderPermissions(gradebookUid)) {
                viewableAssignments = this.getAssignments(gradebook.getId(), null, true);
            } else if (gradebook.getCategory_type() == 1) {
                assignmentsToReturn = this.getAssignments(gradebookUid);
            } else {
                List allCategories;
                String userUid = this.getUserUid();
                if (this.getGradebookPermissionService().getPermissionForUserForAllAssignment(gradebook.getId(), userUid)) {
                    assignmentsToReturn = this.getAssignments(gradebookUid);
                }
                if ((allCategories = this.getCategoriesWithAssignments(gradebook.getId())) != null && !allCategories.isEmpty()) {
                    ArrayList<Long> catIds = new ArrayList<Long>();
                    for (Category category : allCategories) {
                        catIds.add(category.getId());
                    }
                    List viewableCategorieIds = this.getGradebookPermissionService().getCategoriesForUser(gradebook.getId(), userUid, catIds, gradebook.getCategory_type());
                    ArrayList<Category> viewableCategories = new ArrayList<Category>();
                    for (Category category : allCategories) {
                        if (!viewableCategorieIds.contains(category.getId())) continue;
                        viewableCategories.add(category);
                    }
                    for (Category cat : viewableCategories) {
                        List assignments;
                        if (cat == null || (assignments = cat.getAssignmentList()) == null || assignments.isEmpty()) continue;
                        viewableAssignments.addAll(assignments);
                    }
                }
            }
        } else if (this.getAuthz().isUserAbleToViewOwnGrades(gradebookUid) && (allAssigns = this.getAssignments(gradebook.getId(), null, true)) != null) {
            for (org.sakaiproject.tool.gradebook.Assignment assign : allAssigns) {
                if (assign == null || !assign.isReleased()) continue;
                viewableAssignments.add(assign);
            }
        }
        if (viewableAssignments != null && !viewableAssignments.isEmpty()) {
            for (org.sakaiproject.tool.gradebook.Assignment assignment : viewableAssignments) {
                assignmentsToReturn.add(this.getAssignmentDefinition(assignment));
            }
        }
        return assignmentsToReturn;
    }

    public Map<String, String> getViewableStudentsForItemForCurrentUser(String gradebookUid, Long gradableObjectId) {
        String userUid = this.authn.getUserUid();
        return this.getViewableStudentsForItemForUser(userUid, gradebookUid, gradableObjectId);
    }

    public Map<String, String> getViewableStudentsForItemForUser(String userUid, final String gradebookUid, final Long gradableObjectId) {
        if (gradebookUid == null || gradableObjectId == null || userUid == null) {
            throw new IllegalArgumentException("null gradebookUid or gradableObjectId or userId passed to getViewableStudentsForUserForItem. gradebookUid: " + gradebookUid + " gradableObjectId:" + gradableObjectId + " userId: " + userUid);
        }
        if (!this.authz.isUserAbleToGrade(gradebookUid, userUid)) {
            return new HashMap<String, String>();
        }
        org.sakaiproject.tool.gradebook.Assignment gradebookItem = (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, gradableObjectId, session);
            }
        });
        if (gradebookItem == null) {
            log.debug((Object)"The gradebook item does not exist, so returning empty set");
            return new HashMap<String, String>();
        }
        Long categoryId = gradebookItem.getCategory() == null ? null : gradebookItem.getCategory().getId();
        Map enrRecFunctionMap = this.authz.findMatchingEnrollmentsForItemForUser(userUid, gradebookUid, categoryId, this.getGradebook(gradebookUid).getCategory_type(), null, null);
        if (enrRecFunctionMap == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> studentIdFunctionMap = new HashMap<String, String>();
        for (Map.Entry entry : enrRecFunctionMap.entrySet()) {
            EnrollmentRecord enr = (EnrollmentRecord)entry.getKey();
            if (enr == null || enrRecFunctionMap.get(enr) == null) continue;
            studentIdFunctionMap.put(enr.getUser().getUserUid(), (String)entry.getValue());
        }
        return studentIdFunctionMap;
    }

    public boolean isGradableObjectDefined(Long gradableObjectId) {
        if (gradableObjectId == null) {
            throw new IllegalArgumentException("null gradableObjectId passed to isGradableObjectDefined");
        }
        return this.isAssignmentDefined(gradableObjectId);
    }

    public Map getViewableSectionUuidToNameMap(String gradebookUid) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("Null gradebookUid passed to getViewableSectionIdToNameMap");
        }
        HashMap<String, String> sectionIdNameMap = new HashMap<String, String>();
        List viewableCourseSections = this.getAuthz().getViewableSections(gradebookUid);
        if (viewableCourseSections == null || viewableCourseSections.isEmpty()) {
            return sectionIdNameMap;
        }
        for (CourseSection section : viewableCourseSections) {
            if (section == null) continue;
            sectionIdNameMap.put(section.getUuid(), section.getTitle());
        }
        return sectionIdNameMap;
    }

    public boolean currentUserHasGradeAllPerm(String gradebookUid) {
        return this.authz.isUserAbleToGradeAll(gradebookUid);
    }

    public boolean isUserAllowedToGradeAll(String gradebookUid, String userUid) {
        return this.authz.isUserAbleToGradeAll(gradebookUid, userUid);
    }

    public boolean currentUserHasGradingPerm(String gradebookUid) {
        return this.authz.isUserAbleToGrade(gradebookUid);
    }

    public boolean isUserAllowedToGrade(String gradebookUid, String userUid) {
        return this.authz.isUserAbleToGrade(gradebookUid, userUid);
    }

    public boolean currentUserHasEditPerm(String gradebookUid) {
        return this.authz.isUserAbleToEditAssessments(gradebookUid);
    }

    public boolean currentUserHasViewOwnGradesPerm(String gradebookUid) {
        return this.authz.isUserAbleToViewOwnGrades(gradebookUid);
    }

    public List<GradeDefinition> getGradesForStudentsForItem(final String gradebookUid, final Long gradableObjectId, List<String> studentIds) {
        org.sakaiproject.tool.gradebook.Assignment gbItem;
        if (gradableObjectId == null) {
            throw new IllegalArgumentException("null gradableObjectId passed to getGradesForStudentsForItem");
        }
        ArrayList<GradeDefinition> studentGrades = new ArrayList<GradeDefinition>();
        if (studentIds != null && !studentIds.isEmpty() && (gbItem = (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, gradableObjectId, session);
            }
        })) != null) {
            List gradeRecs;
            Gradebook gradebook = gbItem.getGradebook();
            if (!this.authz.isUserAbleToGrade(gradebook.getUid())) {
                throw new SecurityException("User " + this.authn.getUserUid() + " attempted to access grade information without permission in gb " + gradebook.getUid() + " using gradebookService.getGradesForStudentsForItem");
            }
            Long categoryId = gbItem.getCategory() != null ? gbItem.getCategory().getId() : null;
            Map enrRecFunctionMap = this.authz.findMatchingEnrollmentsForItem(gradebook.getUid(), categoryId, gradebook.getCategory_type(), null, null);
            Set enrRecs = enrRecFunctionMap.keySet();
            HashMap<String, EnrollmentRecord> studentIdEnrRecMap = new HashMap<String, EnrollmentRecord>();
            if (enrRecs != null) {
                for (EnrollmentRecord enr : enrRecs) {
                    if (enr == null) continue;
                    studentIdEnrRecMap.put(enr.getUser().getUserUid(), enr);
                }
            }
            for (String studentId : studentIds) {
                if (studentId == null || studentIdEnrRecMap.containsKey(studentId)) continue;
                throw new SecurityException("User " + this.authn.getUserUid() + " attempted to access grade information for student " + studentId + " without permission in gb " + gradebook.getUid() + " using gradebookService.getGradesForStudentsForItem");
            }
            List commentRecs = this.getComments(gbItem, studentIds);
            HashMap<String, String> studentIdCommentTextMap = new HashMap<String, String>();
            if (commentRecs != null) {
                for (Comment comment : commentRecs) {
                    if (comment == null) continue;
                    studentIdCommentTextMap.put(comment.getStudentId(), comment.getCommentText());
                }
            }
            if ((gradeRecs = this.getAllAssignmentGradeRecordsForGbItem(gradableObjectId, studentIds)) != null) {
                if (gradebook.getGrade_type() == 3) {
                    this.convertPointsToLetterGrade(gradebook, gradeRecs);
                } else if (gradebook.getGrade_type() == 2) {
                    this.convertPointsToPercentage(gradebook, gradeRecs);
                }
                boolean gradeReleased = gradebook.isAssignmentsDisplayed() && gbItem.isReleased();
                for (AssignmentGradeRecord agr : gradeRecs) {
                    String grade;
                    if (agr == null) continue;
                    GradeDefinition gradeDef = new GradeDefinition();
                    gradeDef.setStudentUid(agr.getStudentId());
                    gradeDef.setGradeEntryType(gradebook.getGrade_type());
                    gradeDef.setGradeReleased(gradeReleased);
                    gradeDef.setGraderUid(agr.getGraderId());
                    gradeDef.setDateRecorded(agr.getDateRecorded());
                    String commentText = (String)studentIdCommentTextMap.get(agr.getStudentId());
                    if (commentText != null) {
                        gradeDef.setGradeComment(commentText);
                    }
                    if (gradebook.getGrade_type() == 3) {
                        gradeDef.setGrade(agr.getLetterEarned());
                    } else if (gradebook.getGrade_type() == 2) {
                        grade = agr.getPercentEarned() != null ? agr.getPercentEarned().toString() : null;
                        gradeDef.setGrade(grade);
                    } else {
                        grade = agr.getPointsEarned() != null ? agr.getPointsEarned().toString() : null;
                        gradeDef.setGrade(grade);
                    }
                    studentGrades.add(gradeDef);
                }
            }
        }
        return studentGrades;
    }

    public boolean isGradeValid(String gradebookUuid, String grade) {
        Gradebook gradebook;
        if (gradebookUuid == null) {
            throw new IllegalArgumentException("Null gradebookUuid passed to isGradeValid");
        }
        try {
            gradebook = this.getGradebook(gradebookUuid);
        }
        catch (GradebookNotFoundException gnfe) {
            throw new GradebookNotFoundException("No gradebook exists with the given gradebookUid: " + gradebookUuid + "Error: " + gnfe.getMessage());
        }
        int gradeEntryType = gradebook.getGrade_type();
        LetterGradePercentMapping mapping = null;
        if (gradeEntryType == 3) {
            mapping = this.getLetterGradePercentMapping(gradebook);
        }
        return this.isGradeValid(grade, gradeEntryType, mapping);
    }

    private boolean isGradeValid(String grade, int gradeEntryType, LetterGradePercentMapping gradeMapping) {
        boolean gradeIsValid;
        block13: {
            gradeIsValid = false;
            if (grade == null || "".equals(grade)) {
                gradeIsValid = true;
            } else {
                if (gradeEntryType == 1 || gradeEntryType == 2) {
                    try {
                        String decimal;
                        Double gradeAsDouble = Double.parseDouble(grade);
                        if (!(gradeAsDouble >= 0.0)) break block13;
                        String[] splitOnDecimal = grade.split("\\.");
                        if (splitOnDecimal == null || splitOnDecimal.length < 2) {
                            gradeIsValid = true;
                        } else if (splitOnDecimal.length == 2 && (decimal = splitOnDecimal[1]).length() <= 2) {
                            gradeIsValid = true;
                        }
                        break block13;
                    }
                    catch (NumberFormatException nfe) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Passed grade is not a numeric value");
                        }
                        break block13;
                    }
                }
                if (gradeEntryType == 3) {
                    if (gradeMapping == null) {
                        throw new IllegalArgumentException("Null mapping passed to isGradeValid for a letter grade-based gradeook");
                    }
                    String standardizedGrade = gradeMapping.standardizeInputGrade(grade);
                    if (standardizedGrade != null) {
                        gradeIsValid = true;
                    }
                } else {
                    throw new IllegalArgumentException("Invalid gradeEntryType passed to isGradeValid");
                }
            }
        }
        return gradeIsValid;
    }

    public List<String> identifyStudentsWithInvalidGrades(String gradebookUid, Map<String, String> studentIdToGradeMap) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("null gradebookUid passed to identifyStudentsWithInvalidGrades");
        }
        ArrayList<String> studentsWithInvalidGrade = new ArrayList<String>();
        if (studentIdToGradeMap != null) {
            Gradebook gradebook;
            try {
                gradebook = this.getGradebook(gradebookUid);
            }
            catch (GradebookNotFoundException gnfe) {
                throw new GradebookNotFoundException("No gradebook exists with the given gradebookUid: " + gradebookUid + "Error: " + gnfe.getMessage());
            }
            LetterGradePercentMapping gradeMapping = null;
            if (gradebook.getGrade_type() == 3) {
                gradeMapping = this.getLetterGradePercentMapping(gradebook);
            }
            for (String studentId : studentIdToGradeMap.keySet()) {
                String grade = studentIdToGradeMap.get(studentId);
                if (this.isGradeValid(grade, gradebook.getGrade_type(), gradeMapping)) continue;
                studentsWithInvalidGrade.add(studentId);
            }
        }
        return studentsWithInvalidGrade;
    }

    public void saveGradeAndCommentForStudent(String gradebookUid, Long gradableObjectId, String studentUid, String grade, String comment) {
        if (gradebookUid == null || gradableObjectId == null || studentUid == null) {
            throw new IllegalArgumentException("Null gradebookUid or gradableObjectId or studentUid passed to saveGradeAndCommentForStudent");
        }
        GradeDefinition gradeDef = new GradeDefinition();
        gradeDef.setStudentUid(studentUid);
        gradeDef.setGrade(grade);
        gradeDef.setGradeComment(comment);
        ArrayList<GradeDefinition> gradeDefList = new ArrayList<GradeDefinition>();
        gradeDefList.add(gradeDef);
        this.saveGradesAndComments(gradebookUid, gradableObjectId, gradeDefList);
    }

    public void saveGradesAndComments(final String gradebookUid, final Long gradableObjectId, List<GradeDefinition> gradeDefList) {
        if (gradebookUid == null || gradableObjectId == null) {
            throw new IllegalArgumentException("Null gradebookUid or gradableObjectId passed to saveGradesAndComments");
        }
        if (gradeDefList != null) {
            Gradebook gradebook;
            try {
                gradebook = this.getGradebook(gradebookUid);
            }
            catch (GradebookNotFoundException gnfe) {
                throw new GradebookNotFoundException("No gradebook exists with the given gradebookUid: " + gradebookUid + "Error: " + gnfe.getMessage());
            }
            org.sakaiproject.tool.gradebook.Assignment assignment = (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, gradableObjectId, session);
                }
            });
            if (assignment == null) {
                throw new AssessmentNotFoundException("No gradebook item exists with gradable object id = " + gradableObjectId);
            }
            if (!this.currentUserHasGradingPerm(gradebookUid)) {
                log.warn((Object)"User attempted to save grades and comments without authorization");
                throw new SecurityException("Current user is not authorized to save grades or comments in gradebook " + gradebookUid);
            }
            HashMap<String, GradeDefinition> studentIdGradeDefMap = new HashMap<String, GradeDefinition>();
            HashMap<String, String> studentIdToGradeMap = new HashMap<String, String>();
            for (GradeDefinition gradeDef : gradeDefList) {
                studentIdGradeDefMap.put(gradeDef.getStudentUid(), gradeDef);
                studentIdToGradeMap.put(gradeDef.getStudentUid(), gradeDef.getGrade());
            }
            List<String> invalidStudents = this.identifyStudentsWithInvalidGrades(gradebookUid, studentIdToGradeMap);
            if (invalidStudents != null && !invalidStudents.isEmpty()) {
                throw new InvalidGradeException("At least one grade passed to be updated is invalid. No grades or comments were updated.");
            }
            boolean userHasGradeAllPerm = this.currentUserHasGradeAllPerm(gradebookUid);
            List allGradeRecs = this.getAllAssignmentGradeRecordsForGbItem(gradableObjectId, studentIdGradeDefMap.keySet());
            HashMap<String, AssignmentGradeRecord> studentIdToAgrMap = new HashMap<String, AssignmentGradeRecord>();
            if (allGradeRecs != null) {
                for (AssignmentGradeRecord rec : allGradeRecs) {
                    studentIdToAgrMap.put(rec.getStudentId(), rec);
                }
            }
            String graderId = this.getAuthn().getUserUid();
            Date now = new Date();
            LetterGradePercentMapping mapping = null;
            if (gradebook.getGrade_type() == 3) {
                mapping = this.getLetterGradePercentMapping(gradebook);
            }
            List allComments = this.getComments(assignment, studentIdGradeDefMap.keySet());
            HashMap<String, Comment> studentIdCommentMap = new HashMap<String, Comment>();
            if (allComments != null) {
                for (Comment comment : allComments) {
                    studentIdCommentMap.put(comment.getStudentId(), comment);
                }
            }
            HashSet<AssignmentGradeRecord> agrToUpdate = new HashSet<AssignmentGradeRecord>();
            ArrayList<Comment> commentsToUpdate = new ArrayList<Comment>();
            HashSet<GradingEvent> eventsToAdd = new HashSet<GradingEvent>();
            for (GradeDefinition gradeDef : gradeDefList) {
                Comment comment;
                GradingEvent event;
                String studentId = gradeDef.getStudentUid();
                if (!userHasGradeAllPerm && !this.isUserAbleToGradeItemForStudent(gradebookUid, gradableObjectId, studentId)) {
                    log.warn((Object)("User " + graderId + " attempted to save a grade for " + studentId + " without authorization"));
                    throw new SecurityException("User " + graderId + " attempted to save a grade for " + studentId + " without authorization");
                }
                Double convertedGrade = this.convertInputGradeToPoints(gradebook.getGrade_type(), mapping, assignment.getPointsPossible(), gradeDef.getGrade());
                AssignmentGradeRecord gradeRec = (AssignmentGradeRecord)studentIdToAgrMap.get(studentId);
                if (gradeRec != null) {
                    if (convertedGrade == null && gradeRec.getPointsEarned() != null || convertedGrade != null && gradeRec.getPointsEarned() == null || convertedGrade != null && gradeRec.getPointsEarned() != null && !convertedGrade.equals(gradeRec.getPointsEarned())) {
                        gradeRec.setPointsEarned(convertedGrade);
                        gradeRec.setGraderId(graderId);
                        gradeRec.setDateRecorded(now);
                        agrToUpdate.add(gradeRec);
                        event = new GradingEvent((GradableObject)assignment, graderId, studentId, (Object)gradeDef.getGrade());
                        eventsToAdd.add(event);
                    }
                } else if (gradeDef.getGrade() != null && !gradeDef.getGrade().trim().equals("")) {
                    gradeRec = new AssignmentGradeRecord(assignment, studentId, convertedGrade);
                    gradeRec.setPointsEarned(convertedGrade);
                    gradeRec.setGraderId(graderId);
                    gradeRec.setDateRecorded(now);
                    agrToUpdate.add(gradeRec);
                    event = new GradingEvent((GradableObject)assignment, graderId, studentId, (Object)gradeDef.getGrade());
                    eventsToAdd.add(event);
                }
                if ((comment = (Comment)studentIdCommentMap.get(studentId)) != null) {
                    boolean newCommentIsNull;
                    boolean oldCommentIsNull = comment.getCommentText() == null || comment.getCommentText().equals("");
                    boolean bl = newCommentIsNull = gradeDef.getGradeComment() == null || gradeDef.getGradeComment().equals("");
                    if (!(oldCommentIsNull && !newCommentIsNull || !oldCommentIsNull && newCommentIsNull) && (oldCommentIsNull || newCommentIsNull || gradeDef.getGradeComment().equals(comment.getCommentText()))) continue;
                    comment.setCommentText(gradeDef.getGradeComment());
                    comment.setGraderId(graderId);
                    comment.setDateRecorded(now);
                    commentsToUpdate.add(comment);
                    continue;
                }
                if (gradeDef.getGradeComment() == null || gradeDef.getGradeComment().trim().equals("")) continue;
                comment = new Comment(studentId, gradeDef.getGradeComment(), (GradableObject)assignment);
                comment.setGraderId(graderId);
                comment.setDateRecorded(now);
                commentsToUpdate.add(comment);
            }
            try {
                this.getHibernateTemplate().saveOrUpdateAll(agrToUpdate);
                this.getHibernateTemplate().saveOrUpdateAll(commentsToUpdate);
                this.getHibernateTemplate().saveOrUpdateAll(eventsToAdd);
            }
            catch (HibernateOptimisticLockingFailureException holfe) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("An optimistic locking failure occurred while attempting to save scores and comments for gb Item " + gradableObjectId));
                }
                throw new StaleObjectModificationException((Throwable)holfe);
            }
            catch (StaleObjectStateException sose) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("An optimistic locking failure occurred while attempting to save scores and comments for gb Item " + gradableObjectId));
                }
                throw new StaleObjectModificationException((Throwable)sose);
            }
        }
    }

    private Double convertInputGradeToPoints(int gradeEntryType, LetterGradePercentMapping mapping, Double gbItemPointsPossible, String grade) throws InvalidGradeException {
        Double convertedValue = null;
        if (grade != null && !"".equals(grade)) {
            if (gradeEntryType == 1) {
                try {
                    Double pointValue;
                    convertedValue = pointValue = Double.valueOf(Double.parseDouble(grade));
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidGradeException("Invalid grade passed to convertInputGradeToPoints");
                }
            }
            if (gradeEntryType == 2 || gradeEntryType == 3) {
                if (gbItemPointsPossible == null) {
                    throw new IllegalArgumentException("Null points possible passed to convertInputGradeToPoints for letter or % based grading");
                }
                Double percentage = null;
                if (gradeEntryType == 3) {
                    String standardizedGrade;
                    if (mapping == null) {
                        throw new IllegalArgumentException("No mapping passed to convertInputGradeToPoints for a letter-based gb");
                    }
                    if (mapping.getGradeMap() != null && (percentage = mapping.getValue(standardizedGrade = mapping.standardizeInputGrade(grade))) == null) {
                        throw new IllegalArgumentException("Invalid grade passed to convertInputGradeToPoints");
                    }
                } else {
                    try {
                        percentage = Double.parseDouble(grade);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Invalid % grade passed to convertInputGradeToPoints");
                    }
                }
                convertedValue = this.calculateEquivalentPointValueForPercent(gbItemPointsPossible, percentage);
            } else {
                throw new InvalidGradeException("invalid grade entry type passed to convertInputGradeToPoints");
            }
        }
        return convertedValue;
    }

    private List getTotalPointsEarnedInternalFixing(Long gradebookId, String studentId, Session session, Gradebook gradebook, List categories, List<AssignmentGradeRecord> studentGradeRecs) {
        double totalPointsEarned = 0.0;
        double literalTotalPointsEarned = 0.0;
        Iterator scoresIter = session.createQuery("select agr.pointsEarned, asn from AssignmentGradeRecord agr, Assignment asn where agr.gradableObject=asn and agr.studentId=:student and asn.gradebook.id=:gbid and asn.removed=false and asn.pointsPossible > 0").setParameter("student", (Object)studentId).setParameter("gbid", (Object)gradebookId).list().iterator();
        List assgnsList = session.createQuery("from Assignment as asn where asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false and asn.pointsPossible > 0").setParameter("gbid", (Object)gradebookId).list();
        HashMap<Long, Double> cateScoreMap = new HashMap<Long, Double>();
        HashMap<Long, Double> cateTotalScoreMap = new HashMap<Long, Double>();
        HashSet<Long> assignmentsTaken = new HashSet<Long>();
        block0: while (scoresIter.hasNext()) {
            Object[] returned = (Object[])scoresIter.next();
            Double pointsEarned = (Double)returned[0];
            org.sakaiproject.tool.gradebook.Assignment go = (org.sakaiproject.tool.gradebook.Assignment)returned[1];
            if (go == null || !go.isCounted() || pointsEarned == null) continue;
            boolean skip = false;
            for (AssignmentGradeRecord gr : studentGradeRecs) {
                if (!gr.getAssignment().getId().equals(go.getId())) continue;
                if (!gr.getDroppedFromGrade().booleanValue()) break;
                skip = true;
                break;
            }
            if (skip) continue;
            Double fixingPointsEarned = this.fixingPointsEarned(pointsEarned, go, gradebook);
            if (gradebook.getCategory_type() == 1) {
                totalPointsEarned += fixingPointsEarned.doubleValue();
                literalTotalPointsEarned += fixingPointsEarned.doubleValue();
                assignmentsTaken.add(go.getId());
                continue;
            }
            if (gradebook.getCategory_type() == 2 && go != null) {
                totalPointsEarned += fixingPointsEarned.doubleValue();
                literalTotalPointsEarned += fixingPointsEarned.doubleValue();
                assignmentsTaken.add(go.getId());
                continue;
            }
            if (gradebook.getCategory_type() != 3 || go == null || categories == null) continue;
            for (int i = 0; i < categories.size(); ++i) {
                Category cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || go.getCategory() == null || !cate.getId().equals(go.getCategory().getId())) continue;
                assignmentsTaken.add(go.getId());
                literalTotalPointsEarned += fixingPointsEarned.doubleValue();
                if (cateScoreMap.get(cate.getId()) != null) {
                    cateScoreMap.put(cate.getId(), (Double)cateScoreMap.get(cate.getId()) + fixingPointsEarned);
                    continue block0;
                }
                cateScoreMap.put(cate.getId(), fixingPointsEarned);
                continue block0;
            }
        }
        if (gradebook.getCategory_type() == 3 && categories != null) {
            for (org.sakaiproject.tool.gradebook.Assignment asgn : assgnsList) {
                if (!assignmentsTaken.contains(asgn.getId())) continue;
                for (int i = 0; i < categories.size(); ++i) {
                    Category cate = (Category)categories.get(i);
                    if (cate == null || cate.isRemoved() || asgn.getCategory() == null || !cate.getId().equals(asgn.getCategory().getId())) continue;
                    if (cateTotalScoreMap.get(cate.getId()) == null) {
                        cateTotalScoreMap.put(cate.getId(), asgn.getPointsPossible());
                        continue;
                    }
                    cateTotalScoreMap.put(cate.getId(), (Double)cateTotalScoreMap.get(cate.getId()) + asgn.getPointsPossible());
                }
            }
        }
        if (assignmentsTaken.isEmpty()) {
            totalPointsEarned = -1.0;
        }
        if (gradebook.getCategory_type() == 3) {
            for (int i = 0; i < categories.size(); ++i) {
                Category cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || cateScoreMap.get(cate.getId()) == null || cateTotalScoreMap.get(cate.getId()) == null) continue;
                totalPointsEarned += (Double)cateScoreMap.get(cate.getId()) * cate.getWeight() / (Double)cateTotalScoreMap.get(cate.getId());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTotalPointsEarnedInternal for studentId=" + studentId + " returning " + totalPointsEarned));
        }
        ArrayList<Double> returnList = new ArrayList<Double>();
        returnList.add(totalPointsEarned);
        returnList.add(literalTotalPointsEarned);
        return returnList;
    }

    private Double fixingPointsEarned(Double pointsEarned, org.sakaiproject.tool.gradebook.Assignment assignment, Gradebook gradebook) {
        Double pointPossible = assignment.getPointsPossible();
        if (pointPossible != null && pointPossible > 0.0) {
            LetterGradePercentMapping lgpm = this.getLetterGradePercentMapping(assignment.getGradebook());
            String letterGrade = lgpm.getGrade(this.calculateEquivalentPercent(pointPossible, pointsEarned));
            GradeMapping gradeMap = gradebook.getSelectedGradeMapping();
            if (gradeMap != null) {
                Double rightPercent = gradeMap.getValue(letterGrade);
                BigDecimal rightPercentBD = new BigDecimal(rightPercent);
                BigDecimal pointPossibleBD = new BigDecimal(pointPossible);
                return rightPercentBD.multiply(pointPossibleBD).divide(new BigDecimal(Double.valueOf("100.0"))).doubleValue();
            }
        }
        return null;
    }

    public Map getFixedGrade(String gradebookUid) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            Gradebook thisGradebook = this.getGradebook(gradebookUid);
            List assignList = this.getAssignmentsCounted(thisGradebook.getId());
            boolean nonAssignment = false;
            if (assignList == null || assignList.size() < 1) {
                nonAssignment = true;
            }
            Long gradebookId = thisGradebook.getId();
            CourseGrade courseGrade = this.getCourseGrade(gradebookId);
            Map viewableEnrollmentsMap = this.authz.findMatchingEnrollmentsForViewableCourseGrade(gradebookUid, thisGradebook.getCategory_type(), null, null);
            HashMap<String, EnrollmentRecord> enrollmentMap = new HashMap<String, EnrollmentRecord>();
            HashMap<String, EnrollmentRecord> enrollmentMapUid = new HashMap<String, EnrollmentRecord>();
            for (EnrollmentRecord enr : viewableEnrollmentsMap.keySet()) {
                enrollmentMap.put(enr.getUser().getUserUid(), enr);
                enrollmentMapUid.put(enr.getUser().getUserUid(), enr);
            }
            List gradeRecords = this.getPointsEarnedCourseGradeRecordsFixing(courseGrade, enrollmentMap.keySet());
            for (CourseGradeRecord gradeRecord : gradeRecords) {
                GradeMapping gradeMap = thisGradebook.getSelectedGradeMapping();
                EnrollmentRecord enr = (EnrollmentRecord)enrollmentMapUid.get(gradeRecord.getStudentId());
                if (enr == null || nonAssignment) continue;
                returnMap.put(enr.getUser().getDisplayId(), gradeMap.getGrade(gradeRecord.getNonNullAutoCalculatedGrade()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnMap;
    }

    public List getPointsEarnedCourseGradeRecordsFixing(final CourseGrade courseGrade, final Collection studentUids) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (studentUids == null || studentUids.size() == 0) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Returning no grade records for an empty collection of student UIDs");
                    }
                    return new ArrayList();
                }
                Query q = session.createQuery("from CourseGradeRecord as cgr where cgr.gradableObject.id=:gradableObjectId");
                q.setLong("gradableObjectId", courseGrade.getId().longValue());
                List records = GradebookServiceHibernateImpl.this.filterAndPopulateCourseGradeRecordsByStudents(courseGrade, q.list(), studentUids);
                Long gradebookId = courseGrade.getGradebook().getId();
                Gradebook gradebook = GradebookServiceHibernateImpl.this.getGradebook(gradebookId);
                List cates = GradebookServiceHibernateImpl.this.getCategories(gradebookId);
                Map<String, List<AssignmentGradeRecord>> gradeRecMap = GradebookServiceHibernateImpl.this.getGradeRecordMapForStudents(session, gradebookId, studentUids);
                List<org.sakaiproject.tool.gradebook.Assignment> countedAssigns = GradebookServiceHibernateImpl.this.getCountedAssignments(session, gradebookId);
                for (CourseGradeRecord cgr : records) {
                    List<AssignmentGradeRecord> studentGradeRecs = gradeRecMap.get(cgr.getStudentId());
                    GradebookServiceHibernateImpl.this.applyDropScores(studentGradeRecs);
                    List totalEarned = GradebookServiceHibernateImpl.this.getTotalPointsEarnedInternalFixing(gradebookId, cgr.getStudentId(), session, gradebook, cates, studentGradeRecs);
                    double totalPointsEarned = (Double)totalEarned.get(0);
                    double literalTotalPointsEarned = (Double)totalEarned.get(1);
                    double totalPointsPossible = GradebookServiceHibernateImpl.this.getTotalPointsInternal(gradebookId, session, gradebook, cates, cgr.getStudentId(), studentGradeRecs, countedAssigns);
                    cgr.initNonpersistentFields(totalPointsPossible, totalPointsEarned, literalTotalPointsEarned);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Points earned = " + cgr.getPointsEarned()));
                }
                return records;
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public Map getFixedPoint(String gradebookUid) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            Gradebook thisGradebook = this.getGradebook(gradebookUid);
            List assignList = this.getAssignmentsCounted(thisGradebook.getId());
            boolean nonAssignment = false;
            if (assignList == null || assignList.size() < 1) {
                nonAssignment = true;
            }
            Long gradebookId = thisGradebook.getId();
            CourseGrade courseGrade = this.getCourseGrade(gradebookId);
            Map viewableEnrollmentsMap = this.authz.findMatchingEnrollmentsForViewableCourseGrade(gradebookUid, thisGradebook.getCategory_type(), null, null);
            HashMap<String, EnrollmentRecord> enrollmentMap = new HashMap<String, EnrollmentRecord>();
            HashMap<String, EnrollmentRecord> enrollmentMapUid = new HashMap<String, EnrollmentRecord>();
            for (EnrollmentRecord enr : viewableEnrollmentsMap.keySet()) {
                enrollmentMap.put(enr.getUser().getUserUid(), enr);
                enrollmentMapUid.put(enr.getUser().getUserUid(), enr);
            }
            List gradeRecords = this.getPointsEarnedCourseGradeRecordsFixing(courseGrade, enrollmentMap.keySet());
            for (CourseGradeRecord gradeRecord : gradeRecords) {
                EnrollmentRecord enr = (EnrollmentRecord)enrollmentMapUid.get(gradeRecord.getStudentId());
                if (enr == null || nonAssignment) continue;
                returnMap.put(enr.getUser().getDisplayId(), gradeRecord.getNonNullAutoCalculatedGrade().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnMap;
    }

    public Map getOldPoint(String gradebookUid) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            Gradebook thisGradebook = this.getGradebook(gradebookUid);
            List assignList = this.getAssignmentsCounted(thisGradebook.getId());
            boolean nonAssignment = false;
            if (assignList == null || assignList.size() < 1) {
                nonAssignment = true;
            }
            Long gradebookId = thisGradebook.getId();
            CourseGrade courseGrade = this.getCourseGrade(gradebookId);
            Map viewableEnrollmentsMap = this.authz.findMatchingEnrollmentsForViewableCourseGrade(gradebookUid, thisGradebook.getCategory_type(), null, null);
            HashMap<String, EnrollmentRecord> enrollmentMap = new HashMap<String, EnrollmentRecord>();
            HashMap<String, EnrollmentRecord> enrollmentMapUid = new HashMap<String, EnrollmentRecord>();
            for (EnrollmentRecord enr : viewableEnrollmentsMap.keySet()) {
                enrollmentMap.put(enr.getUser().getUserUid(), enr);
                enrollmentMapUid.put(enr.getUser().getUserUid(), enr);
            }
            List gradeRecords = this.getPointsEarnedCourseGradeRecords(courseGrade, enrollmentMap.keySet());
            for (CourseGradeRecord gradeRecord : gradeRecords) {
                GradeMapping gradeMap = thisGradebook.getSelectedGradeMapping();
                EnrollmentRecord enr = (EnrollmentRecord)enrollmentMapUid.get(gradeRecord.getStudentId());
                if (enr == null || nonAssignment) continue;
                returnMap.put(enr.getUser().getDisplayId(), gradeRecord.getNonNullAutoCalculatedGrade().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnMap;
    }

    public int getGradeEntryType(String gradebookUid) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("null gradebookUid passed to getGradeEntryType");
        }
        try {
            Gradebook gradebook = this.getGradebook(gradebookUid);
            return gradebook.getGrade_type();
        }
        catch (GradebookNotFoundException gnfe) {
            throw new GradebookNotFoundException("No gradebook exists with the given gradebookUid: " + gradebookUid);
        }
    }

    public Map getEnteredCourseGrade(final String gradebookUid) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Gradebook thisGradebook = GradebookServiceHibernateImpl.this.getGradebook(gradebookUid);
                Long gradebookId = thisGradebook.getId();
                CourseGrade courseGrade = GradebookServiceHibernateImpl.this.getCourseGrade(gradebookId);
                Map viewableEnrollmentsMap = GradebookServiceHibernateImpl.this.authz.findMatchingEnrollmentsForViewableCourseGrade(gradebookUid, thisGradebook.getCategory_type(), null, null);
                HashMap<String, EnrollmentRecord> enrollmentMap = new HashMap<String, EnrollmentRecord>();
                HashMap<String, EnrollmentRecord> enrollmentMapUid = new HashMap<String, EnrollmentRecord>();
                for (EnrollmentRecord enr : viewableEnrollmentsMap.keySet()) {
                    enrollmentMap.put(enr.getUser().getUserUid(), enr);
                    enrollmentMapUid.put(enr.getUser().getUserUid(), enr);
                }
                Query q = session.createQuery("from CourseGradeRecord as cgr where cgr.gradableObject.id=:gradableObjectId");
                q.setLong("gradableObjectId", courseGrade.getId().longValue());
                List records = GradebookServiceHibernateImpl.this.filterAndPopulateCourseGradeRecordsByStudents(courseGrade, q.list(), enrollmentMap.keySet());
                HashMap<String, String> returnMap = new HashMap<String, String>();
                for (int i = 0; i < records.size(); ++i) {
                    EnrollmentRecord enr;
                    CourseGradeRecord cgr = (CourseGradeRecord)records.get(i);
                    if (cgr.getEnteredGrade() == null || cgr.getEnteredGrade().equalsIgnoreCase("") || (enr = (EnrollmentRecord)enrollmentMapUid.get(cgr.getStudentId())) == null) continue;
                    returnMap.put(enr.getUser().getDisplayId(), cgr.getEnteredGrade());
                }
                return returnMap;
            }
        };
        return (Map)this.getHibernateTemplate().execute(hc);
    }

    public Map getCalculatedCourseGrade(String gradebookUid) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            Gradebook thisGradebook = this.getGradebook(gradebookUid);
            List assignList = this.getAssignmentsCounted(thisGradebook.getId());
            boolean nonAssignment = false;
            if (assignList == null || assignList.size() < 1) {
                nonAssignment = true;
            }
            Long gradebookId = thisGradebook.getId();
            CourseGrade courseGrade = this.getCourseGrade(gradebookId);
            Map viewableEnrollmentsMap = this.authz.findMatchingEnrollmentsForViewableCourseGrade(gradebookUid, thisGradebook.getCategory_type(), null, null);
            HashMap<String, EnrollmentRecord> enrollmentMap = new HashMap<String, EnrollmentRecord>();
            HashMap<String, EnrollmentRecord> enrollmentMapUid = new HashMap<String, EnrollmentRecord>();
            for (EnrollmentRecord enr : viewableEnrollmentsMap.keySet()) {
                enrollmentMap.put(enr.getUser().getUserUid(), enr);
                enrollmentMapUid.put(enr.getUser().getUserUid(), enr);
            }
            List gradeRecords = this.getPointsEarnedCourseGradeRecords(courseGrade, enrollmentMap.keySet());
            for (CourseGradeRecord gradeRecord : gradeRecords) {
                GradeMapping gradeMap = thisGradebook.getSelectedGradeMapping();
                EnrollmentRecord enr = (EnrollmentRecord)enrollmentMapUid.get(gradeRecord.getStudentId());
                if (enr == null || nonAssignment) continue;
                returnMap.put(enr.getUser().getDisplayId(), gradeMap.getGrade(gradeRecord.getNonNullAutoCalculatedGrade()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnMap;
    }

    public String getAssignmentScoreString(final String gradebookUid, final String assignmentName, final String studentUid) throws GradebookNotFoundException, AssessmentNotFoundException {
        final boolean studentRequestingOwnScore = this.authn.getUserUid().equals(studentUid);
        Double assignmentScore = (Double)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.sakaiproject.tool.gradebook.Assignment assignment = GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName, session);
                if (assignment == null) {
                    throw new AssessmentNotFoundException("There is no assignment named " + assignmentName + " in gradebook " + gradebookUid);
                }
                if (!studentRequestingOwnScore && !GradebookServiceHibernateImpl.this.isUserAbleToViewItemForStudent(gradebookUid, assignment.getId(), studentUid)) {
                    log.error((Object)("AUTHORIZATION FAILURE: User " + GradebookServiceHibernateImpl.this.getUserUid() + " in gradebook " + gradebookUid + " attempted to retrieve grade for student " + studentUid + " for assignment " + assignmentName));
                    throw new SecurityException("You do not have permission to perform this operation");
                }
                if (studentRequestingOwnScore && !assignment.isReleased()) {
                    log.error((Object)("AUTHORIZATION FAILURE: Student " + GradebookServiceHibernateImpl.this.getUserUid() + " in gradebook " + gradebookUid + " attempted to retrieve score for unreleased assignment " + assignment.getName()));
                    throw new SecurityException("You do not have permission to perform this operation");
                }
                AssignmentGradeRecord gradeRecord = GradebookServiceHibernateImpl.this.getAssignmentGradeRecord(assignment, studentUid, session);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("gradeRecord=" + gradeRecord));
                }
                if (gradeRecord == null) {
                    return null;
                }
                return gradeRecord.getPointsEarned();
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)("returning " + assignmentScore));
        }
        if (assignmentScore == null) {
            return null;
        }
        return Double.valueOf(assignmentScore).toString();
    }

    public String getAssignmentScoreString(final String gradebookUid, final Long gbItemId, String studentUid) throws GradebookNotFoundException, AssessmentNotFoundException {
        if (gradebookUid == null || gbItemId == null || studentUid == null) {
            throw new IllegalArgumentException("null parameter passed to getAssignmentScore");
        }
        org.sakaiproject.tool.gradebook.Assignment assignment = (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, gbItemId, session);
            }
        });
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assignment with the gbItemId " + gbItemId);
        }
        return this.getAssignmentScoreString(gradebookUid, assignment.getName(), studentUid);
    }

    public void setAssignmentScoreString(final String gradebookUid, final String assignmentName, final String studentUid, final String score, final String clientServiceDescription) throws GradebookNotFoundException, AssessmentNotFoundException {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.sakaiproject.tool.gradebook.Assignment assignment = GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName, session);
                if (assignment == null) {
                    throw new AssessmentNotFoundException("There is no assignment named " + assignmentName + " in gradebook " + gradebookUid);
                }
                if (assignment.isExternallyMaintained()) {
                    log.error((Object)("AUTHORIZATION FAILURE: User " + GradebookServiceHibernateImpl.this.getUserUid() + " in gradebook " + gradebookUid + " attempted to grade externally maintained assignment " + assignmentName + " from " + clientServiceDescription));
                    throw new SecurityException("You do not have permission to perform this operation");
                }
                if (!GradebookServiceHibernateImpl.this.isUserAbleToGradeItemForStudent(gradebookUid, assignment.getId(), studentUid)) {
                    log.error((Object)("AUTHORIZATION FAILURE: User " + GradebookServiceHibernateImpl.this.getUserUid() + " in gradebook " + gradebookUid + " attempted to grade student " + studentUid + " from " + clientServiceDescription + " for item " + assignmentName));
                    throw new SecurityException("You do not have permission to perform this operation");
                }
                Date now = new Date();
                String graderId = GradebookServiceHibernateImpl.this.getAuthn().getUserUid();
                AssignmentGradeRecord gradeRecord = GradebookServiceHibernateImpl.this.getAssignmentGradeRecord(assignment, studentUid, session);
                if (gradeRecord == null) {
                    gradeRecord = new AssignmentGradeRecord(assignment, studentUid, GradebookServiceHibernateImpl.this.convertStringToDouble(score));
                } else {
                    gradeRecord.setPointsEarned(GradebookServiceHibernateImpl.this.convertStringToDouble(score));
                }
                gradeRecord.setGraderId(graderId);
                gradeRecord.setDateRecorded(now);
                session.saveOrUpdate((Object)gradeRecord);
                session.save((Object)new GradingEvent((GradableObject)assignment, graderId, studentUid, (Object)score));
                session.flush();
                session.clear();
                return null;
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)("Score updated in gradebookUid=" + gradebookUid + ", assignmentName=" + assignmentName + " by userUid=" + this.getUserUid() + " from client=" + clientServiceDescription + ", new score=" + score));
        }
    }

    public void finalizeGrades(String gradebookUid) throws GradebookNotFoundException {
        if (!this.getAuthz().isUserAbleToGradeAll(gradebookUid)) {
            log.error((Object)("AUTHORIZATION FAILURE: User " + this.getUserUid() + " in gradebook " + gradebookUid + " attempted to finalize grades"));
            throw new SecurityException("You do not have permission to perform this operation");
        }
        this.finalizeNullGradeRecords(this.getGradebook(gradebookUid));
    }

    public String getLowestPossibleGradeForGbItem(final String gradebookUid, final Long gradebookItemId) {
        if (gradebookUid == null || gradebookItemId == null) {
            throw new IllegalArgumentException("Null gradebookUid and/or gradebookItemId passed to getLowestPossibleGradeForGbItem. gradebookUid:" + gradebookUid + " gradebookItemId:" + gradebookItemId);
        }
        org.sakaiproject.tool.gradebook.Assignment gbItem = (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, gradebookItemId, session);
            }
        });
        if (gbItem == null) {
            throw new AssessmentNotFoundException("No gradebook item found with id " + gradebookItemId);
        }
        Gradebook gradebook = gbItem.getGradebook();
        if (!this.isUserAbleToViewAssignments(gradebookUid) && !this.currentUserHasViewOwnGradesPerm(gradebookUid)) {
            throw new SecurityException("User attempted to access gradebookItem: " + gradebookItemId + " in gradebook:" + gradebookUid + " without permission!");
        }
        String lowestPossibleGrade = null;
        if (gbItem.getUngraded()) {
            lowestPossibleGrade = null;
        } else if (gradebook.getGrade_type() == 2 || gradebook.getGrade_type() == 1) {
            lowestPossibleGrade = "0";
        } else if (gbItem.getGradebook().getGrade_type() == 3) {
            LetterGradePercentMapping mapping = this.getLetterGradePercentMapping(gradebook);
            lowestPossibleGrade = mapping.getGrade(Double.valueOf(0.0));
        }
        return lowestPossibleGrade;
    }

    public List<CategoryDefinition> getCategoryDefinitions(String gradebookUid) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("Null gradebookUid passed to getCategoryDefinitions");
        }
        if (!this.isUserAbleToViewAssignments(gradebookUid)) {
            log.warn((Object)("AUTHORIZATION FAILURE: User " + this.getUserUid() + " in gradebook " + gradebookUid + " attempted to retrieve all categories without permission"));
            throw new SecurityException("You do not have permission to perform this operation");
        }
        ArrayList<CategoryDefinition> categoryDefList = new ArrayList<CategoryDefinition>();
        List gbCategories = this.getCategories(this.getGradebook(gradebookUid).getId());
        if (gbCategories != null) {
            for (Category category : gbCategories) {
                categoryDefList.add(this.getCategoryDefinition(category));
            }
        }
        return categoryDefList;
    }

    private CategoryDefinition getCategoryDefinition(Category category) {
        CategoryDefinition categoryDef = new CategoryDefinition();
        if (category != null) {
            categoryDef.setId(category.getId());
            categoryDef.setName(category.getName());
            categoryDef.setWeight(category.getWeight());
            categoryDef.setAssignmentList(this.getAssignments(category.getGradebook().getUid(), category.getName()));
        }
        return categoryDef;
    }

    public boolean checkStuendsNotSubmitted(String gradebookUid) {
        return this.checkStudentsNotSubmitted(gradebookUid);
    }

    protected Map<String, List<AssignmentGradeRecord>> getGradeRecordMapForStudents(Session session, Long gradebookId, Collection<String> studentUids) {
        HashMap<String, List<AssignmentGradeRecord>> filteredGradeRecs = new HashMap<String, List<AssignmentGradeRecord>>();
        if (studentUids != null) {
            List allGradeRecs = new ArrayList();
            if (studentUids.size() >= MAX_NUMBER_OF_SQL_PARAMETERS_IN_LIST) {
                allGradeRecs = session.createQuery("from AssignmentGradeRecord agr where agr.gradableObject.gradebook.id=:gbid and agr.gradableObject.removed=false").setParameter("gbid", (Object)gradebookId).list();
            } else {
                String query = "from AssignmentGradeRecord agr where agr.gradableObject.gradebook.id=:gbid and agr.gradableObject.removed=false and agr.studentId in (:studentUids)";
                allGradeRecs = session.createQuery(query).setParameter("gbid", (Object)gradebookId).setParameterList("studentUids", studentUids).list();
            }
            if (allGradeRecs != null) {
                for (AssignmentGradeRecord gradeRec : allGradeRecs) {
                    if (!studentUids.contains(gradeRec.getStudentId())) continue;
                    String studentId = gradeRec.getStudentId();
                    ArrayList<AssignmentGradeRecord> gradeRecList = (ArrayList<AssignmentGradeRecord>)filteredGradeRecs.get(studentId);
                    if (gradeRecList == null) {
                        gradeRecList = new ArrayList<AssignmentGradeRecord>();
                        gradeRecList.add(gradeRec);
                        filteredGradeRecs.put(studentId, gradeRecList);
                        continue;
                    }
                    gradeRecList.add(gradeRec);
                    filteredGradeRecs.put(studentId, gradeRecList);
                }
            }
        }
        return filteredGradeRecs;
    }

    protected List<org.sakaiproject.tool.gradebook.Assignment> getCountedAssignments(Session session, Long gradebookId) {
        ArrayList<org.sakaiproject.tool.gradebook.Assignment> assignList = new ArrayList<org.sakaiproject.tool.gradebook.Assignment>();
        List results = session.createQuery("from Assignment as asn where asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false").setParameter("gbid", (Object)gradebookId).list();
        if (results != null) {
            for (org.sakaiproject.tool.gradebook.Assignment a : results) {
                if (a.getPointsPossible() == null || !(a.getPointsPossible() > 0.0)) continue;
                assignList.add(a);
            }
        }
        return assignList;
    }

    public void applyDropScores(Collection<AssignmentGradeRecord> gradeRecords) {
        if (gradeRecords == null || gradeRecords.size() < 1) {
            return;
        }
        long start = System.currentTimeMillis();
        ArrayList<String> studentIds = new ArrayList<String>();
        ArrayList<Category> categories = new ArrayList<Category>();
        HashMap<String, ArrayList<AssignmentGradeRecord>> gradeRecordMap = new HashMap<String, ArrayList<AssignmentGradeRecord>>();
        for (AssignmentGradeRecord gradeRecord : gradeRecords) {
            ArrayList<AssignmentGradeRecord> gradeRecordsByCatAndStudent;
            Category cat;
            if (gradeRecord == null || gradeRecord.getPointsEarned() == null) continue;
            gradeRecord.setDroppedFromGrade(Boolean.valueOf(false));
            org.sakaiproject.tool.gradebook.Assignment assignment = gradeRecord.getAssignment();
            if (assignment.getUngraded() || assignment.isNotCounted() || assignment.getItemType().equals(org.sakaiproject.tool.gradebook.Assignment.item_type_adjustment) || assignment.isRemoved()) continue;
            String studentId = gradeRecord.getStudentId();
            if (!studentIds.contains(studentId)) {
                studentIds.add(studentId);
            }
            if ((cat = gradeRecord.getAssignment().getCategory()) == null) continue;
            if (!categories.contains(cat)) {
                categories.add(cat);
            }
            if ((gradeRecordsByCatAndStudent = (ArrayList<AssignmentGradeRecord>)gradeRecordMap.get(studentId + cat.getId())) == null) {
                gradeRecordsByCatAndStudent = new ArrayList<AssignmentGradeRecord>();
                gradeRecordsByCatAndStudent.add(gradeRecord);
                gradeRecordMap.put(studentId + cat.getId(), gradeRecordsByCatAndStudent);
                continue;
            }
            gradeRecordsByCatAndStudent.add(gradeRecord);
        }
        if (categories == null || categories.size() < 1) {
            return;
        }
        for (Category cat : categories) {
            Integer dropHighest = cat.getDropHighest();
            Integer dropLowest = cat.getDrop_lowest();
            Integer keepHighest = cat.getKeepHighest();
            Long catId = cat.getId();
            if (!(dropHighest != null && dropHighest > 0 || dropLowest != null && dropLowest > 0) && (keepHighest == null || keepHighest <= 0)) continue;
            for (String studentId : studentIds) {
                int i;
                ArrayList gradesByCategory = new ArrayList();
                List gradeRecordsByCatAndStudent = (List)gradeRecordMap.get(studentId + cat.getId());
                if (gradeRecordsByCatAndStudent == null) continue;
                gradesByCategory.addAll(gradeRecordsByCatAndStudent);
                int numGrades = gradesByCategory.size();
                if (dropHighest > 0 && numGrades > dropHighest + dropLowest) {
                    for (i = 0; i < dropHighest; ++i) {
                        AssignmentGradeRecord highest = (AssignmentGradeRecord)Collections.max(gradesByCategory, AssignmentGradeRecord.numericComparator);
                        highest.setDroppedFromGrade(Boolean.valueOf(true));
                        gradesByCategory.remove(highest);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("dropHighest applied to " + highest));
                    }
                }
                if (keepHighest > 0 && numGrades > gradesByCategory.size() - keepHighest) {
                    dropLowest = gradesByCategory.size() - keepHighest;
                }
                if (dropLowest <= 0 || numGrades <= dropLowest + dropHighest) continue;
                for (i = 0; i < dropLowest; ++i) {
                    AssignmentGradeRecord lowest = (AssignmentGradeRecord)Collections.min(gradesByCategory, AssignmentGradeRecord.numericComparator);
                    lowest.setDroppedFromGrade(Boolean.valueOf(true));
                    gradesByCategory.remove(lowest);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("dropLowest applied to " + lowest));
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("processed " + studentIds.size() + "students in category " + cat.getId()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("GradebookManager.applyDropScores took " + (System.currentTimeMillis() - start) + " millis to execute"));
        }
    }

    public GradebookService.PointsPossibleValidation isPointsPossibleValid(String gradebookUid, Assignment gradebookItem, Double pointsPossible) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("Null gradebookUid passed to isPointsPossibleValid");
        }
        if (gradebookItem == null) {
            throw new IllegalArgumentException("Null gradebookItem passed to isPointsPossibleValid");
        }
        if (pointsPossible == null) {
            return GradebookService.PointsPossibleValidation.INVALID_NULL_VALUE;
        }
        if (pointsPossible <= 0.0) {
            return GradebookService.PointsPossibleValidation.INVALID_NUMERIC_VALUE;
        }
        BigDecimal bd = new BigDecimal(pointsPossible);
        bd = bd.setScale(2, 4);
        double roundedVal = bd.doubleValue();
        double diff = pointsPossible - roundedVal;
        if (diff != 0.0) {
            return GradebookService.PointsPossibleValidation.INVALID_DECIMAL;
        }
        return GradebookService.PointsPossibleValidation.VALID;
    }

    private Double convertStringToDouble(String doubleAsString) {
        Double scoreAsDouble = null;
        if (doubleAsString != null) {
            try {
                NumberFormat numberFormat = NumberFormat.getInstance(new ResourceLoader().getLocale());
                Number numericScore = numberFormat.parse(doubleAsString.trim());
                scoreAsDouble = numericScore.doubleValue();
            }
            catch (ParseException e) {
                log.error((Object)e);
            }
        }
        return scoreAsDouble;
    }

    private List<Assignment> getAssignments(String gradebookUid, String categoryName) {
        List<Assignment> allAssignments = this.getAssignments(gradebookUid);
        ArrayList<Assignment> matchingAssignments = new ArrayList<Assignment>();
        for (Assignment assignment : allAssignments) {
            if (!StringUtils.equals((String)assignment.getCategoryName(), (String)categoryName)) continue;
            matchingAssignments.add(assignment);
        }
        return matchingAssignments;
    }
}

