/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.gradebook;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.component.gradebook.BaseHibernateManager;
import org.sakaiproject.service.gradebook.shared.GradebookExistsException;
import org.sakaiproject.service.gradebook.shared.GradebookFrameworkService;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.service.gradebook.shared.GradingScaleDefinition;
import org.sakaiproject.tool.gradebook.CourseGrade;
import org.sakaiproject.tool.gradebook.GradeMapping;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradingScale;
import org.sakaiproject.tool.gradebook.LetterGradeMapping;
import org.sakaiproject.tool.gradebook.LetterGradePercentMapping;
import org.sakaiproject.tool.gradebook.LetterGradePlusMinusMapping;
import org.sakaiproject.tool.gradebook.PassNotPassMapping;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class GradebookFrameworkServiceImpl
extends BaseHibernateManager
implements GradebookFrameworkService {
    private static final Log log = LogFactory.getLog(GradebookFrameworkServiceImpl.class);
    public static final String UID_OF_DEFAULT_GRADING_SCALE_PROPERTY = "uidOfDefaultGradingScale";
    public static final String PROP_COURSE_POINTS_DISPLAYED = "gradebook.coursepoints.displayed";
    public static final String PROP_COURSE_GRADE_DISPLAYED = "gradebook.coursegrade.displayed";
    public static final String PROP_ASSIGNMENTS_DISPLAYED = "gradebook.assignments.displayed";

    public void addGradebook(final String uid, final String name) {
        if (this.isGradebookDefined(uid)) {
            log.warn((Object)("You can not add a gradebook with uid=" + uid + ".  That gradebook already exists."));
            throw new GradebookExistsException("You can not add a gradebook with uid=" + uid + ".  That gradebook already exists.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding gradebook uid=" + uid + " by userUid=" + this.getUserUid()));
        }
        this.createDefaultLetterGradeMapping(this.getHardDefaultLetterMapping());
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List gradingScales = session.createQuery("from GradingScale as gradingScale where gradingScale.unavailable=false").list();
                if (gradingScales.isEmpty()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"No Grading Scale defined yet. This is probably because you have upgraded or you are working with a new database. Default grading scales will be created. Any customized system-wide grade mappings you may have defined in previous versions will have to be reconfigured.");
                    }
                    gradingScales = GradebookFrameworkServiceImpl.this.addDefaultGradingScales(session);
                }
                Gradebook gradebook = new Gradebook(name);
                gradebook.setUid(uid);
                session.save((Object)gradebook);
                CourseGrade cg = new CourseGrade();
                cg.setGradebook(gradebook);
                session.save((Object)cg);
                Boolean propAssignmentsDisplayed = GradebookFrameworkServiceImpl.this.serverConfigurationService.getBoolean(GradebookFrameworkServiceImpl.PROP_ASSIGNMENTS_DISPLAYED, true);
                gradebook.setAssignmentsDisplayed(propAssignmentsDisplayed.booleanValue());
                Boolean propCourseGradeDisplayed = GradebookFrameworkServiceImpl.this.serverConfigurationService.getBoolean(GradebookFrameworkServiceImpl.PROP_COURSE_GRADE_DISPLAYED, false);
                gradebook.setCourseGradeDisplayed(propCourseGradeDisplayed.booleanValue());
                Boolean propCoursePointsDisplayed = GradebookFrameworkServiceImpl.this.serverConfigurationService.getBoolean(GradebookFrameworkServiceImpl.PROP_COURSE_POINTS_DISPLAYED, false);
                String defaultScaleUid = GradebookFrameworkServiceImpl.this.getPropertyValue(GradebookFrameworkServiceImpl.UID_OF_DEFAULT_GRADING_SCALE_PROPERTY);
                GradeMapping defaultGradeMapping = null;
                HashSet<GradeMapping> gradeMappings = new HashSet<GradeMapping>();
                for (GradingScale gradingScale : gradingScales) {
                    GradeMapping gradeMapping = new GradeMapping(gradingScale);
                    gradeMapping.setGradebook(gradebook);
                    session.save((Object)gradeMapping);
                    gradeMappings.add(gradeMapping);
                    if (!gradingScale.getUid().equals(defaultScaleUid)) continue;
                    defaultGradeMapping = gradeMapping;
                }
                if (defaultGradeMapping == null) {
                    defaultGradeMapping = (GradeMapping)gradeMappings.iterator().next();
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("No default GradeMapping found for new Gradebook=" + gradebook.getUid() + "; will set default to " + defaultGradeMapping.getName()));
                    }
                }
                gradebook.setSelectedGradeMapping(defaultGradeMapping);
                gradebook.setGradeMappings(gradeMappings);
                gradebook.setGrade_type(1);
                gradebook.setCategory_type(1);
                session.update((Object)gradebook);
                return null;
            }
        });
    }

    private List addDefaultGradingScales(Session session) throws HibernateException {
        ArrayList<GradingScale> gradingScales = new ArrayList<GradingScale>();
        GradeMapping[] oldGradeMappings = new GradeMapping[]{new LetterGradeMapping(), new LetterGradePlusMinusMapping(), new PassNotPassMapping()};
        for (int i = 0; i < oldGradeMappings.length; ++i) {
            GradeMapping sampleMapping = oldGradeMappings[i];
            sampleMapping.setDefaultValues();
            GradingScale gradingScale = new GradingScale();
            String uid = sampleMapping.getClass().getName();
            uid = uid.substring(uid.lastIndexOf(46) + 1);
            gradingScale.setUid(uid);
            gradingScale.setUnavailable(false);
            gradingScale.setName(sampleMapping.getName());
            gradingScale.setGrades(new ArrayList(sampleMapping.getGrades()));
            gradingScale.setDefaultBottomPercents(new HashMap(sampleMapping.getGradeMap()));
            session.save((Object)gradingScale);
            if (log.isInfoEnabled()) {
                log.info((Object)("Added Grade Mapping " + gradingScale.getUid()));
            }
            gradingScales.add(gradingScale);
        }
        this.setDefaultGradingScale("LetterGradePlusMinusMapping");
        session.flush();
        return gradingScales;
    }

    public void setAvailableGradingScales(final Collection gradingScaleDefinitions) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                GradebookFrameworkServiceImpl.this.mergeGradeMappings(gradingScaleDefinitions, session);
                return null;
            }
        });
    }

    public void setDefaultGradingScale(String uid) {
        this.setPropertyValue(UID_OF_DEFAULT_GRADING_SCALE_PROPERTY, uid);
    }

    private void copyDefinitionToScale(GradingScaleDefinition bean, GradingScale gradingScale) {
        gradingScale.setUnavailable(false);
        gradingScale.setName(bean.getName());
        gradingScale.setGrades(bean.getGrades());
        HashMap<String, Double> defaultBottomPercents = new HashMap<String, Double>();
        Iterator gradesIter = bean.getGrades().iterator();
        Iterator defaultBottomPercentsIter = bean.getDefaultBottomPercents().iterator();
        while (gradesIter.hasNext() && defaultBottomPercentsIter.hasNext()) {
            String grade = (String)gradesIter.next();
            Double value = (Double)defaultBottomPercentsIter.next();
            defaultBottomPercents.put(grade, value);
        }
        gradingScale.setDefaultBottomPercents(defaultBottomPercents);
    }

    private void mergeGradeMappings(Collection gradingScaleDefinitions, Session session) throws HibernateException {
        HashMap<String, GradingScaleDefinition> newMappingDefinitionsMap = new HashMap<String, GradingScaleDefinition>();
        HashSet<String> uidsToSet = new HashSet<String>();
        for (GradingScaleDefinition bean : gradingScaleDefinitions) {
            newMappingDefinitionsMap.put(bean.getUid(), bean);
            uidsToSet.add(bean.getUid());
        }
        Query q = session.createQuery("from GradingScale as gradingScale where gradingScale.uid not in (:uidList) and gradingScale.unavailable=false");
        q.setParameterList("uidList", uidsToSet);
        List gmtList = q.list();
        for (GradingScale gradingScale : gmtList) {
            gradingScale.setUnavailable(true);
            session.update((Object)gradingScale);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Set Grading Scale " + gradingScale.getUid() + " unavailable"));
        }
        q = session.createQuery("from GradingScale as gradingScale where gradingScale.uid in (:uidList)");
        q.setParameterList("uidList", uidsToSet);
        gmtList = q.list();
        for (GradingScale gradingScale : gmtList) {
            this.copyDefinitionToScale((GradingScaleDefinition)newMappingDefinitionsMap.get(gradingScale.getUid()), gradingScale);
            uidsToSet.remove(gradingScale.getUid());
            session.update((Object)gradingScale);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Updated Grading Scale " + gradingScale.getUid()));
        }
        for (String uid : uidsToSet) {
            GradingScale gradingScale = new GradingScale();
            gradingScale.setUid(uid);
            GradingScaleDefinition bean = (GradingScaleDefinition)newMappingDefinitionsMap.get(uid);
            this.copyDefinitionToScale(bean, gradingScale);
            session.save((Object)gradingScale);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Added Grading Scale " + gradingScale.getUid()));
        }
        session.flush();
    }

    public void deleteGradebook(String uid) throws GradebookNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting gradebook uid=" + uid + " by userUid=" + this.getUserUid()));
        }
        Long gradebookId = this.getGradebook(uid).getId();
        HibernateTemplate hibTempl = this.getHibernateTemplate();
        List toBeDeleted = hibTempl.find("from GradingEvent as ge where ge.gradableObject.gradebook.id=?", (Object)gradebookId);
        int numberDeleted = toBeDeleted.size();
        hibTempl.deleteAll((Collection)toBeDeleted);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted " + numberDeleted + " grading events"));
        }
        toBeDeleted = hibTempl.find("from AbstractGradeRecord as gr where gr.gradableObject.gradebook.id=?", (Object)gradebookId);
        numberDeleted = toBeDeleted.size();
        hibTempl.deleteAll((Collection)toBeDeleted);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted " + numberDeleted + " grade records"));
        }
        toBeDeleted = hibTempl.find("from GradableObject as go where go.gradebook.id=?", (Object)gradebookId);
        numberDeleted = toBeDeleted.size();
        hibTempl.deleteAll((Collection)toBeDeleted);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted " + numberDeleted + " gradable objects"));
        }
        Gradebook gradebook = (Gradebook)hibTempl.load(Gradebook.class, (Serializable)gradebookId);
        gradebook.setSelectedGradeMapping(null);
        toBeDeleted = hibTempl.find("from GradeMapping as gm where gm.gradebook.id=?", (Object)gradebookId);
        numberDeleted = toBeDeleted.size();
        hibTempl.deleteAll((Collection)toBeDeleted);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted " + numberDeleted + " grade mappings"));
        }
        hibTempl.delete((Object)gradebook);
        hibTempl.flush();
        hibTempl.clear();
    }

    private void createDefaultLetterGradeMapping(final Map gradeMap) {
        if (this.getDefaultLetterGradePercentMapping() == null) {
            Set keySet = gradeMap.keySet();
            if (keySet.size() != GradebookService.validLetterGrade.length) {
                throw new IllegalArgumentException("gradeMap doesn't have right size in BaseHibernateManager.createDefaultLetterGradePercentMapping");
            }
            if (!this.validateLetterGradeMapping(gradeMap)) {
                throw new IllegalArgumentException("gradeMap contains invalid letter in BaseHibernateManager.createDefaultLetterGradePercentMapping");
            }
            HibernateCallback hc = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    LetterGradePercentMapping lgpm = new LetterGradePercentMapping();
                    session.save((Object)lgpm);
                    HashMap saveMap = new HashMap();
                    for (String key : gradeMap.keySet()) {
                        saveMap.put(key, gradeMap.get(key));
                    }
                    if (lgpm != null) {
                        lgpm.setGradeMap(saveMap);
                        lgpm.setMappingType(1);
                        session.update((Object)lgpm);
                    }
                    return null;
                }
            };
            this.getHibernateTemplate().execute(hc);
        }
    }

    private Map getHardDefaultLetterMapping() {
        HashMap<String, Double> gradeMap = new HashMap<String, Double>();
        gradeMap.put("A+", 100.0);
        gradeMap.put("A", 95.0);
        gradeMap.put("A-", 90.0);
        gradeMap.put("B+", 87.0);
        gradeMap.put("B", 83.0);
        gradeMap.put("B-", 80.0);
        gradeMap.put("C+", 77.0);
        gradeMap.put("C", 73.0);
        gradeMap.put("C-", 70.0);
        gradeMap.put("D+", 67.0);
        gradeMap.put("D", 63.0);
        gradeMap.put("D-", 60.0);
        gradeMap.put("F", 0.0);
        return gradeMap;
    }
}

