/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.gradebook;

import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.component.gradebook.BaseHibernateManager;
import org.sakaiproject.service.gradebook.shared.AssessmentNotFoundException;
import org.sakaiproject.service.gradebook.shared.Assignment;
import org.sakaiproject.service.gradebook.shared.AssignmentHasIllegalPointsException;
import org.sakaiproject.service.gradebook.shared.CommentDefinition;
import org.sakaiproject.service.gradebook.shared.ConflictingAssignmentNameException;
import org.sakaiproject.service.gradebook.shared.ConflictingExternalIdException;
import org.sakaiproject.service.gradebook.shared.ExternalAssignmentProvider;
import org.sakaiproject.service.gradebook.shared.ExternalAssignmentProviderCompat;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.service.gradebook.shared.InvalidCategoryException;
import org.sakaiproject.tool.gradebook.AssignmentGradeRecord;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.facades.EventTrackingService;
import org.sakaiproject.util.ResourceLoader;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class GradebookExternalAssessmentServiceImpl
extends BaseHibernateManager
implements GradebookExternalAssessmentService {
    private static final Log log = LogFactory.getLog(GradebookExternalAssessmentServiceImpl.class);
    private static final Log logData = LogFactory.getLog((String)(GradebookExternalAssessmentServiceImpl.class.getName() + ".GB_DATA"));
    private GradebookService gradebookService;
    private EventTrackingService eventTrackingService;
    private ConcurrentHashMap<String, ExternalAssignmentProvider> externalProviders = new ConcurrentHashMap();
    private ConcurrentHashMap<ExternalAssignmentProvider, Method> providerMethods = new ConcurrentHashMap();
    public static final String UPDATE_SAME_SCORE_PROP = "gradebook.externalAssessments.updateSameScore";

    @Override
    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public void setGradebookService(GradebookService gradebookService) {
        this.gradebookService = gradebookService;
    }

    public GradebookService getGradebookService() {
        return (GradebookService)ComponentManager.get((String)"org.sakaiproject.service.gradebook.GradebookService");
    }

    public ConcurrentHashMap<String, ExternalAssignmentProvider> getExternalAssignmentProviders() {
        if (this.externalProviders == null) {
            this.externalProviders = new ConcurrentHashMap(0);
        }
        return this.externalProviders;
    }

    public void registerExternalAssignmentProvider(ExternalAssignmentProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.getExternalAssignmentProviders().put(provider.getAppKey(), provider);
        if (!(provider instanceof ExternalAssignmentProviderCompat)) {
            try {
                Method m = provider.getClass().getDeclaredMethod("getAllExternalAssignments", String.class);
                if (m.getReturnType().equals(List.class)) {
                    this.providerMethods.put(provider, m);
                }
            }
            catch (Exception e) {
                log.warn((Object)("ExternalAssignmentProvider [" + provider.getAppKey() + " / " + provider.getClass().toString() + "] does not implement getAllExternalAssignments. It will not be able to exclude items from student views/grades. " + "See the ExternalAssignmentProviderCompat interface and SAK-23733 for details."));
            }
        }
    }

    public void unregisterExternalAssignmentProvider(String providerAppKey) {
        if (providerAppKey == null || "".equals(providerAppKey)) {
            throw new IllegalArgumentException("providerAppKey must be set");
        }
        if (this.getExternalAssignmentProviders().containsKey(providerAppKey)) {
            ExternalAssignmentProvider provider = this.getExternalAssignmentProviders().get(providerAppKey);
            this.providerMethods.remove(provider);
            this.getExternalAssignmentProviders().remove(providerAppKey);
        }
    }

    public void init() {
        log.info((Object)"INIT");
    }

    public void destroy() {
        log.info((Object)"DESTROY");
        if (this.externalProviders != null) {
            this.externalProviders.clear();
            this.externalProviders = null;
        }
    }

    public void addExternalAssessment(final String gradebookUid, final String externalId, final String externalUrl, final String title, final double points, final Date dueDate, final String externalServiceDescription) throws ConflictingAssignmentNameException, ConflictingExternalIdException, GradebookNotFoundException {
        if (StringUtils.trimToNull((String)externalServiceDescription) == null || StringUtils.trimToNull((String)externalId) == null || StringUtils.trimToNull((String)title) == null) {
            throw new RuntimeException("External service description, externalId, and title must not be empty");
        }
        if (points <= 0.0) {
            throw new AssignmentHasIllegalPointsException("Points must be > 0");
        }
        if (this.isAssignmentDefined(gradebookUid, title)) {
            throw new ConflictingAssignmentNameException("An assignment with that name already exists in gradebook uid=" + gradebookUid);
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List conflictList = session.createQuery("select asn from Assignment as asn where asn.externalId=? and asn.gradebook.uid=?").setString(0, externalId).setString(1, gradebookUid).list();
                Integer externalIdConflicts = conflictList.size();
                if (externalIdConflicts > 0) {
                    throw new ConflictingExternalIdException("An external assessment with that ID already exists in gradebook uid=" + gradebookUid);
                }
                Gradebook gradebook = GradebookExternalAssessmentServiceImpl.this.getGradebook(gradebookUid);
                org.sakaiproject.tool.gradebook.Assignment asn = new org.sakaiproject.tool.gradebook.Assignment(gradebook, title, Double.valueOf(points), dueDate);
                asn.setExternallyMaintained(true);
                asn.setExternalId(externalId);
                asn.setExternalInstructorLink(externalUrl);
                asn.setExternalStudentLink(externalUrl);
                asn.setExternalAppName(externalServiceDescription);
                asn.setReleased(true);
                asn.setUngraded(false);
                session.save((Object)asn);
                return null;
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)("External assessment added to gradebookUid=" + gradebookUid + ", externalId=" + externalId + " by userUid=" + this.getUserUid() + " from externalApp=" + externalServiceDescription));
        }
    }

    public void updateExternalAssessment(final String gradebookUid, final String externalId, final String externalUrl, final String title, final double points, final Date dueDate) throws GradebookNotFoundException, AssessmentNotFoundException, AssignmentHasIllegalPointsException {
        final org.sakaiproject.tool.gradebook.Assignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        if (points <= 0.0) {
            throw new AssignmentHasIllegalPointsException("Points must be > 0");
        }
        if (StringUtils.trimToNull((String)externalId) == null || StringUtils.trimToNull((String)title) == null) {
            throw new RuntimeException("ExternalId, and title must not be empty");
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                asn.setExternalInstructorLink(externalUrl);
                asn.setExternalStudentLink(externalUrl);
                asn.setName(title);
                asn.setDueDate(dueDate);
                asn.setReleased(true);
                asn.setPointsPossible(Double.valueOf(points));
                session.update((Object)asn);
                if (log.isInfoEnabled()) {
                    log.info((Object)("External assessment updated in gradebookUid=" + gradebookUid + ", externalId=" + externalId + " by userUid=" + GradebookExternalAssessmentServiceImpl.this.getUserUid()));
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
    }

    public void removeExternalAssessment(String gradebookUid, String externalId) throws GradebookNotFoundException, AssessmentNotFoundException {
        org.sakaiproject.tool.gradebook.Assignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no external assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        HibernateTemplate hibTempl = this.getHibernateTemplate();
        List toBeDeletedEvents = hibTempl.find("from GradingEvent as ge where ge.gradableObject=?", (Object)asn);
        int numberDeletedEvents = toBeDeletedEvents.size();
        hibTempl.deleteAll((Collection)toBeDeletedEvents);
        if (logData.isDebugEnabled()) {
            logData.debug((Object)("Deleted " + numberDeletedEvents + "records from gb_grading_event_t"));
        }
        List toBeDeleted = hibTempl.find("from AssignmentGradeRecord as agr where agr.gradableObject=?", (Object)asn);
        int numberDeleted = toBeDeleted.size();
        hibTempl.deleteAll((Collection)toBeDeleted);
        if (log.isInfoEnabled()) {
            log.info((Object)("Deleted " + numberDeleted + " externally defined scores"));
        }
        toBeDeleted = hibTempl.find("from Comment as c where c.gradableObject = ?", (Object)asn);
        hibTempl.deleteAll((Collection)toBeDeleted);
        if (log.isInfoEnabled()) {
            log.info((Object)("Deleted " + toBeDeleted.size() + " externally defined score comments"));
        }
        hibTempl.flush();
        hibTempl.clear();
        hibTempl.delete((Object)asn);
        if (log.isInfoEnabled()) {
            log.info((Object)("External assessment removed from gradebookUid=" + gradebookUid + ", externalId=" + externalId + " by userUid=" + this.getUserUid()));
        }
    }

    private org.sakaiproject.tool.gradebook.Assignment getExternalAssignment(String gradebookUid, final String externalId) throws GradebookNotFoundException {
        final Gradebook gradebook = this.getGradebook(gradebookUid);
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery("from Assignment as asn where asn.gradebook=? and asn.externalId=?").setEntity(0, (Object)gradebook).setString(1, externalId).uniqueResult();
            }
        };
        return (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(hc);
    }

    public void updateExternalAssessmentComments(final String gradebookUid, String externalId, final Map<String, String> studentUidsToComments) throws GradebookNotFoundException, AssessmentNotFoundException {
        final org.sakaiproject.tool.gradebook.Assignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        final Set<String> studentIds = studentUidsToComments.keySet();
        if (studentIds.isEmpty()) {
            return;
        }
        Date now = new Date();
        String graderId = this.getUserUid();
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List existingScores;
                Query q;
                if (studentIds.size() <= BaseHibernateManager.MAX_NUMBER_OF_SQL_PARAMETERS_IN_LIST) {
                    q = session.createQuery("from AssignmentGradeRecord as gr where gr.gradableObject=:go and gr.studentId in (:studentIds)");
                    q.setParameter("go", (Object)asn);
                    q.setParameterList("studentIds", (Collection)studentIds);
                    existingScores = q.list();
                } else {
                    q = session.createQuery("from AssignmentGradeRecord as gr where gr.gradableObject=:go");
                    q.setParameter("go", (Object)asn);
                    existingScores = GradebookExternalAssessmentServiceImpl.this.filterGradeRecordsByStudents(q.list(), studentIds);
                }
                HashSet<String> changedStudents = new HashSet<String>();
                for (AssignmentGradeRecord agr : existingScores) {
                    String studentUid = agr.getStudentId();
                    boolean alwaysUpdate = ServerConfigurationService.getBoolean((String)GradebookExternalAssessmentServiceImpl.UPDATE_SAME_SCORE_PROP, (boolean)false);
                    CommentDefinition gradeComment = GradebookExternalAssessmentServiceImpl.this.getAssignmentScoreComment(gradebookUid, asn.getId(), studentUid);
                    String oldComment = gradeComment != null ? gradeComment.getCommentText() : null;
                    String newComment = (String)studentUidsToComments.get(studentUid);
                    if (!alwaysUpdate && (newComment == null || newComment.equals(oldComment)) && (newComment != null || oldComment == null)) continue;
                    changedStudents.add(studentUid);
                    GradebookExternalAssessmentServiceImpl.this.setAssignmentScoreComment(gradebookUid, asn.getId(), studentUid, newComment);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("updateExternalAssessmentScores sent " + studentIds.size() + " records, actually changed " + changedStudents.size()));
                }
                session.flush();
                session.clear();
                return null;
            }
        });
    }

    public void updateExternalAssessmentScores(final String gradebookUid, String externalId, final Map<String, Double> studentUidsToScores) throws GradebookNotFoundException, AssessmentNotFoundException {
        final org.sakaiproject.tool.gradebook.Assignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        final Set<String> studentIds = studentUidsToScores.keySet();
        if (studentIds.isEmpty()) {
            return;
        }
        final Date now = new Date();
        final String graderId = this.getUserUid();
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List existingScores;
                Query q;
                if (studentIds.size() <= BaseHibernateManager.MAX_NUMBER_OF_SQL_PARAMETERS_IN_LIST) {
                    q = session.createQuery("from AssignmentGradeRecord as gr where gr.gradableObject=:go and gr.studentId in (:studentIds)");
                    q.setParameter("go", (Object)assignment);
                    q.setParameterList("studentIds", (Collection)studentIds);
                    existingScores = q.list();
                } else {
                    q = session.createQuery("from AssignmentGradeRecord as gr where gr.gradableObject=:go");
                    q.setParameter("go", (Object)assignment);
                    existingScores = GradebookExternalAssessmentServiceImpl.this.filterGradeRecordsByStudents(q.list(), studentIds);
                }
                HashSet previouslyUnscoredStudents = new HashSet(studentIds);
                HashSet<String> changedStudents = new HashSet<String>();
                for (AssignmentGradeRecord agr : existingScores) {
                    String studentUid = agr.getStudentId();
                    previouslyUnscoredStudents.remove(studentUid);
                    boolean alwaysUpdate = ServerConfigurationService.getBoolean((String)GradebookExternalAssessmentServiceImpl.UPDATE_SAME_SCORE_PROP, (boolean)false);
                    Double oldPointsEarned = agr.getPointsEarned();
                    Double newPointsEarned = (Double)studentUidsToScores.get(studentUid);
                    if (!alwaysUpdate && (newPointsEarned == null || newPointsEarned.equals(oldPointsEarned)) && (newPointsEarned != null || oldPointsEarned == null)) continue;
                    agr.setDateRecorded(now);
                    agr.setGraderId(graderId);
                    agr.setPointsEarned(newPointsEarned);
                    session.update((Object)agr);
                    changedStudents.add(studentUid);
                    GradebookExternalAssessmentServiceImpl.this.postUpdateGradeEvent(gradebookUid, assignment.getName(), studentUid, newPointsEarned);
                }
                for (String studentUid : previouslyUnscoredStudents) {
                    Double newPointsEarned = (Double)studentUidsToScores.get(studentUid);
                    if (newPointsEarned == null) continue;
                    AssignmentGradeRecord agr = new AssignmentGradeRecord(assignment, studentUid, newPointsEarned);
                    agr.setDateRecorded(now);
                    agr.setGraderId(graderId);
                    session.save((Object)agr);
                    changedStudents.add(studentUid);
                    GradebookExternalAssessmentServiceImpl.this.postUpdateGradeEvent(gradebookUid, assignment.getName(), studentUid, newPointsEarned);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("updateExternalAssessmentScores sent " + studentIds.size() + " records, actually changed " + changedStudents.size()));
                }
                session.flush();
                session.clear();
                return null;
            }
        });
    }

    public void updateExternalAssessmentScoresString(final String gradebookUid, String externalId, final Map<String, String> studentUidsToScores) throws GradebookNotFoundException, AssessmentNotFoundException {
        final org.sakaiproject.tool.gradebook.Assignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        final Set<String> studentIds = studentUidsToScores.keySet();
        if (studentIds.isEmpty()) {
            return;
        }
        final Date now = new Date();
        final String graderId = this.getUserUid();
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List existingScores;
                Query q;
                if (studentIds.size() <= BaseHibernateManager.MAX_NUMBER_OF_SQL_PARAMETERS_IN_LIST) {
                    q = session.createQuery("from AssignmentGradeRecord as gr where gr.gradableObject=:go and gr.studentId in (:studentIds)");
                    q.setParameter("go", (Object)assignment);
                    q.setParameterList("studentIds", (Collection)studentIds);
                    existingScores = q.list();
                } else {
                    q = session.createQuery("from AssignmentGradeRecord as gr where gr.gradableObject=:go");
                    q.setParameter("go", (Object)assignment);
                    existingScores = GradebookExternalAssessmentServiceImpl.this.filterGradeRecordsByStudents(q.list(), studentIds);
                }
                HashSet previouslyUnscoredStudents = new HashSet(studentIds);
                HashSet<String> changedStudents = new HashSet<String>();
                for (AssignmentGradeRecord agr : existingScores) {
                    Double newPointsEarned;
                    String studentUid = agr.getStudentId();
                    previouslyUnscoredStudents.remove(studentUid);
                    boolean alwaysUpdate = ServerConfigurationService.getBoolean((String)GradebookExternalAssessmentServiceImpl.UPDATE_SAME_SCORE_PROP, (boolean)false);
                    Double oldPointsEarned = agr.getPointsEarned();
                    String newPointsEarnedString = (String)studentUidsToScores.get(studentUid);
                    Double d = newPointsEarned = newPointsEarnedString == null ? null : GradebookExternalAssessmentServiceImpl.this.convertStringToDouble(newPointsEarnedString);
                    if (!alwaysUpdate && (newPointsEarned == null || newPointsEarned.equals(oldPointsEarned)) && (newPointsEarned != null || oldPointsEarned == null)) continue;
                    agr.setDateRecorded(now);
                    agr.setGraderId(graderId);
                    if (newPointsEarned != null) {
                        agr.setPointsEarned(Double.valueOf(newPointsEarned));
                    } else {
                        agr.setPointsEarned(null);
                    }
                    session.update((Object)agr);
                    changedStudents.add(studentUid);
                    GradebookExternalAssessmentServiceImpl.this.postUpdateGradeEvent(gradebookUid, assignment.getName(), studentUid, newPointsEarned);
                }
                for (String studentUid : previouslyUnscoredStudents) {
                    String newPointsEarned = (String)studentUidsToScores.get(studentUid);
                    if (newPointsEarned == null) continue;
                    AssignmentGradeRecord agr = new AssignmentGradeRecord(assignment, studentUid, GradebookExternalAssessmentServiceImpl.this.convertStringToDouble(newPointsEarned));
                    agr.setDateRecorded(now);
                    agr.setGraderId(graderId);
                    session.save((Object)agr);
                    changedStudents.add(studentUid);
                    GradebookExternalAssessmentServiceImpl.this.postUpdateGradeEvent(gradebookUid, assignment.getName(), studentUid, GradebookExternalAssessmentServiceImpl.this.convertStringToDouble(newPointsEarned));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("updateExternalAssessmentScores sent " + studentIds.size() + " records, actually changed " + changedStudents.size()));
                }
                session.flush();
                session.clear();
                return null;
            }
        });
    }

    public boolean isAssignmentDefined(final String gradebookUid, final String assignmentName) throws GradebookNotFoundException {
        org.sakaiproject.tool.gradebook.Assignment assignment = (org.sakaiproject.tool.gradebook.Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookExternalAssessmentServiceImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName, session);
            }
        });
        return assignment != null;
    }

    public boolean isExternalAssignmentDefined(String gradebookUid, String externalId) throws GradebookNotFoundException {
        org.sakaiproject.tool.gradebook.Assignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        return assignment != null;
    }

    public boolean isExternalAssignmentGrouped(String gradebookUid, String externalId) throws GradebookNotFoundException {
        org.sakaiproject.tool.gradebook.Assignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        boolean result = false;
        if (assignment == null) {
            result = false;
            log.info((Object)("No assignment found for external assignment check: gradebookUid=" + gradebookUid + ", externalId=" + externalId));
        } else {
            for (ExternalAssignmentProvider provider : this.getExternalAssignmentProviders().values()) {
                if (!provider.isAssignmentDefined(externalId)) continue;
                result = provider.isAssignmentGrouped(externalId);
            }
        }
        return result;
    }

    public boolean isExternalAssignmentVisible(String gradebookUid, String externalId, String userId) throws GradebookNotFoundException {
        org.sakaiproject.tool.gradebook.Assignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        boolean result = false;
        boolean providerResponded = false;
        if (assignment == null) {
            result = false;
            log.info((Object)("No assignment found for external assignment check: gradebookUid=" + gradebookUid + ", externalId=" + externalId));
        } else {
            for (ExternalAssignmentProvider provider : this.getExternalAssignmentProviders().values()) {
                if (!provider.isAssignmentDefined(externalId)) continue;
                providerResponded = true;
                result = result || provider.isAssignmentVisible(externalId, userId);
            }
        }
        return result || !providerResponded;
    }

    public Map<String, String> getExternalAssignmentsForCurrentUser(String gradebookUid) throws GradebookNotFoundException {
        Gradebook gradebook = this.getGradebook(gradebookUid);
        HashMap<String, String> visibleAssignments = new HashMap<String, String>();
        Set<String> providedAssignments = this.getProvidedExternalAssignments(gradebookUid);
        for (ExternalAssignmentProvider provider : this.getExternalAssignmentProviders().values()) {
            String appKey = provider.getAppKey();
            List assignments = provider.getExternalAssignmentsForCurrentUser(gradebookUid);
            for (String externalId : assignments) {
                visibleAssignments.put(externalId, appKey);
            }
        }
        List gbAssignments = this.getGradebookService().getViewableAssignmentsForCurrentUser(gradebookUid);
        for (Assignment assignment : gbAssignments) {
            String id = assignment.getExternalId();
            if (!assignment.isExternallyMaintained() || providedAssignments.contains(id) || visibleAssignments.containsKey(id)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("External assignment in gradebook [%s] is not handled by a provider; ID: %s", gradebookUid, id));
            }
            visibleAssignments.put(id, null);
        }
        return visibleAssignments;
    }

    protected Set<String> getProvidedExternalAssignments(String gradebookUid) {
        HashSet<String> allAssignments = new HashSet<String>();
        for (ExternalAssignmentProvider provider : this.getExternalAssignmentProviders().values()) {
            if (provider instanceof ExternalAssignmentProviderCompat) {
                allAssignments.addAll(((ExternalAssignmentProviderCompat)provider).getAllExternalAssignments(gradebookUid));
                continue;
            }
            if (!this.providerMethods.containsKey(provider)) continue;
            Method m = this.providerMethods.get(provider);
            try {
                List reflectedAssignments = (List)m.invoke((Object)provider, gradebookUid);
                allAssignments.addAll(reflectedAssignments);
            }
            catch (Exception e) {
                log.debug((Object)"Exception calling getAllExternalAssignments", (Throwable)e);
            }
        }
        return allAssignments;
    }

    public Map<String, List<String>> getVisibleExternalAssignments(String gradebookUid, Collection<String> studentIds) throws GradebookNotFoundException {
        Gradebook gradebook = this.getGradebook(gradebookUid);
        Set<String> providedAssignments = this.getProvidedExternalAssignments(gradebookUid);
        HashMap visible = new HashMap();
        for (String string : studentIds) {
            visible.put(string, new HashSet());
        }
        for (ExternalAssignmentProvider externalAssignmentProvider : this.getExternalAssignmentProviders().values()) {
            HashSet<String> studentIdsCopy = new HashSet<String>(studentIds);
            Map externals = externalAssignmentProvider.getAllExternalAssignments(gradebookUid, studentIdsCopy);
            for (String studentId : externals.keySet()) {
                if (!visible.containsKey(studentId)) continue;
                ((Set)visible.get(studentId)).addAll((Collection)externals.get(studentId));
            }
        }
        List allAssignments = this.getGradebookService().getViewableAssignmentsForCurrentUser(gradebookUid);
        for (Assignment assignment : allAssignments) {
            String id = assignment.getExternalId();
            if (!assignment.isExternallyMaintained() || providedAssignments.contains(id)) continue;
            for (String studentId : visible.keySet()) {
                ((Set)visible.get(studentId)).add(id);
            }
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String studentId : visible.keySet()) {
            hashMap.put(studentId, new ArrayList((Collection)visible.get(studentId)));
        }
        return hashMap;
    }

    public void setExternalAssessmentToGradebookAssignment(final String gradebookUid, final String externalId) {
        final org.sakaiproject.tool.gradebook.Assignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        assignment.setExternalAppName(null);
        assignment.setExternalId(null);
        assignment.setExternalInstructorLink(null);
        assignment.setExternalStudentLink(null);
        assignment.setExternallyMaintained(false);
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.update((Object)assignment);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Externally-managed assignment " + externalId + " moved to Gradebook management in gradebookUid=" + gradebookUid + " by userUid=" + GradebookExternalAssessmentServiceImpl.this.getUserUid()));
                }
                return null;
            }
        });
    }

    public void addExternalAssessment(String gradebookUid, String externalId, String externalUrl, String title, Double points, Date dueDate, String externalServiceDescription, Boolean ungraded) throws GradebookNotFoundException, ConflictingAssignmentNameException, ConflictingExternalIdException, AssignmentHasIllegalPointsException {
        this.addExternalAssessment(gradebookUid, externalId, externalUrl, title, points, dueDate, externalServiceDescription, ungraded, null);
    }

    public void addExternalAssessment(final String gradebookUid, final String externalId, final String externalUrl, final String title, final Double points, final Date dueDate, final String externalServiceDescription, final Boolean ungraded, final Long categoryId) throws GradebookNotFoundException, ConflictingAssignmentNameException, ConflictingExternalIdException, AssignmentHasIllegalPointsException {
        if (StringUtils.trimToNull((String)externalServiceDescription) == null || StringUtils.trimToNull((String)externalId) == null || StringUtils.trimToNull((String)title) == null) {
            throw new RuntimeException("External service description, externalId, and title must not be empty");
        }
        if (ungraded != null && !ungraded.booleanValue() && (points == null || points <= 0.0) || ungraded == null && (points == null || points <= 0.0)) {
            throw new AssignmentHasIllegalPointsException("Points can't be null or Points must be > 0");
        }
        if (this.isAssignmentDefined(gradebookUid, title)) {
            throw new ConflictingAssignmentNameException("An assignment with that name already exists in gradebook uid=" + gradebookUid);
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List conflictList = session.createQuery("select asn from Assignment as asn where asn.externalId=? and asn.gradebook.uid=?").setString(0, externalId).setString(1, gradebookUid).list();
                Integer externalIdConflicts = conflictList.size();
                if (externalIdConflicts > 0) {
                    throw new ConflictingExternalIdException("An external assessment with that ID already exists in gradebook uid=" + gradebookUid);
                }
                Gradebook gradebook = GradebookExternalAssessmentServiceImpl.this.getGradebook(gradebookUid);
                Category persistedCategory = null;
                if (categoryId != null && ((persistedCategory = GradebookExternalAssessmentServiceImpl.this.getCategory(categoryId)) == null || persistedCategory.isRemoved() || !persistedCategory.getGradebook().getId().equals(gradebook.getId()))) {
                    throw new InvalidCategoryException("The category with id " + categoryId + " is not valid for gradebook " + gradebook.getUid());
                }
                org.sakaiproject.tool.gradebook.Assignment asn = new org.sakaiproject.tool.gradebook.Assignment(gradebook, title, points, dueDate);
                asn.setExternallyMaintained(true);
                asn.setExternalId(externalId);
                asn.setExternalInstructorLink(externalUrl);
                asn.setExternalStudentLink(externalUrl);
                asn.setExternalAppName(externalServiceDescription);
                if (persistedCategory != null) {
                    asn.setCategory(persistedCategory);
                }
                asn.setReleased(true);
                if (ungraded != null) {
                    asn.setUngraded(ungraded.booleanValue());
                } else {
                    asn.setUngraded(false);
                }
                session.save((Object)asn);
                return null;
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)("External assessment added to gradebookUid=" + gradebookUid + ", externalId=" + externalId + " by userUid=" + this.getUserUid() + " from externalApp=" + externalServiceDescription));
        }
    }

    public void updateExternalAssessment(final String gradebookUid, final String externalId, final String externalUrl, final String title, final Double points, final Date dueDate, final Boolean ungraded) throws GradebookNotFoundException, AssessmentNotFoundException, ConflictingAssignmentNameException, AssignmentHasIllegalPointsException {
        final org.sakaiproject.tool.gradebook.Assignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        if (ungraded != null && !ungraded.booleanValue() && (points == null || points <= 0.0) || ungraded == null && (points == null || points <= 0.0)) {
            throw new AssignmentHasIllegalPointsException("Points can't be null or Points must be > 0");
        }
        if (StringUtils.trimToNull((String)externalId) == null || StringUtils.trimToNull((String)title) == null) {
            throw new RuntimeException("ExternalId, and title must not be empty");
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                asn.setExternalInstructorLink(externalUrl);
                asn.setExternalStudentLink(externalUrl);
                asn.setName(title);
                asn.setDueDate(dueDate);
                asn.setReleased(true);
                asn.setPointsPossible(points);
                if (ungraded != null) {
                    asn.setUngraded(ungraded.booleanValue());
                } else {
                    asn.setUngraded(false);
                }
                session.update((Object)asn);
                if (log.isInfoEnabled()) {
                    log.info((Object)("External assessment updated in gradebookUid=" + gradebookUid + ", externalId=" + externalId + " by userUid=" + GradebookExternalAssessmentServiceImpl.this.getUserUid()));
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
    }

    public void updateExternalAssessmentComment(final String gradebookUid, String externalId, final String studentUid, final String comment) throws GradebookNotFoundException, AssessmentNotFoundException {
        final org.sakaiproject.tool.gradebook.Assignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        if (logData.isDebugEnabled()) {
            logData.debug((Object)("BEGIN: Update 1 score for gradebookUid=" + gradebookUid + ", external assessment=" + externalId + " from " + asn.getExternalAppName()));
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                String oldComment;
                Date now = new Date();
                boolean alwaysUpdate = ServerConfigurationService.getBoolean((String)GradebookExternalAssessmentServiceImpl.UPDATE_SAME_SCORE_PROP, (boolean)false);
                CommentDefinition gradeComment = GradebookExternalAssessmentServiceImpl.this.getAssignmentScoreComment(gradebookUid, asn.getId(), studentUid);
                String string = oldComment = gradeComment != null ? gradeComment.getCommentText() : null;
                if (alwaysUpdate || comment != null && !comment.equals(oldComment) || comment == null && oldComment != null) {
                    if (comment != null) {
                        GradebookExternalAssessmentServiceImpl.this.setAssignmentScoreComment(gradebookUid, asn.getId(), studentUid, comment);
                    } else {
                        GradebookExternalAssessmentServiceImpl.this.setAssignmentScoreComment(gradebookUid, asn.getId(), studentUid, null);
                    }
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
        if (logData.isDebugEnabled()) {
            logData.debug((Object)("END: Update 1 score for gradebookUid=" + gradebookUid + ", external assessment=" + externalId + " from " + asn.getExternalAppName()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("External assessment comment updated in gradebookUid=" + gradebookUid + ", externalId=" + externalId + " by userUid=" + this.getUserUid() + ", new score=" + comment));
        }
    }

    public void updateExternalAssessmentScore(final String gradebookUid, String externalId, final String studentUid, final String points) throws GradebookNotFoundException, AssessmentNotFoundException {
        final org.sakaiproject.tool.gradebook.Assignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        if (logData.isDebugEnabled()) {
            logData.debug((Object)("BEGIN: Update 1 score for gradebookUid=" + gradebookUid + ", external assessment=" + externalId + " from " + asn.getExternalAppName()));
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Double newPointsEarned;
                Date now = new Date();
                AssignmentGradeRecord agr = GradebookExternalAssessmentServiceImpl.this.getAssignmentGradeRecord(asn, studentUid, session);
                boolean alwaysUpdate = ServerConfigurationService.getBoolean((String)GradebookExternalAssessmentServiceImpl.UPDATE_SAME_SCORE_PROP, (boolean)false);
                Double oldPointsEarned = agr == null ? null : agr.getPointsEarned();
                Double d = newPointsEarned = points == null ? null : GradebookExternalAssessmentServiceImpl.this.convertStringToDouble(points);
                if (alwaysUpdate || newPointsEarned != null && !newPointsEarned.equals(oldPointsEarned) || newPointsEarned == null && oldPointsEarned != null) {
                    if (agr == null) {
                        agr = newPointsEarned != null ? new AssignmentGradeRecord(asn, studentUid, Double.valueOf(newPointsEarned)) : new AssignmentGradeRecord(asn, studentUid, null);
                    } else if (newPointsEarned != null) {
                        agr.setPointsEarned(Double.valueOf(newPointsEarned));
                    } else {
                        agr.setPointsEarned(null);
                    }
                    agr.setDateRecorded(now);
                    agr.setGraderId(GradebookExternalAssessmentServiceImpl.this.getUserUid());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("About to save AssignmentGradeRecord id=" + agr.getId() + ", version=" + agr.getVersion() + ", studenttId=" + agr.getStudentId() + ", pointsEarned=" + agr.getPointsEarned()));
                    }
                    session.saveOrUpdate((Object)agr);
                    session.flush();
                    session.clear();
                    GradebookExternalAssessmentServiceImpl.this.postUpdateGradeEvent(gradebookUid, asn.getName(), studentUid, newPointsEarned);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Ignoring updateExternalAssessmentScore, since the new points value is the same as the old");
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
        if (logData.isDebugEnabled()) {
            logData.debug((Object)("END: Update 1 score for gradebookUid=" + gradebookUid + ", external assessment=" + externalId + " from " + asn.getExternalAppName()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("External assessment score updated in gradebookUid=" + gradebookUid + ", externalId=" + externalId + " by userUid=" + this.getUserUid() + ", new score=" + points));
        }
    }

    private void postUpdateGradeEvent(String gradebookUid, String assignmentName, String studentUid, Double pointsEarned) {
        if (this.eventTrackingService != null) {
            this.eventTrackingService.postEvent("gradebook.updateItemScore", "/gradebook/" + gradebookUid + "/" + assignmentName + "/" + studentUid + "/" + pointsEarned + "/student");
        }
    }

    private Double convertStringToDouble(String doubleAsString) {
        Double scoreAsDouble = null;
        if (doubleAsString != null && !"".equals(doubleAsString)) {
            try {
                DecimalFormat dcformat = (DecimalFormat)this.getNumberFormat();
                String decSeparator = dcformat.getDecimalFormatSymbols().getDecimalSeparator() + "";
                if (",".equals(decSeparator)) {
                    doubleAsString = doubleAsString.replace(".", ",");
                }
                Number numericScore = this.getNumberFormat().parse(doubleAsString.trim());
                scoreAsDouble = numericScore.doubleValue();
            }
            catch (ParseException e) {
                log.error((Object)e);
            }
        }
        return scoreAsDouble;
    }

    private NumberFormat getNumberFormat() {
        return NumberFormat.getInstance(new ResourceLoader().getLocale());
    }

    public Long getExternalAssessmentCategoryId(String gradebookUId, String externalId) {
        Long categoryId = null;
        org.sakaiproject.tool.gradebook.Assignment assignment = this.getExternalAssignment(gradebookUId, externalId);
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUId);
        }
        if (assignment.getCategory() != null) {
            categoryId = assignment.getCategory().getId();
        }
        return categoryId;
    }
}

