/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook.facades.sakai2impl;

import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.entity.api.ContextObserver;
import org.sakaiproject.entity.api.EntityTransferrer;
import org.sakaiproject.importer.api.HandlesImportable;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.service.gradebook.shared.Assignment;
import org.sakaiproject.service.gradebook.shared.GradebookFrameworkService;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.facades.sakai2impl.BaseEntityProducer;
import org.sakaiproject.tool.gradebook.facades.sakai2impl.XmlImportable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GradebookEntityProducer
extends BaseEntityProducer
implements ContextObserver,
EntityTransferrer,
HandlesImportable {
    private static final Logger log = LoggerFactory.getLogger(GradebookEntityProducer.class);
    private String[] toolIdArray;
    private GradebookFrameworkService gradebookFrameworkService;
    private GradebookService gradebookService;
    public static final String GRADEBOOK_DEFINITION_TYPE = "sakai-gradebook";

    public void setToolIds(List toolIds) {
        if (log.isDebugEnabled()) {
            log.debug("setToolIds(" + toolIds + ")");
        }
        if (toolIds != null) {
            this.toolIdArray = toolIds.toArray(new String[0]);
        }
    }

    public String[] myToolIds() {
        return this.toolIdArray;
    }

    public void contextCreated(String context, boolean toolPlacement) {
        if (toolPlacement && !this.gradebookFrameworkService.isGradebookDefined(context)) {
            if (log.isDebugEnabled()) {
                log.debug("Gradebook being added to context " + context);
            }
            this.gradebookFrameworkService.addGradebook(context, context);
        }
    }

    public void contextUpdated(String context, boolean toolPlacement) {
        if (toolPlacement) {
            if (!this.gradebookFrameworkService.isGradebookDefined(context)) {
                if (log.isDebugEnabled()) {
                    log.debug("Gradebook being added to context " + context);
                }
                this.gradebookFrameworkService.addGradebook(context, context);
            }
        } else if (this.gradebookFrameworkService.isGradebookDefined(context) && log.isDebugEnabled()) {
            log.debug("Gradebook removed from context " + context + " but associated data will remain until context deletion");
        }
    }

    public void contextDeleted(String context, boolean toolPlacement) {
        if (this.gradebookFrameworkService.isGradebookDefined(context)) {
            if (log.isDebugEnabled()) {
                log.debug("Gradebook being deleted from context " + context);
            }
            try {
                this.gradebookFrameworkService.deleteGradebook(context);
            }
            catch (GradebookNotFoundException e) {
                log.warn(e.getMessage());
            }
        }
    }

    public void transferCopyEntities(String fromContext, String toContext, List ids) {
        String fromGradebookXml = this.gradebookService.getGradebookDefinitionXml(fromContext);
        this.gradebookService.transferGradebookDefinitionXml(fromContext, toContext, fromGradebookXml);
    }

    public void setGradebookFrameworkService(GradebookFrameworkService gradebookFrameworkService) {
        this.gradebookFrameworkService = gradebookFrameworkService;
    }

    public void setGradebookService(GradebookService gradebookService) {
        this.gradebookService = gradebookService;
    }

    public boolean canHandleType(String typeName) {
        return typeName.equals(GRADEBOOK_DEFINITION_TYPE);
    }

    public void handle(Importable importable, String siteId) {
        if (importable.getTypeName().equals(GRADEBOOK_DEFINITION_TYPE)) {
            this.gradebookService.mergeGradebookDefinitionXml(siteId, ((XmlImportable)importable).getXmlData());
        }
    }

    public List<Importable> getAllImportables(String contextId) {
        ArrayList<Importable> importables = new ArrayList<Importable>();
        importables.add(new XmlImportable(GRADEBOOK_DEFINITION_TYPE, this.gradebookService.getGradebookDefinitionXml(contextId)));
        return importables;
    }

    public void transferCopyEntities(String fromContext, String toContext, List ids, boolean cleanup) {
        if (cleanup) {
            Gradebook gradebook;
            Long gradebookId;
            List categoryList;
            String toSiteId = toContext;
            List gbItems = this.gradebookService.getAssignments(toSiteId);
            if (gbItems != null && !gbItems.isEmpty()) {
                for (Assignment assign : gbItems) {
                    this.gradebookService.removeAssignment(assign.getId());
                }
            }
            if ((categoryList = this.gradebookService.getCategories(gradebookId = (gradebook = (Gradebook)this.gradebookService.getGradebook(toSiteId)).getId())) != null) {
                for (Category category : categoryList) {
                    this.gradebookService.removeCategory(category.getId());
                }
            }
        }
        this.transferCopyEntities(fromContext, toContext, ids);
    }
}

