/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.gradebook;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.section.api.SectionAwareness;
import org.sakaiproject.section.api.coursemanagement.EnrollmentRecord;
import org.sakaiproject.section.api.facade.Role;
import org.sakaiproject.service.gradebook.shared.AssessmentNotFoundException;
import org.sakaiproject.service.gradebook.shared.CommentDefinition;
import org.sakaiproject.service.gradebook.shared.ConflictingAssignmentNameException;
import org.sakaiproject.service.gradebook.shared.ConflictingCategoryNameException;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.service.gradebook.shared.GraderPermission;
import org.sakaiproject.service.gradebook.shared.StaleObjectModificationException;
import org.sakaiproject.tool.gradebook.AbstractGradeRecord;
import org.sakaiproject.tool.gradebook.Assignment;
import org.sakaiproject.tool.gradebook.AssignmentGradeRecord;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.Comment;
import org.sakaiproject.tool.gradebook.CourseGrade;
import org.sakaiproject.tool.gradebook.CourseGradeRecord;
import org.sakaiproject.tool.gradebook.GradableObject;
import org.sakaiproject.tool.gradebook.GradeMapping;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradebookProperty;
import org.sakaiproject.tool.gradebook.GradingEvent;
import org.sakaiproject.tool.gradebook.LetterGradePercentMapping;
import org.sakaiproject.tool.gradebook.Permission;
import org.sakaiproject.tool.gradebook.facades.Authn;
import org.sakaiproject.tool.gradebook.facades.EventTrackingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class BaseHibernateManager
extends HibernateDaoSupport {
    private static final Logger log = LoggerFactory.getLogger(BaseHibernateManager.class);
    public static int MAX_NUMBER_OF_SQL_PARAMETERS_IN_LIST = 1000;
    protected SectionAwareness sectionAwareness;
    protected Authn authn;
    protected EventTrackingService eventTrackingService;
    protected ServerConfigurationService serverConfigurationService;
    protected GradebookExternalAssessmentService externalAssessmentService;
    protected Map propertiesMap = new HashMap();

    public Gradebook getGradebook(String uid) throws GradebookNotFoundException {
        List list = this.getHibernateTemplate().find("from Gradebook as gb where gb.uid=?", (Object)uid);
        if (list.size() == 1) {
            return (Gradebook)list.get(0);
        }
        throw new GradebookNotFoundException("Could not find gradebook uid=" + uid);
    }

    public boolean isGradebookDefined(String gradebookUid) {
        String hql = "from Gradebook as gb where gb.uid=?";
        return this.getHibernateTemplate().find(hql, (Object)gradebookUid).size() == 1;
    }

    protected List getAssignments(Long gradebookId, Session session) throws HibernateException {
        List assignments = session.createQuery("from Assignment as asn where asn.gradebook.id=? and asn.removed=false").setLong(0, gradebookId.longValue()).list();
        return assignments;
    }

    protected List getCountedStudentGradeRecords(Long gradebookId, String studentId, Session session) throws HibernateException {
        return session.createQuery("select agr from AssignmentGradeRecord as agr, Assignment as asn where agr.studentId=? and agr.gradableObject=asn and asn.removed=false and asn.notCounted=false and asn.gradebook.id=? and asn.ungraded=false").setString(0, studentId).setLong(1, gradebookId.longValue()).list();
    }

    public CourseGrade getCourseGrade(Long gradebookId) {
        return (CourseGrade)this.getHibernateTemplate().find("from CourseGrade as cg where cg.gradebook.id=?", (Object)gradebookId).get(0);
    }

    protected CourseGradeRecord getCourseGradeRecord(Gradebook gradebook, String studentId, Session session) throws HibernateException {
        return (CourseGradeRecord)session.createQuery("from CourseGradeRecord as cgr where cgr.studentId=? and cgr.gradableObject.gradebook=?").setString(0, studentId).setEntity(1, (Object)gradebook).uniqueResult();
    }

    public String getGradebookUid(Long id) {
        return ((Gradebook)this.getHibernateTemplate().load(Gradebook.class, (Serializable)id)).getUid();
    }

    protected Set getAllStudentUids(String gradebookUid) {
        List enrollments = this.getSectionAwareness().getSiteMembersInRole(gradebookUid, Role.STUDENT);
        HashSet<String> studentUids = new HashSet<String>();
        Iterator iter = enrollments.iterator();
        while (iter.hasNext()) {
            studentUids.add(((EnrollmentRecord)iter.next()).getUser().getUserUid());
        }
        return studentUids;
    }

    protected Map getPropertiesMap() {
        return this.propertiesMap;
    }

    public String getPropertyValue(String name) {
        List list;
        String value = (String)this.propertiesMap.get(name);
        if (value == null && !(list = this.getHibernateTemplate().find("from GradebookProperty as prop where prop.name=?", (Object)name)).isEmpty()) {
            GradebookProperty property = (GradebookProperty)list.get(0);
            value = property.getValue();
            this.propertiesMap.put(name, value);
        }
        return value;
    }

    public void setPropertyValue(String name, String value) {
        List list = this.getHibernateTemplate().find("from GradebookProperty as prop where prop.name=?", (Object)name);
        GradebookProperty property = !list.isEmpty() ? (GradebookProperty)list.get(0) : new GradebookProperty(name);
        property.setValue(value);
        this.getHibernateTemplate().saveOrUpdate((Object)property);
        this.propertiesMap.put(name, value);
    }

    protected List filterGradeRecordsByStudents(Collection gradeRecords, Collection studentUids) {
        ArrayList<AbstractGradeRecord> filteredRecords = new ArrayList<AbstractGradeRecord>();
        for (AbstractGradeRecord agr : gradeRecords) {
            if (!studentUids.contains(agr.getStudentId())) continue;
            filteredRecords.add(agr);
        }
        return filteredRecords;
    }

    @Deprecated
    protected Assignment getAssignmentWithoutStats(String gradebookUid, String assignmentName, Session session) throws HibernateException {
        return (Assignment)session.createQuery("from Assignment as asn where asn.name=? and asn.gradebook.uid=? and asn.removed=false").setString(0, assignmentName).setString(1, gradebookUid).uniqueResult();
    }

    protected Assignment getAssignmentWithoutStats(String gradebookUid, Long assignmentId, Session session) throws HibernateException {
        return (Assignment)session.createQuery("from Assignment as asn where asn.id=? and asn.gradebook.uid=? and asn.removed=false").setLong(0, assignmentId.longValue()).setString(1, gradebookUid).uniqueResult();
    }

    protected void updateAssignment(Assignment assignment, Session session) throws ConflictingAssignmentNameException, HibernateException {
        session.evict((Object)assignment);
        Assignment asnFromDb = (Assignment)session.load(Assignment.class, (Serializable)assignment.getId());
        List conflictList = session.createQuery("select go from GradableObject as go where go.name = ? and go.gradebook = ? and go.removed=false and go.id != ?").setString(0, assignment.getName()).setEntity(1, (Object)assignment.getGradebook()).setLong(2, assignment.getId().longValue()).list();
        int numNameConflicts = conflictList.size();
        if (numNameConflicts > 0) {
            throw new ConflictingAssignmentNameException("You can not save multiple assignments in a gradebook with the same name");
        }
        session.evict((Object)asnFromDb);
        session.update((Object)assignment);
    }

    protected AssignmentGradeRecord getAssignmentGradeRecord(Assignment assignment, String studentUid, Session session) throws HibernateException {
        return (AssignmentGradeRecord)session.createQuery("from AssignmentGradeRecord as agr where agr.studentId=? and agr.gradableObject.id=?").setString(0, studentUid).setLong(1, assignment.getId().longValue()).uniqueResult();
    }

    public Long createAssignment(Long gradebookId, String name, Double points, Date dueDate, Boolean isNotCounted, Boolean isReleased, Boolean isExtraCredit) throws ConflictingAssignmentNameException, StaleObjectModificationException {
        return this.createNewAssignment(gradebookId, null, name, points, dueDate, isNotCounted, isReleased, isExtraCredit);
    }

    public Long createAssignmentForCategory(Long gradebookId, Long categoryId, String name, Double points, Date dueDate, Boolean isNotCounted, Boolean isReleased, Boolean isExtraCredit) throws ConflictingAssignmentNameException, StaleObjectModificationException, IllegalArgumentException {
        if (gradebookId == null || categoryId == null) {
            throw new IllegalArgumentException("gradebookId or categoryId is null in BaseHibernateManager.createAssignmentForCategory");
        }
        return this.createNewAssignment(gradebookId, categoryId, name, points, dueDate, isNotCounted, isReleased, isExtraCredit);
    }

    private Long createNewAssignment(Long gradebookId, Long categoryId, String name, Double points, Date dueDate, Boolean isNotCounted, Boolean isReleased, Boolean isExtraCredit) throws ConflictingAssignmentNameException, StaleObjectModificationException {
        Assignment asn = this.prepareNewAssignment(name, points, dueDate, isNotCounted, isReleased, isExtraCredit);
        return this.saveNewAssignment(gradebookId, categoryId, asn);
    }

    private Assignment prepareNewAssignment(String name, Double points, Date dueDate, Boolean isNotCounted, Boolean isReleased, Boolean isExtraCredit) {
        String validatedName = StringUtils.trimToNull((String)name);
        if (validatedName == null) {
            throw new ConflictingAssignmentNameException("You cannot save an assignment without a name");
        }
        if (StringUtils.startsWithAny((String)validatedName, (String[])new String[]{"*", "#"})) {
            throw new ConflictingAssignmentNameException("Assignment names cannot start with * or # as they are reserved");
        }
        Assignment asn = new Assignment();
        asn.setName(validatedName);
        asn.setPointsPossible(points);
        asn.setDueDate(dueDate);
        asn.setUngraded(false);
        if (isNotCounted != null) {
            asn.setNotCounted(isNotCounted.booleanValue());
        }
        if (isExtraCredit != null) {
            asn.setExtraCredit(Boolean.valueOf(isExtraCredit));
        }
        if (isReleased != null) {
            asn.setReleased(isReleased.booleanValue());
        }
        return asn;
    }

    private void loadAssignmentGradebookAndCategory(Session session, Assignment asn, Long gradebookId, Long categoryId) {
        Gradebook gb = (Gradebook)session.load(Gradebook.class, (Serializable)gradebookId);
        asn.setGradebook(gb);
        if (categoryId != null) {
            Category cat = (Category)session.load(Category.class, (Serializable)categoryId);
            asn.setCategory(cat);
        }
    }

    protected Long saveNewAssignment(final Long gradebookId, final Long categoryId, final Assignment asn) throws ConflictingAssignmentNameException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                BaseHibernateManager.this.loadAssignmentGradebookAndCategory(session, asn, gradebookId, categoryId);
                if (BaseHibernateManager.this.assignmentNameExists(session, asn.getName(), asn.getGradebook())) {
                    throw new ConflictingAssignmentNameException("You cannot save multiple assignments in a gradebook with the same name");
                }
                return (Long)session.save((Object)asn);
            }
        };
        return (Long)this.getHibernateTemplate().execute(hc);
    }

    public void updateGradebook(final Gradebook gradebook) throws StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Gradebook gradebookFromPersistence = (Gradebook)session.load(gradebook.getClass(), (Serializable)gradebook.getId());
                GradeMapping mappingFromPersistence = gradebookFromPersistence.getSelectedGradeMapping();
                if (!mappingFromPersistence.getId().equals(gradebook.getSelectedGradeMapping().getId()) && BaseHibernateManager.this.isExplicitlyEnteredCourseGradeRecords(gradebook.getId())) {
                    throw new IllegalStateException("Selected grade mapping can not be changed, since explicit course grades exist.");
                }
                Iterator iter = gradebookFromPersistence.getGradeMappings().iterator();
                while (iter.hasNext()) {
                    session.evict(iter.next());
                }
                session.evict((Object)gradebookFromPersistence);
                try {
                    session.update((Object)gradebook);
                    session.flush();
                }
                catch (StaleObjectStateException e) {
                    throw new StaleObjectModificationException((Throwable)e);
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
    }

    public boolean isExplicitlyEnteredCourseGradeRecords(final Long gradebookId) {
        final Set studentUids = this.getAllStudentUids(this.getGradebookUid(gradebookId));
        if (studentUids.isEmpty()) {
            return false;
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Integer total;
                block2: {
                    block1: {
                        if (studentUids.size() > MAX_NUMBER_OF_SQL_PARAMETERS_IN_LIST) break block1;
                        Query q = session.createQuery("select cgr from CourseGradeRecord as cgr where cgr.enteredGrade is not null and cgr.gradableObject.gradebook.id=:gradebookId and cgr.studentId in (:studentUids)");
                        q.setLong("gradebookId", gradebookId.longValue());
                        q.setParameterList("studentUids", (Collection)studentUids);
                        List totalList = q.list();
                        total = totalList.size();
                        if (!log.isDebugEnabled()) break block2;
                        log.debug("total number of explicitly entered course grade records = " + total);
                        break block2;
                    }
                    total = 0;
                    Query q = session.createQuery("select cgr.studentId from CourseGradeRecord as cgr where cgr.enteredGrade is not null and cgr.gradableObject.gradebook.id=:gradebookId");
                    q.setLong("gradebookId", gradebookId.longValue());
                    for (String studentId : q.list()) {
                        if (!studentUids.contains(studentId)) continue;
                        total = 1;
                        break;
                    }
                }
                return total;
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hc) > 0;
    }

    public Authn getAuthn() {
        return this.authn;
    }

    public void setAuthn(Authn authn) {
        this.authn = authn;
    }

    protected String getUserUid() {
        return this.authn.getUserUid();
    }

    protected SectionAwareness getSectionAwareness() {
        return this.sectionAwareness;
    }

    public void setSectionAwareness(SectionAwareness sectionAwareness) {
        this.sectionAwareness = sectionAwareness;
    }

    protected ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    protected EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    protected GradebookExternalAssessmentService getGradebookExternalAssessmentService() {
        return this.externalAssessmentService;
    }

    public void setGradebookExternalAssessmentService(GradebookExternalAssessmentService externalAssessmentService) {
        this.externalAssessmentService = externalAssessmentService;
    }

    public void postEvent(String message, String objectReference) {
        this.eventTrackingService.postEvent(message, objectReference);
    }

    public Long createCategory(Long gradebookId, String name, Double weight, Integer drop_lowest, Integer dropHighest, Integer keepHighest, Boolean is_extra_credit) {
        return this.createCategory(gradebookId, name, weight, drop_lowest, dropHighest, keepHighest, is_extra_credit, null);
    }

    public Long createCategory(final Long gradebookId, final String name, final Double weight, final Integer drop_lowest, final Integer dropHighest, final Integer keepHighest, final Boolean is_extra_credit, final Integer categoryOrder) throws ConflictingCategoryNameException, StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Gradebook gb = (Gradebook)session.load(Gradebook.class, (Serializable)gradebookId);
                List conflictList = session.createQuery("select ca from Category as ca where ca.name = ? and ca.gradebook = ? and ca.removed=false ").setString(0, name).setEntity(1, (Object)gb).list();
                int numNameConflicts = conflictList.size();
                if (numNameConflicts > 0) {
                    throw new ConflictingCategoryNameException("You can not save multiple catetories in a gradebook with the same name");
                }
                if (weight > 1.0 || weight < 0.0) {
                    throw new IllegalArgumentException("weight for category is greater than 1 or less than 0 in createCategory of BaseHibernateManager");
                }
                if ((drop_lowest != null && drop_lowest > 0 || dropHighest != null && dropHighest > 0) && keepHighest != null && keepHighest > 0) {
                    throw new IllegalArgumentException("a combination of positive values for keepHighest and either drop_lowest or dropHighest occurred in createCategory of BaseHibernateManager");
                }
                Category ca = new Category();
                ca.setGradebook(gb);
                ca.setName(name);
                ca.setWeight(weight);
                ca.setDrop_lowest(drop_lowest);
                ca.setDropHighest(dropHighest);
                ca.setKeepHighest(keepHighest);
                ca.setRemoved(false);
                ca.setExtraCredit(is_extra_credit);
                ca.setCategoryOrder(categoryOrder);
                Long id = (Long)session.save((Object)ca);
                return id;
            }
        };
        return (Long)this.getHibernateTemplate().execute(hc);
    }

    public List getCategories(final Long gradebookId) throws HibernateException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List categories = session.createQuery("from Category as ca where ca.gradebook=? and ca.removed=false").setLong(0, gradebookId.longValue()).list();
                return categories;
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List getCategoriesWithAssignments(Long gradebookId) {
        List categories = this.getCategories(gradebookId);
        ArrayList<Category> categoriesWithAssignments = new ArrayList<Category>();
        if (categories != null) {
            for (Category category : categories) {
                if (category == null) continue;
                List assignments = this.getAssignmentsForCategory(category.getId());
                category.setAssignmentList(assignments);
                categoriesWithAssignments.add(category);
            }
        }
        return categoriesWithAssignments;
    }

    public List getAssignmentsForCategory(final Long categoryId) throws HibernateException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List assignments = session.createQuery("from Assignment as assign where assign.category=? and assign.removed=false").setLong(0, categoryId.longValue()).list();
                return assignments;
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public Category getCategory(final Long categoryId) throws HibernateException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery("from Category as cat where cat.id=?").setLong(0, categoryId.longValue()).uniqueResult();
            }
        };
        return (Category)this.getHibernateTemplate().execute(hc);
    }

    protected void updateCategory(Category category, Session session) throws ConflictingAssignmentNameException, HibernateException {
        session.evict((Object)category);
        Category persistentCat = (Category)session.load(Category.class, (Serializable)category.getId());
        List conflictList = session.createQuery("select ca from Category as ca where ca.name = ? and ca.gradebook = ? and ca.id != ? and ca.removed=false").setString(0, category.getName()).setEntity(1, (Object)category.getGradebook()).setLong(2, category.getId().longValue()).list();
        int numNameConflicts = conflictList.size();
        if (numNameConflicts > 0) {
            throw new ConflictingCategoryNameException("You can not save multiple category in a gradebook with the same name");
        }
        if (category.getWeight() > 1.0 || category.getWeight() < 0.0) {
            throw new IllegalArgumentException("weight for category is greater than 1 or less than 0 in updateCategory of BaseHibernateManager");
        }
        session.evict((Object)persistentCat);
        session.update((Object)category);
    }

    public void updateCategory(final Category category) throws ConflictingCategoryNameException, StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.evict((Object)category);
                Category persistentCat = (Category)session.load(Category.class, (Serializable)category.getId());
                List conflictList = session.createQuery("select ca from Category as ca where ca.name = ? and ca.gradebook = ? and ca.id != ? and ca.removed=false").setString(0, category.getName()).setEntity(1, (Object)category.getGradebook()).setLong(2, category.getId().longValue()).list();
                int numNameConflicts = conflictList.size();
                if (numNameConflicts > 0) {
                    throw new ConflictingCategoryNameException("You can not save multiple category in a gradebook with the same name");
                }
                if (category.getWeight() > 1.0 || category.getWeight() < 0.0) {
                    throw new IllegalArgumentException("weight for category is greater than 1 or less than 0 in updateCategory of BaseHibernateManager");
                }
                session.evict((Object)persistentCat);
                session.update((Object)category);
                return null;
            }
        };
        try {
            this.getHibernateTemplate().execute(hc);
        }
        catch (Exception e) {
            throw new StaleObjectModificationException((Throwable)e);
        }
    }

    public void removeCategory(final Long categoryId) throws StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Category persistentCat = (Category)session.load(Category.class, (Serializable)categoryId);
                List assigns = BaseHibernateManager.this.getAssignmentsForCategory(categoryId);
                for (Assignment assignment : assigns) {
                    assignment.setCategory(null);
                    BaseHibernateManager.this.updateAssignment(assignment, session);
                }
                persistentCat.setRemoved(true);
                session.update((Object)persistentCat);
                return null;
            }
        };
        try {
            this.getHibernateTemplate().execute(hc);
        }
        catch (Exception e) {
            throw new StaleObjectModificationException((Throwable)e);
        }
    }

    public LetterGradePercentMapping getDefaultLetterGradePercentMapping() {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List defaultMapping = session.createQuery("select lgpm from LetterGradePercentMapping as lgpm where lgpm.mappingType = 1").list();
                if (defaultMapping == null || defaultMapping.size() == 0) {
                    log.info("Default letter grade mapping hasn't been created in DB in BaseHibernateManager.getDefaultLetterGradePercentMapping");
                    return null;
                }
                if (defaultMapping.size() > 1) {
                    log.error("Duplicate default letter grade mapping was created in DB in BaseHibernateManager.getDefaultLetterGradePercentMapping");
                    return null;
                }
                return (LetterGradePercentMapping)defaultMapping.get(0);
            }
        };
        return (LetterGradePercentMapping)this.getHibernateTemplate().execute(hc);
    }

    public void createOrUpdateDefaultLetterGradePercentMapping(Map gradeMap) {
        if (gradeMap == null) {
            throw new IllegalArgumentException("gradeMap is null in BaseHibernateManager.createOrUpdateDefaultLetterGradePercentMapping");
        }
        LetterGradePercentMapping lgpm = this.getDefaultLetterGradePercentMapping();
        if (lgpm != null) {
            this.updateDefaultLetterGradePercentMapping(gradeMap, lgpm);
        } else {
            this.createDefaultLetterGradePercentMapping(gradeMap);
        }
    }

    private void updateDefaultLetterGradePercentMapping(final Map gradeMap, final LetterGradePercentMapping lgpm) {
        Set keySet = gradeMap.keySet();
        if (keySet.size() != GradebookService.validLetterGrade.length) {
            throw new IllegalArgumentException("gradeMap doesn't have right size in BaseHibernateManager.updateDefaultLetterGradePercentMapping");
        }
        if (!this.validateLetterGradeMapping(gradeMap)) {
            throw new IllegalArgumentException("gradeMap contains invalid letter in BaseHibernateManager.updateDefaultLetterGradePercentMapping");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HashMap saveMap = new HashMap();
                for (String key : gradeMap.keySet()) {
                    saveMap.put(key, gradeMap.get(key));
                }
                lgpm.setGradeMap(saveMap);
                session.update((Object)lgpm);
                return null;
            }
        };
        this.getHibernateTemplate().execute(hcb);
    }

    public void createDefaultLetterGradePercentMapping(final Map gradeMap) {
        if (this.getDefaultLetterGradePercentMapping() != null) {
            throw new IllegalArgumentException("gradeMap has already been created in BaseHibernateManager.createDefaultLetterGradePercentMapping");
        }
        if (gradeMap == null) {
            throw new IllegalArgumentException("gradeMap is null in BaseHibernateManager.createDefaultLetterGradePercentMapping");
        }
        Set keySet = gradeMap.keySet();
        if (keySet.size() != GradebookService.validLetterGrade.length) {
            throw new IllegalArgumentException("gradeMap doesn't have right size in BaseHibernateManager.createDefaultLetterGradePercentMapping");
        }
        if (!this.validateLetterGradeMapping(gradeMap)) {
            throw new IllegalArgumentException("gradeMap contains invalid letter in BaseHibernateManager.createDefaultLetterGradePercentMapping");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                LetterGradePercentMapping lgpm = new LetterGradePercentMapping();
                HashMap saveMap = new HashMap();
                for (String key : gradeMap.keySet()) {
                    saveMap.put(key, gradeMap.get(key));
                }
                if (lgpm != null) {
                    lgpm.setGradeMap(saveMap);
                    lgpm.setMappingType(1);
                    session.save((Object)lgpm);
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hcb);
    }

    public LetterGradePercentMapping getLetterGradePercentMapping(final Gradebook gradebook) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                LetterGradePercentMapping mapping = (LetterGradePercentMapping)session.createQuery("from LetterGradePercentMapping as lgpm where lgpm.gradebookId=:gradebookId and lgpm.mappingType=2").setLong("gradebookId", gradebook.getId().longValue()).uniqueResult();
                if (mapping == null) {
                    LetterGradePercentMapping lgpm = BaseHibernateManager.this.getDefaultLetterGradePercentMapping();
                    LetterGradePercentMapping returnLgpm = new LetterGradePercentMapping();
                    returnLgpm.setGradebookId(gradebook.getId());
                    returnLgpm.setGradeMap(lgpm.getGradeMap());
                    returnLgpm.setMappingType(2);
                    return returnLgpm;
                }
                return mapping;
            }
        };
        return (LetterGradePercentMapping)this.getHibernateTemplate().execute(hc);
    }

    private LetterGradePercentMapping getLetterGradePercentMappingForGradebook(final Gradebook gradebook) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                LetterGradePercentMapping mapping = (LetterGradePercentMapping)session.createQuery("from LetterGradePercentMapping as lgpm where lgpm.gradebookId=:gradebookId and lgpm.mappingType=2").setLong("gradebookId", gradebook.getId().longValue()).uniqueResult();
                return mapping;
            }
        };
        return (LetterGradePercentMapping)this.getHibernateTemplate().execute(hc);
    }

    public void saveOrUpdateLetterGradePercentMapping(final Map gradeMap, final Gradebook gradebook) {
        if (gradeMap == null) {
            throw new IllegalArgumentException("gradeMap is null in BaseHibernateManager.saveOrUpdateLetterGradePercentMapping");
        }
        LetterGradePercentMapping lgpm = this.getLetterGradePercentMappingForGradebook(gradebook);
        if (lgpm == null) {
            Set keySet = gradeMap.keySet();
            if (keySet.size() != GradebookService.validLetterGrade.length) {
                throw new IllegalArgumentException("gradeMap doesn't have right size in BaseHibernateManager.saveOrUpdateLetterGradePercentMapping");
            }
            if (!this.validateLetterGradeMapping(gradeMap)) {
                throw new IllegalArgumentException("gradeMap contains invalid letter in BaseHibernateManager.saveOrUpdateLetterGradePercentMapping");
            }
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    LetterGradePercentMapping lgpm = new LetterGradePercentMapping();
                    if (lgpm != null) {
                        HashMap<String, Double> saveMap = new HashMap<String, Double>();
                        for (String letterGrade : gradeMap.keySet()) {
                            Double value = (Double)gradeMap.get(letterGrade);
                            saveMap.put(letterGrade, value);
                        }
                        lgpm.setGradeMap(saveMap);
                        lgpm.setGradebookId(gradebook.getId());
                        lgpm.setMappingType(2);
                        session.save((Object)lgpm);
                    }
                    return null;
                }
            };
            this.getHibernateTemplate().execute(hcb);
        } else {
            this.udpateLetterGradePercentMapping(gradeMap, gradebook);
        }
    }

    private void udpateLetterGradePercentMapping(final Map gradeMap, final Gradebook gradebook) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                LetterGradePercentMapping lgpm = BaseHibernateManager.this.getLetterGradePercentMapping(gradebook);
                if (lgpm == null) {
                    throw new IllegalArgumentException("LetterGradePercentMapping is null in BaseHibernateManager.updateLetterGradePercentMapping");
                }
                if (gradeMap == null) {
                    throw new IllegalArgumentException("gradeMap is null in BaseHibernateManager.updateLetterGradePercentMapping");
                }
                Set keySet = gradeMap.keySet();
                if (keySet.size() != GradebookService.validLetterGrade.length) {
                    throw new IllegalArgumentException("gradeMap doesn't have right size in BaseHibernateManager.udpateLetterGradePercentMapping");
                }
                if (!BaseHibernateManager.this.validateLetterGradeMapping(gradeMap)) {
                    throw new IllegalArgumentException("gradeMap contains invalid letter in BaseHibernateManager.udpateLetterGradePercentMapping");
                }
                HashMap saveMap = new HashMap();
                for (String key : gradeMap.keySet()) {
                    saveMap.put(key, gradeMap.get(key));
                }
                lgpm.setGradeMap(saveMap);
                session.save((Object)lgpm);
                return null;
            }
        };
        this.getHibernateTemplate().execute(hcb);
    }

    protected boolean validateLetterGradeMapping(Map gradeMap) {
        Set keySet = gradeMap.keySet();
        for (String key : keySet) {
            boolean validLetter = false;
            for (int i = 0; i < GradebookService.validLetterGrade.length; ++i) {
                if (!key.equalsIgnoreCase(GradebookService.validLetterGrade[i])) continue;
                validLetter = true;
                break;
            }
            if (validLetter) continue;
            return false;
        }
        return true;
    }

    public Long createUngradedAssignment(final Long gradebookId, final String name, final Date dueDate, final Boolean isNotCounted, final Boolean isReleased) throws ConflictingAssignmentNameException, StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Gradebook gb = (Gradebook)session.load(Gradebook.class, (Serializable)gradebookId);
                String trimmedName = name;
                if (name != null) {
                    trimmedName = name.trim();
                }
                if (BaseHibernateManager.this.assignmentNameExists(session, trimmedName, gb)) {
                    throw new ConflictingAssignmentNameException("You can not save multiple assignments in a gradebook with the same name");
                }
                Assignment asn = new Assignment();
                asn.setGradebook(gb);
                asn.setName(trimmedName);
                asn.setDueDate(dueDate);
                asn.setUngraded(true);
                if (isNotCounted != null) {
                    asn.setNotCounted(isNotCounted.booleanValue());
                }
                if (isReleased != null) {
                    asn.setReleased(isReleased.booleanValue());
                }
                Long id = (Long)session.save((Object)asn);
                return id;
            }
        };
        return (Long)this.getHibernateTemplate().execute(hc);
    }

    public Long createUngradedAssignmentForCategory(final Long gradebookId, final Long categoryId, final String name, final Date dueDate, final Boolean isNotCounted, final Boolean isReleased) throws ConflictingAssignmentNameException, StaleObjectModificationException, IllegalArgumentException {
        if (gradebookId == null || categoryId == null) {
            throw new IllegalArgumentException("gradebookId or categoryId is null in BaseHibernateManager.createUngradedAssignmentForCategory");
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Gradebook gb = (Gradebook)session.load(Gradebook.class, (Serializable)gradebookId);
                Category cat = (Category)session.load(Category.class, (Serializable)categoryId);
                String trimmedName = name;
                if (name != null) {
                    trimmedName = name.trim();
                }
                if (BaseHibernateManager.this.assignmentNameExists(session, trimmedName, gb)) {
                    throw new ConflictingAssignmentNameException("You can not save multiple assignments in a gradebook with the same name");
                }
                Assignment asn = new Assignment();
                asn.setGradebook(gb);
                asn.setCategory(cat);
                asn.setName(trimmedName);
                asn.setDueDate(dueDate);
                asn.setUngraded(true);
                if (isNotCounted != null) {
                    asn.setNotCounted(isNotCounted.booleanValue());
                }
                if (isReleased != null) {
                    asn.setReleased(isReleased.booleanValue());
                }
                Long id = (Long)session.save((Object)asn);
                return id;
            }
        };
        return (Long)this.getHibernateTemplate().execute(hc);
    }

    public Long addPermission(final Long gradebookId, final String userId, final String function, final Long categoryId, final String groupId) throws IllegalArgumentException {
        if (gradebookId == null || userId == null || function == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.addPermission");
        }
        if (!function.equalsIgnoreCase(GradebookService.gradePermission) && !function.equalsIgnoreCase(GradebookService.viewPermission)) {
            throw new IllegalArgumentException("Function is not grade or view in BaseHibernateManager.addPermission");
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Permission permission = new Permission();
                permission.setCategoryId(categoryId);
                permission.setGradebookId(gradebookId);
                permission.setGroupId(groupId);
                permission.setFunction(function);
                permission.setUserId(userId);
                Long permissionId = (Long)session.save((Object)permission);
                return permissionId;
            }
        };
        return (Long)this.getHibernateTemplate().execute(hc);
    }

    @Deprecated
    public List getPermissionsForGB(final Long gradebookId) throws IllegalArgumentException {
        if (gradebookId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForGB");
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query q = session.createQuery("from Permission as perm where perm.gradebookId=:gradebookId");
                q.setLong("gradebookId", gradebookId.longValue());
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    @Deprecated
    public void updatePermission(Collection perms) {
        for (Permission perm : perms) {
            if (perm == null) continue;
            this.updatePermission(perm);
        }
    }

    @Deprecated
    public void updatePermission(final Permission perm) throws IllegalArgumentException {
        if (perm == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.updatePermission");
        }
        if (perm.getId() == null) {
            throw new IllegalArgumentException("Object is not persistent in BaseHibernateManager.updatePermission");
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.update((Object)perm);
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
    }

    @Deprecated
    public void deletePermission(final Permission perm) throws IllegalArgumentException {
        if (perm == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.deletePermission");
        }
        if (perm.getId() == null) {
            throw new IllegalArgumentException("Object is not persistent in BaseHibernateManager.deletePermission");
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.delete((Object)perm);
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
    }

    public List<Permission> getPermissionsForUser(final Long gradebookId, final String userId) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUser");
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query q = session.createQuery("from Permission as perm where perm.gradebookId=:gradebookId and perm.userId=:userId");
                q.setLong("gradebookId", gradebookId.longValue());
                q.setString("userId", userId);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List<Permission> getPermissionsForUserForCategory(final Long gradebookId, final String userId, final List cateIds) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserForCategory");
        }
        if (cateIds != null && cateIds.size() > 0) {
            HibernateCallback hc = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query q = session.createQuery("from Permission as perm where perm.gradebookId=:gradebookId and perm.userId=:userId and perm.categoryId in (:cateIds)");
                    q.setLong("gradebookId", gradebookId.longValue());
                    q.setString("userId", userId);
                    q.setParameterList("cateIds", (Collection)cateIds);
                    return q.list();
                }
            };
            return (List)this.getHibernateTemplate().execute(hc);
        }
        return null;
    }

    public List<Permission> getPermissionsForUserAnyCategory(final Long gradebookId, final String userId) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserAnyCategory");
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query q = session.createQuery("from Permission as perm where perm.gradebookId=:gradebookId and perm.userId=:userId and perm.categoryId is null and perm.function in (:functions)");
                q.setLong("gradebookId", gradebookId.longValue());
                q.setString("userId", userId);
                q.setParameterList("functions", (Collection)GraderPermission.getStandardPermissions());
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List<Permission> getPermissionsForUserAnyGroup(final Long gradebookId, final String userId) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserAnyGroup");
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query q = session.createQuery("from Permission as perm where perm.gradebookId=:gradebookId and perm.userId=:userId and perm.groupId is null and perm.function in (:functions)");
                q.setLong("gradebookId", gradebookId.longValue());
                q.setString("userId", userId);
                q.setParameterList("functions", (Collection)GraderPermission.getStandardPermissions());
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List<Permission> getPermissionsForUserAnyGroupForCategory(final Long gradebookId, final String userId, final List cateIds) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserAnyGroupForCategory");
        }
        if (cateIds != null && cateIds.size() > 0) {
            HibernateCallback hc = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query q = session.createQuery("from Permission as perm where perm.gradebookId=:gradebookId and perm.userId=:userId and perm.categoryId in (:cateIds) and perm.groupId is null");
                    q.setLong("gradebookId", gradebookId.longValue());
                    q.setString("userId", userId);
                    q.setParameterList("cateIds", (Collection)cateIds);
                    return q.list();
                }
            };
            return (List)this.getHibernateTemplate().execute(hc);
        }
        return null;
    }

    public List getPermissionsForGBForCategoryIds(final Long gradebookId, final List cateIds) throws IllegalArgumentException {
        if (gradebookId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserAnyGroupForCategory");
        }
        if (cateIds != null && cateIds.size() > 0) {
            HibernateCallback hc = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query q = session.createQuery("from Permission as perm where perm.gradebookId=:gradebookId and perm.categoryId in (:cateIds)");
                    q.setLong("gradebookId", gradebookId.longValue());
                    q.setParameterList("cateIds", (Collection)cateIds);
                    return q.list();
                }
            };
            return (List)this.getHibernateTemplate().execute(hc);
        }
        return null;
    }

    public List getPermissionsForUserAnyGroupAnyCategory(final Long gradebookId, final String userId) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserAnyGroupForCategory");
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query q = session.createQuery("from Permission as perm where perm.gradebookId=:gradebookId and perm.userId=:userId and perm.categoryId is null and perm.groupId is null");
                q.setLong("gradebookId", gradebookId.longValue());
                q.setString("userId", userId);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List getPermissionsForUserForGoupsAnyCategory(final Long gradebookId, final String userId, final List groupIds) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserForGoupsAnyCategory");
        }
        if (groupIds != null && groupIds.size() > 0) {
            HibernateCallback hc = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query q = session.createQuery("from Permission as perm where perm.gradebookId=:gradebookId and perm.userId=:userId and perm.categoryId is null and perm.groupId in (:groupIds) ");
                    q.setLong("gradebookId", gradebookId.longValue());
                    q.setString("userId", userId);
                    q.setParameterList("groupIds", (Collection)groupIds);
                    return q.list();
                }
            };
            return (List)this.getHibernateTemplate().execute(hc);
        }
        return null;
    }

    public List getPermissionsForUserForGroup(final Long gradebookId, final String userId, final List groupIds) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserForGroup");
        }
        if (groupIds != null && groupIds.size() > 0) {
            HibernateCallback hc = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query q = session.createQuery("from Permission as perm where perm.gradebookId=:gradebookId and perm.userId=:userId and perm.groupId in (:groupIds) ");
                    q.setLong("gradebookId", gradebookId.longValue());
                    q.setString("userId", userId);
                    q.setParameterList("groupIds", (Collection)groupIds);
                    return q.list();
                }
            };
            return (List)this.getHibernateTemplate().execute(hc);
        }
        return null;
    }

    public boolean isAssignmentDefined(Long gradableObjectId) {
        String hql = "from Assignment as asn where asn.id=? and removed=false";
        return this.getHibernateTemplate().find(hql, (Object)gradableObjectId).size() == 1;
    }

    public Assignment getAssignment(Long gradableObjectId) {
        return (Assignment)this.getHibernateTemplate().load(Assignment.class, (Serializable)gradableObjectId);
    }

    protected Double calculateEquivalentPercent(Double doublePointsPossible, Double doublePointsEarned) {
        if (doublePointsEarned == null || doublePointsPossible == null) {
            return null;
        }
        BigDecimal pointsEarned = new BigDecimal(doublePointsEarned.toString());
        BigDecimal pointsPossible = new BigDecimal(doublePointsPossible.toString());
        if (pointsEarned.compareTo(BigDecimal.ZERO) == 0 || pointsPossible.compareTo(BigDecimal.ZERO) == 0) {
            return new Double(0.0);
        }
        BigDecimal equivPercent = pointsEarned.divide(pointsPossible, GradebookService.MATH_CONTEXT).multiply(new BigDecimal("100"));
        return equivPercent.doubleValue();
    }

    protected List convertPointsToPercentage(Gradebook gradebook, List studentRecordsFromDB) {
        ArrayList<AssignmentGradeRecord> percentageList = new ArrayList<AssignmentGradeRecord>();
        for (int i = 0; i < studentRecordsFromDB.size(); ++i) {
            AssignmentGradeRecord agr = (AssignmentGradeRecord)studentRecordsFromDB.get(i);
            if (agr == null) continue;
            Double pointsPossible = agr.getAssignment().getPointsPossible();
            if (pointsPossible == null || agr.getPointsEarned() == null) {
                agr.setPercentEarned(null);
                percentageList.add(agr);
                continue;
            }
            agr.setDateRecorded(agr.getDateRecorded());
            agr.setGraderId(agr.getGraderId());
            agr.setPercentEarned(this.calculateEquivalentPercent(pointsPossible, agr.getPointsEarned()));
            percentageList.add(agr);
        }
        return percentageList;
    }

    protected List convertPointsToLetterGrade(Gradebook gradebook, List studentRecordsFromDB) {
        ArrayList<AssignmentGradeRecord> letterGradeList = new ArrayList<AssignmentGradeRecord>();
        LetterGradePercentMapping lgpm = this.getLetterGradePercentMapping(gradebook);
        for (int i = 0; i < studentRecordsFromDB.size(); ++i) {
            AssignmentGradeRecord agr = (AssignmentGradeRecord)studentRecordsFromDB.get(i);
            if (agr == null) continue;
            Double pointsPossible = agr.getAssignment().getPointsPossible();
            agr.setDateRecorded(agr.getDateRecorded());
            agr.setGraderId(agr.getGraderId());
            if (pointsPossible == null || agr.getPointsEarned() == null) {
                agr.setLetterEarned(null);
                letterGradeList.add(agr);
                continue;
            }
            String letterGrade = lgpm.getGrade(this.calculateEquivalentPercent(pointsPossible, agr.getPointsEarned()));
            agr.setLetterEarned(letterGrade);
            letterGradeList.add(agr);
        }
        return letterGradeList;
    }

    protected Double calculateEquivalentPointValueForPercent(Double doublePointsPossible, Double doublePercentEarned) {
        if (doublePointsPossible == null || doublePercentEarned == null) {
            return null;
        }
        BigDecimal pointsPossible = new BigDecimal(doublePointsPossible.toString());
        BigDecimal percentEarned = new BigDecimal(doublePercentEarned.toString());
        BigDecimal equivPoints = pointsPossible.multiply(percentEarned.divide(new BigDecimal("100"), GradebookService.MATH_CONTEXT));
        return equivPoints.doubleValue();
    }

    public List getComments(final Assignment assignment, final Collection studentIds) {
        if (studentIds.isEmpty()) {
            return new ArrayList();
        }
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List<Comment> comments;
                if (studentIds.size() <= MAX_NUMBER_OF_SQL_PARAMETERS_IN_LIST) {
                    Query q = session.createQuery("from Comment as c where c.gradableObject=:go and c.studentId in (:studentIds)");
                    q.setParameter("go", (Object)assignment);
                    q.setParameterList("studentIds", studentIds);
                    comments = q.list();
                } else {
                    comments = new ArrayList();
                    Query q = session.createQuery("from Comment as c where c.gradableObject=:go");
                    q.setParameter("go", (Object)assignment);
                    List allComments = q.list();
                    for (Comment comment : allComments) {
                        if (!studentIds.contains(comment.getStudentId())) continue;
                        comments.add(comment);
                    }
                }
                return comments;
            }
        });
    }

    protected Map<String, Set<Assignment>> getVisibleExternalAssignments(Gradebook gradebook, Collection<String> studentIds, List<Assignment> assignments) {
        String gradebookUid = gradebook.getUid();
        Map allExternals = this.externalAssessmentService.getVisibleExternalAssignments(gradebookUid, studentIds);
        HashMap<String, Assignment> allRequested = new HashMap<String, Assignment>();
        for (Assignment a : assignments) {
            if (!a.isExternallyMaintained()) continue;
            allRequested.put(a.getExternalId(), a);
        }
        HashMap<String, Set<Assignment>> visible = new HashMap<String, Set<Assignment>>();
        for (String studentId : allExternals.keySet()) {
            if (!studentIds.contains(studentId)) continue;
            HashSet studentAssignments = new HashSet();
            for (String assignmentId : (List)allExternals.get(studentId)) {
                if (!allRequested.containsKey(assignmentId)) continue;
                studentAssignments.add(allRequested.get(assignmentId));
            }
            visible.put(studentId, studentAssignments);
        }
        return visible;
    }

    protected boolean studentCanView(String studentId, Assignment assignment) {
        block4: {
            if (assignment.isExternallyMaintained()) {
                try {
                    String gbUid = assignment.getGradebook().getUid();
                    String extId = assignment.getExternalId();
                    if (this.externalAssessmentService.isExternalAssignmentGrouped(gbUid, extId)) {
                        return this.externalAssessmentService.isExternalAssignmentVisible(gbUid, extId, studentId);
                    }
                }
                catch (GradebookNotFoundException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Bogus graded assignment checked for course grades: " + assignment.getId());
                }
            }
        }
        return true;
    }

    protected void finalizeNullGradeRecords(final Gradebook gradebook) {
        final Set studentUids = this.getAllStudentUids(gradebook.getUid());
        final Date now = new Date();
        final String graderId = this.getAuthn().getUserUid();
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List countedAssignments = session.createQuery("from Assignment as asn where asn.gradebook.id=:gb and asn.removed=false and asn.notCounted=false and asn.ungraded=false").setLong("gb", gradebook.getId().longValue()).list();
                Map<String, Set<Assignment>> visible = BaseHibernateManager.this.getVisibleExternalAssignments(gradebook, studentUids, countedAssignments);
                for (Assignment assignment : countedAssignments) {
                    List scoredGradeRecords = session.createQuery("from AssignmentGradeRecord as agr where agr.gradableObject.id=:go").setLong("go", assignment.getId().longValue()).list();
                    HashMap<String, AssignmentGradeRecord> studentToGradeRecordMap = new HashMap<String, AssignmentGradeRecord>();
                    for (AssignmentGradeRecord scoredGradeRecord : scoredGradeRecords) {
                        studentToGradeRecordMap.put(scoredGradeRecord.getStudentId(), scoredGradeRecord);
                    }
                    for (String studentUid : studentUids) {
                        if (assignment.isExternallyMaintained() && (!visible.containsKey(studentUid) || !visible.get(studentUid).contains(assignment))) continue;
                        AssignmentGradeRecord gradeRecord = (AssignmentGradeRecord)studentToGradeRecordMap.get(studentUid);
                        if (gradeRecord != null) {
                            if (gradeRecord.getPointsEarned() != null) continue;
                            gradeRecord.setPointsEarned(Double.valueOf(0.0));
                        } else {
                            gradeRecord = new AssignmentGradeRecord(assignment, studentUid, Double.valueOf(0.0));
                        }
                        gradeRecord.setGraderId(graderId);
                        gradeRecord.setDateRecorded(now);
                        session.saveOrUpdate((Object)gradeRecord);
                        session.save((Object)new GradingEvent((GradableObject)assignment, graderId, studentUid, (Object)gradeRecord.getPointsEarned()));
                    }
                }
                return null;
            }
        });
    }

    protected boolean assignmentNameExists(Session session, String name, Gradebook gradebook) {
        String HQL_ASSIGNMENTS_BY_NAME = "select go from GradableObject as go where go.name = :name and go.gradebook = :gb and go.removed=false";
        Query q = session.createQuery("select go from GradableObject as go where go.name = :name and go.gradebook = :gb and go.removed=false");
        q.setString("name", name);
        q.setEntity("gb", (Object)gradebook);
        return !q.list().isEmpty();
    }

    private Comment getInternalComment(String gradebookUid, Long assignmentId, String studentUid, Session session) {
        Query q = session.createQuery("from Comment as c where c.studentId=:studentId and c.gradableObject.gradebook.uid=:gradebookUid and c.gradableObject.id=:assignmentId and gradableObject.removed=false");
        q.setParameter("studentId", (Object)studentUid);
        q.setParameter("gradebookUid", (Object)gradebookUid);
        q.setParameter("assignmentId", (Object)assignmentId);
        return (Comment)q.uniqueResult();
    }

    public CommentDefinition getAssignmentScoreComment(final String gradebookUid, final Long assignmentId, final String studentUid) throws GradebookNotFoundException, AssessmentNotFoundException {
        if (gradebookUid == null || assignmentId == null || studentUid == null) {
            throw new IllegalArgumentException("null parameter passed to getAssignmentScoreComment. Values are gradebookUid:" + gradebookUid + " assignmentId:" + assignmentId + " studentUid:" + studentUid);
        }
        Assignment assignment = (Assignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return BaseHibernateManager.this.getAssignmentWithoutStats(gradebookUid, assignmentId, session);
            }
        });
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assignmentId " + assignmentId + " for gradebookUid " + gradebookUid);
        }
        CommentDefinition commentDefinition = null;
        Comment comment = (Comment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return BaseHibernateManager.this.getInternalComment(gradebookUid, assignmentId, studentUid, session);
            }
        });
        if (comment != null) {
            commentDefinition = new CommentDefinition();
            commentDefinition.setAssignmentName(assignment.getName());
            commentDefinition.setCommentText(comment.getCommentText());
            commentDefinition.setDateRecorded(comment.getDateRecorded());
            commentDefinition.setGraderUid(comment.getGraderId());
            commentDefinition.setStudentUid(comment.getStudentId());
        }
        return commentDefinition;
    }

    public void setAssignmentScoreComment(final String gradebookUid, final Long assignmentId, final String studentUid, final String commentText) throws GradebookNotFoundException, AssessmentNotFoundException {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Comment comment = BaseHibernateManager.this.getInternalComment(gradebookUid, assignmentId, studentUid, session);
                if (comment == null) {
                    comment = new Comment(studentUid, commentText, (GradableObject)BaseHibernateManager.this.getAssignmentWithoutStats(gradebookUid, assignmentId, session));
                } else {
                    comment.setCommentText(commentText);
                }
                comment.setGraderId(BaseHibernateManager.this.authn.getUserUid());
                comment.setDateRecorded(new Date());
                session.saveOrUpdate((Object)comment);
                return null;
            }
        });
    }

    public void updateGradeMapping(final Long gradeMappingId, final Map<String, Double> gradeMap) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                GradeMapping gradeMapping = (GradeMapping)session.load(GradeMapping.class, (Serializable)gradeMappingId);
                gradeMapping.setGradeMap(gradeMap);
                session.update((Object)gradeMapping);
                session.flush();
                return null;
            }
        });
    }

    protected List<CourseGradeRecord> getCourseGradeOverrides(Gradebook gradebook, Session session) throws HibernateException {
        return session.createQuery("from CourseGradeRecord as cgr where cgr.gradableObject.gradebook=? and cgr.enteredGrade is not null").setEntity(0, (Object)gradebook).list();
    }
}

