/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.gradebook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.sakaiproject.component.gradebook.BaseHibernateManager;
import org.sakaiproject.section.api.SectionAwareness;
import org.sakaiproject.section.api.coursemanagement.CourseSection;
import org.sakaiproject.section.api.coursemanagement.EnrollmentRecord;
import org.sakaiproject.section.api.facade.Role;
import org.sakaiproject.service.gradebook.shared.GradebookPermissionService;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.service.gradebook.shared.GraderPermission;
import org.sakaiproject.service.gradebook.shared.PermissionDefinition;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradebookAssignment;
import org.sakaiproject.tool.gradebook.Permission;
import org.springframework.orm.hibernate4.HibernateCallback;

public class GradebookPermissionServiceImpl
extends BaseHibernateManager
implements GradebookPermissionService {
    private SectionAwareness sectionAwareness;

    public List<Long> getCategoriesForUser(Long gradebookId, String userId, List<Long> categoryIdList) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getCategoriesForUser");
        }
        List<Permission> anyCategoryPermission = this.getPermissionsForUserAnyCategory(gradebookId, userId);
        if (anyCategoryPermission != null && anyCategoryPermission.size() > 0) {
            return categoryIdList;
        }
        ArrayList<Long> returnCatIds = new ArrayList<Long>();
        List<Permission> permList = this.getPermissionsForUserForCategory(gradebookId, userId, categoryIdList);
        for (Permission perm : permList) {
            if (perm == null || returnCatIds.contains(perm.getCategoryId())) continue;
            returnCatIds.add(perm.getCategoryId());
        }
        return returnCatIds;
    }

    public List<Long> getCategoriesForUserForStudentView(Long gradebookId, String userId, String studentId, List<Long> categoriesIds, List<String> sectionIds) throws IllegalArgumentException {
        if (gradebookId == null || userId == null || studentId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getCategoriesForUser");
        }
        ArrayList<Long> returnCategoryList = new ArrayList<Long>();
        if (categoriesIds == null || categoriesIds.isEmpty()) {
            return returnCategoryList;
        }
        List<Permission> graderPermissions = this.getPermissionsForUser(gradebookId, userId);
        if (graderPermissions == null || graderPermissions.isEmpty()) {
            return returnCategoryList;
        }
        ArrayList<String> studentSections = new ArrayList<String>();
        if (sectionIds != null) {
            for (String sectionId : sectionIds) {
                if (sectionId == null || !this.sectionAwareness.isSectionMemberInRole(sectionId, studentId, Role.STUDENT)) continue;
                studentSections.add(sectionId);
            }
        }
        for (Permission perm : graderPermissions) {
            String sectionId = perm.getGroupId();
            if (!studentSections.contains(sectionId) && sectionId != null) continue;
            Long catId = perm.getCategoryId();
            if (catId == null) {
                return returnCategoryList;
            }
            returnCategoryList.add(catId);
        }
        return returnCategoryList;
    }

    public boolean getPermissionForUserForAllAssignment(Long gradebookId, String userId) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getPermissionForUserForAllAssignment");
        }
        List<Permission> anyCategoryPermission = this.getPermissionsForUserAnyCategory(gradebookId, userId);
        return anyCategoryPermission != null && anyCategoryPermission.size() > 0;
    }

    public boolean getPermissionForUserForAllAssignmentForStudent(Long gradebookId, String userId, String studentId, List sectionIds) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getPermissionForUserForAllAssignment");
        }
        List<Permission> graderPermissions = this.getPermissionsForUser(gradebookId, userId);
        if (graderPermissions == null || graderPermissions.isEmpty()) {
            return false;
        }
        for (Permission perm : graderPermissions) {
            String sectionId = perm.getGroupId();
            if (sectionId != null && (!sectionIds.contains(sectionId) || !this.sectionAwareness.isSectionMemberInRole(sectionId, studentId, Role.STUDENT)) || perm.getCategoryId() != null) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getStudentsForItem(Long gradebookId, String userId, List<String> studentIds, int cateType, Long categoryId, List courseSections) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getStudentsForItem");
        }
        if (cateType != 2 && cateType != 3 && cateType != 1) {
            throw new IllegalArgumentException("Invalid category type in GradebookPermissionServiceImpl.getStudentsForItem");
        }
        if (studentIds != null) {
            Map<String, List<String>> sectionIdStudentIdsMap = this.getSectionIdStudentIdsMap(courseSections, studentIds);
            if (cateType == 1) {
                List<Permission> perms = this.getPermissionsForUserAnyGroup(gradebookId, userId);
                HashMap<String, String> studentMap = new HashMap<String, String>();
                if (perms != null && perms.size() > 0) {
                    boolean view = false;
                    boolean grade = false;
                    for (Permission perm : perms) {
                        if (perm != null && perm.getFunction().equalsIgnoreCase(GradebookService.gradePermission)) {
                            grade = true;
                            break;
                        }
                        if (perm == null || !perm.getFunction().equalsIgnoreCase(GradebookService.viewPermission)) continue;
                        view = true;
                    }
                    Iterator<String> studentIter = studentIds.iterator();
                    while (studentIter.hasNext()) {
                        if (grade) {
                            studentMap.put(studentIter.next(), GradebookService.gradePermission);
                            continue;
                        }
                        if (!view) continue;
                        studentMap.put(studentIter.next(), GradebookService.viewPermission);
                    }
                }
                if ((perms = this.getPermissionsForUser(gradebookId, userId)) != null) {
                    Map<String, String> studentMapForGroups = this.filterPermissionForGrader(perms, studentIds, sectionIdStudentIdsMap);
                    for (Map.Entry<String, String> entry : studentMapForGroups.entrySet()) {
                        String key2 = entry.getKey();
                        if ((!studentMap.containsKey(key2) || !((String)studentMap.get(key2)).equalsIgnoreCase(GradebookService.viewPermission)) && studentMap.containsKey(key2)) continue;
                        studentMap.put(key2, studentMapForGroups.get(key2));
                    }
                }
                return studentMap;
            }
            ArrayList<Long> cateList = new ArrayList<Long>();
            cateList.add(categoryId);
            List<Permission> perms = this.getPermissionsForUserAnyGroupForCategory(gradebookId, userId, cateList);
            HashMap<String, String> studentMap = new HashMap<String, String>();
            if (perms != null && perms.size() > 0) {
                boolean view = false;
                boolean grade = false;
                for (Permission permission : perms) {
                    if (permission != null && permission.getFunction().equalsIgnoreCase(GradebookService.gradePermission)) {
                        grade = true;
                        break;
                    }
                    if (permission == null || !permission.getFunction().equalsIgnoreCase(GradebookService.viewPermission)) continue;
                    view = true;
                }
                Iterator<String> studentIter = studentIds.iterator();
                while (studentIter.hasNext()) {
                    if (grade) {
                        studentMap.put(studentIter.next(), GradebookService.gradePermission);
                        continue;
                    }
                    if (!view) continue;
                    studentMap.put(studentIter.next(), GradebookService.viewPermission);
                }
            }
            if ((perms = this.getPermissionsForUserAnyGroupAnyCategory(gradebookId, userId)) != null) {
                Map<String, String> studentMapForGroups = this.filterPermissionForGraderForAllStudent(perms, studentIds);
                for (Map.Entry<String, String> entry : studentMapForGroups.entrySet()) {
                    String string = entry.getKey();
                    if ((!studentMap.containsKey(string) || !((String)studentMap.get(string)).equalsIgnoreCase(GradebookService.viewPermission)) && studentMap.containsKey(string)) continue;
                    studentMap.put(string, entry.getValue());
                }
            }
            if (courseSections != null && !courseSections.isEmpty()) {
                ArrayList<String> groupIds = new ArrayList<String>();
                for (CourseSection grp : courseSections) {
                    if (grp == null) continue;
                    groupIds.add(grp.getUuid());
                }
                perms = this.getPermissionsForUserForGoupsAnyCategory(gradebookId, userId, groupIds);
                if (perms != null) {
                    Map<String, String> studentMapForGroups = this.filterPermissionForGrader(perms, studentIds, sectionIdStudentIdsMap);
                    for (Map.Entry entry : studentMapForGroups.entrySet()) {
                        String key3 = (String)entry.getKey();
                        if ((!studentMap.containsKey(key3) || !((String)studentMap.get(key3)).equalsIgnoreCase(GradebookService.viewPermission)) && studentMap.containsKey(key3)) continue;
                        studentMap.put(key3, (String)entry.getValue());
                    }
                }
            }
            if ((perms = this.getPermissionsForUserForCategory(gradebookId, userId, cateList)) != null) {
                Map<String, String> studentMapForGroups = this.filterPermissionForGrader(perms, studentIds, sectionIdStudentIdsMap);
                for (Map.Entry<String, String> entry : studentMapForGroups.entrySet()) {
                    String string = entry.getKey();
                    if ((!studentMap.containsKey(string) || !((String)studentMap.get(string)).equalsIgnoreCase(GradebookService.viewPermission)) && studentMap.containsKey(string)) continue;
                    studentMap.put(string, entry.getValue());
                }
            }
            return studentMap;
        }
        return null;
    }

    public Map<String, String> getStudentsForItem(String gradebookUid, String userId, List<String> studentIds, int cateType, Long categoryId, List courseSections) throws IllegalArgumentException {
        if (gradebookUid == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getStudentsForItem");
        }
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        return this.getStudentsForItem(gradebookId, userId, studentIds, cateType, categoryId, courseSections);
    }

    public List<String> getViewableGroupsForUser(Long gradebookId, String userId, List<String> groupIds) {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getViewableSectionsForUser");
        }
        if (groupIds == null || groupIds.size() == 0) {
            return null;
        }
        List<Permission> anyGroupPermission = this.getPermissionsForUserAnyGroup(gradebookId, userId);
        if (anyGroupPermission != null && anyGroupPermission.size() > 0) {
            return groupIds;
        }
        List permList = this.getPermissionsForUserForGroup(gradebookId, userId, groupIds);
        ArrayList<String> filteredGroups = new ArrayList<String>();
        block0: for (String groupId : groupIds) {
            if (groupId == null) continue;
            for (Permission perm : permList) {
                if (perm == null || !perm.getGroupId().equals(groupId)) continue;
                filteredGroups.add(groupId);
                continue block0;
            }
        }
        return filteredGroups;
    }

    public List getViewableGroupsForUser(String gradebookUid, String userId, List groupIds) {
        if (gradebookUid == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getViewableSectionsForUser");
        }
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        return this.getViewableGroupsForUser(gradebookId, userId, (List<String>)groupIds);
    }

    public List getGraderPermissionsForUser(Long gradebookId, String userId) {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getPermissionsForUser");
        }
        return this.getPermissionsForUser(gradebookId, userId);
    }

    public List getGraderPermissionsForUser(String gradebookUid, String userId) {
        if (gradebookUid == null || userId == null) {
            throw new IllegalArgumentException("Null gradebookUid or userId passed to getGraderPermissionsForUser");
        }
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        return this.getPermissionsForUser(gradebookId, userId);
    }

    private Map<String, String> filterPermissionForGrader(List<Permission> perms, List<String> studentIds, Map<String, List<String>> sectionIdStudentIdsMap) {
        if (perms != null) {
            HashMap<String, String> permMap = new HashMap<String, String>();
            for (Permission perm : perms) {
                if (perm == null) continue;
                if (permMap.containsKey(perm.getGroupId()) && ((String)permMap.get(perm.getGroupId())).equalsIgnoreCase(GradebookService.viewPermission)) {
                    if (!perm.getFunction().equalsIgnoreCase(GradebookService.gradePermission)) continue;
                    permMap.put(perm.getGroupId(), GradebookService.gradePermission);
                    continue;
                }
                if (permMap.containsKey(perm.getGroupId())) continue;
                permMap.put(perm.getGroupId(), perm.getFunction());
            }
            HashMap<String, String> studentMap = new HashMap<String, String>();
            if (perms != null) {
                for (String studentId : studentIds) {
                    if (sectionIdStudentIdsMap == null) continue;
                    for (Map.Entry<String, List<String>> entry : sectionIdStudentIdsMap.entrySet()) {
                        String grpId = entry.getKey();
                        List<String> sectionMembers = entry.getValue();
                        if (sectionMembers == null || !sectionMembers.contains(studentId) || !permMap.containsKey(grpId)) continue;
                        if (studentMap.containsKey(studentId) && ((String)studentMap.get(studentId)).equalsIgnoreCase(GradebookService.viewPermission)) {
                            if (!((String)permMap.get(grpId)).equalsIgnoreCase(GradebookService.gradePermission)) continue;
                            studentMap.put(studentId, GradebookService.gradePermission);
                            continue;
                        }
                        if (studentMap.containsKey(studentId)) continue;
                        studentMap.put(studentId, (String)permMap.get(grpId));
                    }
                }
            }
            return studentMap;
        }
        return new HashMap<String, String>();
    }

    private Map<String, String> filterPermissionForGraderForAllStudent(List<Permission> perms, List<String> studentIds) {
        if (perms != null) {
            Boolean grade = false;
            Boolean view = false;
            for (Permission perm : perms) {
                if (perm.getFunction().equalsIgnoreCase(GradebookService.gradePermission)) {
                    grade = true;
                    break;
                }
                if (!perm.getFunction().equalsIgnoreCase(GradebookService.viewPermission)) continue;
                view = true;
            }
            HashMap<String, String> studentMap = new HashMap<String, String>();
            if (grade.booleanValue() || view.booleanValue()) {
                for (String studentId : studentIds) {
                    if (grade.booleanValue()) {
                        studentMap.put(studentId, GradebookService.gradePermission);
                        continue;
                    }
                    if (!view.booleanValue()) continue;
                    studentMap.put(studentId, GradebookService.viewPermission);
                }
            }
            return studentMap;
        }
        return new HashMap<String, String>();
    }

    private Map filterPermissionForGraderForAllAssignments(List perms, List assignmentList) {
        if (perms != null) {
            Boolean grade = false;
            Boolean view = false;
            for (Permission perm : perms) {
                if (perm.getFunction().equalsIgnoreCase(GradebookService.gradePermission)) {
                    grade = true;
                    break;
                }
                if (!perm.getFunction().equalsIgnoreCase(GradebookService.viewPermission)) continue;
                view = true;
            }
            HashMap<Long, String> assignMap = new HashMap<Long, String>();
            if (grade.booleanValue() || view.booleanValue()) {
                for (GradebookAssignment assign : assignmentList) {
                    if (grade.booleanValue() && assign != null) {
                        assignMap.put(assign.getId(), GradebookService.gradePermission);
                        continue;
                    }
                    if (!view.booleanValue() || assign == null) continue;
                    assignMap.put(assign.getId(), GradebookService.viewPermission);
                }
            }
            return assignMap;
        }
        return new HashMap();
    }

    private Map getAvailableItemsForStudent(Gradebook gradebook, String userId, String studentId, Map sectionIdCourseSectionMap, Map catIdCategoryMap, List assignments, List permsForUserAnyGroup, List allPermsForUser, List permsForAnyGroupForCategories, List permsForUserAnyGroupAnyCategory, List permsForGroupsAnyCategory, List permsForUserForCategories, Map sectionIdStudentIdsMap) throws IllegalArgumentException {
        Long key;
        Map<Long, String> assignMapForGroups;
        if (gradebook == null || userId == null || studentId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getAvailableItemsForStudent");
        }
        ArrayList cateList = new ArrayList(catIdCategoryMap.values());
        if (gradebook.getCategory_type() == 1) {
            HashMap<Long, String> assignMap = new HashMap<Long, String>();
            if (permsForUserAnyGroup != null && permsForUserAnyGroup.size() > 0) {
                boolean view = false;
                boolean grade = false;
                for (Permission perm : permsForUserAnyGroup) {
                    if (perm != null && perm.getFunction().equalsIgnoreCase(GradebookService.gradePermission)) {
                        grade = true;
                        break;
                    }
                    if (perm == null || !perm.getFunction().equalsIgnoreCase(GradebookService.viewPermission)) continue;
                    view = true;
                }
                for (GradebookAssignment as : assignments) {
                    if (grade && as != null) {
                        assignMap.put(as.getId(), GradebookService.gradePermission);
                        continue;
                    }
                    if (!view || as == null) continue;
                    assignMap.put(as.getId(), GradebookService.viewPermission);
                }
            }
            if (allPermsForUser != null) {
                Map assignsMapForGroups = this.filterPermissionForGrader(allPermsForUser, studentId, assignments, sectionIdStudentIdsMap);
                for (Map.Entry entry : assignsMapForGroups.entrySet()) {
                    Long key2 = (Long)entry.getKey();
                    if ((!assignMap.containsKey(key2) || !((String)assignMap.get(key2)).equalsIgnoreCase(GradebookService.viewPermission)) && assignMap.containsKey(key2)) continue;
                    assignMap.put(key2, (String)entry.getValue());
                }
            }
            return assignMap;
        }
        HashMap<Long, Object> assignMap = new HashMap<Long, Object>();
        if (permsForAnyGroupForCategories != null && permsForAnyGroupForCategories.size() > 0) {
            block3: for (Permission perm : permsForAnyGroupForCategories) {
                if (perm == null || perm.getCategoryId() == null) continue;
                for (Category cate : cateList) {
                    if (cate == null || !cate.getId().equals(perm.getCategoryId())) continue;
                    List assignmentList = cate.getAssignmentList();
                    if (assignmentList == null) continue block3;
                    for (GradebookAssignment as : assignmentList) {
                        if (as == null) continue;
                        Long assignId = as.getId();
                        if (as.getCategory() == null) continue;
                        if (assignMap.containsKey(assignId) && ((String)assignMap.get(assignId)).equalsIgnoreCase(GradebookService.viewPermission)) {
                            if (!perm.getFunction().equalsIgnoreCase(GradebookService.gradePermission)) continue;
                            assignMap.put(assignId, GradebookService.gradePermission);
                            continue;
                        }
                        if (assignMap.containsKey(assignId)) continue;
                        assignMap.put(assignId, perm.getFunction());
                    }
                    continue block3;
                }
            }
        }
        if (permsForUserAnyGroupAnyCategory != null) {
            assignMapForGroups = this.filterPermissionForGraderForAllAssignments(permsForUserAnyGroupAnyCategory, assignments);
            for (Map.Entry entry : assignMapForGroups.entrySet()) {
                key = (Long)entry.getKey();
                if ((!assignMap.containsKey(key) || !((String)assignMap.get(key)).equalsIgnoreCase(GradebookService.viewPermission)) && assignMap.containsKey(key)) continue;
                assignMap.put(key, entry.getValue());
            }
        }
        if (permsForGroupsAnyCategory != null) {
            assignMapForGroups = this.filterPermissionForGrader(permsForGroupsAnyCategory, studentId, assignments, sectionIdStudentIdsMap);
            for (Map.Entry entry : assignMapForGroups.entrySet()) {
                key = (Long)entry.getKey();
                if ((!assignMap.containsKey(key) || !((String)assignMap.get(key)).equalsIgnoreCase(GradebookService.viewPermission)) && assignMap.containsKey(key)) continue;
                assignMap.put(key, entry.getValue());
            }
        }
        if (permsForUserForCategories != null && (assignMapForGroups = this.filterPermissionForGraderForCategory(permsForUserForCategories, studentId, cateList, sectionIdStudentIdsMap)) != null) {
            for (Map.Entry<Object, Object> entry : assignMapForGroups.entrySet()) {
                key = (Long)entry.getKey();
                if ((!assignMap.containsKey(key) || !((String)assignMap.get(key)).equalsIgnoreCase(GradebookService.viewPermission)) && assignMap.containsKey(key)) continue;
                assignMap.put(key, entry.getValue());
            }
        }
        return assignMap;
    }

    public Map getAvailableItemsForStudent(Long gradebookId, String userId, String studentId, Collection courseSections) throws IllegalArgumentException {
        if (gradebookId == null || userId == null || studentId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getAvailableItemsForStudent");
        }
        List categories = this.getCategoriesWithAssignments(gradebookId);
        HashMap<Long, Category> catIdCategoryMap = new HashMap<Long, Category>();
        if (!categories.isEmpty()) {
            for (Category cat : categories) {
                if (cat == null) continue;
                catIdCategoryMap.put(cat.getId(), cat);
            }
        }
        HashMap<String, CourseSection> sectionIdCourseSectionMap = new HashMap<String, CourseSection>();
        if (!courseSections.isEmpty()) {
            for (CourseSection section : courseSections) {
                if (section == null) continue;
                sectionIdCourseSectionMap.put(section.getUuid(), section);
            }
        }
        ArrayList<String> studentIds = new ArrayList<String>();
        studentIds.add(studentId);
        Map<String, List<String>> sectionIdStudentIdsMap = this.getSectionIdStudentIdsMap(courseSections, studentIds);
        Gradebook gradebook = this.getGradebook(this.getGradebookUid(gradebookId));
        List<GradebookAssignment> assignments = this.getAssignments(gradebookId);
        ArrayList categoryIds = new ArrayList(catIdCategoryMap.keySet());
        ArrayList groupIds = new ArrayList(sectionIdCourseSectionMap.keySet());
        List<Permission> permsForUserAnyGroup = this.getPermissionsForUserAnyGroup(gradebookId, userId);
        List<Permission> allPermsForUser = this.getPermissionsForUser(gradebookId, userId);
        List<Permission> permsForAnyGroupForCategories = this.getPermissionsForUserAnyGroupForCategory(gradebookId, userId, categoryIds);
        List<Permission> permsForUserAnyGroupAnyCategory = this.getPermissionsForUserAnyGroupAnyCategory(gradebookId, userId);
        List<Permission> permsForGroupsAnyCategory = this.getPermissionsForUserForGoupsAnyCategory(gradebookId, userId, groupIds);
        List<Permission> permsForUserForCategories = this.getPermissionsForUserForCategory(gradebookId, userId, categoryIds);
        return this.getAvailableItemsForStudent(gradebook, userId, studentId, sectionIdCourseSectionMap, catIdCategoryMap, assignments, permsForUserAnyGroup, allPermsForUser, permsForAnyGroupForCategories, permsForUserAnyGroupAnyCategory, permsForGroupsAnyCategory, permsForUserForCategories, sectionIdStudentIdsMap);
    }

    public Map getAvailableItemsForStudent(String gradebookUid, String userId, String studentId, Collection courseSections) throws IllegalArgumentException {
        if (gradebookUid == null || userId == null || studentId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getAvailableItemsForStudent");
        }
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        return this.getAvailableItemsForStudent(gradebookId, userId, studentId, courseSections);
    }

    private Map filterPermissionForGrader(List perms, String studentId, List assignmentList, Map sectionIdStudentIdsMap) {
        if (perms != null) {
            HashMap<String, String> permMap = new HashMap<String, String>();
            for (Permission perm : perms) {
                if (perm == null) continue;
                if (permMap.containsKey(perm.getGroupId()) && ((String)permMap.get(perm.getGroupId())).equalsIgnoreCase(GradebookService.viewPermission)) {
                    if (!perm.getFunction().equalsIgnoreCase(GradebookService.gradePermission)) continue;
                    permMap.put(perm.getGroupId(), GradebookService.gradePermission);
                    continue;
                }
                if (permMap.containsKey(perm.getGroupId())) continue;
                permMap.put(perm.getGroupId(), perm.getFunction());
            }
            HashMap<Long, String> assignmentMap = new HashMap<Long, String>();
            if (perms != null && sectionIdStudentIdsMap != null) {
                Iterator iter = assignmentList.iterator();
                while (iter.hasNext()) {
                    Long assignId = ((GradebookAssignment)iter.next()).getId();
                    for (Map.Entry entry : sectionIdStudentIdsMap.entrySet()) {
                        String grpId = (String)entry.getKey();
                        List sectionMembers = (List)sectionIdStudentIdsMap.get(grpId);
                        if (sectionMembers == null || !sectionMembers.contains(studentId) || !permMap.containsKey(grpId)) continue;
                        if (assignmentMap.containsKey(assignId) && ((String)assignmentMap.get(assignId)).equalsIgnoreCase(GradebookService.viewPermission)) {
                            if (!((String)permMap.get(grpId)).equalsIgnoreCase(GradebookService.gradePermission)) continue;
                            assignmentMap.put(assignId, GradebookService.gradePermission);
                            continue;
                        }
                        if (assignmentMap.containsKey(assignId)) continue;
                        assignmentMap.put(assignId, (String)permMap.get(grpId));
                    }
                }
            }
            return assignmentMap;
        }
        return new HashMap();
    }

    private Map<Long, String> filterPermissionForGraderForCategory(List perms, String studentId, List categoryList, Map sectionIdStudentIdsMap) {
        if (perms != null) {
            HashMap<Long, String> assignmentMap = new HashMap<Long, String>();
            block0: for (Permission perm : perms) {
                if (perm == null || perm.getCategoryId() == null) continue;
                for (Category cate : categoryList) {
                    if (cate == null || !cate.getId().equals(perm.getCategoryId())) continue;
                    List assignmentList = cate.getAssignmentList();
                    if (assignmentList == null) continue block0;
                    for (GradebookAssignment as : assignmentList) {
                        if (as == null || sectionIdStudentIdsMap == null) continue;
                        Long assignId = as.getId();
                        for (Map.Entry entry : sectionIdStudentIdsMap.entrySet()) {
                            String grpId = (String)entry.getKey();
                            List sectionMembers = (List)sectionIdStudentIdsMap.get(grpId);
                            if (sectionMembers == null || !sectionMembers.contains(studentId) || as.getCategory() == null) continue;
                            if (assignmentMap.containsKey(assignId) && grpId.equals(perm.getGroupId()) && ((String)assignmentMap.get(assignId)).equalsIgnoreCase(GradebookService.viewPermission)) {
                                if (!perm.getFunction().equalsIgnoreCase(GradebookService.gradePermission)) continue;
                                assignmentMap.put(assignId, GradebookService.gradePermission);
                                continue;
                            }
                            if (assignmentMap.containsKey(assignId) || !grpId.equals(perm.getGroupId())) continue;
                            assignmentMap.put(assignId, perm.getFunction());
                        }
                    }
                    continue block0;
                }
            }
            return assignmentMap;
        }
        return new HashMap<Long, String>();
    }

    public Map getAvailableItemsForStudents(Long gradebookId, String userId, List studentIds, Collection courseSections) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getAvailableItemsForStudents");
        }
        HashMap<Long, Category> catIdCategoryMap = new HashMap<Long, Category>();
        List categories = this.getCategoriesWithAssignments(gradebookId);
        if (categories != null && !categories.isEmpty()) {
            for (Category cat : categories) {
                if (cat == null) continue;
                catIdCategoryMap.put(cat.getId(), cat);
            }
        }
        HashMap<String, CourseSection> sectionIdCourseSectionMap = new HashMap<String, CourseSection>();
        if (!courseSections.isEmpty()) {
            for (CourseSection section : courseSections) {
                if (section == null) continue;
                sectionIdCourseSectionMap.put(section.getUuid(), section);
            }
        }
        Map<String, List<String>> sectionIdStudentIdsMap = this.getSectionIdStudentIdsMap(courseSections, studentIds);
        Gradebook gradebook = this.getGradebook(this.getGradebookUid(gradebookId));
        List<GradebookAssignment> assignments = this.getAssignments(gradebookId);
        ArrayList categoryIds = new ArrayList(catIdCategoryMap.keySet());
        ArrayList groupIds = new ArrayList(sectionIdCourseSectionMap.keySet());
        List<Permission> permsForUserAnyGroup = this.getPermissionsForUserAnyGroup(gradebookId, userId);
        List<Permission> allPermsForUser = this.getPermissionsForUser(gradebookId, userId);
        List<Permission> permsForAnyGroupForCategories = this.getPermissionsForUserAnyGroupForCategory(gradebookId, userId, categoryIds);
        List<Permission> permsForUserAnyGroupAnyCategory = this.getPermissionsForUserAnyGroupAnyCategory(gradebookId, userId);
        List<Permission> permsForGroupsAnyCategory = this.getPermissionsForUserForGoupsAnyCategory(gradebookId, userId, groupIds);
        List<Permission> permsForUserForCategories = this.getPermissionsForUserForCategory(gradebookId, userId, categoryIds);
        if (studentIds != null) {
            HashMap<String, Map> studentsMap = new HashMap<String, Map>();
            for (String studentId : studentIds) {
                if (studentId == null) continue;
                Map assignMap = this.getAvailableItemsForStudent(gradebook, userId, studentId, sectionIdCourseSectionMap, catIdCategoryMap, assignments, permsForUserAnyGroup, allPermsForUser, permsForAnyGroupForCategories, permsForUserAnyGroupAnyCategory, permsForGroupsAnyCategory, permsForUserForCategories, sectionIdStudentIdsMap);
                studentsMap.put(studentId, assignMap);
            }
            return studentsMap;
        }
        return new HashMap();
    }

    public Map getAvailableItemsForStudents(String gradebookUid, String userId, List studentIds, Collection courseSections) throws IllegalArgumentException {
        if (gradebookUid == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getAvailableItemsForStudents");
        }
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        return this.getAvailableItemsForStudents(gradebookId, userId, studentIds, courseSections);
    }

    public Map getCourseGradePermission(Long gradebookId, String userId, List studentIds, List courseSections) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getCourseGradePermission");
        }
        if (studentIds != null) {
            HashMap<String, String> studentsMap = new HashMap<String, String>();
            Map<String, List<String>> sectionIdStudentIdsMap = this.getSectionIdStudentIdsMap(courseSections, studentIds);
            List<Permission> perms = this.getPermissionsForUserAnyGroupAnyCategory(gradebookId, userId);
            if (perms != null) {
                Map<String, String> studentMapForGroups = this.filterPermissionForGraderForAllStudent(perms, studentIds);
                for (Map.Entry<String, String> entry : studentMapForGroups.entrySet()) {
                    String key = entry.getKey();
                    if ((!studentsMap.containsKey(key) || !((String)studentsMap.get(key)).equalsIgnoreCase(GradebookService.viewPermission)) && studentsMap.containsKey(key)) continue;
                    studentsMap.put(key, studentMapForGroups.get(key));
                }
            }
            ArrayList<String> groupIds = new ArrayList<String>();
            if (courseSections != null) {
                Gradebook gradebook;
                for (CourseSection grp : courseSections) {
                    if (grp == null) continue;
                    groupIds.add(grp.getUuid());
                }
                perms = this.getPermissionsForUserForGoupsAnyCategory(gradebookId, userId, groupIds);
                if (perms != null) {
                    Map<String, String> studentMapForGroups = this.filterPermissionForGrader(perms, studentIds, sectionIdStudentIdsMap);
                    for (Map.Entry<String, String> entry : studentMapForGroups.entrySet()) {
                        String key = entry.getKey();
                        if ((!studentsMap.containsKey(key) || !((String)studentsMap.get(key)).equalsIgnoreCase(GradebookService.viewPermission)) && studentsMap.containsKey(key)) continue;
                        studentsMap.put(key, entry.getValue());
                    }
                }
                if ((gradebook = this.getGradebook(this.getGradebookUid(gradebookId))) != null && (gradebook.getCategory_type() == 2 || gradebook.getCategory_type() == 3)) {
                    List cateList = this.getCategories(gradebookId);
                    perms = this.getPermissionsForUserForGroup(gradebookId, userId, groupIds);
                    if (perms != null) {
                        Map<String, String> studentMapForGroups = this.filterForAllCategoryStudents(perms, studentIds, cateList, sectionIdStudentIdsMap);
                        for (Map.Entry entry : studentMapForGroups.entrySet()) {
                            String key = (String)entry.getKey();
                            if ((!studentsMap.containsKey(key) || !((String)studentsMap.get(key)).equalsIgnoreCase(GradebookService.viewPermission)) && studentsMap.containsKey(key)) continue;
                            studentsMap.put(key, (String)entry.getValue());
                        }
                    }
                    ArrayList<Long> cateIdList = new ArrayList<Long>();
                    for (Category category : cateList) {
                        if (category == null) continue;
                        cateIdList.add(category.getId());
                    }
                    perms = this.getPermissionsForUserAnyGroupForCategory(gradebookId, userId, cateIdList);
                    if (perms != null && perms.size() > 0) {
                        Map<String, String> studentMapForGroups = this.filterForAllCategoryStudentsAnyGroup(perms, courseSections, studentIds, cateList);
                        for (Map.Entry<String, String> entry : studentMapForGroups.entrySet()) {
                            String key = entry.getKey();
                            if ((!studentsMap.containsKey(key) || !((String)studentsMap.get(key)).equalsIgnoreCase(GradebookService.viewPermission)) && studentsMap.containsKey(key)) continue;
                            studentsMap.put(key, entry.getValue());
                        }
                    }
                }
            }
            return studentsMap;
        }
        return new HashMap();
    }

    public Map getCourseGradePermission(String gradebookUid, String userId, List studentIds, List courseSections) throws IllegalArgumentException {
        if (gradebookUid == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getCourseGradePermission");
        }
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        return this.getCourseGradePermission(gradebookId, userId, studentIds, courseSections);
    }

    private Map<String, String> filterForAllCategoryStudents(List perms, List studentIds, List cateList, Map sectionIdStudentIdsMap) {
        if (perms != null && sectionIdStudentIdsMap != null && studentIds != null && cateList != null) {
            ArrayList<Long> cateIdList = new ArrayList<Long>();
            for (Category cate : cateList) {
                if (cate == null) continue;
                cateIdList.add(cate.getId());
            }
            HashMap<String, Map> studentCateMap = new HashMap<String, Map>();
            for (String studentId : studentIds) {
                studentCateMap.put(studentId, new HashMap());
                if (studentId == null) continue;
                for (Map.Entry entry : sectionIdStudentIdsMap.entrySet()) {
                    List grpMembers;
                    String grpId = (String)entry.getKey();
                    if (grpId == null || (grpMembers = (List)sectionIdStudentIdsMap.get(grpId)) == null || grpMembers.isEmpty() || !grpMembers.contains(studentId)) continue;
                    for (Permission perm : perms) {
                        if (perm == null || !perm.getGroupId().equals(grpId) || perm.getCategoryId() == null || !cateIdList.contains(perm.getCategoryId())) continue;
                        Map cateMap = (Map)studentCateMap.get(studentId);
                        if (cateMap.get(perm.getCategoryId()) == null || ((String)cateMap.get(perm.getCategoryId())).equals(GradebookService.viewPermission)) {
                            cateMap.put(perm.getCategoryId(), perm.getFunction());
                        }
                        studentCateMap.put(studentId, cateMap);
                    }
                }
            }
            HashMap<String, String> studentPermissionMap = new HashMap<String, String>();
            for (Map.Entry perEntry : studentCateMap.entrySet()) {
                String studentId = (String)perEntry.getKey();
                Map cateMap = (Map)perEntry.getValue();
                if (cateMap == null) continue;
                for (Long existCateId : cateIdList) {
                    if (existCateId == null) continue;
                    boolean hasPermissionForCate = false;
                    String permission = null;
                    for (Map.Entry entry : cateMap.entrySet()) {
                        Long cateId = (Long)entry.getKey();
                        if (!cateId.equals(existCateId)) continue;
                        hasPermissionForCate = true;
                        permission = (String)entry.getValue();
                        break;
                    }
                    if (hasPermissionForCate && permission != null) {
                        if (studentPermissionMap.get(studentId) != null && !((String)studentPermissionMap.get(studentId)).equals(GradebookService.gradePermission)) continue;
                        studentPermissionMap.put(studentId, permission);
                        continue;
                    }
                    if (hasPermissionForCate || studentPermissionMap.get(studentId) == null) continue;
                    studentPermissionMap.remove(studentId);
                }
            }
            return studentPermissionMap;
        }
        return new HashMap<String, String>();
    }

    private Map<String, String> filterForAllCategoryStudentsAnyGroup(List perms, List courseSections, List studentIds, List cateList) {
        if (perms != null && courseSections != null && studentIds != null && cateList != null) {
            HashMap<Long, String> cateMap = new HashMap<Long, String>();
            for (Category cate : cateList) {
                if (cate == null) continue;
                boolean permissionExistForCate = false;
                for (Permission perm : perms) {
                    if (perm == null || !perm.getCategoryId().equals(cate.getId())) continue;
                    if (cateMap.get(cate.getId()) == null || ((String)cateMap.get(cate.getId())).equals(GradebookService.viewPermission)) {
                        cateMap.put(cate.getId(), perm.getFunction());
                    }
                    permissionExistForCate = true;
                }
                if (permissionExistForCate) continue;
                return new HashMap<String, String>();
            }
            boolean view = false;
            Iterator iter = cateMap.keySet().iterator();
            while (iter.hasNext()) {
                String permission = (String)cateMap.get((Long)iter.next());
                if (permission == null || !permission.equals(GradebookService.viewPermission)) continue;
                view = true;
            }
            HashMap<String, String> studentMap = new HashMap<String, String>();
            for (String studentId : studentIds) {
                if (view) {
                    studentMap.put(studentId, GradebookService.viewPermission);
                    continue;
                }
                studentMap.put(studentId, GradebookService.gradePermission);
            }
            return studentMap;
        }
        return new HashMap<String, String>();
    }

    public List getViewableStudentsForUser(Long gradebookId, String userId, List studentIds, List sections) {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getAvailableItemsForStudent");
        }
        ArrayList viewableStudents = new ArrayList();
        if (studentIds == null || studentIds.isEmpty()) {
            return viewableStudents;
        }
        List<Permission> permsForAnyGroup = this.getPermissionsForUserAnyGroup(gradebookId, userId);
        if (!permsForAnyGroup.isEmpty()) {
            return studentIds;
        }
        Map<String, List<String>> sectionIdStudentIdsMap = this.getSectionIdStudentIdsMap(sections, studentIds);
        if (sectionIdStudentIdsMap.isEmpty()) {
            return null;
        }
        HashMap studentMap = new HashMap();
        ArrayList<String> groupIds = new ArrayList<String>(sectionIdStudentIdsMap.keySet());
        List permsForGroupsAnyCategory = this.getPermissionsForUserForGroup(gradebookId, userId, groupIds);
        if (permsForGroupsAnyCategory.isEmpty()) {
            return viewableStudents;
        }
        for (Permission perm : permsForGroupsAnyCategory) {
            ArrayList sectionStudentIds;
            String groupId = perm.getGroupId();
            if (groupId == null || (sectionStudentIds = (ArrayList)sectionIdStudentIdsMap.get(groupId)) == null || sectionStudentIds.isEmpty()) continue;
            for (String studentId : sectionStudentIds) {
                studentMap.put(studentId, null);
            }
        }
        return new ArrayList(studentMap.keySet());
    }

    public List getViewableStudentsForUser(String gradebookUid, String userId, List studentIds, List sections) {
        if (gradebookUid == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in GradebookPermissionServiceImpl.getViewableStudentsForUser");
        }
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        return this.getViewableStudentsForUser(gradebookId, userId, studentIds, sections);
    }

    @Override
    public SectionAwareness getSectionAwareness() {
        return this.sectionAwareness;
    }

    @Override
    public void setSectionAwareness(SectionAwareness sectionAwareness) {
        this.sectionAwareness = sectionAwareness;
    }

    private Map<String, List<String>> getSectionIdStudentIdsMap(Collection courseSections, Collection studentIds) {
        HashMap<String, List<String>> sectionIdStudentIdsMap = new HashMap<String, List<String>>();
        if (courseSections != null) {
            for (CourseSection section : courseSections) {
                if (section == null) continue;
                String sectionId = section.getUuid();
                List members = this.getSectionAwareness().getSectionMembersInRole(sectionId, Role.STUDENT);
                ArrayList<String> sectionMembersFiltered = new ArrayList<String>();
                if (!members.isEmpty()) {
                    for (EnrollmentRecord enr : members) {
                        String studentId = enr.getUser().getUserUid();
                        if (!studentIds.contains(studentId)) continue;
                        sectionMembersFiltered.add(studentId);
                    }
                }
                sectionIdStudentIdsMap.put(sectionId, sectionMembersFiltered);
            }
        }
        return sectionIdStudentIdsMap;
    }

    public List<PermissionDefinition> getPermissionsForUser(String gradebookUid, String userId) {
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        List<Permission> permissions = this.getPermissionsForUser(gradebookId, userId);
        ArrayList<PermissionDefinition> rval = new ArrayList<PermissionDefinition>();
        for (Permission permission : permissions) {
            rval.add(this.toPermissionDefinition(permission));
        }
        return rval;
    }

    public void updatePermissionsForUser(String gradebookUid, String userId, List<PermissionDefinition> permissionDefinitions) {
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        final List<Permission> currentPermissions = this.getPermissionsForUser(gradebookId, userId);
        final ArrayList<Permission> newPermissions = new ArrayList<Permission>();
        for (PermissionDefinition def : permissionDefinitions) {
            if (!(StringUtils.equalsIgnoreCase((CharSequence)def.getFunction(), (CharSequence)GraderPermission.GRADE.toString()) || StringUtils.equalsIgnoreCase((CharSequence)def.getFunction(), (CharSequence)GraderPermission.VIEW.toString()) || StringUtils.equalsIgnoreCase((CharSequence)def.getFunction(), (CharSequence)GraderPermission.VIEW_COURSE_GRADE.toString()))) {
                throw new IllegalArgumentException("Invalid function for permission definition: " + def.getFunction());
            }
            Permission permission = new Permission();
            permission.setCategoryId(def.getCategoryId());
            permission.setGradebookId(gradebookId);
            permission.setGroupId(def.getGroupReference());
            permission.setFunction(def.getFunction());
            permission.setUserId(userId);
            newPermissions.add(permission);
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                for (Permission currentPermission : currentPermissions) {
                    session.delete((Object)currentPermission);
                }
                for (Permission newPermission : newPermissions) {
                    session.save((Object)newPermission);
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
    }

    private PermissionDefinition toPermissionDefinition(Permission permission) {
        PermissionDefinition rval = new PermissionDefinition();
        if (permission != null) {
            rval.setId(permission.getId());
            rval.setUserId(permission.getUserId());
            rval.setCategoryId(permission.getCategoryId());
            rval.setFunction(permission.getFunction());
            rval.setGroupReference(permission.getGroupId());
        }
        return rval;
    }
}

