/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook.facades.sections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.section.api.SectionAwareness;
import org.sakaiproject.section.api.coursemanagement.CourseSection;
import org.sakaiproject.section.api.coursemanagement.EnrollmentRecord;
import org.sakaiproject.section.api.facade.Role;
import org.sakaiproject.service.gradebook.shared.Assignment;
import org.sakaiproject.service.gradebook.shared.GradebookPermissionService;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.gradebook.GradebookAssignment;
import org.sakaiproject.tool.gradebook.facades.Authn;
import org.sakaiproject.tool.gradebook.facades.Authz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzSectionsImpl
implements Authz {
    private static final Logger log = LoggerFactory.getLogger(AuthzSectionsImpl.class);
    private Authn authn;
    private SectionAwareness sectionAwareness;
    private GradebookPermissionService gradebookPermissionService;

    public boolean isUserAbleToGrade(String gradebookUid) {
        String userUid = this.authn.getUserUid();
        return this.isUserAbleToGrade(gradebookUid, userUid);
    }

    public boolean isUserAbleToGrade(String gradebookUid, String userUid) {
        return this.getSectionAwareness().isSiteMemberInRole(gradebookUid, userUid, Role.INSTRUCTOR) || this.getSectionAwareness().isSiteMemberInRole(gradebookUid, userUid, Role.TA);
    }

    public boolean isUserAbleToGradeAll(String gradebookUid) {
        return this.isUserAbleToGradeAll(gradebookUid, this.authn.getUserUid());
    }

    public boolean isUserAbleToGradeAll(String gradebookUid, String userUid) {
        return this.getSectionAwareness().isSiteMemberInRole(gradebookUid, userUid, Role.INSTRUCTOR);
    }

    public boolean isUserHasGraderPermissions(String gradebookUid) {
        String userUid = this.authn.getUserUid();
        List permissions = this.gradebookPermissionService.getGraderPermissionsForUser(gradebookUid, userUid);
        return permissions != null && permissions.size() > 0;
    }

    public boolean isUserHasGraderPermissions(Long gradebookId) {
        String userUid = this.authn.getUserUid();
        List permissions = this.gradebookPermissionService.getGraderPermissionsForUser(gradebookId, userUid);
        return permissions != null && permissions.size() > 0;
    }

    public boolean isUserHasGraderPermissions(String gradebookUid, String userUid) {
        List permissions = this.gradebookPermissionService.getGraderPermissionsForUser(gradebookUid, userUid);
        return permissions != null && permissions.size() > 0;
    }

    public boolean isUserHasGraderPermissions(Long gradebookId, String userUid) {
        List permissions = this.gradebookPermissionService.getGraderPermissionsForUser(gradebookId, userUid);
        return permissions != null && permissions.size() > 0;
    }

    private boolean isUserTAinSection(String sectionUid) {
        String userUid = this.authn.getUserUid();
        return this.getSectionAwareness().isSectionMemberInRole(sectionUid, userUid, Role.TA);
    }

    private boolean isUserTAinSection(String sectionUid, String userUid) {
        return this.getSectionAwareness().isSectionMemberInRole(sectionUid, userUid, Role.TA);
    }

    public boolean isUserAbleToEditAssessments(String gradebookUid) {
        String userUid = this.authn.getUserUid();
        return this.getSectionAwareness().isSiteMemberInRole(gradebookUid, userUid, Role.INSTRUCTOR);
    }

    public boolean isUserAbleToViewOwnGrades(String gradebookUid) {
        String userUid = this.authn.getUserUid();
        return this.getSectionAwareness().isSiteMemberInRole(gradebookUid, userUid, Role.STUDENT);
    }

    public boolean isUserAbleToViewStudentNumbers(String gradebookUid) {
        String userUid = this.authn.getUserUid();
        return this.getSectionAwareness().isSiteMemberInRole(gradebookUid, userUid, Role.INSTRUCTOR);
    }

    public String getGradeViewFunctionForUserForStudentForItem(String gradebookUid, Long itemId, String studentUid) {
        if (itemId == null || studentUid == null || gradebookUid == null) {
            throw new IllegalArgumentException("Null parameter(s) in AuthzSectionsServiceImpl.isUserAbleToGradeItemForStudent");
        }
        if (this.isUserAbleToGradeAll(gradebookUid)) {
            return GradebookService.gradePermission;
        }
        String userUid = this.authn.getUserUid();
        List viewableSections = this.getViewableSections(gradebookUid);
        ArrayList<String> sectionIds = new ArrayList<String>();
        if (viewableSections != null && !viewableSections.isEmpty()) {
            for (CourseSection section : viewableSections) {
                sectionIds.add(section.getUuid());
            }
        }
        if (this.isUserHasGraderPermissions(gradebookUid, userUid)) {
            Map itemIdFunctionMap = this.gradebookPermissionService.getAvailableItemsForStudent(gradebookUid, userUid, studentUid, (Collection)viewableSections);
            if (itemIdFunctionMap == null || itemIdFunctionMap.isEmpty()) {
                return null;
            }
            String functionValueForItem = (String)itemIdFunctionMap.get(itemId);
            String view = GradebookService.viewPermission;
            String grade = GradebookService.gradePermission;
            if (functionValueForItem != null) {
                if (functionValueForItem.equalsIgnoreCase(grade)) {
                    return GradebookService.gradePermission;
                }
                if (functionValueForItem.equalsIgnoreCase(view)) {
                    return GradebookService.viewPermission;
                }
            }
            return null;
        }
        for (String sectionUuid : sectionIds) {
            if (!this.isUserTAinSection(sectionUuid) || !this.getSectionAwareness().isSectionMemberInRole(sectionUuid, studentUid, Role.STUDENT)) continue;
            return GradebookService.gradePermission;
        }
        return null;
    }

    private boolean isUserAbleToGradeOrViewItemForStudent(String gradebookUid, Long itemId, String studentUid, String function) throws IllegalArgumentException {
        if (itemId == null || studentUid == null || function == null) {
            throw new IllegalArgumentException("Null parameter(s) in AuthzSectionsServiceImpl.isUserAbleToGradeItemForStudent");
        }
        if (this.isUserAbleToGradeAll(gradebookUid)) {
            return true;
        }
        String userUid = this.authn.getUserUid();
        List viewableSections = this.getViewableSections(gradebookUid);
        ArrayList<String> sectionIds = new ArrayList<String>();
        if (viewableSections != null && !viewableSections.isEmpty()) {
            for (CourseSection section : viewableSections) {
                sectionIds.add(section.getUuid());
            }
        }
        if (this.isUserHasGraderPermissions(gradebookUid, userUid)) {
            Map itemIdFunctionMap = this.gradebookPermissionService.getAvailableItemsForStudent(gradebookUid, userUid, studentUid, (Collection)viewableSections);
            if (itemIdFunctionMap == null || itemIdFunctionMap.isEmpty()) {
                return false;
            }
            String functionValueForItem = (String)itemIdFunctionMap.get(itemId);
            String view = GradebookService.viewPermission;
            String grade = GradebookService.gradePermission;
            if (functionValueForItem != null) {
                if (function.equalsIgnoreCase(grade) && functionValueForItem.equalsIgnoreCase(grade)) {
                    return true;
                }
                if (function.equalsIgnoreCase(view) && (functionValueForItem.equalsIgnoreCase(grade) || functionValueForItem.equalsIgnoreCase(view))) {
                    return true;
                }
            }
            return false;
        }
        for (String sectionUuid : sectionIds) {
            if (!this.isUserTAinSection(sectionUuid) || !this.getSectionAwareness().isSectionMemberInRole(sectionUuid, studentUid, Role.STUDENT)) continue;
            return true;
        }
        return false;
    }

    public boolean isUserAbleToGradeItemForStudent(String gradebookUid, Long itemId, String studentUid) throws IllegalArgumentException {
        return this.isUserAbleToGradeOrViewItemForStudent(gradebookUid, itemId, studentUid, GradebookService.gradePermission);
    }

    public boolean isUserAbleToViewItemForStudent(String gradebookUid, Long itemId, String studentUid) throws IllegalArgumentException {
        return this.isUserAbleToGradeOrViewItemForStudent(gradebookUid, itemId, studentUid, GradebookService.viewPermission);
    }

    public List getViewableSections(String gradebookUid) {
        ArrayList<CourseSection> viewableSections = new ArrayList<CourseSection>();
        List allSections = this.getAllSections(gradebookUid);
        if (allSections == null || allSections.isEmpty()) {
            return viewableSections;
        }
        if (this.isUserAbleToGradeAll(gradebookUid)) {
            return allSections;
        }
        HashMap<String, CourseSection> sectionIdCourseSectionMap = new HashMap<String, CourseSection>();
        for (CourseSection section : allSections) {
            sectionIdCourseSectionMap.put(section.getUuid(), section);
        }
        String userUid = this.authn.getUserUid();
        if (this.isUserHasGraderPermissions(gradebookUid, userUid)) {
            List viewableSectionIds = this.gradebookPermissionService.getViewableGroupsForUser(gradebookUid, userUid, new ArrayList(sectionIdCourseSectionMap.keySet()));
            if (viewableSectionIds != null && !viewableSectionIds.isEmpty()) {
                for (String sectionUuid : viewableSectionIds) {
                    CourseSection viewableSection = (CourseSection)sectionIdCourseSectionMap.get(sectionUuid);
                    if (viewableSection == null) continue;
                    viewableSections.add(viewableSection);
                }
            }
        } else {
            for (Map.Entry entry : sectionIdCourseSectionMap.entrySet()) {
                CourseSection viewableSection;
                String sectionUuid = (String)entry.getKey();
                if (!this.isUserTAinSection(sectionUuid) || (viewableSection = (CourseSection)sectionIdCourseSectionMap.get(sectionUuid)) == null) continue;
                viewableSections.add(viewableSection);
            }
        }
        Collections.sort(viewableSections);
        return viewableSections;
    }

    public List getAllSections(String gradebookUid) {
        SectionAwareness sectionAwareness = this.getSectionAwareness();
        List sections = sectionAwareness.getSections(gradebookUid);
        return sections;
    }

    private List getSectionEnrollmentsTrusted(String sectionUid) {
        return this.getSectionAwareness().getSectionMembersInRole(sectionUid, Role.STUDENT);
    }

    public Map findMatchingEnrollmentsForItem(String gradebookUid, Long categoryId, int gbCategoryType, String optionalSearchString, String optionalSectionUid) {
        String userUid = this.authn.getUserUid();
        return this.findMatchingEnrollmentsForItemOrCourseGrade(userUid, gradebookUid, categoryId, gbCategoryType, optionalSearchString, optionalSectionUid, false);
    }

    public Map findMatchingEnrollmentsForItemForUser(String userUid, String gradebookUid, Long categoryId, int gbCategoryType, String optionalSearchString, String optionalSectionUid) {
        return this.findMatchingEnrollmentsForItemOrCourseGrade(userUid, gradebookUid, categoryId, gbCategoryType, optionalSearchString, optionalSectionUid, false);
    }

    public Map findMatchingEnrollmentsForViewableCourseGrade(String gradebookUid, int gbCategoryType, String optionalSearchString, String optionalSectionUid) {
        String userUid = this.authn.getUserUid();
        return this.findMatchingEnrollmentsForItemOrCourseGrade(userUid, gradebookUid, null, gbCategoryType, optionalSearchString, optionalSectionUid, true);
    }

    public Map findMatchingEnrollmentsForViewableItems(String gradebookUid, List allGbItems, String optionalSearchString, String optionalSectionUid) {
        HashMap<Object, Map> enrollmentMap;
        block33: {
            HashMap<String, CourseSection> sectionIdCourseSectionMap;
            HashMap<String, EnrollmentRecord> studentIdEnrRecMap;
            block34: {
                block32: {
                    List sectionMembers;
                    enrollmentMap = new HashMap<Object, Map>();
                    List filteredEnrollments = null;
                    filteredEnrollments = optionalSearchString != null ? this.getSectionAwareness().findSiteMembersInRole(gradebookUid, Role.STUDENT, optionalSearchString) : this.getSectionAwareness().getSiteMembersInRole(gradebookUid, Role.STUDENT);
                    if (filteredEnrollments == null || filteredEnrollments.isEmpty()) {
                        return enrollmentMap;
                    }
                    HashMap<String, EnrollmentRecord> studentsInSectionMap = new HashMap<String, EnrollmentRecord>();
                    if (optionalSectionUid != null && !(sectionMembers = this.getSectionEnrollmentsTrusted(optionalSectionUid)).isEmpty()) {
                        for (EnrollmentRecord member : sectionMembers) {
                            studentsInSectionMap.put(member.getUser().getUserUid(), member);
                        }
                    }
                    studentIdEnrRecMap = new HashMap<String, EnrollmentRecord>();
                    for (EnrollmentRecord enr : filteredEnrollments) {
                        String studentId = enr.getUser().getUserUid();
                        if (optionalSectionUid != null) {
                            if (!studentsInSectionMap.containsKey(studentId)) continue;
                            studentIdEnrRecMap.put(studentId, enr);
                            continue;
                        }
                        studentIdEnrRecMap.put(studentId, enr);
                    }
                    if (!this.isUserAbleToGradeAll(gradebookUid)) break block32;
                    ArrayList enrollments = new ArrayList(studentIdEnrRecMap.values());
                    HashMap<Long, String> assignFunctionMap = new HashMap<Long, String>();
                    if (allGbItems != null && !allGbItems.isEmpty()) {
                        for (Object assign : allGbItems) {
                            Long assignId = null;
                            if (assign instanceof Assignment) {
                                assignId = ((Assignment)assign).getId();
                            } else if (assign instanceof GradebookAssignment) {
                                assignId = ((GradebookAssignment)assign).getId();
                            }
                            if (assignId == null) continue;
                            assignFunctionMap.put(assignId, GradebookService.gradePermission);
                        }
                    }
                    for (EnrollmentRecord enr : enrollments) {
                        enrollmentMap.put(enr, assignFunctionMap);
                    }
                    break block33;
                }
                String userId = this.authn.getUserUid();
                sectionIdCourseSectionMap = new HashMap<String, CourseSection>();
                List viewableSections = this.getViewableSections(gradebookUid);
                for (CourseSection section : viewableSections) {
                    sectionIdCourseSectionMap.put(section.getUuid(), section);
                }
                if (!this.isUserHasGraderPermissions(gradebookUid)) break block34;
                List<Object> myStudentIds = new ArrayList(studentIdEnrRecMap.keySet());
                ArrayList<Object> selSections = new ArrayList();
                if (optionalSectionUid == null) {
                    selSections = new ArrayList(sectionIdCourseSectionMap.values());
                } else {
                    CourseSection section = (CourseSection)sectionIdCourseSectionMap.get(optionalSectionUid);
                    if (section != null) {
                        selSections.add(section);
                    }
                }
                myStudentIds = this.getGradebookPermissionService().getViewableStudentsForUser(gradebookUid, userId, myStudentIds, selSections);
                Map<String, Object> viewableStudentIdItemsMap = new HashMap();
                if (allGbItems == null || allGbItems.isEmpty()) {
                    if (myStudentIds != null) {
                        for (String string : myStudentIds) {
                            if (string == null) continue;
                            viewableStudentIdItemsMap.put(string, null);
                        }
                    }
                } else {
                    viewableStudentIdItemsMap = this.gradebookPermissionService.getAvailableItemsForStudents(gradebookUid, userId, myStudentIds, selSections);
                }
                if (viewableStudentIdItemsMap.isEmpty()) break block33;
                for (Map.Entry entry : viewableStudentIdItemsMap.entrySet()) {
                    String studentId = (String)entry.getKey();
                    EnrollmentRecord enrRec = (EnrollmentRecord)studentIdEnrRecMap.get(studentId);
                    if (enrRec == null) continue;
                    Map itemIdFunctionMap = (Map)viewableStudentIdItemsMap.get(studentId);
                    enrollmentMap.put(enrRec, itemIdFunctionMap);
                }
                break block33;
            }
            ArrayList<String> availableSections = new ArrayList<String>();
            if (optionalSectionUid != null && this.isUserTAinSection(optionalSectionUid)) {
                if (sectionIdCourseSectionMap.containsKey(optionalSectionUid)) {
                    availableSections.add(optionalSectionUid);
                }
            } else {
                for (String sectionUuid : sectionIdCourseSectionMap.keySet()) {
                    if (!this.isUserTAinSection(sectionUuid)) continue;
                    availableSections.add(sectionUuid);
                }
            }
            HashMap<String, EnrollmentRecord> uniqueEnrollees = new HashMap<String, EnrollmentRecord>();
            for (String sectionUuid : availableSections) {
                List list = this.getSectionEnrollmentsTrusted(sectionUuid);
                for (EnrollmentRecord enr : list) {
                    uniqueEnrollees.put(enr.getUser().getUserUid(), enr);
                }
            }
            for (String enrId : studentIdEnrRecMap.keySet()) {
                if (!uniqueEnrollees.containsKey(enrId)) continue;
                HashMap<Long, String> hashMap = new HashMap<Long, String>();
                if (allGbItems != null && !allGbItems.isEmpty()) {
                    for (Object assign : allGbItems) {
                        Long assignId = null;
                        if (assign instanceof Assignment) {
                            assignId = ((Assignment)assign).getId();
                        } else if (assign instanceof GradebookAssignment) {
                            assignId = ((GradebookAssignment)assign).getId();
                        }
                        if (assignId == null) continue;
                        hashMap.put(assignId, GradebookService.gradePermission);
                    }
                }
                enrollmentMap.put(studentIdEnrRecMap.get(enrId), hashMap);
            }
        }
        return enrollmentMap;
    }

    private Map findMatchingEnrollmentsForItemOrCourseGrade(String userUid, String gradebookUid, Long categoryId, int gbCategoryType, String optionalSearchString, String optionalSectionUid, boolean itemIsCourseGrade) {
        List sectionMembers;
        Map<EnrollmentRecord, String> enrollmentMap = new HashMap<EnrollmentRecord, String>();
        List filteredEnrollments = new ArrayList();
        filteredEnrollments = optionalSearchString != null ? this.getSectionAwareness().findSiteMembersInRole(gradebookUid, Role.STUDENT, optionalSearchString) : this.getSectionAwareness().getSiteMembersInRole(gradebookUid, Role.STUDENT);
        if (filteredEnrollments.isEmpty()) {
            return enrollmentMap;
        }
        HashMap<String, EnrollmentRecord> studentsInSectionMap = new HashMap<String, EnrollmentRecord>();
        if (optionalSectionUid != null && !(sectionMembers = this.getSectionAwareness().getSectionMembersInRole(optionalSectionUid, Role.STUDENT)).isEmpty()) {
            for (EnrollmentRecord member : sectionMembers) {
                studentsInSectionMap.put(member.getUser().getUserUid(), member);
            }
        }
        HashMap<String, EnrollmentRecord> studentIdEnrRecMap = new HashMap<String, EnrollmentRecord>();
        for (EnrollmentRecord enr : filteredEnrollments) {
            String studentId = enr.getUser().getUserUid();
            if (optionalSectionUid != null) {
                if (!studentsInSectionMap.containsKey(studentId)) continue;
                studentIdEnrRecMap.put(studentId, enr);
                continue;
            }
            studentIdEnrRecMap.put(enr.getUser().getUserUid(), enr);
        }
        if (this.isUserAbleToGradeAll(gradebookUid, userUid)) {
            ArrayList enrollments = new ArrayList(studentIdEnrRecMap.values());
            for (EnrollmentRecord enr : enrollments) {
                enrollmentMap.put(enr, GradebookService.gradePermission);
            }
        } else {
            HashMap<String, CourseSection> sectionIdCourseSectionMap = new HashMap<String, CourseSection>();
            List allSections = this.getAllSections(gradebookUid);
            for (CourseSection section : allSections) {
                sectionIdCourseSectionMap.put(section.getUuid(), section);
            }
            if (this.isUserHasGraderPermissions(gradebookUid, userUid)) {
                ArrayList myStudentIds = new ArrayList(studentIdEnrRecMap.keySet());
                ArrayList<Object> selSections = new ArrayList();
                if (optionalSectionUid == null) {
                    selSections = new ArrayList(sectionIdCourseSectionMap.values());
                } else {
                    CourseSection section = (CourseSection)sectionIdCourseSectionMap.get(optionalSectionUid);
                    if (section != null) {
                        selSections.add(section);
                    }
                }
                Map viewableEnrollees = new HashMap();
                viewableEnrollees = itemIsCourseGrade ? this.gradebookPermissionService.getCourseGradePermission(gradebookUid, userUid, myStudentIds, selSections) : this.gradebookPermissionService.getStudentsForItem(gradebookUid, userUid, myStudentIds, gbCategoryType, categoryId, selSections);
                if (!viewableEnrollees.isEmpty()) {
                    for (Map.Entry entry : viewableEnrollees.entrySet()) {
                        String studentId = (String)entry.getKey();
                        EnrollmentRecord enrRec = (EnrollmentRecord)studentIdEnrRecMap.get(studentId);
                        if (enrRec == null) continue;
                        enrollmentMap.put(enrRec, (String)viewableEnrollees.get(studentId));
                    }
                }
            } else {
                enrollmentMap = this.getEnrollmentMapUsingDefaultPermissions(userUid, studentIdEnrRecMap, sectionIdCourseSectionMap, optionalSectionUid);
            }
        }
        return enrollmentMap;
    }

    private Map getEnrollmentMapUsingDefaultPermissions(String userUid, Map studentIdEnrRecMap, Map sectionIdCourseSectionMap, String optionalSectionUid) {
        HashMap enrollmentMap = new HashMap();
        ArrayList<String> availableSections = new ArrayList<String>();
        if (optionalSectionUid != null && this.isUserTAinSection(optionalSectionUid, userUid)) {
            if (sectionIdCourseSectionMap.containsKey(optionalSectionUid)) {
                availableSections.add(optionalSectionUid);
            }
        } else {
            for (String sectionUuid : sectionIdCourseSectionMap.keySet()) {
                if (!this.isUserTAinSection(sectionUuid, userUid)) continue;
                availableSections.add(sectionUuid);
            }
        }
        HashMap<String, EnrollmentRecord> uniqueEnrollees = new HashMap<String, EnrollmentRecord>();
        for (String sectionUuid : availableSections) {
            List sectionEnrollments = this.getSectionEnrollmentsTrusted(sectionUuid);
            for (EnrollmentRecord enr : sectionEnrollments) {
                uniqueEnrollees.put(enr.getUser().getUserUid(), enr);
            }
        }
        for (String enrId : studentIdEnrRecMap.keySet()) {
            if (!uniqueEnrollees.containsKey(enrId)) continue;
            enrollmentMap.put(studentIdEnrRecMap.get(enrId), GradebookService.gradePermission);
        }
        return enrollmentMap;
    }

    public List findStudentSectionMemberships(String gradebookUid, String studentUid) {
        List sectionMemberships = new ArrayList();
        try {
            sectionMemberships = (List)SiteService.getSite((String)gradebookUid).getGroupsWithMember(studentUid);
        }
        catch (IdUnusedException e) {
            log.error("No site with id = " + gradebookUid);
        }
        return sectionMemberships;
    }

    public List getStudentSectionMembershipNames(String gradebookUid, String studentUid) {
        ArrayList<String> sectionNames = new ArrayList<String>();
        List sections = this.findStudentSectionMemberships(gradebookUid, studentUid);
        if (sections != null && !sections.isEmpty()) {
            for (Group myGroup : sections) {
                sectionNames.add(myGroup.getTitle());
            }
        }
        return sectionNames;
    }

    public Authn getAuthn() {
        return this.authn;
    }

    public void setAuthn(Authn authn) {
        this.authn = authn;
    }

    public SectionAwareness getSectionAwareness() {
        return this.sectionAwareness;
    }

    public void setSectionAwareness(SectionAwareness sectionAwareness) {
        this.sectionAwareness = sectionAwareness;
    }

    public GradebookPermissionService getGradebookPermissionService() {
        return this.gradebookPermissionService;
    }

    public void setGradebookPermissionService(GradebookPermissionService gradebookPermissionService) {
        this.gradebookPermissionService = gradebookPermissionService;
    }
}

