/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook.facades.sakai2impl;

import java.util.List;
import org.sakaiproject.authz.cover.FunctionManager;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.section.api.facade.Role;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.gradebook.facades.Authz;
import org.sakaiproject.tool.gradebook.facades.sections.AuthzSectionsImpl;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzSakai2Impl
extends AuthzSectionsImpl
implements Authz {
    private static final Logger log = LoggerFactory.getLogger(AuthzSakai2Impl.class);
    public static final String PERMISSION_GRADE_ALL = "gradebook.gradeAll";
    public static final String PERMISSION_GRADE_SECTION = "gradebook.gradeSection";
    public static final String PERMISSION_EDIT_ASSIGNMENTS = "gradebook.editAssignments";
    public static final String PERMISSION_VIEW_OWN_GRADES = "gradebook.viewOwnGrades";
    public static final String PERMISSION_VIEW_STUDENT_NUMBERS = "gradebook.viewStudentNumbers";

    public void init() {
        List registered = FunctionManager.getInstance().getRegisteredFunctions("gradebook");
        if (!registered.contains(PERMISSION_GRADE_ALL)) {
            FunctionManager.registerFunction((String)PERMISSION_GRADE_ALL);
        }
        if (!registered.contains(PERMISSION_GRADE_SECTION)) {
            FunctionManager.registerFunction((String)PERMISSION_GRADE_SECTION);
        }
        if (!registered.contains(PERMISSION_EDIT_ASSIGNMENTS)) {
            FunctionManager.registerFunction((String)PERMISSION_EDIT_ASSIGNMENTS);
        }
        if (!registered.contains(PERMISSION_VIEW_OWN_GRADES)) {
            FunctionManager.registerFunction((String)PERMISSION_VIEW_OWN_GRADES);
        }
        if (!registered.contains(PERMISSION_VIEW_STUDENT_NUMBERS)) {
            FunctionManager.registerFunction((String)PERMISSION_VIEW_STUDENT_NUMBERS);
        }
    }

    @Override
    public boolean isUserAbleToGrade(String gradebookUid) {
        return this.hasPermission(gradebookUid, PERMISSION_GRADE_ALL) || this.hasPermission(gradebookUid, PERMISSION_GRADE_SECTION);
    }

    @Override
    public boolean isUserAbleToGrade(String gradebookUid, String userUid) {
        try {
            User user = UserDirectoryService.getUser((String)userUid);
            return this.hasPermission(user, gradebookUid, PERMISSION_GRADE_ALL) || this.hasPermission(user, gradebookUid, PERMISSION_GRADE_SECTION);
        }
        catch (UserNotDefinedException unde) {
            log.warn("User not found for userUid: " + userUid);
            return false;
        }
    }

    @Override
    public boolean isUserAbleToGradeAll(String gradebookUid) {
        return this.hasPermission(gradebookUid, PERMISSION_GRADE_ALL);
    }

    @Override
    public boolean isUserAbleToGradeAll(String gradebookUid, String userUid) {
        try {
            User user = UserDirectoryService.getUser((String)userUid);
            return this.hasPermission(user, gradebookUid, PERMISSION_GRADE_ALL);
        }
        catch (UserNotDefinedException unde) {
            log.warn("User not found for userUid: " + userUid);
            return false;
        }
    }

    public boolean isUserAbleToGradeSection(String sectionUid) {
        return this.getSectionAwareness().isSectionMemberInRole(sectionUid, this.getAuthn().getUserUid(), Role.TA);
    }

    @Override
    public boolean isUserAbleToEditAssessments(String gradebookUid) {
        return this.hasPermission(gradebookUid, PERMISSION_EDIT_ASSIGNMENTS);
    }

    @Override
    public boolean isUserAbleToViewOwnGrades(String gradebookUid) {
        return this.hasPermission(gradebookUid, PERMISSION_VIEW_OWN_GRADES);
    }

    @Override
    public boolean isUserAbleToViewStudentNumbers(String gradebookUid) {
        return this.hasPermission(gradebookUid, PERMISSION_VIEW_STUDENT_NUMBERS);
    }

    private boolean hasPermission(String gradebookUid, String permission) {
        return SecurityService.unlock((String)permission, (String)SiteService.siteReference((String)gradebookUid));
    }

    private boolean hasPermission(User user, String gradebookUid, String permission) {
        return SecurityService.unlock((User)user, (String)permission, (String)SiteService.siteReference((String)gradebookUid));
    }
}

