/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.gradebook;

import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.gradebook.BaseHibernateManager;
import org.sakaiproject.hibernate.HibernateCriterionUtils;
import org.sakaiproject.service.gradebook.shared.AssessmentNotFoundException;
import org.sakaiproject.service.gradebook.shared.Assignment;
import org.sakaiproject.service.gradebook.shared.AssignmentHasIllegalPointsException;
import org.sakaiproject.service.gradebook.shared.CommentDefinition;
import org.sakaiproject.service.gradebook.shared.ConflictingAssignmentNameException;
import org.sakaiproject.service.gradebook.shared.ConflictingExternalIdException;
import org.sakaiproject.service.gradebook.shared.ExternalAssignmentProvider;
import org.sakaiproject.service.gradebook.shared.ExternalAssignmentProviderCompat;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.service.gradebook.shared.GradebookHelper;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.service.gradebook.shared.InvalidCategoryException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.tool.gradebook.AssignmentGradeRecord;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradebookAssignment;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.HibernateTemplate;

public class GradebookExternalAssessmentServiceImpl
extends BaseHibernateManager
implements GradebookExternalAssessmentService {
    private static final Logger log = LoggerFactory.getLogger(GradebookExternalAssessmentServiceImpl.class);
    private ToolManager toolManager;
    private SiteService siteService;
    private ConcurrentHashMap<String, ExternalAssignmentProvider> externalProviders = new ConcurrentHashMap();
    private final ConcurrentHashMap<ExternalAssignmentProvider, Method> providerMethods = new ConcurrentHashMap();
    public static final String UPDATE_SAME_SCORE_PROP = "gradebook.externalAssessments.updateSameScore";
    public static final boolean UPDATE_SAME_SCORE_PROP_DEFAULT = false;

    public GradebookService getGradebookService() {
        return (GradebookService)ComponentManager.get((String)"org.sakaiproject.service.gradebook.GradebookService");
    }

    public ConcurrentMap<String, ExternalAssignmentProvider> getExternalAssignmentProviders() {
        if (this.externalProviders == null) {
            this.externalProviders = new ConcurrentHashMap(0);
        }
        return this.externalProviders;
    }

    public void registerExternalAssignmentProvider(ExternalAssignmentProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.getExternalAssignmentProviders().put(provider.getAppKey(), provider);
        if (!(provider instanceof ExternalAssignmentProviderCompat)) {
            try {
                Method m = provider.getClass().getDeclaredMethod("getAllExternalAssignments", String.class);
                if (m.getReturnType().equals(List.class)) {
                    this.providerMethods.put(provider, m);
                }
            }
            catch (Exception e) {
                log.warn("ExternalAssignmentProvider [" + provider.getAppKey() + " / " + provider.getClass().toString() + "] does not implement getAllExternalAssignments. It will not be able to exclude items from student views/grades. See the ExternalAssignmentProviderCompat interface and SAK-23733 for details.");
            }
        }
    }

    public void unregisterExternalAssignmentProvider(String providerAppKey) {
        if (providerAppKey == null || "".equals(providerAppKey)) {
            throw new IllegalArgumentException("providerAppKey must be set");
        }
        if (this.getExternalAssignmentProviders().containsKey(providerAppKey)) {
            ExternalAssignmentProvider provider = (ExternalAssignmentProvider)this.getExternalAssignmentProviders().get(providerAppKey);
            this.providerMethods.remove(provider);
            this.getExternalAssignmentProviders().remove(providerAppKey);
        }
    }

    public void init() {
        log.debug("INIT");
    }

    public void destroy() {
        log.debug("DESTROY");
        if (this.externalProviders != null) {
            this.externalProviders.clear();
            this.externalProviders = null;
        }
    }

    public synchronized void addExternalAssessment(String gradebookUid, String externalId, String externalUrl, String title, double points, Date dueDate, String externalServiceDescription, String externalData) throws ConflictingAssignmentNameException, ConflictingExternalIdException, GradebookNotFoundException {
        if (StringUtils.trimToNull((String)externalServiceDescription) == null || StringUtils.trimToNull((String)externalId) == null || StringUtils.trimToNull((String)title) == null) {
            throw new RuntimeException("External service description, externalId, and title must not be empty");
        }
        if (points <= 0.0) {
            throw new AssignmentHasIllegalPointsException("Points must be > 0");
        }
        if (this.isAssignmentDefined(gradebookUid, title)) {
            throw new ConflictingAssignmentNameException("An assignment with that name already exists in gradebook uid=" + gradebookUid);
        }
        GradebookHelper.validateGradeItemName((String)title);
        this.getHibernateTemplate().execute(session -> {
            Number externalIdConflicts = (Number)session.createCriteria(GradebookAssignment.class).createAlias("gradebook", "g").add((Criterion)Restrictions.eq((String)"externalId", (Object)externalId)).add((Criterion)Restrictions.eq((String)"g.uid", (Object)gradebookUid)).setProjection(Projections.rowCount()).uniqueResult();
            if (externalIdConflicts.intValue() > 0) {
                throw new ConflictingExternalIdException("An external assessment with ID=" + externalId + " already exists in gradebook uid=" + gradebookUid);
            }
            Gradebook gradebook = this.getGradebook(gradebookUid);
            GradebookAssignment asn = new GradebookAssignment(gradebook, title, Double.valueOf(points), dueDate);
            asn.setExternallyMaintained(Boolean.valueOf(true));
            asn.setExternalId(externalId);
            asn.setExternalInstructorLink(externalUrl);
            asn.setExternalStudentLink(externalUrl);
            asn.setExternalAppName(externalServiceDescription);
            asn.setExternalData(externalData);
            asn.setReleased(Boolean.valueOf(true));
            asn.setUngraded(Boolean.valueOf(false));
            session.save((Object)asn);
            return null;
        });
        log.info("External assessment added to gradebookUid={}, externalId={} by userUid={} from externalApp={}", new Object[]{gradebookUid, externalId, this.getUserUid(), externalServiceDescription});
    }

    public void updateExternalAssessment(final String gradebookUid, final String externalId, final String externalUrl, final String externalData, final String title, final double points, final Date dueDate) throws GradebookNotFoundException, AssessmentNotFoundException, AssignmentHasIllegalPointsException {
        final GradebookAssignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        if (points <= 0.0) {
            throw new AssignmentHasIllegalPointsException("Points must be > 0");
        }
        if (StringUtils.trimToNull((String)externalId) == null || StringUtils.trimToNull((String)title) == null) {
            throw new RuntimeException("ExternalId, and title must not be empty");
        }
        GradebookHelper.validateGradeItemName((String)title);
        HibernateCallback<Object> hc = new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                asn.setExternalInstructorLink(externalUrl);
                asn.setExternalStudentLink(externalUrl);
                asn.setExternalData(externalData);
                asn.setName(title);
                asn.setDueDate(dueDate);
                asn.setReleased(Boolean.valueOf(BooleanUtils.isTrue((Boolean)asn.getReleased())));
                asn.setPointsPossible(Double.valueOf(points));
                session.update((Object)asn);
                log.info("External assessment updated in gradebookUid={}, externalId={} by userUid={}", new Object[]{gradebookUid, externalId, GradebookExternalAssessmentServiceImpl.this.getUserUid()});
                return null;
            }
        };
        this.getHibernateTemplate().execute((HibernateCallback)hc);
    }

    public void removeExternalAssessment(String gradebookUid, String externalId) throws GradebookNotFoundException, AssessmentNotFoundException {
        GradebookAssignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no external assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        HibernateTemplate hibTempl = this.getHibernateTemplate();
        hibTempl.execute(session -> {
            int numDeleted = session.createQuery("delete GradingEvent where gradableObject=:go").setParameter("go", (Object)asn).executeUpdate();
            log.debug("Deleted {} records from gb_grading_event_t", (Object)numDeleted);
            numDeleted = session.createQuery("delete AssignmentGradeRecord where gradableObject=:go").setParameter("go", (Object)asn).executeUpdate();
            log.info("Deleted {} externally defined scores", (Object)numDeleted);
            numDeleted = session.createQuery("delete Comment where gradableObject=:go").setParameter("go", (Object)asn).executeUpdate();
            log.info("Deleted {} externally defined comments", (Object)numDeleted);
            return null;
        });
        hibTempl.delete((Object)asn);
        log.info("External assessment removed from gradebookUid={}, externalId={} by userUid={}", new Object[]{gradebookUid, externalId, this.getUserUid()});
    }

    private GradebookAssignment getExternalAssignment(String gradebookUid, String externalId) throws GradebookNotFoundException {
        Gradebook gradebook = this.getGradebook(gradebookUid);
        HibernateCallback hc = session -> (GradebookAssignment)session.createQuery("from GradebookAssignment as asn where asn.gradebook = :gradebook and asn.externalId = :externalid").setEntity("gradebook", (Object)gradebook).setString("externalid", externalId).uniqueResult();
        return (GradebookAssignment)this.getHibernateTemplate().execute(hc);
    }

    public void updateExternalAssessmentComments(String gradebookUid, String externalId, Map<String, String> studentUidsToComments) throws GradebookNotFoundException, AssessmentNotFoundException {
        GradebookAssignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        Set<String> studentIds = studentUidsToComments.keySet();
        if (studentIds.isEmpty()) {
            return;
        }
        this.getHibernateTemplate().execute(session -> {
            List existingScores = session.createCriteria(AssignmentGradeRecord.class).add((Criterion)Restrictions.eq((String)"gradableObject", (Object)asn)).add(HibernateCriterionUtils.CriterionInRestrictionSplitter((String)"studentId", (Collection)studentIds)).list();
            HashSet<String> changedStudents = new HashSet<String>();
            for (AssignmentGradeRecord agr : existingScores) {
                String studentUid = agr.getStudentId();
                boolean alwaysUpdate = this.isUpdateSameScore();
                CommentDefinition gradeComment = this.getAssignmentScoreComment(gradebookUid, asn.getId(), studentUid);
                String oldComment = gradeComment != null ? gradeComment.getCommentText() : null;
                String newComment = (String)studentUidsToComments.get(studentUid);
                if (!alwaysUpdate && (newComment == null || newComment.equals(oldComment)) && (newComment != null || oldComment == null)) continue;
                changedStudents.add(studentUid);
                this.setAssignmentScoreComment(gradebookUid, asn.getId(), studentUid, newComment);
            }
            log.debug("updateExternalAssessmentScores sent {} records, actually changed {}", (Object)studentIds.size(), (Object)changedStudents.size());
            return null;
        });
    }

    public void updateExternalAssessmentScores(String gradebookUid, String externalId, Map<String, Double> studentUidsToScores) throws GradebookNotFoundException, AssessmentNotFoundException {
        GradebookAssignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        Set<String> studentIds = studentUidsToScores.keySet();
        if (studentIds.isEmpty()) {
            return;
        }
        Date now = new Date();
        String graderId = this.getUserUid();
        this.getHibernateTemplate().execute(session -> {
            List existingScores = session.createCriteria(AssignmentGradeRecord.class).add((Criterion)Restrictions.eq((String)"gradableObject", (Object)assignment)).add(HibernateCriterionUtils.CriterionInRestrictionSplitter((String)"studentId", (Collection)studentIds)).list();
            HashSet previouslyUnscoredStudents = new HashSet(studentIds);
            HashSet<String> changedStudents = new HashSet<String>();
            for (AssignmentGradeRecord agr : existingScores) {
                String studentUid = agr.getStudentId();
                previouslyUnscoredStudents.remove(studentUid);
                boolean alwaysUpdate = this.isUpdateSameScore();
                Double oldPointsEarned = agr.getPointsEarned();
                Double newPointsEarned = (Double)studentUidsToScores.get(studentUid);
                if (!alwaysUpdate && (newPointsEarned == null || newPointsEarned.equals(oldPointsEarned)) && (newPointsEarned != null || oldPointsEarned == null)) continue;
                agr.setDateRecorded(now);
                agr.setGraderId(graderId);
                agr.setPointsEarned(newPointsEarned);
                session.update((Object)agr);
                changedStudents.add(studentUid);
                this.postUpdateGradeEvent(gradebookUid, assignment.getName(), studentUid, newPointsEarned);
            }
            for (String studentUid : previouslyUnscoredStudents) {
                Double newPointsEarned = (Double)studentUidsToScores.get(studentUid);
                if (newPointsEarned == null) continue;
                AssignmentGradeRecord agr = new AssignmentGradeRecord(assignment, studentUid, newPointsEarned);
                agr.setDateRecorded(now);
                agr.setGraderId(graderId);
                session.save((Object)agr);
                changedStudents.add(studentUid);
                this.postUpdateGradeEvent(gradebookUid, assignment.getName(), studentUid, newPointsEarned);
            }
            log.debug("updateExternalAssessmentScores sent {} records, actually changed {}", (Object)studentIds.size(), (Object)changedStudents.size());
            return null;
        });
    }

    public void updateExternalAssessmentScoresString(String gradebookUid, String externalId, Map<String, String> studentUidsToScores) throws GradebookNotFoundException, AssessmentNotFoundException {
        GradebookAssignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        Set<String> studentIds = studentUidsToScores.keySet();
        if (studentIds.isEmpty()) {
            return;
        }
        Date now = new Date();
        String graderId = this.getUserUid();
        this.getHibernateTemplate().execute(session -> {
            List existingScores = session.createCriteria(AssignmentGradeRecord.class).add((Criterion)Restrictions.eq((String)"gradableObject", (Object)assignment)).add(HibernateCriterionUtils.CriterionInRestrictionSplitter((String)"studentId", (Collection)studentIds)).list();
            HashSet previouslyUnscoredStudents = new HashSet(studentIds);
            HashSet<String> changedStudents = new HashSet<String>();
            for (AssignmentGradeRecord agr : existingScores) {
                Double newPointsEarned;
                String studentUid = agr.getStudentId();
                previouslyUnscoredStudents.remove(studentUid);
                boolean alwaysUpdate = this.isUpdateSameScore();
                Double oldPointsEarned = agr.getPointsEarned();
                String newPointsEarnedString = (String)studentUidsToScores.get(studentUid);
                Double d = newPointsEarned = newPointsEarnedString == null ? null : this.convertStringToDouble(newPointsEarnedString);
                if (!alwaysUpdate && (newPointsEarned == null || newPointsEarned.equals(oldPointsEarned)) && (newPointsEarned != null || oldPointsEarned == null)) continue;
                agr.setDateRecorded(now);
                agr.setGraderId(graderId);
                if (newPointsEarned != null) {
                    agr.setPointsEarned(newPointsEarned);
                } else {
                    agr.setPointsEarned(null);
                }
                session.update((Object)agr);
                changedStudents.add(studentUid);
                this.postUpdateGradeEvent(gradebookUid, assignment.getName(), studentUid, newPointsEarned);
            }
            for (String studentUid : previouslyUnscoredStudents) {
                String newPointsEarned = (String)studentUidsToScores.get(studentUid);
                if (newPointsEarned == null) continue;
                AssignmentGradeRecord agr = new AssignmentGradeRecord(assignment, studentUid, this.convertStringToDouble(newPointsEarned));
                agr.setDateRecorded(now);
                agr.setGraderId(graderId);
                session.save((Object)agr);
                changedStudents.add(studentUid);
                this.postUpdateGradeEvent(gradebookUid, assignment.getName(), studentUid, this.convertStringToDouble(newPointsEarned));
            }
            log.debug("updateExternalAssessmentScores sent {} records, actually changed {}", (Object)studentIds.size(), (Object)changedStudents.size());
            return null;
        });
    }

    public boolean isAssignmentDefined(String gradebookUid, String assignmentName) throws GradebookNotFoundException {
        GradebookAssignment assignment = (GradebookAssignment)this.getHibernateTemplate().execute(session -> this.getAssignmentWithoutStats(gradebookUid, assignmentName));
        return assignment != null;
    }

    public boolean isExternalAssignmentDefined(String gradebookUid, String externalId) throws GradebookNotFoundException {
        GradebookAssignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        return assignment != null;
    }

    public boolean isExternalAssignmentGrouped(String gradebookUid, String externalId) throws GradebookNotFoundException {
        GradebookAssignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        boolean result = false;
        boolean providerResponded = false;
        if (assignment == null) {
            log.info("No assignment found for external assignment check: gradebookUid=" + gradebookUid + ", externalId=" + externalId);
        } else {
            for (ExternalAssignmentProvider provider : this.getExternalAssignmentProviders().values()) {
                if (!provider.isAssignmentDefined(assignment.getExternalAppName(), externalId)) continue;
                providerResponded = true;
                result = result || provider.isAssignmentGrouped(externalId);
            }
        }
        return result || !providerResponded;
    }

    public boolean isExternalAssignmentVisible(String gradebookUid, String externalId, String userId) throws GradebookNotFoundException {
        GradebookAssignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        boolean result = false;
        boolean providerResponded = false;
        if (assignment == null) {
            log.info("No assignment found for external assignment check: gradebookUid=" + gradebookUid + ", externalId=" + externalId);
        } else {
            for (ExternalAssignmentProvider provider : this.getExternalAssignmentProviders().values()) {
                if (!provider.isAssignmentDefined(assignment.getExternalAppName(), externalId)) continue;
                providerResponded = true;
                result = result || provider.isAssignmentVisible(externalId, userId);
            }
        }
        return result || !providerResponded;
    }

    public Map<String, String> getExternalAssignmentsForCurrentUser(String gradebookUid) throws GradebookNotFoundException {
        HashMap<String, String> visibleAssignments = new HashMap<String, String>();
        Set<String> providedAssignments = this.getProvidedExternalAssignments(gradebookUid);
        for (ExternalAssignmentProvider provider : this.getExternalAssignmentProviders().values()) {
            String appKey = provider.getAppKey();
            List assignments = provider.getExternalAssignmentsForCurrentUser(gradebookUid);
            for (String externalId : assignments) {
                visibleAssignments.put(externalId, appKey);
            }
        }
        List gbAssignments = this.getGradebookService().getViewableAssignmentsForCurrentUser(gradebookUid);
        for (Assignment assignment : gbAssignments) {
            String id = assignment.getExternalId();
            if (!assignment.isExternallyMaintained() || providedAssignments.contains(id) || visibleAssignments.containsKey(id)) continue;
            log.debug("External assignment in gradebook [{}] is not handled by a provider; ID: {}", (Object)gradebookUid, (Object)id);
            visibleAssignments.put(id, null);
        }
        return visibleAssignments;
    }

    protected Set<String> getProvidedExternalAssignments(String gradebookUid) {
        HashSet<String> allAssignments = new HashSet<String>();
        for (ExternalAssignmentProvider provider : this.getExternalAssignmentProviders().values()) {
            if (provider instanceof ExternalAssignmentProviderCompat) {
                allAssignments.addAll(((ExternalAssignmentProviderCompat)provider).getAllExternalAssignments(gradebookUid));
                continue;
            }
            if (!this.providerMethods.containsKey(provider)) continue;
            Method m = this.providerMethods.get(provider);
            try {
                List reflectedAssignments = (List)m.invoke((Object)provider, gradebookUid);
                allAssignments.addAll(reflectedAssignments);
            }
            catch (Exception e) {
                log.debug("Exception calling getAllExternalAssignments", (Throwable)e);
            }
        }
        return allAssignments;
    }

    public Map<String, List<String>> getVisibleExternalAssignments(String gradebookUid, Collection<String> studentIds) throws GradebookNotFoundException {
        Set<String> providedAssignments = this.getProvidedExternalAssignments(gradebookUid);
        HashMap visible = new HashMap();
        for (String studentId : studentIds) {
            visible.put(studentId, new HashSet());
        }
        for (Object provider : this.getExternalAssignmentProviders().values()) {
            HashSet<String> studentIdsCopy = new HashSet<String>(studentIds);
            Map externals = provider.getAllExternalAssignments(gradebookUid, studentIdsCopy);
            for (String studentId : externals.keySet()) {
                if (!visible.containsKey(studentId)) continue;
                ((Set)visible.get(studentId)).addAll((Collection)externals.get(studentId));
            }
        }
        List allAssignments = this.getGradebookService().getViewableAssignmentsForCurrentUser(gradebookUid);
        for (Assignment assignment : allAssignments) {
            String id = assignment.getExternalId();
            if (!assignment.isExternallyMaintained() || providedAssignments.contains(id)) continue;
            for (String studentId : visible.keySet()) {
                ((Set)visible.get(studentId)).add(id);
            }
        }
        HashMap<String, List<String>> visibleList = new HashMap<String, List<String>>();
        for (String studentId : visible.keySet()) {
            visibleList.put(studentId, new ArrayList((Collection)visible.get(studentId)));
        }
        return visibleList;
    }

    public void setExternalAssessmentToGradebookAssignment(String gradebookUid, String externalId) {
        GradebookAssignment assignment = this.getExternalAssignment(gradebookUid, externalId);
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        assignment.setExternalAppName(null);
        assignment.setExternalId(null);
        assignment.setExternalInstructorLink(null);
        assignment.setExternalStudentLink(null);
        assignment.setExternalData(null);
        assignment.setExternallyMaintained(Boolean.valueOf(false));
        this.getHibernateTemplate().execute(session -> {
            session.update((Object)assignment);
            log.info("Externally-managed assignment {} moved to Gradebook management in gradebookUid={} by userUid={}", new Object[]{externalId, gradebookUid, this.getUserUid()});
            return null;
        });
    }

    public void addExternalAssessment(String gradebookUid, String externalId, String externalUrl, String title, Double points, Date dueDate, String externalServiceDescription, String externalData, Boolean ungraded) throws GradebookNotFoundException, ConflictingAssignmentNameException, ConflictingExternalIdException, AssignmentHasIllegalPointsException {
        this.addExternalAssessment(gradebookUid, externalId, externalUrl, title, points, dueDate, externalServiceDescription, externalData, ungraded, null);
    }

    public synchronized void addExternalAssessment(String gradebookUid, String externalId, String externalUrl, String title, Double points, Date dueDate, String externalServiceDescription, String externalData, Boolean ungraded, Long categoryId) throws GradebookNotFoundException, ConflictingAssignmentNameException, ConflictingExternalIdException, AssignmentHasIllegalPointsException {
        if (StringUtils.trimToNull((String)externalServiceDescription) == null || StringUtils.trimToNull((String)externalId) == null || StringUtils.trimToNull((String)title) == null) {
            throw new RuntimeException("External service description, externalId, and title must not be empty");
        }
        if (ungraded != null && !ungraded.booleanValue() && (points == null || points <= 0.0) || ungraded == null && (points == null || points <= 0.0)) {
            throw new AssignmentHasIllegalPointsException("Points can't be null or Points must be > 0");
        }
        if (this.isAssignmentDefined(gradebookUid, title)) {
            throw new ConflictingAssignmentNameException("An assignment with that name already exists in gradebook uid=" + gradebookUid);
        }
        GradebookHelper.validateGradeItemName((String)title);
        this.getHibernateTemplate().execute(session -> {
            Number externalIdConflicts = (Number)session.createCriteria(GradebookAssignment.class).createAlias("gradebook", "g").add((Criterion)Restrictions.eq((String)"externalId", (Object)externalId)).add((Criterion)Restrictions.eq((String)"g.uid", (Object)gradebookUid)).setProjection(Projections.rowCount()).uniqueResult();
            if (externalIdConflicts.intValue() > 0) {
                throw new ConflictingExternalIdException("An external assessment with that ID already exists in gradebook uid=" + gradebookUid);
            }
            Gradebook gradebook = this.getGradebook(gradebookUid);
            Category persistedCategory = null;
            if (categoryId != null) {
                persistedCategory = this.getCategory(categoryId);
                if (persistedCategory.isDropScores()) {
                    List<GradebookAssignment> thisCategoryAssignments = this.getAssignmentsForCategory(categoryId);
                    for (GradebookAssignment thisAssignment : thisCategoryAssignments) {
                        if (Objects.equals(thisAssignment.getPointsPossible(), points)) continue;
                        String errorMessage = "Assignment points mismatch the selected Gradebook Category (" + thisAssignment.getPointsPossible().toString() + ") and cannot be added to Gradebook )";
                        throw new InvalidCategoryException(errorMessage);
                    }
                }
                if (persistedCategory == null || persistedCategory.isRemoved() || !persistedCategory.getGradebook().getId().equals(gradebook.getId())) {
                    throw new InvalidCategoryException("The category with id " + categoryId + " is not valid for gradebook " + gradebook.getUid());
                }
            }
            GradebookAssignment asn = new GradebookAssignment(gradebook, title, points, dueDate);
            asn.setExternallyMaintained(Boolean.valueOf(true));
            asn.setExternalId(externalId);
            asn.setExternalInstructorLink(externalUrl);
            asn.setExternalStudentLink(externalUrl);
            asn.setExternalAppName(externalServiceDescription);
            asn.setExternalData(externalData);
            if (persistedCategory != null) {
                asn.setCategory(persistedCategory);
            }
            asn.setReleased(Boolean.valueOf(true));
            if (ungraded != null) {
                asn.setUngraded(ungraded);
            } else {
                asn.setUngraded(Boolean.valueOf(false));
            }
            session.save((Object)asn);
            return null;
        });
        log.info("External assessment added to gradebookUid={}, externalId={} by userUid={} from externalApp={}", new Object[]{gradebookUid, externalId, this.getUserUid(), externalServiceDescription});
    }

    public void updateExternalAssessment(String gradebookUid, String externalId, String externalUrl, String externalData, String title, Double points, Date dueDate, Boolean ungraded) throws GradebookNotFoundException, AssessmentNotFoundException, ConflictingAssignmentNameException, AssignmentHasIllegalPointsException {
        GradebookAssignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        if (ungraded != null && !ungraded.booleanValue() && (points == null || points <= 0.0) || ungraded == null && (points == null || points <= 0.0)) {
            throw new AssignmentHasIllegalPointsException("Points can't be null or Points must be > 0");
        }
        if (StringUtils.trimToNull((String)externalId) == null || StringUtils.trimToNull((String)title) == null) {
            throw new RuntimeException("ExternalId, and title must not be empty");
        }
        GradebookHelper.validateGradeItemName((String)title);
        HibernateCallback hc = session -> {
            asn.setExternalInstructorLink(externalUrl);
            asn.setExternalStudentLink(externalUrl);
            asn.setExternalData(externalData);
            asn.setName(title);
            asn.setDueDate(dueDate);
            asn.setReleased(Boolean.valueOf(BooleanUtils.isTrue((Boolean)asn.getReleased())));
            asn.setPointsPossible(points);
            if (ungraded != null) {
                asn.setUngraded(Boolean.valueOf(ungraded));
            } else {
                asn.setUngraded(Boolean.valueOf(false));
            }
            session.update((Object)asn);
            log.info("External assessment updated in gradebookUid={}, externalId={} by userUid={}", new Object[]{gradebookUid, externalId, this.getUserUid()});
            return null;
        };
        this.getHibernateTemplate().execute(hc);
    }

    public void updateExternalAssessmentComment(String gradebookUid, String externalId, String studentUid, String comment) throws GradebookNotFoundException, AssessmentNotFoundException {
        GradebookAssignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        log.debug("BEGIN: Update 1 score for gradebookUid={}, external assessment={} from {}", new Object[]{gradebookUid, externalId, asn.getExternalAppName()});
        HibernateCallback hc = session -> {
            String oldComment;
            boolean alwaysUpdate = this.isUpdateSameScore();
            CommentDefinition gradeComment = this.getAssignmentScoreComment(gradebookUid, asn.getId(), studentUid);
            String string = oldComment = gradeComment != null ? gradeComment.getCommentText() : null;
            if (alwaysUpdate || comment != null && !comment.equals(oldComment) || comment == null && oldComment != null) {
                if (comment != null) {
                    this.setAssignmentScoreComment(gradebookUid, asn.getId(), studentUid, comment);
                } else {
                    this.setAssignmentScoreComment(gradebookUid, asn.getId(), studentUid, null);
                }
                log.debug("updateExternalAssessmentComment: grade record saved");
            } else {
                log.debug("Ignoring updateExternalAssessmentComment, since the new comment is the same as the old");
            }
            return null;
        };
        this.getHibernateTemplate().execute(hc);
        log.debug("END: Update 1 score for gradebookUid={}, external assessment={} from {}", new Object[]{gradebookUid, externalId, asn.getExternalAppName()});
        log.debug("External assessment comment updated in gradebookUid={}, externalId={} by userUid={}, new score={}", new Object[]{gradebookUid, externalId, this.getUserUid(), comment});
    }

    public void updateExternalAssessmentScore(String gradebookUid, String externalId, String studentUid, String points) throws GradebookNotFoundException, AssessmentNotFoundException {
        GradebookAssignment asn = this.getExternalAssignment(gradebookUid, externalId);
        if (asn == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUid);
        }
        log.debug("BEGIN: Update 1 score for gradebookUid={}, external assessment={} from {}", new Object[]{gradebookUid, externalId, asn.getExternalAppName()});
        HibernateCallback hc = session -> {
            Double newPointsEarned;
            Date now = new Date();
            AssignmentGradeRecord agr = this.getAssignmentGradeRecord(asn, studentUid);
            boolean alwaysUpdate = this.isUpdateSameScore();
            Double oldPointsEarned = agr == null ? null : agr.getPointsEarned();
            Double d = newPointsEarned = points == null ? null : this.convertStringToDouble(points);
            if (alwaysUpdate || newPointsEarned != null && !newPointsEarned.equals(oldPointsEarned) || newPointsEarned == null && oldPointsEarned != null) {
                if (agr == null) {
                    agr = newPointsEarned != null ? new AssignmentGradeRecord(asn, studentUid, Double.valueOf(newPointsEarned)) : new AssignmentGradeRecord(asn, studentUid, null);
                } else if (newPointsEarned != null) {
                    agr.setPointsEarned(Double.valueOf(newPointsEarned));
                } else {
                    agr.setPointsEarned(null);
                }
                agr.setDateRecorded(now);
                agr.setGraderId(this.getUserUid());
                log.debug("About to save AssignmentGradeRecord id={}, version={}, studenttId={}, pointsEarned={}", new Object[]{agr.getId(), agr.getVersion(), agr.getStudentId(), agr.getPointsEarned()});
                session.saveOrUpdate((Object)agr);
                this.postUpdateGradeEvent(gradebookUid, asn.getName(), studentUid, newPointsEarned);
            } else {
                log.debug("Ignoring updateExternalAssessmentScore, since the new points value is the same as the old");
            }
            return null;
        };
        this.getHibernateTemplate().execute(hc);
        log.debug("END: Update 1 score for gradebookUid={}, external assessment={} from {}", new Object[]{gradebookUid, externalId, asn.getExternalAppName()});
        log.debug("External assessment score updated in gradebookUid={}, externalId={} by userUid={}, new score={}", new Object[]{gradebookUid, externalId, this.getUserUid(), points});
    }

    private void postUpdateGradeEvent(String gradebookUid, String assignmentName, String studentUid, Double pointsEarned) {
        this.postEvent("gradebook.updateItemScore", "/gradebook/" + gradebookUid + "/" + assignmentName + "/" + studentUid + "/" + pointsEarned + "/student");
    }

    private Double convertStringToDouble(String s) {
        Double scoreAsDouble = null;
        String doubleAsString = s;
        if (doubleAsString != null && !"".equals(doubleAsString)) {
            try {
                DecimalFormat dcformat = (DecimalFormat)this.getNumberFormat();
                String decSeparator = dcformat.getDecimalFormatSymbols().getDecimalSeparator() + "";
                if (",".equals(decSeparator)) {
                    doubleAsString = doubleAsString.replace(".", ",");
                }
                Number numericScore = this.getNumberFormat().parse(doubleAsString.trim());
                scoreAsDouble = numericScore.doubleValue();
            }
            catch (ParseException e) {
                log.error(e.getMessage());
            }
        }
        return scoreAsDouble;
    }

    private NumberFormat getNumberFormat() {
        return NumberFormat.getInstance(new ResourceLoader().getLocale());
    }

    public Long getExternalAssessmentCategoryId(String gradebookUId, String externalId) {
        Long categoryId = null;
        GradebookAssignment assignment = this.getExternalAssignment(gradebookUId, externalId);
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assessment id=" + externalId + " in gradebook uid=" + gradebookUId);
        }
        if (assignment.getCategory() != null) {
            categoryId = assignment.getCategory().getId();
        }
        return categoryId;
    }

    private boolean isUpdateSameScore() {
        String siteProperty = null;
        try {
            String siteId = this.toolManager.getCurrentPlacement().getContext();
            Site site = this.siteService.getSite(siteId);
            siteProperty = site.getProperties().getProperty(UPDATE_SAME_SCORE_PROP);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (siteProperty == null) {
            return this.serverConfigurationService.getBoolean(UPDATE_SAME_SCORE_PROP, false);
        }
        return Boolean.TRUE.toString().equals(siteProperty);
    }

    public boolean isCategoriesEnabled(String gradebookUid) {
        Gradebook gradebook = this.getGradebook(gradebookUid);
        return gradebook.getCategory_type() != 1;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

