/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.gradebook;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.component.gradebook.BaseHibernateManager;
import org.sakaiproject.service.gradebook.shared.GradebookExistsException;
import org.sakaiproject.service.gradebook.shared.GradebookFrameworkService;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.service.gradebook.shared.GradingScaleDefinition;
import org.sakaiproject.tool.gradebook.CourseGrade;
import org.sakaiproject.tool.gradebook.GradeMapping;
import org.sakaiproject.tool.gradebook.GradePointsMapping;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradingScale;
import org.sakaiproject.tool.gradebook.LetterGradeMapping;
import org.sakaiproject.tool.gradebook.LetterGradePercentMapping;
import org.sakaiproject.tool.gradebook.LetterGradePlusMinusMapping;
import org.sakaiproject.tool.gradebook.PassNotPassMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.HibernateTemplate;

public class GradebookFrameworkServiceImpl
extends BaseHibernateManager
implements GradebookFrameworkService {
    private static final Logger log = LoggerFactory.getLogger(GradebookFrameworkServiceImpl.class);
    public static final String UID_OF_DEFAULT_GRADING_SCALE_PROPERTY = "uidOfDefaultGradingScale";
    public static final String PROP_COURSE_POINTS_DISPLAYED = "gradebook.coursepoints.displayed";
    public static final String PROP_COURSE_GRADE_DISPLAYED = "gradebook.coursegrade.displayed";
    public static final String PROP_ASSIGNMENTS_DISPLAYED = "gradebook.assignments.displayed";
    public static final String PROP_ASSIGNMENT_STATS_DISPLAYED = "gradebook.stats.assignments.displayed";
    public static final String PROP_COURSE_GRADE_STATS_DISPLAYED = "gradebook.stats.coursegrade.displayed";

    public void addGradebook(String uid, String name) {
        if (this.isGradebookDefined(uid)) {
            log.warn("You can not add a gradebook with uid={}. That gradebook already exists.", (Object)uid);
            throw new GradebookExistsException("You can not add a gradebook with uid=" + uid + ".  That gradebook already exists.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding gradebook uid={} by userUid={}", (Object)uid, (Object)this.getUserUid());
        }
        this.createDefaultLetterGradeMapping(this.getHardDefaultLetterMapping());
        this.getHibernateTemplate().execute(session -> {
            List gradingScales = session.createQuery("from GradingScale as gradingScale where gradingScale.unavailable=false").list();
            if (gradingScales.isEmpty()) {
                if (log.isInfoEnabled()) {
                    log.info("No Grading Scale defined yet. This is probably because you have upgraded or you are working with a new database. Default grading scales will be created. Any customized system-wide grade mappings you may have defined in previous versions will have to be reconfigured.");
                }
                gradingScales = this.addDefaultGradingScales(session);
            }
            Gradebook gradebook = new Gradebook();
            gradebook.setName(name);
            gradebook.setUid(uid);
            session.save((Object)gradebook);
            CourseGrade cg = new CourseGrade();
            cg.setGradebook(gradebook);
            session.save((Object)cg);
            Boolean propAssignmentsDisplayed = this.serverConfigurationService.getBoolean(PROP_ASSIGNMENTS_DISPLAYED, true);
            gradebook.setAssignmentsDisplayed(propAssignmentsDisplayed.booleanValue());
            Boolean propCourseGradeDisplayed = this.serverConfigurationService.getBoolean(PROP_COURSE_GRADE_DISPLAYED, false);
            gradebook.setCourseGradeDisplayed(propCourseGradeDisplayed.booleanValue());
            Boolean propCoursePointsDisplayed = this.serverConfigurationService.getBoolean(PROP_COURSE_POINTS_DISPLAYED, false);
            gradebook.setCoursePointsDisplayed(propCoursePointsDisplayed.booleanValue());
            String defaultScaleUid = this.getPropertyValue(UID_OF_DEFAULT_GRADING_SCALE_PROPERTY);
            GradeMapping defaultGradeMapping = null;
            HashSet<GradeMapping> gradeMappings = new HashSet<GradeMapping>();
            for (GradingScale gradingScale : gradingScales) {
                GradeMapping gradeMapping = new GradeMapping(gradingScale);
                gradeMapping.setGradebook(gradebook);
                session.save((Object)gradeMapping);
                gradeMappings.add(gradeMapping);
                if (!gradingScale.getUid().equals(defaultScaleUid)) continue;
                defaultGradeMapping = gradeMapping;
            }
            if (defaultGradeMapping == null) {
                defaultGradeMapping = (GradeMapping)gradeMappings.iterator().next();
                if (log.isWarnEnabled()) {
                    log.warn("No default GradeMapping found for new Gradebook={}; will set default to {}", (Object)gradebook.getUid(), (Object)defaultGradeMapping.getName());
                }
            }
            gradebook.setSelectedGradeMapping(defaultGradeMapping);
            gradebook.setGradeMappings(gradeMappings);
            gradebook.setGrade_type(1);
            gradebook.setCategory_type(1);
            gradebook.setCourseLetterGradeDisplayed(true);
            gradebook.setCourseAverageDisplayed(true);
            Boolean propAssignmentStatsDisplayed = this.serverConfigurationService.getBoolean(PROP_ASSIGNMENT_STATS_DISPLAYED, true);
            gradebook.setAssignmentStatsDisplayed(propAssignmentStatsDisplayed.booleanValue());
            Boolean propCourseGradeStatsDisplayed = this.serverConfigurationService.getBoolean(PROP_COURSE_GRADE_STATS_DISPLAYED, true);
            gradebook.setCourseGradeStatsDisplayed(propCourseGradeStatsDisplayed.booleanValue());
            session.update((Object)gradebook);
            return null;
        });
    }

    private List addDefaultGradingScales(Session session) throws HibernateException {
        GradeMapping[] oldGradeMappings;
        ArrayList<GradingScale> gradingScales = new ArrayList<GradingScale>();
        for (GradeMapping sampleMapping : oldGradeMappings = new GradeMapping[]{new LetterGradeMapping(), new LetterGradePlusMinusMapping(), new PassNotPassMapping(), new GradePointsMapping()}) {
            sampleMapping.setDefaultValues();
            GradingScale gradingScale = new GradingScale();
            String uid = sampleMapping.getClass().getName();
            uid = uid.substring(uid.lastIndexOf(46) + 1);
            gradingScale.setUid(uid);
            gradingScale.setUnavailable(false);
            gradingScale.setName(sampleMapping.getName());
            gradingScale.setGrades(new ArrayList(sampleMapping.getGrades()));
            gradingScale.setDefaultBottomPercents(new HashMap(sampleMapping.getGradeMap()));
            session.save((Object)gradingScale);
            if (log.isInfoEnabled()) {
                log.info("Added Grade Mapping " + gradingScale.getUid());
            }
            gradingScales.add(gradingScale);
        }
        this.setDefaultGradingScale("LetterGradePlusMinusMapping");
        session.flush();
        return gradingScales;
    }

    public void setAvailableGradingScales(Collection gradingScaleDefinitions) {
        this.getHibernateTemplate().execute(session -> {
            this.mergeGradeMappings(gradingScaleDefinitions, session);
            return null;
        });
    }

    public void saveGradeMappingToGradebook(String scaleUuid, String gradebookUid) {
        this.getHibernateTemplate().execute(session -> {
            List gradingScales = session.createQuery("from GradingScale as gradingScale where gradingScale.unavailable=false").list();
            for (GradingScale gradingScale : gradingScales) {
                if (!gradingScale.getUid().equals(scaleUuid)) continue;
                GradeMapping gradeMapping = new GradeMapping(gradingScale);
                Gradebook gradebookToSet = this.getGradebook(gradebookUid);
                gradeMapping.setGradebook(gradebookToSet);
                session.save((Object)gradeMapping);
            }
            session.flush();
            return null;
        });
    }

    public List<GradingScale> getAvailableGradingScales() {
        return (List)this.getHibernateTemplate().execute(session -> {
            List gradingScales = session.createQuery("from GradingScale as gradingScale where gradingScale.unavailable=false").list();
            if (gradingScales.isEmpty()) {
                if (log.isInfoEnabled()) {
                    log.info("No Grading Scale defined yet. This is probably because you have upgraded or you are working with a new database. Default grading scales will be created. Any customized system-wide grade mappings you may have defined in previous versions will have to be reconfigured.");
                }
                gradingScales = this.addDefaultGradingScales(session);
            }
            return gradingScales;
        });
    }

    public List<GradingScaleDefinition> getAvailableGradingScaleDefinitions() {
        List<GradingScale> gradingScales = this.getAvailableGradingScales();
        ArrayList<GradingScaleDefinition> rval = new ArrayList<GradingScaleDefinition>();
        for (GradingScale gradingScale : gradingScales) {
            rval.add(gradingScale.toGradingScaleDefinition());
        }
        return rval;
    }

    public void setDefaultGradingScale(String uid) {
        this.setPropertyValue(UID_OF_DEFAULT_GRADING_SCALE_PROPERTY, uid);
    }

    private void copyDefinitionToScale(GradingScaleDefinition bean, GradingScale gradingScale) {
        gradingScale.setUnavailable(false);
        gradingScale.setName(bean.getName());
        gradingScale.setGrades(bean.getGrades());
        HashMap<String, Double> defaultBottomPercents = new HashMap<String, Double>();
        Iterator gradesIter = bean.getGrades().iterator();
        Iterator defaultBottomPercentsIter = bean.getDefaultBottomPercentsAsList().iterator();
        while (gradesIter.hasNext() && defaultBottomPercentsIter.hasNext()) {
            String grade = (String)gradesIter.next();
            Double value = (Double)defaultBottomPercentsIter.next();
            defaultBottomPercents.put(grade, value);
        }
        gradingScale.setDefaultBottomPercents(defaultBottomPercents);
    }

    private void mergeGradeMappings(Collection<GradingScaleDefinition> gradingScaleDefinitions, Session session) throws HibernateException {
        HashMap<String, GradingScaleDefinition> newMappingDefinitionsMap = new HashMap<String, GradingScaleDefinition>();
        HashSet<String> uidsToSet = new HashSet<String>();
        for (GradingScaleDefinition bean : gradingScaleDefinitions) {
            newMappingDefinitionsMap.put(bean.getUid(), bean);
            uidsToSet.add(bean.getUid());
        }
        Query q = session.createQuery("from GradingScale as gradingScale where gradingScale.uid not in (:uidList) and gradingScale.unavailable=false");
        q.setParameterList("uidList", uidsToSet);
        List gmtList = q.list();
        for (GradingScale gradingScale : gmtList) {
            gradingScale.setUnavailable(true);
            session.update((Object)gradingScale);
            if (!log.isInfoEnabled()) continue;
            log.info("Set Grading Scale " + gradingScale.getUid() + " unavailable");
        }
        q = session.createQuery("from GradingScale as gradingScale where gradingScale.uid in (:uidList)");
        q.setParameterList("uidList", uidsToSet);
        gmtList = q.list();
        for (GradingScale gradingScale : gmtList) {
            this.copyDefinitionToScale((GradingScaleDefinition)newMappingDefinitionsMap.get(gradingScale.getUid()), gradingScale);
            uidsToSet.remove(gradingScale.getUid());
            session.update((Object)gradingScale);
            if (!log.isInfoEnabled()) continue;
            log.info("Updated Grading Scale " + gradingScale.getUid());
        }
        for (String uid : uidsToSet) {
            GradingScale gradingScale = new GradingScale();
            gradingScale.setUid(uid);
            GradingScaleDefinition bean = (GradingScaleDefinition)newMappingDefinitionsMap.get(uid);
            this.copyDefinitionToScale(bean, gradingScale);
            session.save((Object)gradingScale);
            if (!log.isInfoEnabled()) continue;
            log.info("Added Grading Scale " + gradingScale.getUid());
        }
        session.flush();
    }

    public void deleteGradebook(String uid) throws GradebookNotFoundException {
        log.debug("Deleting gradebook uid={} by userUid={}", (Object)uid, (Object)this.getUserUid());
        Long gradebookId = this.getGradebook(uid).getId();
        HibernateTemplate hibTempl = this.getHibernateTemplate();
        List toBeDeleted = hibTempl.findByNamedParam("from GradingEvent as ge where ge.gradableObject.gradebook.id = :gradebookid", "gradebookid", (Object)gradebookId);
        int numberDeleted = toBeDeleted.size();
        hibTempl.deleteAll((Collection)toBeDeleted);
        log.debug("Deleted {} grading events", (Object)numberDeleted);
        toBeDeleted = hibTempl.findByNamedParam("from Comment as gc where gc.gradableObject.gradebook.id = :gradebookid", "gradebookid", (Object)gradebookId);
        numberDeleted = toBeDeleted.size();
        hibTempl.deleteAll((Collection)toBeDeleted);
        log.debug("Deleted {} grade comments", (Object)numberDeleted);
        toBeDeleted = hibTempl.findByNamedParam("from AbstractGradeRecord as gr where gr.gradableObject.gradebook.id = :gradebookid", "gradebookid", (Object)gradebookId);
        numberDeleted = toBeDeleted.size();
        hibTempl.deleteAll((Collection)toBeDeleted);
        if (log.isDebugEnabled()) {
            log.debug("Deleted {} grade records", (Object)numberDeleted);
        }
        toBeDeleted = hibTempl.findByNamedParam("from GradableObject as go where go.gradebook.id = :gradebookid", "gradebookid", (Object)gradebookId);
        numberDeleted = toBeDeleted.size();
        hibTempl.deleteAll((Collection)toBeDeleted);
        log.debug("Deleted {} gradable objects", (Object)numberDeleted);
        toBeDeleted = hibTempl.findByNamedParam("from Category as cg where cg.gradebook.id = :gradebookid", "gradebookid", (Object)gradebookId);
        numberDeleted = toBeDeleted.size();
        hibTempl.deleteAll((Collection)toBeDeleted);
        log.debug("Deleted {} gradable categories", (Object)numberDeleted);
        Gradebook gradebook = (Gradebook)hibTempl.load(Gradebook.class, (Serializable)gradebookId);
        gradebook.setSelectedGradeMapping(null);
        toBeDeleted = hibTempl.findByNamedParam("from GradeMapping as gm where gm.gradebook.id = :gradebookid", "gradebookid", (Object)gradebookId);
        numberDeleted = toBeDeleted.size();
        hibTempl.deleteAll((Collection)toBeDeleted);
        if (log.isDebugEnabled()) {
            log.debug("Deleted {} grade mappings", (Object)numberDeleted);
        }
        hibTempl.delete((Object)gradebook);
        hibTempl.flush();
        hibTempl.clear();
    }

    private void createDefaultLetterGradeMapping(Map gradeMap) {
        if (this.getDefaultLetterGradePercentMapping() == null) {
            Set keySet = gradeMap.keySet();
            if (keySet.size() != GradebookService.validLetterGrade.length) {
                throw new IllegalArgumentException("gradeMap doesn't have right size in BaseHibernateManager.createDefaultLetterGradePercentMapping");
            }
            if (!this.validateLetterGradeMapping(gradeMap)) {
                throw new IllegalArgumentException("gradeMap contains invalid letter in BaseHibernateManager.createDefaultLetterGradePercentMapping");
            }
            HibernateCallback hc = session -> {
                LetterGradePercentMapping lgpm = new LetterGradePercentMapping();
                session.save((Object)lgpm);
                HashMap saveMap = new HashMap();
                for (String key : gradeMap.keySet()) {
                    saveMap.put(key, gradeMap.get(key));
                }
                if (lgpm != null) {
                    lgpm.setGradeMap(saveMap);
                    lgpm.setMappingType(1);
                    session.update((Object)lgpm);
                }
                return null;
            };
            this.getHibernateTemplate().execute(hc);
        }
    }

    private Map<String, Double> getHardDefaultLetterMapping() {
        HashMap<String, Double> gradeMap = new HashMap<String, Double>();
        gradeMap.put("A+", 100.0);
        gradeMap.put("A", 95.0);
        gradeMap.put("A-", 90.0);
        gradeMap.put("B+", 87.0);
        gradeMap.put("B", 83.0);
        gradeMap.put("B-", 80.0);
        gradeMap.put("C+", 77.0);
        gradeMap.put("C", 73.0);
        gradeMap.put("C-", 70.0);
        gradeMap.put("D+", 67.0);
        gradeMap.put("D", 63.0);
        gradeMap.put("D-", 60.0);
        gradeMap.put("F", 0.0);
        return gradeMap;
    }
}

