/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.gradebook;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.hibernate.HibernateCriterionUtils;
import org.sakaiproject.section.api.SectionAwareness;
import org.sakaiproject.section.api.facade.Role;
import org.sakaiproject.service.gradebook.shared.AssessmentNotFoundException;
import org.sakaiproject.service.gradebook.shared.CommentDefinition;
import org.sakaiproject.service.gradebook.shared.ConflictingAssignmentNameException;
import org.sakaiproject.service.gradebook.shared.ConflictingCategoryNameException;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.service.gradebook.shared.GradebookHelper;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.service.gradebook.shared.GraderPermission;
import org.sakaiproject.service.gradebook.shared.StaleObjectModificationException;
import org.sakaiproject.tool.gradebook.AbstractGradeRecord;
import org.sakaiproject.tool.gradebook.AssignmentGradeRecord;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.Comment;
import org.sakaiproject.tool.gradebook.CourseGrade;
import org.sakaiproject.tool.gradebook.CourseGradeRecord;
import org.sakaiproject.tool.gradebook.GradableObject;
import org.sakaiproject.tool.gradebook.GradeMapping;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradebookAssignment;
import org.sakaiproject.tool.gradebook.GradebookProperty;
import org.sakaiproject.tool.gradebook.GradingEvent;
import org.sakaiproject.tool.gradebook.LetterGradePercentMapping;
import org.sakaiproject.tool.gradebook.Permission;
import org.sakaiproject.tool.gradebook.facades.Authn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.support.HibernateDaoSupport;

public abstract class BaseHibernateManager
extends HibernateDaoSupport {
    private static final Logger log = LoggerFactory.getLogger(BaseHibernateManager.class);
    protected SectionAwareness sectionAwareness;
    protected Authn authn;
    protected EventTrackingService eventTrackingService;
    protected ServerConfigurationService serverConfigurationService;
    protected GradebookExternalAssessmentService externalAssessmentService;
    protected Map<String, String> propertiesMap = new HashMap<String, String>();

    public Gradebook getGradebook(String uid) throws GradebookNotFoundException {
        List list = this.getHibernateTemplate().findByNamedParam("from Gradebook as gb where gb.uid = :uid", "uid", (Object)uid);
        if (list.size() == 1) {
            return (Gradebook)list.get(0);
        }
        throw new GradebookNotFoundException("Could not find gradebook uid=" + uid);
    }

    public boolean isGradebookDefined(String gradebookUid) {
        return (Long)this.getSessionFactory().getCurrentSession().createCriteria(Gradebook.class).add((Criterion)Restrictions.eq((String)"uid", (Object)gradebookUid)).setProjection(Projections.rowCount()).uniqueResult() == 1L;
    }

    protected List<GradebookAssignment> getAssignments(Long gradebookId) throws HibernateException {
        return this.getSessionFactory().getCurrentSession().createQuery("from GradebookAssignment as asn where asn.gradebook.id = :gradebookid and asn.removed is false").setLong("gradebookid", gradebookId.longValue()).list();
    }

    protected List getCountedStudentGradeRecords(Long gradebookId, String studentId) throws HibernateException {
        return this.getSessionFactory().getCurrentSession().createQuery("select agr from AssignmentGradeRecord as agr, GradebookAssignment as asn where agr.studentId = :studentid and agr.gradableObject = asn and asn.removed is false and asn.notCounted is false and asn.gradebook.id = :gradebookid and asn.ungraded is false").setString("studentid", studentId).setLong("gradebookid", gradebookId.longValue()).list();
    }

    public CourseGrade getCourseGrade(Long gradebookId) {
        return (CourseGrade)this.getSessionFactory().getCurrentSession().createQuery("from CourseGrade as cg where cg.gradebook.id = :gradebookid").setLong("gradebookid", gradebookId.longValue()).uniqueResult();
    }

    protected CourseGradeRecord getCourseGradeRecord(Gradebook gradebook, String studentId) throws HibernateException {
        return (CourseGradeRecord)this.getSessionFactory().getCurrentSession().createQuery("from CourseGradeRecord as cgr where cgr.studentId = :studentid and cgr.gradableObject.gradebook = :gradebook").setString("studentid", studentId).setEntity("gradebook", (Object)gradebook).uniqueResult();
    }

    public String getGradebookUid(Long id) {
        return ((Gradebook)this.getHibernateTemplate().load(Gradebook.class, (Serializable)id)).getUid();
    }

    protected Set<String> getAllStudentUids(String gradebookUid) {
        List enrollments = this.getSectionAwareness().getSiteMembersInRole(gradebookUid, Role.STUDENT);
        return enrollments.stream().map(e -> e.getUser().getUserUid()).collect(Collectors.toSet());
    }

    public String getPropertyValue(String name) {
        List list;
        String value = this.propertiesMap.get(name);
        if (value == null && !(list = this.getHibernateTemplate().findByNamedParam("from GradebookProperty as prop where prop.name = :name", "name", (Object)name)).isEmpty()) {
            GradebookProperty property = (GradebookProperty)list.get(0);
            value = property.getValue();
            this.propertiesMap.put(name, value);
        }
        return value;
    }

    public void setPropertyValue(String name, String value) {
        List list = this.getHibernateTemplate().findByNamedParam("from GradebookProperty as prop where prop.name = :name", "name", (Object)name);
        GradebookProperty property = !list.isEmpty() ? (GradebookProperty)list.get(0) : new GradebookProperty(name);
        property.setValue(value);
        this.getHibernateTemplate().saveOrUpdate((Object)property);
        this.propertiesMap.put(name, value);
    }

    protected List filterGradeRecordsByStudents(Collection gradeRecords, Collection studentUids) {
        ArrayList<AbstractGradeRecord> filteredRecords = new ArrayList<AbstractGradeRecord>();
        for (AbstractGradeRecord agr : gradeRecords) {
            if (!studentUids.contains(agr.getStudentId())) continue;
            filteredRecords.add(agr);
        }
        return filteredRecords;
    }

    @Deprecated
    protected GradebookAssignment getAssignmentWithoutStats(String gradebookUid, String assignmentName) throws HibernateException {
        return (GradebookAssignment)this.getSessionFactory().getCurrentSession().createQuery("from GradebookAssignment as asn where asn.name = :assignmentname and asn.gradebook.uid = :gradebookuid and asn.removed is false").setString("assignmentname", assignmentName).setString("gradebookuid", gradebookUid).uniqueResult();
    }

    protected GradebookAssignment getAssignmentWithoutStats(String gradebookUid, Long assignmentId) throws HibernateException {
        return (GradebookAssignment)this.getSessionFactory().getCurrentSession().createQuery("from GradebookAssignment as asn where asn.id = :assignmentid and asn.gradebook.uid = :gradebookuid and asn.removed is false").setLong("assignmentid", assignmentId.longValue()).setString("gradebookuid", gradebookUid).uniqueResult();
    }

    protected void updateAssignment(GradebookAssignment assignment) throws ConflictingAssignmentNameException, HibernateException {
        Session session = this.getSessionFactory().getCurrentSession();
        session.evict((Object)assignment);
        GradebookAssignment asnFromDb = (GradebookAssignment)session.load(GradebookAssignment.class, (Serializable)assignment.getId());
        Long count = (Long)session.createCriteria(GradableObject.class).add((Criterion)Restrictions.eq((String)"name", (Object)assignment.getName())).add((Criterion)Restrictions.eq((String)"gradebook", (Object)assignment.getGradebook())).add((Criterion)Restrictions.ne((String)"id", (Object)assignment.getId())).add((Criterion)Restrictions.eq((String)"removed", (Object)false)).setProjection(Projections.rowCount()).uniqueResult();
        if (count > 0L) {
            throw new ConflictingAssignmentNameException("You can not save multiple assignments in a gradebook with the same name");
        }
        session.evict((Object)asnFromDb);
        session.update((Object)assignment);
    }

    protected AssignmentGradeRecord getAssignmentGradeRecord(GradebookAssignment assignment, String studentUid) throws HibernateException {
        return (AssignmentGradeRecord)this.getSessionFactory().getCurrentSession().createQuery("from AssignmentGradeRecord as agr where agr.studentId = :studentid and agr.gradableObject.id = :assignmentid").setString("studentid", studentUid).setLong("assignmentid", assignment.getId().longValue()).uniqueResult();
    }

    public Long createAssignment(Long gradebookId, String name, Double points, Date dueDate, Boolean isNotCounted, Boolean isReleased, Boolean isExtraCredit, Integer sortOrder) throws ConflictingAssignmentNameException, StaleObjectModificationException {
        return this.createNewAssignment(gradebookId, null, name, points, dueDate, isNotCounted, isReleased, isExtraCredit, sortOrder, null);
    }

    public Long createAssignmentForCategory(Long gradebookId, Long categoryId, String name, Double points, Date dueDate, Boolean isNotCounted, Boolean isReleased, Boolean isExtraCredit, Integer categorizedSortOrder) throws ConflictingAssignmentNameException, StaleObjectModificationException, IllegalArgumentException {
        if (gradebookId == null || categoryId == null) {
            throw new IllegalArgumentException("gradebookId or categoryId is null in BaseHibernateManager.createAssignmentForCategory");
        }
        return this.createNewAssignment(gradebookId, categoryId, name, points, dueDate, isNotCounted, isReleased, isExtraCredit, null, categorizedSortOrder);
    }

    private Long createNewAssignment(Long gradebookId, Long categoryId, String name, Double points, Date dueDate, Boolean isNotCounted, Boolean isReleased, Boolean isExtraCredit, Integer sortOrder, Integer categorizedSortOrder) throws ConflictingAssignmentNameException, StaleObjectModificationException {
        GradebookAssignment asn = this.prepareNewAssignment(name, points, dueDate, isNotCounted, isReleased, isExtraCredit, sortOrder, categorizedSortOrder);
        return this.saveNewAssignment(gradebookId, categoryId, asn);
    }

    private GradebookAssignment prepareNewAssignment(String name, Double points, Date dueDate, Boolean isNotCounted, Boolean isReleased, Boolean isExtraCredit, Integer sortOrder, Integer categorizedSortOrder) {
        String validatedName = GradebookHelper.validateGradeItemName((String)name);
        GradebookAssignment asn = new GradebookAssignment();
        asn.setName(validatedName);
        asn.setPointsPossible(points);
        asn.setDueDate(dueDate);
        asn.setUngraded(Boolean.valueOf(false));
        if (isNotCounted != null) {
            asn.setNotCounted(Boolean.valueOf(isNotCounted));
        }
        if (isExtraCredit != null) {
            asn.setExtraCredit(Boolean.valueOf(isExtraCredit));
        }
        if (isReleased != null) {
            asn.setReleased(Boolean.valueOf(isReleased));
        }
        if (sortOrder != null) {
            asn.setSortOrder(sortOrder);
        }
        if (categorizedSortOrder != null) {
            asn.setCategorizedSortOrder(categorizedSortOrder);
        }
        return asn;
    }

    private void loadAssignmentGradebookAndCategory(GradebookAssignment asn, Long gradebookId, Long categoryId) {
        Session session = this.getSessionFactory().getCurrentSession();
        Gradebook gb = (Gradebook)session.load(Gradebook.class, (Serializable)gradebookId);
        asn.setGradebook(gb);
        if (categoryId != null) {
            Category cat = (Category)session.load(Category.class, (Serializable)categoryId);
            asn.setCategory(cat);
        }
    }

    protected Long saveNewAssignment(Long gradebookId, Long categoryId, GradebookAssignment asn) throws ConflictingAssignmentNameException {
        HibernateCallback hc = session -> {
            this.loadAssignmentGradebookAndCategory(asn, gradebookId, categoryId);
            if (this.assignmentNameExists(asn.getName(), asn.getGradebook())) {
                throw new ConflictingAssignmentNameException("You cannot save multiple assignments in a gradebook with the same name");
            }
            return (Long)session.save((Object)asn);
        };
        return (Long)this.getHibernateTemplate().execute(hc);
    }

    public void updateGradebook(Gradebook gradebook) throws StaleObjectModificationException {
        HibernateCallback hc = session -> {
            Gradebook gradebookFromPersistence = (Gradebook)session.load(gradebook.getClass(), (Serializable)gradebook.getId());
            GradeMapping mappingFromPersistence = gradebookFromPersistence.getSelectedGradeMapping();
            if (!mappingFromPersistence.getId().equals(gradebook.getSelectedGradeMapping().getId()) && this.isExplicitlyEnteredCourseGradeRecords(gradebook.getId())) {
                throw new IllegalStateException("Selected grade mapping can not be changed, since explicit course grades exist.");
            }
            for (Object element : gradebookFromPersistence.getGradeMappings()) {
                session.evict(element);
            }
            session.evict((Object)gradebookFromPersistence);
            try {
                session.update((Object)gradebook);
                session.flush();
            }
            catch (StaleObjectStateException e) {
                throw new StaleObjectModificationException((Throwable)e);
            }
            return null;
        };
        this.getHibernateTemplate().execute(hc);
    }

    public boolean isExplicitlyEnteredCourseGradeRecords(Long gradebookId) {
        ArrayList<String> studentUids = new ArrayList<String>(this.getAllStudentUids(this.getGradebookUid(gradebookId)));
        if (studentUids.isEmpty()) {
            return false;
        }
        HibernateCallback hc = session -> (Number)session.createCriteria(CourseGradeRecord.class).createAlias("gradableObject", "go").createAlias("go.gradebook", "gb").add((Criterion)Restrictions.eq((String)"gb.id", (Object)gradebookId)).add(Restrictions.isNotNull((String)"enteredGrade")).add(HibernateCriterionUtils.CriterionInRestrictionSplitter((String)"studentId", (Collection)studentUids)).setProjection(Projections.rowCount()).uniqueResult();
        Number number = (Number)this.getHibernateTemplate().execute(hc);
        log.debug("total number of explicitly entered course grade records = {}", (Object)number);
        return number.intValue() > 0;
    }

    public Authn getAuthn() {
        return this.authn;
    }

    public void setAuthn(Authn authn) {
        this.authn = authn;
    }

    protected String getUserUid() {
        return this.authn.getUserUid();
    }

    protected SectionAwareness getSectionAwareness() {
        return this.sectionAwareness;
    }

    public void setSectionAwareness(SectionAwareness sectionAwareness) {
        this.sectionAwareness = sectionAwareness;
    }

    protected ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    protected EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    protected GradebookExternalAssessmentService getGradebookExternalAssessmentService() {
        return this.externalAssessmentService;
    }

    public void setGradebookExternalAssessmentService(GradebookExternalAssessmentService externalAssessmentService) {
        this.externalAssessmentService = externalAssessmentService;
    }

    public void postEvent(String event, String objectReference) {
        this.eventTrackingService.post(this.eventTrackingService.newEvent(event, objectReference, true));
    }

    public Long createCategory(Long gradebookId, String name, Double weight, Integer drop_lowest, Integer dropHighest, Integer keepHighest, Boolean is_extra_credit, Boolean is_equal_weight) {
        return this.createCategory(gradebookId, name, weight, drop_lowest, dropHighest, keepHighest, is_extra_credit, is_equal_weight, null);
    }

    public Long createCategory(Long gradebookId, String name, Double weight, Integer drop_lowest, Integer dropHighest, Integer keepHighest, Boolean is_extra_credit, Boolean is_equal_weight, Integer categoryOrder) throws ConflictingCategoryNameException, StaleObjectModificationException {
        HibernateCallback hc = session -> {
            Gradebook gb = (Gradebook)session.load(Gradebook.class, (Serializable)gradebookId);
            Number numNameConflicts = (Number)session.createCriteria(Category.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"gradebook", (Object)gb)).add((Criterion)Restrictions.eq((String)"removed", (Object)false)).setProjection(Projections.rowCount()).uniqueResult();
            if (numNameConflicts.intValue() > 0) {
                throw new ConflictingCategoryNameException("You can not save multiple categories in a gradebook with the same name");
            }
            if (weight > 1.0 || weight < 0.0) {
                throw new IllegalArgumentException("weight for category is greater than 1 or less than 0 in createCategory of BaseHibernateManager");
            }
            if ((drop_lowest != null && drop_lowest > 0 || dropHighest != null && dropHighest > 0) && keepHighest != null && keepHighest > 0) {
                throw new IllegalArgumentException("a combination of positive values for keepHighest and either drop_lowest or dropHighest occurred in createCategory of BaseHibernateManager");
            }
            Category ca = new Category();
            ca.setGradebook(gb);
            ca.setName(name);
            ca.setWeight(weight);
            ca.setDropLowest(drop_lowest);
            ca.setDropHighest(dropHighest);
            ca.setKeepHighest(keepHighest);
            ca.setRemoved(false);
            ca.setExtraCredit(is_extra_credit);
            ca.setEqualWeightAssignments(is_equal_weight);
            ca.setCategoryOrder(categoryOrder);
            Long id = (Long)session.save((Object)ca);
            return id;
        };
        return (Long)this.getHibernateTemplate().execute(hc);
    }

    public List getCategories(Long gradebookId) throws HibernateException {
        HibernateCallback hc = session -> session.createQuery("from Category as ca where ca.gradebook.id = :gradebookid and ca.removed is false").setLong("gradebookid", gradebookId.longValue()).list();
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List getCategoriesWithAssignments(Long gradebookId) {
        List categories = this.getCategories(gradebookId);
        ArrayList<Category> categoriesWithAssignments = new ArrayList<Category>();
        if (categories != null) {
            for (Category category : categories) {
                if (category == null) continue;
                List<GradebookAssignment> assignments = this.getAssignmentsForCategory(category.getId());
                category.setAssignmentList(assignments);
                categoriesWithAssignments.add(category);
            }
        }
        return categoriesWithAssignments;
    }

    public List<GradebookAssignment> getAssignmentsForCategory(Long categoryId) throws HibernateException {
        HibernateCallback hc = session -> session.createQuery("from GradebookAssignment as assign where assign.category = :categoryid and assign.removed is false").setLong("categoryid", categoryId.longValue()).list();
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public Category getCategory(Long categoryId) throws HibernateException {
        HibernateCallback hc = session -> (Category)session.createQuery("from Category as cat where cat.id = :categoryid").setLong("categoryid", categoryId.longValue()).uniqueResult();
        return (Category)this.getHibernateTemplate().execute(hc);
    }

    public void updateCategory(Category category) throws ConflictingCategoryNameException, StaleObjectModificationException {
        HibernateCallback hc = session -> {
            session.evict((Object)category);
            Category persistentCat = (Category)session.load(Category.class, (Serializable)category.getId());
            Number numNameConflicts = (Number)session.createCriteria(Category.class).add((Criterion)Restrictions.eq((String)"name", (Object)category.getName())).add((Criterion)Restrictions.eq((String)"gradebook", (Object)category.getGradebook())).add((Criterion)Restrictions.ne((String)"id", (Object)category.getId())).add((Criterion)Restrictions.eq((String)"removed", (Object)false)).setProjection(Projections.rowCount()).uniqueResult();
            if (numNameConflicts.intValue() > 0) {
                throw new ConflictingCategoryNameException("You can not save multiple category in a gradebook with the same name");
            }
            if (category.getWeight() > 1.0 || category.getWeight() < 0.0) {
                throw new IllegalArgumentException("weight for category is greater than 1 or less than 0 in updateCategory of BaseHibernateManager");
            }
            session.evict((Object)persistentCat);
            session.update((Object)category);
            return null;
        };
        try {
            this.getHibernateTemplate().execute(hc);
        }
        catch (Exception e) {
            throw new StaleObjectModificationException((Throwable)e);
        }
    }

    public void removeCategory(Long categoryId) throws StaleObjectModificationException {
        HibernateCallback hc = session -> {
            Category persistentCat = (Category)session.load(Category.class, (Serializable)categoryId);
            List<GradebookAssignment> assigns = this.getAssignmentsForCategory(categoryId);
            for (GradebookAssignment assignment : assigns) {
                assignment.setCategory(null);
                this.updateAssignment(assignment);
            }
            persistentCat.setRemoved(true);
            session.update((Object)persistentCat);
            return null;
        };
        try {
            this.getHibernateTemplate().execute(hc);
        }
        catch (Exception e) {
            throw new StaleObjectModificationException((Throwable)e);
        }
    }

    public LetterGradePercentMapping getDefaultLetterGradePercentMapping() {
        HibernateCallback hc = session -> {
            List mapping = session.createCriteria(LetterGradePercentMapping.class).add((Criterion)Restrictions.eq((String)"mappingType", (Object)1)).list();
            if (mapping.size() == 0) {
                log.info("Default letter grade mapping hasn't been created in DB in BaseHibernateManager.getDefaultLetterGradePercentMapping");
                return null;
            }
            if (mapping.size() > 1) {
                log.error("Duplicate default letter grade mapping was created in DB in BaseHibernateManager.getDefaultLetterGradePercentMapping");
                return null;
            }
            return (LetterGradePercentMapping)mapping.get(0);
        };
        return (LetterGradePercentMapping)this.getHibernateTemplate().execute(hc);
    }

    public void createOrUpdateDefaultLetterGradePercentMapping(Map gradeMap) {
        if (gradeMap == null) {
            throw new IllegalArgumentException("gradeMap is null in BaseHibernateManager.createOrUpdateDefaultLetterGradePercentMapping");
        }
        LetterGradePercentMapping lgpm = this.getDefaultLetterGradePercentMapping();
        if (lgpm != null) {
            this.updateDefaultLetterGradePercentMapping(gradeMap, lgpm);
        } else {
            this.createDefaultLetterGradePercentMapping(gradeMap);
        }
    }

    private void updateDefaultLetterGradePercentMapping(Map<String, Double> gradeMap, LetterGradePercentMapping lgpm) {
        Set<String> keySet = gradeMap.keySet();
        if (keySet.size() != GradebookService.validLetterGrade.length) {
            throw new IllegalArgumentException("gradeMap doesn't have right size in BaseHibernateManager.updateDefaultLetterGradePercentMapping");
        }
        if (!this.validateLetterGradeMapping(gradeMap)) {
            throw new IllegalArgumentException("gradeMap contains invalid letter in BaseHibernateManager.updateDefaultLetterGradePercentMapping");
        }
        HibernateCallback hcb = session -> {
            HashMap saveMap = new HashMap(gradeMap);
            lgpm.setGradeMap(saveMap);
            session.update((Object)lgpm);
            return null;
        };
        this.getHibernateTemplate().execute(hcb);
    }

    public void createDefaultLetterGradePercentMapping(Map<String, Double> gradeMap) {
        if (this.getDefaultLetterGradePercentMapping() != null) {
            throw new IllegalArgumentException("gradeMap has already been created in BaseHibernateManager.createDefaultLetterGradePercentMapping");
        }
        if (gradeMap == null) {
            throw new IllegalArgumentException("gradeMap is null in BaseHibernateManager.createDefaultLetterGradePercentMapping");
        }
        Set<String> keySet = gradeMap.keySet();
        if (keySet.size() != GradebookService.validLetterGrade.length) {
            throw new IllegalArgumentException("gradeMap doesn't have right size in BaseHibernateManager.createDefaultLetterGradePercentMapping");
        }
        if (!this.validateLetterGradeMapping(gradeMap)) {
            throw new IllegalArgumentException("gradeMap contains invalid letter in BaseHibernateManager.createDefaultLetterGradePercentMapping");
        }
        HibernateCallback hcb = session -> {
            LetterGradePercentMapping lgpm = new LetterGradePercentMapping();
            HashMap saveMap = new HashMap(gradeMap);
            lgpm.setGradeMap(saveMap);
            lgpm.setMappingType(1);
            session.save((Object)lgpm);
            return null;
        };
        this.getHibernateTemplate().execute(hcb);
    }

    public LetterGradePercentMapping getLetterGradePercentMapping(Gradebook gradebook) {
        HibernateCallback hc = session -> {
            LetterGradePercentMapping mapping = (LetterGradePercentMapping)session.createQuery("from LetterGradePercentMapping as lgpm where lgpm.gradebookId = :gradebookId and lgpm.mappingType = 2").setLong("gradebookId", gradebook.getId().longValue()).uniqueResult();
            if (mapping == null) {
                LetterGradePercentMapping lgpm = this.getDefaultLetterGradePercentMapping();
                LetterGradePercentMapping returnLgpm = new LetterGradePercentMapping();
                returnLgpm.setGradebookId(gradebook.getId());
                returnLgpm.setGradeMap(lgpm.getGradeMap());
                returnLgpm.setMappingType(2);
                return returnLgpm;
            }
            return mapping;
        };
        return (LetterGradePercentMapping)this.getHibernateTemplate().execute(hc);
    }

    private LetterGradePercentMapping getLetterGradePercentMappingForGradebook(Gradebook gradebook) {
        HibernateCallback hc = session -> {
            LetterGradePercentMapping mapping = (LetterGradePercentMapping)session.createQuery("from LetterGradePercentMapping as lgpm where lgpm.gradebookId = :gradebookId and lgpm.mappingType = 2").setLong("gradebookId", gradebook.getId().longValue()).uniqueResult();
            return mapping;
        };
        return (LetterGradePercentMapping)this.getHibernateTemplate().execute(hc);
    }

    public void saveOrUpdateLetterGradePercentMapping(Map<String, Double> gradeMap, Gradebook gradebook) {
        if (gradeMap == null) {
            throw new IllegalArgumentException("gradeMap is null in BaseHibernateManager.saveOrUpdateLetterGradePercentMapping");
        }
        LetterGradePercentMapping lgpm = this.getLetterGradePercentMappingForGradebook(gradebook);
        if (lgpm == null) {
            Set<String> keySet = gradeMap.keySet();
            if (keySet.size() != GradebookService.validLetterGrade.length) {
                throw new IllegalArgumentException("gradeMap doesn't have right size in BaseHibernateManager.saveOrUpdateLetterGradePercentMapping");
            }
            if (!this.validateLetterGradeMapping(gradeMap)) {
                throw new IllegalArgumentException("gradeMap contains invalid letter in BaseHibernateManager.saveOrUpdateLetterGradePercentMapping");
            }
            HibernateCallback hcb = session -> {
                LetterGradePercentMapping lgpm1 = new LetterGradePercentMapping();
                HashMap saveMap = new HashMap(gradeMap);
                lgpm1.setGradeMap(saveMap);
                lgpm1.setGradebookId(gradebook.getId());
                lgpm1.setMappingType(2);
                session.save((Object)lgpm1);
                return null;
            };
            this.getHibernateTemplate().execute(hcb);
        } else {
            this.udpateLetterGradePercentMapping(gradeMap, gradebook);
        }
    }

    private void udpateLetterGradePercentMapping(Map<String, Double> gradeMap, Gradebook gradebook) {
        HibernateCallback hcb = session -> {
            LetterGradePercentMapping lgpm = this.getLetterGradePercentMapping(gradebook);
            if (lgpm == null) {
                throw new IllegalArgumentException("LetterGradePercentMapping is null in BaseHibernateManager.updateLetterGradePercentMapping");
            }
            if (gradeMap == null) {
                throw new IllegalArgumentException("gradeMap is null in BaseHibernateManager.updateLetterGradePercentMapping");
            }
            Set keySet = gradeMap.keySet();
            if (keySet.size() != GradebookService.validLetterGrade.length) {
                throw new IllegalArgumentException("gradeMap doesn't have right size in BaseHibernateManager.udpateLetterGradePercentMapping");
            }
            if (!this.validateLetterGradeMapping(gradeMap)) {
                throw new IllegalArgumentException("gradeMap contains invalid letter in BaseHibernateManager.udpateLetterGradePercentMapping");
            }
            HashMap saveMap = new HashMap(gradeMap);
            lgpm.setGradeMap(saveMap);
            session.save((Object)lgpm);
            return null;
        };
        this.getHibernateTemplate().execute(hcb);
    }

    protected boolean validateLetterGradeMapping(Map<String, Double> gradeMap) {
        for (String key : gradeMap.keySet()) {
            boolean validLetter = false;
            for (String element : GradebookService.validLetterGrade) {
                if (!key.equalsIgnoreCase(element)) continue;
                validLetter = true;
                break;
            }
            if (validLetter) continue;
            return false;
        }
        return true;
    }

    public Long createUngradedAssignment(Long gradebookId, String name, Date dueDate, Boolean isNotCounted, Boolean isReleased) throws ConflictingAssignmentNameException, StaleObjectModificationException {
        HibernateCallback hc = session -> {
            Gradebook gb = (Gradebook)session.load(Gradebook.class, (Serializable)gradebookId);
            String trimmedName = StringUtils.trimToEmpty((String)name);
            if (this.assignmentNameExists(trimmedName, gb)) {
                throw new ConflictingAssignmentNameException("You can not save multiple assignments in a gradebook with the same name");
            }
            GradebookAssignment asn = new GradebookAssignment();
            asn.setGradebook(gb);
            asn.setName(trimmedName);
            asn.setDueDate(dueDate);
            asn.setUngraded(Boolean.valueOf(true));
            if (isNotCounted != null) {
                asn.setNotCounted(isNotCounted);
            }
            if (isReleased != null) {
                asn.setReleased(isReleased);
            }
            return (Long)session.save((Object)asn);
        };
        return (Long)this.getHibernateTemplate().execute(hc);
    }

    public Long createUngradedAssignmentForCategory(Long gradebookId, Long categoryId, String name, Date dueDate, Boolean isNotCounted, Boolean isReleased) throws ConflictingAssignmentNameException, StaleObjectModificationException, IllegalArgumentException {
        if (gradebookId == null || categoryId == null) {
            throw new IllegalArgumentException("gradebookId or categoryId is null in BaseHibernateManager.createUngradedAssignmentForCategory");
        }
        HibernateCallback hc = session -> {
            Gradebook gb = (Gradebook)session.load(Gradebook.class, (Serializable)gradebookId);
            Category cat = (Category)session.load(Category.class, (Serializable)categoryId);
            String trimmedName = StringUtils.trimToEmpty((String)name);
            if (this.assignmentNameExists(trimmedName, gb)) {
                throw new ConflictingAssignmentNameException("You can not save multiple assignments in a gradebook with the same name");
            }
            GradebookAssignment asn = new GradebookAssignment();
            asn.setGradebook(gb);
            asn.setCategory(cat);
            asn.setName(trimmedName);
            asn.setDueDate(dueDate);
            asn.setUngraded(Boolean.valueOf(true));
            if (isNotCounted != null) {
                asn.setNotCounted(isNotCounted);
            }
            if (isReleased != null) {
                asn.setReleased(isReleased);
            }
            return (Long)session.save((Object)asn);
        };
        return (Long)this.getHibernateTemplate().execute(hc);
    }

    public Long addPermission(Long gradebookId, String userId, String function, Long categoryId, String groupId) throws IllegalArgumentException {
        if (gradebookId == null || userId == null || function == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.addPermission");
        }
        if (!(function.equalsIgnoreCase(GradebookService.gradePermission) || function.equalsIgnoreCase(GradebookService.viewPermission) || function.equalsIgnoreCase(GradebookService.noPermission))) {
            throw new IllegalArgumentException("Function is not grade, view or none in BaseHibernateManager.addPermission");
        }
        HibernateCallback hc = session -> {
            Permission permission = new Permission();
            permission.setCategoryId(categoryId);
            permission.setGradebookId(gradebookId);
            permission.setGroupId(groupId);
            permission.setFunction(function);
            permission.setUserId(userId);
            return (Long)session.save((Object)permission);
        };
        return (Long)this.getHibernateTemplate().execute(hc);
    }

    @Deprecated
    public List<Permission> getPermissionsForGB(Long gradebookId) throws IllegalArgumentException {
        if (gradebookId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForGB");
        }
        HibernateCallback hc = session -> session.createQuery("from Permission as perm where perm.gradebookId = :gradebookId").setLong("gradebookId", gradebookId.longValue()).list();
        return (List)this.getHibernateTemplate().execute(hc);
    }

    @Deprecated
    public void updatePermission(Collection perms) {
        for (Permission perm : perms) {
            if (perm == null) continue;
            this.updatePermission(perm);
        }
    }

    @Deprecated
    public void updatePermission(Permission perm) throws IllegalArgumentException {
        if (perm == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.updatePermission");
        }
        if (perm.getId() == null) {
            throw new IllegalArgumentException("Object is not persistent in BaseHibernateManager.updatePermission");
        }
        HibernateCallback hc = session -> {
            session.update((Object)perm);
            return null;
        };
        this.getHibernateTemplate().execute(hc);
    }

    @Deprecated
    public void deletePermission(Permission perm) throws IllegalArgumentException {
        if (perm == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.deletePermission");
        }
        if (perm.getId() == null) {
            throw new IllegalArgumentException("Object is not persistent in BaseHibernateManager.deletePermission");
        }
        HibernateCallback hc = session -> {
            session.delete((Object)perm);
            return null;
        };
        this.getHibernateTemplate().execute(hc);
    }

    public List<Permission> getPermissionsForUser(Long gradebookId, String userId) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUser");
        }
        HibernateCallback hc = session -> session.createQuery("from Permission as perm where perm.gradebookId = :gradebookId and perm.userId = :userId").setLong("gradebookId", gradebookId.longValue()).setString("userId", userId).list();
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List<Permission> getPermissionsForUserForCategory(Long gradebookId, String userId, List cateIds) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserForCategory");
        }
        if (cateIds != null && cateIds.size() > 0) {
            HibernateCallback hc = session -> session.createQuery("from Permission as perm where perm.gradebookId = :gradebookId and perm.userId = :userId and perm.categoryId in (:cateIds)").setLong("gradebookId", gradebookId.longValue()).setString("userId", userId).setParameterList("cateIds", (Collection)cateIds).list();
            return (List)this.getHibernateTemplate().execute(hc);
        }
        return null;
    }

    public List<Permission> getPermissionsForUserAnyCategory(Long gradebookId, String userId) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserAnyCategory");
        }
        HibernateCallback hc = session -> session.createQuery("from Permission as perm where perm.gradebookId = :gradebookId and perm.userId = :userId and perm.categoryId is null and perm.function in (:functions)").setLong("gradebookId", gradebookId.longValue()).setString("userId", userId).setParameterList("functions", (Collection)GraderPermission.getStandardPermissions()).list();
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List<Permission> getPermissionsForUserAnyGroup(Long gradebookId, String userId) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserAnyGroup");
        }
        HibernateCallback hc = session -> session.createQuery("from Permission as perm where perm.gradebookId = :gradebookId and perm.userId = :userId and perm.groupId is null and perm.function in (:functions)").setLong("gradebookId", gradebookId.longValue()).setString("userId", userId).setParameterList("functions", (Collection)GraderPermission.getStandardPermissions()).list();
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List<Permission> getPermissionsForUserAnyGroupForCategory(Long gradebookId, String userId, List cateIds) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserAnyGroupForCategory");
        }
        if (cateIds != null && cateIds.size() > 0) {
            HibernateCallback hc = session -> session.createQuery("from Permission as perm where perm.gradebookId = :gradebookId and perm.userId = :userId and perm.categoryId in (:cateIds) and perm.groupId is null").setLong("gradebookId", gradebookId.longValue()).setString("userId", userId).setParameterList("cateIds", (Collection)cateIds).list();
            return (List)this.getHibernateTemplate().execute(hc);
        }
        return null;
    }

    public List<Permission> getPermissionsForGBForCategoryIds(Long gradebookId, List cateIds) throws IllegalArgumentException {
        if (gradebookId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserAnyGroupForCategory");
        }
        if (cateIds != null && cateIds.size() > 0) {
            HibernateCallback hc = session -> session.createQuery("from Permission as perm where perm.gradebookId = :gradebookId and perm.categoryId in (:cateIds)").setLong("gradebookId", gradebookId.longValue()).setParameterList("cateIds", (Collection)cateIds).list();
            return (List)this.getHibernateTemplate().execute(hc);
        }
        return null;
    }

    public List<Permission> getPermissionsForUserAnyGroupAnyCategory(Long gradebookId, String userId) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserAnyGroupForCategory");
        }
        HibernateCallback hc = session -> session.createQuery("from Permission as perm where perm.gradebookId=:gradebookId and perm.userId=:userId and perm.categoryId is null and perm.groupId is null").setLong("gradebookId", gradebookId.longValue()).setString("userId", userId).list();
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List<Permission> getPermissionsForUserForGoupsAnyCategory(Long gradebookId, String userId, List groupIds) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserForGoupsAnyCategory");
        }
        if (groupIds != null && groupIds.size() > 0) {
            HibernateCallback hc = session -> session.createQuery("from Permission as perm where perm.gradebookId = :gradebookId and perm.userId = :userId and perm.categoryId is null and perm.groupId in (:groupIds)").setLong("gradebookId", gradebookId.longValue()).setString("userId", userId).setParameterList("groupIds", (Collection)groupIds).list();
            return (List)this.getHibernateTemplate().execute(hc);
        }
        return null;
    }

    public List getPermissionsForUserForGroup(Long gradebookId, String userId, List groupIds) throws IllegalArgumentException {
        if (gradebookId == null || userId == null) {
            throw new IllegalArgumentException("Null parameter(s) in BaseHibernateManager.getPermissionsForUserForGroup");
        }
        if (groupIds != null && groupIds.size() > 0) {
            HibernateCallback hc = session -> session.createQuery("from Permission as perm where perm.gradebookId = :gradebookId and perm.userId = :userId and perm.groupId in (:groupIds) ").setLong("gradebookId", gradebookId.longValue()).setString("userId", userId).setParameterList("groupIds", (Collection)groupIds).list();
            return (List)this.getHibernateTemplate().execute(hc);
        }
        return null;
    }

    public boolean isAssignmentDefined(Long gradableObjectId) {
        HibernateCallback hc = session -> (Number)session.createCriteria(GradebookAssignment.class).add((Criterion)Restrictions.eq((String)"id", (Object)gradableObjectId)).add((Criterion)Restrictions.eq((String)"removed", (Object)false)).setProjection(Projections.rowCount()).uniqueResult();
        return ((Number)this.getHibernateTemplate().execute(hc)).intValue() == 1;
    }

    public GradebookAssignment getAssignment(Long gradableObjectId) {
        return (GradebookAssignment)this.getHibernateTemplate().load(GradebookAssignment.class, (Serializable)gradableObjectId);
    }

    protected Double calculateEquivalentPercent(Double doublePointsPossible, Double doublePointsEarned) {
        if (doublePointsEarned == null || doublePointsPossible == null) {
            return null;
        }
        BigDecimal pointsEarned = new BigDecimal(doublePointsEarned.toString());
        BigDecimal pointsPossible = new BigDecimal(doublePointsPossible.toString());
        if (pointsEarned.compareTo(BigDecimal.ZERO) == 0 || pointsPossible.compareTo(BigDecimal.ZERO) == 0) {
            return new Double(0.0);
        }
        BigDecimal equivPercent = pointsEarned.divide(pointsPossible, GradebookService.MATH_CONTEXT).multiply(new BigDecimal("100"));
        return equivPercent.doubleValue();
    }

    protected List convertPointsToPercentage(Gradebook gradebook, List studentRecordsFromDB) {
        ArrayList<AssignmentGradeRecord> percentageList = new ArrayList<AssignmentGradeRecord>();
        for (int i = 0; i < studentRecordsFromDB.size(); ++i) {
            AssignmentGradeRecord agr = (AssignmentGradeRecord)studentRecordsFromDB.get(i);
            if (agr == null) continue;
            Double pointsPossible = agr.getAssignment().getPointsPossible();
            if (pointsPossible == null || agr.getPointsEarned() == null) {
                agr.setPercentEarned(null);
                percentageList.add(agr);
                continue;
            }
            agr.setDateRecorded(agr.getDateRecorded());
            agr.setGraderId(agr.getGraderId());
            agr.setPercentEarned(this.calculateEquivalentPercent(pointsPossible, agr.getPointsEarned()));
            percentageList.add(agr);
        }
        return percentageList;
    }

    protected List convertPointsToLetterGrade(Gradebook gradebook, List studentRecordsFromDB) {
        ArrayList<AssignmentGradeRecord> letterGradeList = new ArrayList<AssignmentGradeRecord>();
        LetterGradePercentMapping lgpm = this.getLetterGradePercentMapping(gradebook);
        for (int i = 0; i < studentRecordsFromDB.size(); ++i) {
            AssignmentGradeRecord agr = (AssignmentGradeRecord)studentRecordsFromDB.get(i);
            if (agr == null) continue;
            Double pointsPossible = agr.getAssignment().getPointsPossible();
            agr.setDateRecorded(agr.getDateRecorded());
            agr.setGraderId(agr.getGraderId());
            if (pointsPossible == null || agr.getPointsEarned() == null) {
                agr.setLetterEarned(null);
                letterGradeList.add(agr);
                continue;
            }
            String letterGrade = lgpm.getGrade(this.calculateEquivalentPercent(pointsPossible, agr.getPointsEarned()));
            agr.setLetterEarned(letterGrade);
            letterGradeList.add(agr);
        }
        return letterGradeList;
    }

    protected Double calculateEquivalentPointValueForPercent(Double doublePointsPossible, Double doublePercentEarned) {
        if (doublePointsPossible == null || doublePercentEarned == null) {
            return null;
        }
        BigDecimal pointsPossible = new BigDecimal(doublePointsPossible.toString());
        BigDecimal percentEarned = new BigDecimal(doublePercentEarned.toString());
        BigDecimal equivPoints = pointsPossible.multiply(percentEarned.divide(new BigDecimal("100"), GradebookService.MATH_CONTEXT));
        return equivPoints.doubleValue();
    }

    public List<Comment> getComments(GradebookAssignment assignment, Collection studentIds) {
        if (studentIds.isEmpty()) {
            return new ArrayList<Comment>();
        }
        HibernateCallback hc = session -> session.createCriteria(Comment.class).add((Criterion)Restrictions.eq((String)"gradableObject", (Object)assignment)).add(HibernateCriterionUtils.CriterionInRestrictionSplitter((String)"studentId", (Collection)studentIds)).list();
        return (List)this.getHibernateTemplate().execute(hc);
    }

    protected Map<String, Set<GradebookAssignment>> getVisibleExternalAssignments(Gradebook gradebook, Collection<String> studentIds, List<GradebookAssignment> assignments) {
        String gradebookUid = gradebook.getUid();
        Map allExternals = this.externalAssessmentService.getVisibleExternalAssignments(gradebookUid, studentIds);
        HashMap<String, GradebookAssignment> allRequested = new HashMap<String, GradebookAssignment>();
        for (GradebookAssignment a : assignments) {
            if (!a.isExternallyMaintained()) continue;
            allRequested.put(a.getExternalId(), a);
        }
        HashMap<String, Set<GradebookAssignment>> visible = new HashMap<String, Set<GradebookAssignment>>();
        for (String studentId : allExternals.keySet()) {
            if (!studentIds.contains(studentId)) continue;
            HashSet studentAssignments = new HashSet();
            for (String assignmentId : (List)allExternals.get(studentId)) {
                if (!allRequested.containsKey(assignmentId)) continue;
                studentAssignments.add(allRequested.get(assignmentId));
            }
            visible.put(studentId, studentAssignments);
        }
        return visible;
    }

    protected boolean studentCanView(String studentId, GradebookAssignment assignment) {
        block4: {
            if (assignment.isExternallyMaintained()) {
                try {
                    String gbUid = assignment.getGradebook().getUid();
                    String extId = assignment.getExternalId();
                    if (this.externalAssessmentService.isExternalAssignmentGrouped(gbUid, extId)) {
                        return this.externalAssessmentService.isExternalAssignmentVisible(gbUid, extId, studentId);
                    }
                }
                catch (GradebookNotFoundException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Bogus graded assignment checked for course grades: " + assignment.getId());
                }
            }
        }
        return true;
    }

    protected void finalizeNullGradeRecords(Gradebook gradebook) {
        Set<String> studentUids = this.getAllStudentUids(gradebook.getUid());
        Date now = new Date();
        String graderId = this.getAuthn().getUserUid();
        this.getHibernateTemplate().execute(session -> {
            List countedAssignments = session.createQuery("from GradebookAssignment as asn where asn.gradebook.id = :gb and asn.removed is false and asn.notCounted is false and asn.ungraded is false").setLong("gb", gradebook.getId().longValue()).list();
            Map<String, Set<GradebookAssignment>> visible = this.getVisibleExternalAssignments(gradebook, studentUids, countedAssignments);
            for (GradebookAssignment assignment : countedAssignments) {
                List scoredGradeRecords = session.createQuery("from AssignmentGradeRecord as agr where agr.gradableObject.id = :go").setLong("go", assignment.getId().longValue()).list();
                HashMap<String, AssignmentGradeRecord> studentToGradeRecordMap = new HashMap<String, AssignmentGradeRecord>();
                for (AssignmentGradeRecord scoredGradeRecord : scoredGradeRecords) {
                    studentToGradeRecordMap.put(scoredGradeRecord.getStudentId(), scoredGradeRecord);
                }
                for (String studentUid : studentUids) {
                    if (assignment.isExternallyMaintained() && (!visible.containsKey(studentUid) || !visible.get(studentUid).contains(assignment))) continue;
                    AssignmentGradeRecord gradeRecord = (AssignmentGradeRecord)studentToGradeRecordMap.get(studentUid);
                    if (gradeRecord != null) {
                        if (gradeRecord.getPointsEarned() != null) continue;
                        gradeRecord.setPointsEarned(Double.valueOf(0.0));
                    } else {
                        gradeRecord = new AssignmentGradeRecord(assignment, studentUid, Double.valueOf(0.0));
                    }
                    gradeRecord.setGraderId(graderId);
                    gradeRecord.setDateRecorded(now);
                    session.saveOrUpdate((Object)gradeRecord);
                    session.save((Object)new GradingEvent((GradableObject)assignment, graderId, studentUid, (Object)gradeRecord.getPointsEarned()));
                }
            }
            return null;
        });
    }

    protected boolean assignmentNameExists(String name, Gradebook gradebook) {
        Number count = (Number)this.getHibernateTemplate().execute(session -> session.createCriteria(GradableObject.class).createAlias("gradebook", "gb").add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"gb.uid", (Object)gradebook.getUid())).add((Criterion)Restrictions.eq((String)"removed", (Object)false)).setProjection(Projections.rowCount()).uniqueResult());
        return count.intValue() > 0;
    }

    private Comment getInternalComment(String gradebookUid, Long assignmentId, String studentUid) {
        return (Comment)this.getHibernateTemplate().execute(session -> session.createQuery("from Comment as c where c.studentId = :studentId and c.gradableObject.gradebook.uid = :gradebookUid and c.gradableObject.id = :assignmentId and gradableObject.removed is false").setString("studentId", studentUid).setString("gradebookUid", gradebookUid).setLong("assignmentId", assignmentId.longValue()).uniqueResult());
    }

    public CommentDefinition getAssignmentScoreComment(String gradebookUid, Long assignmentId, String studentUid) throws GradebookNotFoundException, AssessmentNotFoundException {
        if (gradebookUid == null || assignmentId == null || studentUid == null) {
            throw new IllegalArgumentException("null parameter passed to getAssignmentScoreComment. Values are gradebookUid:" + gradebookUid + " assignmentId:" + assignmentId + " studentUid:" + studentUid);
        }
        GradebookAssignment assignment = this.getAssignmentWithoutStats(gradebookUid, assignmentId);
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assignmentId " + assignmentId + " for gradebookUid " + gradebookUid);
        }
        CommentDefinition commentDefinition = null;
        Comment comment = this.getInternalComment(gradebookUid, assignmentId, studentUid);
        if (comment != null) {
            commentDefinition = new CommentDefinition();
            commentDefinition.setAssignmentName(assignment.getName());
            commentDefinition.setCommentText(comment.getCommentText());
            commentDefinition.setDateRecorded(comment.getDateRecorded());
            commentDefinition.setGraderUid(comment.getGraderId());
            commentDefinition.setStudentUid(comment.getStudentId());
        }
        return commentDefinition;
    }

    public void setAssignmentScoreComment(String gradebookUid, Long assignmentId, String studentUid, String commentText) throws GradebookNotFoundException, AssessmentNotFoundException {
        this.getHibernateTemplate().execute(session -> {
            Comment comment = this.getInternalComment(gradebookUid, assignmentId, studentUid);
            if (comment == null) {
                comment = new Comment(studentUid, commentText, (GradableObject)this.getAssignmentWithoutStats(gradebookUid, assignmentId));
            } else {
                comment.setCommentText(commentText);
            }
            comment.setGraderId(this.authn.getUserUid());
            comment.setDateRecorded(new Date());
            session.saveOrUpdate((Object)comment);
            return null;
        });
    }

    public boolean getIsAssignmentExcused(String gradebookUid, Long assignmentId, String studentUid) throws GradebookNotFoundException, AssessmentNotFoundException {
        if (gradebookUid == null || assignmentId == null || studentUid == null) {
            throw new IllegalArgumentException("null parameter passed to getAssignmentScoreComment. Values are gradebookUid:" + gradebookUid + " assignmentId:" + assignmentId + " studentUid:" + studentUid);
        }
        GradebookAssignment assignment = this.getAssignmentWithoutStats(gradebookUid, assignmentId);
        AssignmentGradeRecord agr = this.getAssignmentGradeRecord(assignment, studentUid);
        if (agr == null) {
            return false;
        }
        return BooleanUtils.toBoolean((Boolean)agr.isExcludedFromGrade());
    }

    public void updateGradeMapping(Long gradeMappingId, Map<String, Double> gradeMap) {
        this.getHibernateTemplate().execute(session -> {
            GradeMapping gradeMapping = (GradeMapping)session.load(GradeMapping.class, (Serializable)gradeMappingId);
            gradeMapping.setGradeMap(gradeMap);
            session.update((Object)gradeMapping);
            session.flush();
            return null;
        });
    }

    protected List<CourseGradeRecord> getCourseGradeOverrides(Gradebook gradebook) throws HibernateException {
        return (List)this.getHibernateTemplate().execute(session -> session.createQuery("from CourseGradeRecord as cgr where cgr.gradableObject.gradebook = :gradebook and cgr.enteredGrade is not null").setEntity("gradebook", (Object)gradebook).list());
    }
}

