/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.gradebook;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.gradebook.BaseHibernateManager;
import org.sakaiproject.hibernate.HibernateCriterionUtils;
import org.sakaiproject.rubrics.logic.RubricsService;
import org.sakaiproject.section.api.coursemanagement.CourseSection;
import org.sakaiproject.section.api.coursemanagement.EnrollmentRecord;
import org.sakaiproject.section.api.coursemanagement.ParticipationRecord;
import org.sakaiproject.section.api.coursemanagement.User;
import org.sakaiproject.section.api.facade.Role;
import org.sakaiproject.service.gradebook.shared.AssessmentNotFoundException;
import org.sakaiproject.service.gradebook.shared.Assignment;
import org.sakaiproject.service.gradebook.shared.CategoryDefinition;
import org.sakaiproject.service.gradebook.shared.CategoryScoreData;
import org.sakaiproject.service.gradebook.shared.CommentDefinition;
import org.sakaiproject.service.gradebook.shared.ConflictingAssignmentNameException;
import org.sakaiproject.service.gradebook.shared.ConflictingCategoryNameException;
import org.sakaiproject.service.gradebook.shared.CourseGrade;
import org.sakaiproject.service.gradebook.shared.GradeDefinition;
import org.sakaiproject.service.gradebook.shared.GradeMappingDefinition;
import org.sakaiproject.service.gradebook.shared.GradebookHelper;
import org.sakaiproject.service.gradebook.shared.GradebookInformation;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.GradebookPermissionService;
import org.sakaiproject.service.gradebook.shared.GradebookSecurityException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.service.gradebook.shared.GradingEventStatus;
import org.sakaiproject.service.gradebook.shared.InvalidGradeException;
import org.sakaiproject.service.gradebook.shared.SortType;
import org.sakaiproject.service.gradebook.shared.StaleObjectModificationException;
import org.sakaiproject.service.gradebook.shared.exception.UnmappableCourseGradeOverrideException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.gradebook.AssignmentGradeRecord;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.Comment;
import org.sakaiproject.tool.gradebook.CourseGradeRecord;
import org.sakaiproject.tool.gradebook.GradableObject;
import org.sakaiproject.tool.gradebook.GradeMapping;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradebookAssignment;
import org.sakaiproject.tool.gradebook.GradingEvent;
import org.sakaiproject.tool.gradebook.LetterGradePercentMapping;
import org.sakaiproject.tool.gradebook.facades.Authz;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.HibernateOptimisticLockingFailureException;

public class GradebookServiceHibernateImpl
extends BaseHibernateManager
implements GradebookService {
    private static final Logger log = LoggerFactory.getLogger(GradebookServiceHibernateImpl.class);
    private Authz authz;
    private GradebookPermissionService gradebookPermissionService;
    protected SiteService siteService;
    protected ServerConfigurationService serverConfigService;
    private RubricsService rubricsService;

    public boolean isAssignmentDefined(final String gradebookUid, final String assignmentName) {
        if (!this.isUserAbleToViewAssignments(gradebookUid)) {
            log.warn("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to check for assignment {}", new Object[]{this.getUserUid(), gradebookUid, assignmentName});
            throw new GradebookSecurityException();
        }
        GradebookAssignment assignment = (GradebookAssignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName);
            }
        });
        return assignment != null;
    }

    private boolean isUserAbleToViewAssignments(String gradebookUid) {
        Authz authz = this.getAuthz();
        return authz.isUserAbleToEditAssessments(gradebookUid) || authz.isUserAbleToGrade(gradebookUid);
    }

    public boolean isUserAbleToGradeItemForStudent(String gradebookUid, Long itemId, String studentUid) {
        return this.getAuthz().isUserAbleToGradeItemForStudent(gradebookUid, itemId, studentUid);
    }

    public boolean isUserAbleToViewItemForStudent(String gradebookUid, Long itemId, String studentUid) {
        return this.getAuthz().isUserAbleToViewItemForStudent(gradebookUid, itemId, studentUid);
    }

    public String getGradeViewFunctionForUserForStudentForItem(String gradebookUid, Long itemId, String studentUid) {
        return this.getAuthz().getGradeViewFunctionForUserForStudentForItem(gradebookUid, itemId, studentUid);
    }

    public List<Assignment> getAssignments(String gradebookUid) throws GradebookNotFoundException {
        return this.getAssignments(gradebookUid, SortType.SORT_BY_NONE);
    }

    public List<Assignment> getAssignments(String gradebookUid, SortType sortBy) throws GradebookNotFoundException {
        if (!this.isUserAbleToViewAssignments(gradebookUid)) {
            log.warn("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to get assignments list", (Object)this.getUserUid(), (Object)gradebookUid);
            throw new GradebookSecurityException();
        }
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        List<GradebookAssignment> internalAssignments = this.getAssignments(gradebookId);
        this.sortAssignments(internalAssignments, sortBy, true);
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        Iterator<GradebookAssignment> iterator = internalAssignments.iterator();
        while (iterator.hasNext()) {
            GradebookAssignment gradebookAssignment;
            GradebookAssignment assignment = gradebookAssignment = iterator.next();
            assignments.add(this.getAssignmentDefinition(assignment));
        }
        return assignments;
    }

    public Assignment getAssignment(String gradebookUid, Long assignmentId) throws AssessmentNotFoundException {
        if (assignmentId == null || gradebookUid == null) {
            throw new IllegalArgumentException("null parameter passed to getAssignment. Values are assignmentId:" + assignmentId + " gradebookUid:" + gradebookUid);
        }
        if (!this.isUserAbleToViewAssignments(gradebookUid) && !this.currentUserHasViewOwnGradesPerm(gradebookUid)) {
            log.warn("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to get assignment with id {}", new Object[]{this.getUserUid(), gradebookUid, assignmentId});
            throw new GradebookSecurityException();
        }
        GradebookAssignment assignment = this.getAssignmentWithoutStatsByID(gradebookUid, assignmentId);
        if (assignment == null) {
            throw new AssessmentNotFoundException("No gradebook item exists with gradable object id = " + assignmentId);
        }
        return this.getAssignmentDefinition(assignment);
    }

    @Deprecated
    public Assignment getAssignment(final String gradebookUid, final String assignmentName) throws AssessmentNotFoundException {
        if (assignmentName == null || gradebookUid == null) {
            throw new IllegalArgumentException("null parameter passed to getAssignment. Values are assignmentName:" + assignmentName + " gradebookUid:" + gradebookUid);
        }
        if (!this.isUserAbleToViewAssignments(gradebookUid) && !this.currentUserHasViewOwnGradesPerm(gradebookUid)) {
            log.warn("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to get assignment {}", new Object[]{this.getUserUid(), gradebookUid, assignmentName});
            throw new GradebookSecurityException();
        }
        GradebookAssignment assignment = (GradebookAssignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName);
            }
        });
        if (assignment != null) {
            return this.getAssignmentDefinition(assignment);
        }
        return null;
    }

    public Assignment getExternalAssignment(String gradebookUid, String externalId) throws GradebookNotFoundException {
        Gradebook gradebook = this.getGradebook(gradebookUid);
        HibernateCallback hc = session -> (GradebookAssignment)session.createQuery("from GradebookAssignment as asn where asn.gradebook = :gradebook and asn.externalId = :externalid").setEntity("gradebook", (Object)gradebook).setString("externalid", externalId).uniqueResult();
        return this.getAssignmentDefinition((GradebookAssignment)this.getHibernateTemplate().execute(hc));
    }

    public Assignment getAssignmentByNameOrId(String gradebookUid, String assignmentName) throws AssessmentNotFoundException {
        Assignment assignment = null;
        try {
            assignment = this.getAssignment(gradebookUid, assignmentName);
        }
        catch (AssessmentNotFoundException e) {
            log.debug("Assessment not found by name", (Throwable)e);
        }
        if (assignment == null && NumberUtils.isCreatable((String)assignmentName)) {
            Long assignmentId = NumberUtils.toLong((String)assignmentName, (long)-1L);
            return this.getAssignment(gradebookUid, assignmentId);
        }
        return assignment;
    }

    private Assignment getAssignmentDefinition(GradebookAssignment internalAssignment) {
        Assignment assignmentDefinition = new Assignment();
        assignmentDefinition.setName(internalAssignment.getName());
        assignmentDefinition.setPoints(internalAssignment.getPointsPossible());
        assignmentDefinition.setDueDate(internalAssignment.getDueDate());
        assignmentDefinition.setCounted(internalAssignment.isCounted());
        assignmentDefinition.setExternallyMaintained(internalAssignment.isExternallyMaintained());
        assignmentDefinition.setExternalAppName(internalAssignment.getExternalAppName());
        assignmentDefinition.setExternalId(internalAssignment.getExternalId());
        assignmentDefinition.setExternalData(internalAssignment.getExternalData());
        assignmentDefinition.setReleased(internalAssignment.isReleased().booleanValue());
        assignmentDefinition.setId(internalAssignment.getId());
        assignmentDefinition.setExtraCredit(internalAssignment.isExtraCredit().booleanValue());
        if (internalAssignment.getCategory() != null) {
            assignmentDefinition.setCategoryName(internalAssignment.getCategory().getName());
            assignmentDefinition.setWeight(internalAssignment.getCategory().getWeight());
            assignmentDefinition.setCategoryExtraCredit(internalAssignment.getCategory().isExtraCredit().booleanValue());
            assignmentDefinition.setCategoryEqualWeight(internalAssignment.getCategory().isEqualWeightAssignments().booleanValue());
            assignmentDefinition.setCategoryId(internalAssignment.getCategory().getId());
            assignmentDefinition.setCategoryOrder(internalAssignment.getCategory().getCategoryOrder());
        }
        assignmentDefinition.setUngraded(internalAssignment.getUngraded());
        assignmentDefinition.setSortOrder(internalAssignment.getSortOrder());
        assignmentDefinition.setCategorizedSortOrder(internalAssignment.getCategorizedSortOrder());
        return assignmentDefinition;
    }

    public GradeDefinition getGradeDefinitionForStudentForItem(final String gradebookUid, final Long assignmentId, final String studentUid) {
        if (gradebookUid == null || assignmentId == null || studentUid == null) {
            throw new IllegalArgumentException("Null paraemter passed to getGradeDefinitionForStudentForItem");
        }
        final boolean studentRequestingOwnScore = this.authn.getUserUid().equals(studentUid) || this.isCurrentUserFromGroup(gradebookUid, studentUid);
        GradeDefinition gradeDef = (GradeDefinition)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                GradebookAssignment assignment = GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentId);
                if (assignment == null) {
                    throw new AssessmentNotFoundException("There is no assignment with the assignmentId " + assignmentId + " in gradebook " + gradebookUid);
                }
                if (!studentRequestingOwnScore && !GradebookServiceHibernateImpl.this.isUserAbleToViewItemForStudent(gradebookUid, assignment.getId(), studentUid)) {
                    log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to retrieve grade for student {} for assignment {}", new Object[]{GradebookServiceHibernateImpl.this.getUserUid(), gradebookUid, studentUid, assignmentId});
                    throw new GradebookSecurityException();
                }
                Gradebook gradebook = assignment.getGradebook();
                GradeDefinition gradeDef = new GradeDefinition();
                gradeDef.setStudentUid(studentUid);
                gradeDef.setGradeEntryType(gradebook.getGrade_type());
                gradeDef.setGradeReleased(assignment.isReleased().booleanValue());
                if (!(!studentRequestingOwnScore || gradebook.isAssignmentsDisplayed() && assignment.isReleased().booleanValue())) {
                    gradeDef.setDateRecorded(null);
                    gradeDef.setGrade(null);
                    gradeDef.setGraderUid(null);
                    gradeDef.setGradeComment(null);
                    log.debug("Student {} in gradebook {} retrieving score for unreleased assignment {}", new Object[]{GradebookServiceHibernateImpl.this.getUserUid(), gradebookUid, assignment.getName()});
                } else {
                    String commentText;
                    AssignmentGradeRecord gradeRecord = GradebookServiceHibernateImpl.this.getAssignmentGradeRecord(assignment, studentUid);
                    CommentDefinition gradeComment = GradebookServiceHibernateImpl.this.getAssignmentScoreComment(gradebookUid, assignmentId, studentUid);
                    String string = commentText = gradeComment != null ? gradeComment.getCommentText() : null;
                    if (log.isDebugEnabled()) {
                        log.debug("gradeRecord=" + gradeRecord);
                    }
                    if (gradeRecord == null) {
                        gradeDef.setDateRecorded(null);
                        gradeDef.setGrade(null);
                        gradeDef.setGraderUid(null);
                        gradeDef.setGradeComment(commentText);
                        gradeDef.setExcused(Boolean.valueOf(false));
                    } else {
                        gradeDef.setDateRecorded(gradeRecord.getDateRecorded());
                        gradeDef.setGraderUid(gradeRecord.getGraderId());
                        gradeDef.setGradeComment(commentText);
                        gradeDef.setExcused(gradeRecord.isExcludedFromGrade());
                        if (gradebook.getGrade_type() == 3) {
                            ArrayList<AssignmentGradeRecord> gradeList = new ArrayList<AssignmentGradeRecord>();
                            gradeList.add(gradeRecord);
                            GradebookServiceHibernateImpl.this.convertPointsToLetterGrade(gradebook, gradeList);
                            AssignmentGradeRecord gradeRec = (AssignmentGradeRecord)gradeList.get(0);
                            if (gradeRec != null) {
                                gradeDef.setGrade(gradeRec.getLetterEarned());
                            }
                        } else if (gradebook.getGrade_type() == 2) {
                            Double percent = GradebookServiceHibernateImpl.this.calculateEquivalentPercent(assignment.getPointsPossible(), gradeRecord.getPointsEarned());
                            if (percent != null) {
                                gradeDef.setGrade(percent.toString());
                            }
                        } else if (gradeRecord.getPointsEarned() != null) {
                            gradeDef.setGrade(gradeRecord.getPointsEarned().toString());
                        }
                    }
                }
                return gradeDef;
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("returning grade def for " + studentUid);
        }
        return gradeDef;
    }

    public GradebookInformation getGradebookInformation(String gradebookUid) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("null gradebookUid " + gradebookUid);
        }
        if (!this.currentUserHasEditPerm(gradebookUid) && !this.currentUserHasGradingPerm(gradebookUid)) {
            log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to access gb information", (Object)this.getUserUid(), (Object)gradebookUid);
            throw new GradebookSecurityException();
        }
        Gradebook gradebook = this.getGradebook(gradebookUid);
        if (gradebook == null) {
            throw new IllegalArgumentException("Their is no gradbook associated with this Id: " + gradebookUid);
        }
        GradebookInformation rval = new GradebookInformation();
        rval.setGradeMappings(this.getGradebookGradeMappings(gradebook.getGradeMappings()));
        GradeMapping selectedGradeMapping = gradebook.getSelectedGradeMapping();
        if (selectedGradeMapping != null) {
            rval.setSelectedGradingScaleUid(selectedGradeMapping.getGradingScale().getUid());
            rval.setSelectedGradeMappingId(Long.toString(selectedGradeMapping.getId()));
            Map gradeMap = selectedGradeMapping.getGradeMap();
            gradeMap = GradeMappingDefinition.sortGradeMapping((Map)gradeMap);
            rval.setSelectedGradingScaleBottomPercents(gradeMap);
            rval.setGradeScale(selectedGradeMapping.getGradingScale().getName());
        }
        rval.setGradeType(gradebook.getGrade_type());
        rval.setCategoryType(gradebook.getCategory_type());
        rval.setDisplayReleasedGradeItemsToStudents(gradebook.isAssignmentsDisplayed());
        rval.setCategories(this.getCategoryDefinitions(gradebookUid));
        rval.setCourseGradeDisplayed(gradebook.isCourseGradeDisplayed());
        rval.setCourseLetterGradeDisplayed(gradebook.isCourseLetterGradeDisplayed());
        rval.setCoursePointsDisplayed(gradebook.isCoursePointsDisplayed());
        rval.setCourseAverageDisplayed(gradebook.isCourseAverageDisplayed());
        rval.setAssignmentStatsDisplayed(gradebook.isAssignmentStatsDisplayed());
        rval.setCourseGradeStatsDisplayed(gradebook.isCourseGradeStatsDisplayed());
        return rval;
    }

    public Map<String, String> transferGradebook(GradebookInformation gradebookInformation, List<Assignment> assignments, String toGradebookUid, String fromContext) {
        HashMap<String, String> transversalMap;
        block5: {
            transversalMap = new HashMap<String, String>();
            Gradebook gradebook = this.getGradebook(toGradebookUid);
            gradebook.setCategory_type(gradebookInformation.getCategoryType());
            gradebook.setGrade_type(gradebookInformation.getGradeType());
            gradebook.setAssignmentStatsDisplayed(gradebookInformation.isAssignmentStatsDisplayed());
            gradebook.setCourseGradeStatsDisplayed(gradebookInformation.isCourseGradeStatsDisplayed());
            gradebook.setAssignmentsDisplayed(gradebookInformation.isDisplayReleasedGradeItemsToStudents());
            gradebook.setCourseGradeDisplayed(gradebookInformation.isCourseGradeDisplayed());
            gradebook.setCourseLetterGradeDisplayed(gradebookInformation.isCourseLetterGradeDisplayed());
            gradebook.setCoursePointsDisplayed(gradebookInformation.isCoursePointsDisplayed());
            gradebook.setCourseAverageDisplayed(gradebookInformation.isCourseAverageDisplayed());
            this.updateGradebook(gradebook);
            List categories = gradebookInformation.getCategories();
            assignments.removeIf(a -> a.isExternallyMaintained());
            HashMap categoriesCreated = new HashMap();
            ArrayList assignmentsCreated = new ArrayList();
            if (!categories.isEmpty() && gradebookInformation.getCategoryType() != 1) {
                categories.forEach(c -> assignments.forEach(a -> {
                    if (StringUtils.equals((CharSequence)c.getName(), (CharSequence)a.getCategoryName())) {
                        if (!categoriesCreated.containsKey(c.getName())) {
                            Long categoryId = null;
                            try {
                                categoryId = this.createCategory(gradebook.getId(), c.getName(), c.getWeight(), c.getDropLowest(), c.getDropHighest(), c.getKeepHighest(), c.getExtraCredit(), c.getEqualWeight(), c.getCategoryOrder());
                            }
                            catch (ConflictingCategoryNameException e2) {
                                log.info("Category: {} already exists in target site. Skipping creation.", (Object)c.getName());
                            }
                            if (categoryId == null) {
                                List<CategoryDefinition> existingCategories = this.getCategoryDefinitions(gradebook.getUid());
                                categoryId = existingCategories.stream().filter(e -> StringUtils.equals((CharSequence)e.getName(), (CharSequence)c.getName())).findFirst().get().getId();
                            }
                            categoriesCreated.put(c.getName(), categoryId);
                        }
                        try {
                            Long newId = this.createAssignmentForCategory(gradebook.getId(), (Long)categoriesCreated.get(c.getName()), a.getName(), a.getPoints(), a.getDueDate(), !a.isCounted(), a.isReleased(), a.isExtraCredit(), a.getCategorizedSortOrder());
                            transversalMap.put("gb/" + a.getId(), "gb/" + newId);
                        }
                        catch (ConflictingAssignmentNameException e3) {
                            log.info("GradebookAssignment: {} already exists in target site. Skipping creation.", (Object)a.getName());
                        }
                        catch (Exception ex) {
                            log.warn("GradebookAssignment: exception {} trying to create {} in target site. Skipping creation.", (Object)ex.getMessage(), (Object)a.getName());
                        }
                        assignmentsCreated.add(a.getName());
                    }
                }));
                categories.removeIf(c -> categoriesCreated.containsKey(c.getName()));
                categories.forEach(c -> {
                    try {
                        this.createCategory(gradebook.getId(), c.getName(), c.getWeight(), c.getDropLowest(), c.getDropHighest(), c.getKeepHighest(), c.getExtraCredit(), c.getEqualWeight(), c.getCategoryOrder());
                    }
                    catch (ConflictingCategoryNameException e) {
                        log.info("Category: {} already exists in target site. Skipping creation.", (Object)c.getName());
                    }
                });
            }
            assignments.removeIf(a -> assignmentsCreated.contains(a.getName()));
            assignments.forEach(a -> {
                try {
                    Long newId = this.createAssignment(gradebook.getId(), a.getName(), a.getPoints(), a.getDueDate(), !a.isCounted(), a.isReleased(), a.isExtraCredit(), a.getSortOrder());
                    transversalMap.put("gb/" + a.getId(), "gb/" + newId);
                }
                catch (ConflictingAssignmentNameException e) {
                    log.info("GradebookAssignment: {} already exists in target site. Skipping creation.", (Object)a.getName());
                }
                catch (Exception ex) {
                    log.warn("GradebookAssignment: exception {} trying to create {} in target site. Skipping creation.", (Object)ex.getMessage(), (Object)a.getName());
                }
            });
            String fromGradingScaleUid = gradebookInformation.getSelectedGradingScaleUid();
            if (!StringUtils.isEmpty((CharSequence)fromGradingScaleUid)) {
                for (GradeMapping gradeMapping : gradebook.getGradeMappings()) {
                    if (!gradeMapping.getGradingScale().getUid().equals(fromGradingScaleUid)) continue;
                    Map inputGradePercents = gradebookInformation.getSelectedGradingScaleBottomPercents();
                    Set gradeCodes = inputGradePercents.keySet();
                    if (!gradeCodes.containsAll(gradeMapping.getGradeMap().keySet())) {
                        gradeMapping.getGradeMap().clear();
                    }
                    for (String gradeCode : gradeCodes) {
                        gradeMapping.getGradeMap().put(gradeCode, inputGradePercents.get(gradeCode));
                    }
                    gradebook.setSelectedGradeMapping(gradeMapping);
                    this.updateGradebook(gradebook);
                    log.info("Merge to gradebook {} updated grade mapping", (Object)toGradebookUid);
                    break block5;
                }
                log.info("Merge to gradebook {} skipped grade mapping change because grading scale {} is not defined", (Object)toGradebookUid, (Object)fromGradingScaleUid);
            }
        }
        return transversalMap;
    }

    public void removeAssignment(final Long assignmentId) throws StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                GradebookAssignment asn = (GradebookAssignment)session.load(GradebookAssignment.class, (Serializable)assignmentId);
                Gradebook gradebook = asn.getGradebook();
                asn.setRemoved(true);
                session.update((Object)asn);
                if (log.isInfoEnabled()) {
                    log.info("GradebookAssignment " + asn.getName() + " has been removed from " + gradebook);
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
    }

    public Long addAssignment(String gradebookUid, Assignment assignmentDefinition) {
        if (!this.getAuthz().isUserAbleToEditAssessments(gradebookUid)) {
            log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to add an assignment", (Object)this.getUserUid(), (Object)gradebookUid);
            throw new GradebookSecurityException();
        }
        String validatedName = GradebookHelper.validateAssignmentNameAndPoints((Assignment)assignmentDefinition);
        Gradebook gradebook = this.getGradebook(gradebookUid);
        if (assignmentDefinition.getCategoryId() != null) {
            return this.createAssignmentForCategory(gradebook.getId(), assignmentDefinition.getCategoryId(), validatedName, assignmentDefinition.getPoints(), assignmentDefinition.getDueDate(), !assignmentDefinition.isCounted(), assignmentDefinition.isReleased(), assignmentDefinition.isExtraCredit(), assignmentDefinition.getCategorizedSortOrder());
        }
        return this.createAssignment(gradebook.getId(), validatedName, assignmentDefinition.getPoints(), assignmentDefinition.getDueDate(), !assignmentDefinition.isCounted(), assignmentDefinition.isReleased(), assignmentDefinition.isExtraCredit(), assignmentDefinition.getSortOrder());
    }

    public void updateAssignment(final String gradebookUid, final Long assignmentId, final Assignment assignmentDefinition) {
        if (!this.getAuthz().isUserAbleToEditAssessments(gradebookUid)) {
            log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to change the definition of assignment {}", new Object[]{this.getUserUid(), gradebookUid, assignmentId});
            throw new GradebookSecurityException();
        }
        final String validatedName = GradebookHelper.validateAssignmentNameAndPoints((Assignment)assignmentDefinition);
        final Gradebook gradebook = this.getGradebook(gradebookUid);
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                GradebookAssignment assignment = GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentId);
                if (assignment == null) {
                    throw new AssessmentNotFoundException("There is no assignment with id " + assignmentId + " in gradebook " + gradebookUid);
                }
                boolean scaleGrades = false;
                Double originalPointsPossible = assignment.getPointsPossible();
                if (gradebook.getGrade_type() == 2 && !assignment.getPointsPossible().equals(assignmentDefinition.getPoints())) {
                    scaleGrades = true;
                }
                if (gradebook.getGrade_type() == 1 && assignmentDefinition.isScaleGrades()) {
                    scaleGrades = true;
                }
                if (!assignmentDefinition.isExternallyMaintained()) {
                    assignment.setName(validatedName);
                    assignment.setPointsPossible(assignmentDefinition.getPoints());
                    assignment.setDueDate(assignmentDefinition.getDueDate());
                }
                assignment.setExtraCredit(Boolean.valueOf(assignmentDefinition.isExtraCredit()));
                assignment.setCounted(assignmentDefinition.isCounted());
                assignment.setReleased(Boolean.valueOf(assignmentDefinition.isReleased()));
                assignment.setExternalAppName(assignmentDefinition.getExternalAppName());
                assignment.setExternallyMaintained(Boolean.valueOf(assignmentDefinition.isExternallyMaintained()));
                assignment.setExternalId(assignmentDefinition.getExternalId());
                assignment.setExternalData(assignmentDefinition.getExternalData());
                if (assignmentDefinition.getCategoryId() != null) {
                    Category cat = (Category)session.load(Category.class, (Serializable)assignmentDefinition.getCategoryId());
                    assignment.setCategory(cat);
                } else {
                    assignment.setCategory(null);
                }
                GradebookServiceHibernateImpl.this.updateAssignment(assignment);
                if (scaleGrades) {
                    GradebookServiceHibernateImpl.this.scaleGrades(gradebook, assignment, originalPointsPossible);
                }
                return null;
            }
        });
    }

    @Override
    public org.sakaiproject.tool.gradebook.CourseGrade getCourseGrade(Long gradebookId) {
        return (org.sakaiproject.tool.gradebook.CourseGrade)this.getHibernateTemplate().findByNamedParam("from CourseGrade as cg where cg.gradebook.id = :gradebookid", "gradebookid", (Object)gradebookId).get(0);
    }

    public List getPointsEarnedCourseGradeRecords(final org.sakaiproject.tool.gradebook.CourseGrade courseGrade, final Collection studentUids) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (studentUids == null || studentUids.isEmpty()) {
                    if (log.isInfoEnabled()) {
                        log.info("Returning no grade records for an empty collection of student UIDs");
                    }
                    return new ArrayList();
                }
                Query q = session.createQuery("from CourseGradeRecord as cgr where cgr.gradableObject.id=:gradableObjectId");
                q.setLong("gradableObjectId", courseGrade.getId().longValue());
                List records = GradebookServiceHibernateImpl.this.filterAndPopulateCourseGradeRecordsByStudents(courseGrade, q.list(), studentUids);
                Long gradebookId = courseGrade.getGradebook().getId();
                Gradebook gradebook = GradebookServiceHibernateImpl.this.getGradebook(gradebookId);
                List cates = GradebookServiceHibernateImpl.this.getCategories(gradebookId);
                Map<String, List<AssignmentGradeRecord>> gradeRecMap = GradebookServiceHibernateImpl.this.getGradeRecordMapForStudents(gradebookId, studentUids);
                List<GradebookAssignment> assignments = GradebookServiceHibernateImpl.this.getCountedAssignments(session, gradebookId);
                ArrayList<GradebookAssignment> countedAssigns = new ArrayList<GradebookAssignment>();
                if (assignments != null) {
                    for (GradebookAssignment assign : assignments) {
                        if (!assign.isIncludedInCalculations()) continue;
                        countedAssigns.add(assign);
                    }
                }
                for (CourseGradeRecord cgr : records) {
                    List<AssignmentGradeRecord> studentGradeRecs = gradeRecMap.get(cgr.getStudentId());
                    GradebookServiceHibernateImpl.this.applyDropScores(studentGradeRecs);
                    List totalEarned = GradebookServiceHibernateImpl.this.getTotalPointsEarnedInternal(cgr.getStudentId(), gradebook, cates, studentGradeRecs, countedAssigns);
                    double totalPointsEarned = (Double)totalEarned.get(0);
                    double literalTotalPointsEarned = (Double)totalEarned.get(1);
                    double extraPointsEarned = (Double)totalEarned.get(2);
                    double totalPointsPossible = GradebookServiceHibernateImpl.this.getTotalPointsInternal(gradebook, cates, cgr.getStudentId(), studentGradeRecs, countedAssigns, false);
                    cgr.initNonpersistentFields(totalPointsPossible, totalPointsEarned, literalTotalPointsEarned, extraPointsEarned);
                    if (log.isDebugEnabled()) {
                        log.debug("Points earned = " + cgr.getPointsEarned());
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Points possible = " + cgr.getTotalPointsPossible());
                }
                return records;
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    private List filterAndPopulateCourseGradeRecordsByStudents(org.sakaiproject.tool.gradebook.CourseGrade courseGrade, Collection gradeRecords, Collection studentUids) {
        ArrayList<CourseGradeRecord> filteredRecords = new ArrayList<CourseGradeRecord>();
        HashSet missingStudents = new HashSet(studentUids);
        for (CourseGradeRecord cgr : gradeRecords) {
            if (!studentUids.contains(cgr.getStudentId())) continue;
            filteredRecords.add(cgr);
            missingStudents.remove(cgr.getStudentId());
        }
        for (String studentUid : missingStudents) {
            CourseGradeRecord cgr = new CourseGradeRecord(courseGrade, studentUid);
            filteredRecords.add(cgr);
        }
        return filteredRecords;
    }

    private double getTotalPointsInternal(Gradebook gradebook, List categories, String studentId, List<AssignmentGradeRecord> studentGradeRecs, List<GradebookAssignment> countedAssigns, boolean literalTotal) {
        int gbGradeType = gradebook.getGrade_type();
        if (gbGradeType != 1 && gbGradeType != 2) {
            if (log.isErrorEnabled()) {
                log.error("Wrong grade type in GradebookCalculationImpl.getTotalPointsInternal");
            }
            return -1.0;
        }
        if (studentGradeRecs == null || countedAssigns == null) {
            if (log.isDebugEnabled()) {
                log.debug("Returning 0 from getTotalPointsInternal since studentGradeRecs or countedAssigns was null");
            }
            return 0.0;
        }
        double totalPointsPossible = 0.0;
        HashSet<GradebookAssignment> countedSet = new HashSet<GradebookAssignment>(countedAssigns);
        ArrayList<AssignmentGradeRecord> countedGradeRecs = new ArrayList<AssignmentGradeRecord>();
        for (AssignmentGradeRecord gradeRec : studentGradeRecs) {
            GradebookAssignment assign = gradeRec.getAssignment();
            boolean extraCredit = assign.isExtraCredit();
            if (gradebook.getCategory_type() != 1 && assign.getCategory() != null && assign.getCategory().isExtraCredit().booleanValue()) {
                extraCredit = true;
            }
            boolean excused = BooleanUtils.toBoolean((Boolean)gradeRec.isExcludedFromGrade());
            if (!assign.isCounted() || assign.getUngraded() || assign.isRemoved() || !countedSet.contains(assign) || assign.getPointsPossible() == null || !(assign.getPointsPossible() > 0.0) || gradeRec.getDroppedFromGrade().booleanValue() || extraCredit || excused) continue;
            countedGradeRecs.add(gradeRec);
        }
        HashSet<Long> assignmentsTaken = new HashSet<Long>();
        HashSet<Long> categoryTaken = new HashSet<Long>();
        block1: for (AssignmentGradeRecord gradeRec : countedGradeRecs) {
            if (gradeRec.getPointsEarned() == null || gradeRec.getPointsEarned().equals("")) continue;
            Double pointsEarned = gradeRec.getPointsEarned();
            GradebookAssignment go = gradeRec.getAssignment();
            if (pointsEarned == null) continue;
            if (gradebook.getCategory_type() == 1) {
                assignmentsTaken.add(go.getId());
                continue;
            }
            if (gradebook.getCategory_type() != 2 && gradebook.getCategory_type() != 3 || go == null || categories == null) continue;
            for (int i = 0; i < categories.size(); ++i) {
                Category cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || go.getCategory() == null || !cate.getId().equals(go.getCategory().getId()) || (cate.isExtraCredit() == null || cate.isExtraCredit().booleanValue()) && cate.isExtraCredit() != null) continue;
                assignmentsTaken.add(go.getId());
                categoryTaken.add(cate.getId());
                continue block1;
            }
        }
        if (!assignmentsTaken.isEmpty()) {
            if (!literalTotal && gradebook.getCategory_type() == 3) {
                for (int i = 0; i < categories.size(); ++i) {
                    Category cate = (Category)categories.get(i);
                    if (cate == null || cate.isRemoved() || !categoryTaken.contains(cate.getId())) continue;
                    totalPointsPossible += cate.getWeight().doubleValue();
                }
                return totalPointsPossible;
            }
            for (GradebookAssignment asn : countedAssigns) {
                if (asn == null) continue;
                Double pointsPossible = asn.getPointsPossible();
                if (gradebook.getCategory_type() == 1 && assignmentsTaken.contains(asn.getId())) {
                    totalPointsPossible += pointsPossible.doubleValue();
                    continue;
                }
                if (gradebook.getCategory_type() == 2 && assignmentsTaken.contains(asn.getId())) {
                    totalPointsPossible += pointsPossible.doubleValue();
                    continue;
                }
                if (!literalTotal || gradebook.getCategory_type() != 3 || !assignmentsTaken.contains(asn.getId())) continue;
                totalPointsPossible += pointsPossible.doubleValue();
            }
        } else {
            totalPointsPossible = -1.0;
        }
        return totalPointsPossible;
    }

    private List getTotalPointsEarnedInternal(String studentId, Gradebook gradebook, List categories, List<AssignmentGradeRecord> gradeRecs, List<GradebookAssignment> countedAssigns) {
        int gbGradeType = gradebook.getGrade_type();
        if (gbGradeType != 1 && gbGradeType != 2) {
            if (log.isErrorEnabled()) {
                log.error("Wrong grade type in GradebookCalculationImpl.getTotalPointsEarnedInternal");
            }
            return new ArrayList();
        }
        if (gradeRecs == null || countedAssigns == null) {
            if (log.isDebugEnabled()) {
                log.debug("getTotalPointsEarnedInternal for studentId=" + studentId + " returning 0 because null gradeRecs or countedAssigns");
            }
            ArrayList<Double> returnList = new ArrayList<Double>();
            returnList.add(new Double(0.0));
            returnList.add(new Double(0.0));
            returnList.add(new Double(0.0));
            return returnList;
        }
        BigDecimal totalPointsEarned = new BigDecimal(0);
        BigDecimal extraPointsEarned = new BigDecimal(0);
        BigDecimal literalTotalPointsEarned = new BigDecimal(0.0);
        HashMap<Long, BigDecimal> cateScoreMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> cateTotalScoreMap = new HashMap<Long, BigDecimal>();
        HashSet<Long> assignmentsTaken = new HashSet<Long>();
        block0: for (AssignmentGradeRecord gradeRec : gradeRecs) {
            GradebookAssignment go;
            boolean excused = BooleanUtils.toBoolean((Boolean)gradeRec.isExcludedFromGrade());
            if (gradeRec.getPointsEarned() == null || gradeRec.getPointsEarned().equals("") || gradeRec.getDroppedFromGrade().booleanValue() || !(go = gradeRec.getAssignment()).isIncludedInCalculations() || !countedAssigns.contains(go)) continue;
            BigDecimal pointsEarned = BigDecimal.valueOf(gradeRec.getPointsEarned());
            BigDecimal pointsPossible = BigDecimal.valueOf(go.getPointsPossible());
            if (gradebook.getCategory_type() == 1) {
                if (excused) continue;
                totalPointsEarned = totalPointsEarned.add(pointsEarned, GradebookService.MATH_CONTEXT);
                literalTotalPointsEarned = pointsEarned.add(literalTotalPointsEarned, GradebookService.MATH_CONTEXT);
                assignmentsTaken.add(go.getId());
                continue;
            }
            if (gradebook.getCategory_type() == 2 && go != null) {
                if (excused) continue;
                totalPointsEarned = totalPointsEarned.add(pointsEarned, GradebookService.MATH_CONTEXT);
                literalTotalPointsEarned = pointsEarned.add(literalTotalPointsEarned, GradebookService.MATH_CONTEXT);
                assignmentsTaken.add(go.getId());
                continue;
            }
            if (gradebook.getCategory_type() != 3 || go == null || categories == null) continue;
            for (int i = 0; i < categories.size(); ++i) {
                Category cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || go.getCategory() == null || !cate.getId().equals(go.getCategory().getId())) continue;
                if (excused) continue block0;
                assignmentsTaken.add(go.getId());
                literalTotalPointsEarned = pointsEarned.add(literalTotalPointsEarned, GradebookService.MATH_CONTEXT);
                if (cate.isEqualWeightAssignments().booleanValue()) {
                    pointsEarned = pointsEarned.divide(pointsPossible, GradebookService.MATH_CONTEXT);
                }
                if (cateScoreMap.get(cate.getId()) != null) {
                    cateScoreMap.put(cate.getId(), ((BigDecimal)cateScoreMap.get(cate.getId())).add(pointsEarned, GradebookService.MATH_CONTEXT));
                    continue block0;
                }
                cateScoreMap.put(cate.getId(), pointsEarned);
                continue block0;
            }
        }
        if (gradebook.getCategory_type() == 3 && categories != null) {
            for (GradebookAssignment asgn : countedAssigns) {
                BigDecimal pointsPossible = new BigDecimal(asgn.getPointsPossible());
                if (!assignmentsTaken.contains(asgn.getId())) continue;
                for (int i = 0; i < categories.size(); ++i) {
                    Category cate = (Category)categories.get(i);
                    if (cate == null || cate.isRemoved() || asgn.getCategory() == null || !cate.getId().equals(asgn.getCategory().getId()) || asgn.isExtraCredit().booleanValue()) continue;
                    if (cate.isEqualWeightAssignments().booleanValue()) {
                        pointsPossible = new BigDecimal("1");
                    }
                    if (cateTotalScoreMap.get(cate.getId()) == null) {
                        cateTotalScoreMap.put(cate.getId(), pointsPossible);
                        continue;
                    }
                    cateTotalScoreMap.put(cate.getId(), ((BigDecimal)cateTotalScoreMap.get(cate.getId())).add(pointsPossible));
                }
            }
        }
        if (assignmentsTaken.isEmpty()) {
            totalPointsEarned = new BigDecimal(-1);
        }
        if (gradebook.getCategory_type() == 3) {
            for (int i = 0; i < categories.size(); ++i) {
                Category cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || cateScoreMap.get(cate.getId()) == null || cateTotalScoreMap.get(cate.getId()) == null) continue;
                if (cate.getIsExtraCredit().booleanValue()) {
                    extraPointsEarned = extraPointsEarned.add(((BigDecimal)cateScoreMap.get(cate.getId())).multiply(new BigDecimal(cate.getWeight()), GradebookService.MATH_CONTEXT).divide((BigDecimal)cateTotalScoreMap.get(cate.getId()), GradebookService.MATH_CONTEXT));
                    continue;
                }
                totalPointsEarned = totalPointsEarned.add(((BigDecimal)cateScoreMap.get(cate.getId())).multiply(new BigDecimal(cate.getWeight()), GradebookService.MATH_CONTEXT).divide((BigDecimal)cateTotalScoreMap.get(cate.getId()), GradebookService.MATH_CONTEXT));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("getTotalPointsEarnedInternal for studentId=" + studentId + " returning " + totalPointsEarned);
        }
        ArrayList<Double> returnList = new ArrayList<Double>();
        returnList.add(totalPointsEarned.doubleValue());
        returnList.add(literalTotalPointsEarned.doubleValue());
        returnList.add(extraPointsEarned.doubleValue());
        return returnList;
    }

    public Gradebook getGradebook(Long id) {
        return (Gradebook)this.getHibernateTemplate().load(Gradebook.class, (Serializable)id);
    }

    private List<GradebookAssignment> getAssignmentsCounted(Long gradebookId) throws HibernateException {
        HibernateCallback hc = session -> session.createQuery("from GradebookAssignment as asn where asn.gradebook.id = :gradebookid and asn.removed is false and asn.notCounted is false").setLong("gradebookid", gradebookId.longValue()).list();
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public boolean checkStudentsNotSubmitted(String gradebookUid) {
        Gradebook gradebook = this.getGradebook(gradebookUid);
        Set<String> studentUids = this.getAllStudentUids(this.getGradebookUid(gradebook.getId()));
        if (gradebook.getCategory_type() == 1 || gradebook.getCategory_type() == 2) {
            List records = this.getAllAssignmentGradeRecords(gradebook.getId(), studentUids);
            List assigns = this.getAssignments(gradebook.getId(), SortType.SORT_BY_SORTING, true);
            ArrayList<GradebookAssignment> filteredAssigns = new ArrayList<GradebookAssignment>();
            for (GradebookAssignment assignment : assigns) {
                if (!assignment.isCounted() || assignment.getUngraded()) continue;
                filteredAssigns.add(assignment);
            }
            ArrayList<AssignmentGradeRecord> filteredRecords = new ArrayList<AssignmentGradeRecord>();
            for (AssignmentGradeRecord agr : records) {
                if (agr.isCourseGradeRecord() || !agr.getAssignment().isCounted() || agr.getAssignment().getUngraded()) continue;
                if (agr.getPointsEarned() == null) {
                    return true;
                }
                filteredRecords.add(agr);
            }
            return filteredRecords.size() < filteredAssigns.size() * studentUids.size();
        }
        List assigns = this.getAssignments(gradebook.getId(), SortType.SORT_BY_SORTING, true);
        List records = this.getAllAssignmentGradeRecords(gradebook.getId(), studentUids);
        HashSet<Long> filteredAssigns = new HashSet<Long>();
        for (GradebookAssignment assign : assigns) {
            if (assign == null || !assign.isCounted() || assign.getUngraded() || assign.getCategory() == null || assign.getCategory().isRemoved()) continue;
            filteredAssigns.add(assign.getId());
        }
        ArrayList<AssignmentGradeRecord> filteredRecords = new ArrayList<AssignmentGradeRecord>();
        for (AssignmentGradeRecord agr : records) {
            if (!filteredAssigns.contains(agr.getAssignment().getId()) || agr.isCourseGradeRecord()) continue;
            if (agr.getPointsEarned() == null) {
                return true;
            }
            filteredRecords.add(agr);
        }
        return filteredRecords.size() < filteredAssigns.size() * studentUids.size();
    }

    public List getAllAssignmentGradeRecords(final Long gradebookId, final Collection studentUids) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (studentUids.isEmpty()) {
                    if (log.isInfoEnabled()) {
                        log.info("No enrollments were specified.  Returning an empty List of grade records");
                    }
                    return new ArrayList();
                }
                Query q = session.createQuery("from AssignmentGradeRecord as agr where agr.gradableObject.removed=false and agr.gradableObject.gradebook.id=:gradebookId order by agr.pointsEarned");
                q.setLong("gradebookId", gradebookId.longValue());
                return GradebookServiceHibernateImpl.this.filterGradeRecordsByStudents(q.list(), studentUids);
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    private List getAllAssignmentGradeRecordsForGbItem(final Long gradableObjectId, final Collection studentUids) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (studentUids.isEmpty()) {
                    if (log.isInfoEnabled()) {
                        log.info("No enrollments were specified.  Returning an empty List of grade records");
                    }
                    return new ArrayList();
                }
                Query q = session.createQuery("from AssignmentGradeRecord as agr where agr.gradableObject.removed=false and agr.gradableObject.id=:gradableObjectId order by agr.pointsEarned");
                q.setLong("gradableObjectId", gradableObjectId.longValue());
                return GradebookServiceHibernateImpl.this.filterGradeRecordsByStudents(q.list(), studentUids);
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    private List<AssignmentGradeRecord> getAllAssignmentGradeRecordsForGbItems(final List<Long> gradableObjectIds, final List studentUids) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                ArrayList gradeRecords = new ArrayList();
                if (studentUids.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug("No enrollments were specified. Returning an empty List of grade records");
                    }
                    return gradeRecords;
                }
                int minGbo = 0;
                int maxGbo = Math.min(gradableObjectIds.size(), 1000);
                while (minGbo < gradableObjectIds.size()) {
                    int minStudent = 0;
                    int maxStudent = Math.min(studentUids.size(), 1000);
                    while (minStudent < studentUids.size()) {
                        Query q = session.createQuery("from AssignmentGradeRecord as agr where agr.gradableObject.removed = false and agr.gradableObject.id in (:gradableObjectIds) and agr.studentId in (:studentUids)");
                        q.setParameterList("gradableObjectIds", gradableObjectIds.subList(minGbo, maxGbo));
                        q.setParameterList("studentUids", studentUids.subList(minStudent, maxStudent));
                        gradeRecords.addAll(q.list());
                        maxStudent = Math.min(studentUids.size(), (minStudent += 1000) + 1000);
                    }
                    maxGbo = Math.min(gradableObjectIds.size(), (minGbo += 1000) + 1000);
                }
                return gradeRecords;
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    public List getAssignments(Long gradebookId, SortType sortBy, boolean ascending) {
        List<GradebookAssignment> assignments = this.getAssignments(gradebookId);
        this.sortAssignments(assignments, sortBy, ascending);
        return assignments;
    }

    private void sortAssignments(List assignments, SortType sortBy, boolean ascending) {
        Comparator comp;
        if (sortBy == null) {
            sortBy = SortType.SORT_BY_SORTING;
        }
        switch (sortBy) {
            case SORT_BY_NONE: {
                return;
            }
            case SORT_BY_NAME: {
                comp = GradableObject.nameComparator;
                break;
            }
            case SORT_BY_DATE: {
                comp = GradableObject.dateComparator;
                break;
            }
            case SORT_BY_MEAN: {
                comp = GradableObject.meanComparator;
                break;
            }
            case SORT_BY_POINTS: {
                comp = GradebookAssignment.pointsComparator;
                break;
            }
            case SORT_BY_RELEASED: {
                comp = GradebookAssignment.releasedComparator;
                break;
            }
            case SORT_BY_COUNTED: {
                comp = GradebookAssignment.countedComparator;
                break;
            }
            case SORT_BY_EDITOR: {
                comp = GradebookAssignment.gradeEditorComparator;
                break;
            }
            case SORT_BY_SORTING: {
                comp = GradableObject.sortingComparator;
                break;
            }
            case SORT_BY_CATEGORY: {
                comp = GradebookAssignment.categoryComparator;
                break;
            }
            default: {
                comp = GradableObject.defaultComparator;
            }
        }
        Collections.sort(assignments, comp);
        if (!ascending) {
            Collections.reverse(assignments);
        }
        if (log.isDebugEnabled()) {
            log.debug("sortAssignments: ordering by " + sortBy + " (" + comp + "), ascending=" + ascending);
        }
    }

    public List<Assignment> getViewableAssignmentsForCurrentUser(String gradebookUid) throws GradebookNotFoundException {
        return this.getViewableAssignmentsForCurrentUser(gradebookUid, SortType.SORT_BY_SORTING);
    }

    public List<Assignment> getViewableAssignmentsForCurrentUser(String gradebookUid, SortType sortBy) throws GradebookNotFoundException {
        List allAssigns;
        List<GradebookAssignment> viewableAssignments = new ArrayList();
        LinkedHashSet<Assignment> assignmentsToReturn = new LinkedHashSet<Assignment>();
        Gradebook gradebook = this.getGradebook(gradebookUid);
        if (this.getAuthz().isUserAbleToGradeAll(gradebookUid)) {
            viewableAssignments = this.getAssignments(gradebook.getId(), sortBy, true);
        } else if (this.getAuthz().isUserAbleToGrade(gradebookUid)) {
            if (!this.getAuthz().isUserHasGraderPermissions(gradebookUid)) {
                viewableAssignments = this.getAssignments(gradebook.getId(), sortBy, true);
            } else if (gradebook.getCategory_type() == 1) {
                assignmentsToReturn.addAll(this.getAssignments(gradebookUid, sortBy));
            } else {
                String userUid = this.getUserUid();
                if (this.getGradebookPermissionService().getPermissionForUserForAllAssignment(gradebook.getId(), userUid)) {
                    assignmentsToReturn.addAll(this.getAssignments(gradebookUid, sortBy));
                } else {
                    List<Assignment> list = this.getAssignments(gradebookUid, sortBy);
                    List categoryIds = this.getCategories(gradebook.getId()).stream().map(Category::getId).collect(Collectors.toList());
                    if (!categoryIds.isEmpty()) {
                        List viewableCategoryIds = this.getGradebookPermissionService().getCategoriesForUser(gradebook.getId(), userUid, categoryIds);
                        for (Assignment assignment : list) {
                            if (assignment.getCategoryId() == null || !viewableCategoryIds.contains(assignment.getCategoryId())) continue;
                            assignmentsToReturn.add(assignment);
                        }
                    }
                }
            }
        } else if (this.getAuthz().isUserAbleToViewOwnGrades(gradebookUid) && (allAssigns = this.getAssignments(gradebook.getId(), sortBy, true)) != null) {
            for (GradebookAssignment assign : allAssigns) {
                if (assign == null || !assign.isReleased().booleanValue()) continue;
                viewableAssignments.add(assign);
            }
        }
        if (viewableAssignments != null && !viewableAssignments.isEmpty()) {
            for (Object e : viewableAssignments) {
                GradebookAssignment assignment = (GradebookAssignment)e;
                assignmentsToReturn.add(this.getAssignmentDefinition(assignment));
            }
        }
        return new ArrayList<Assignment>(assignmentsToReturn);
    }

    public Map<String, String> getViewableStudentsForItemForCurrentUser(String gradebookUid, Long gradableObjectId) {
        String userUid = this.authn.getUserUid();
        return this.getViewableStudentsForItemForUser(userUid, gradebookUid, gradableObjectId);
    }

    public Map<String, String> getViewableStudentsForItemForUser(String userUid, String gradebookUid, Long gradableObjectId) {
        if (gradebookUid == null || gradableObjectId == null || userUid == null) {
            throw new IllegalArgumentException("null gradebookUid or gradableObjectId or userId passed to getViewableStudentsForUserForItem. gradebookUid: " + gradebookUid + " gradableObjectId:" + gradableObjectId + " userId: " + userUid);
        }
        if (!this.authz.isUserAbleToGrade(gradebookUid, userUid)) {
            return new HashMap<String, String>();
        }
        GradebookAssignment gradebookItem = this.getAssignmentWithoutStatsByID(gradebookUid, gradableObjectId);
        if (gradebookItem == null) {
            log.debug("The gradebook item does not exist, so returning empty set");
            return new HashMap<String, String>();
        }
        Long categoryId = gradebookItem.getCategory() == null ? null : gradebookItem.getCategory().getId();
        Map enrRecFunctionMap = this.authz.findMatchingEnrollmentsForItemForUser(userUid, gradebookUid, categoryId, this.getGradebook(gradebookUid).getCategory_type(), null, null);
        if (enrRecFunctionMap == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> studentIdFunctionMap = new HashMap<String, String>();
        for (Map.Entry entry : enrRecFunctionMap.entrySet()) {
            EnrollmentRecord enr = (EnrollmentRecord)entry.getKey();
            if (enr == null || enrRecFunctionMap.get(enr) == null) continue;
            studentIdFunctionMap.put(enr.getUser().getUserUid(), (String)entry.getValue());
        }
        return studentIdFunctionMap;
    }

    public boolean isGradableObjectDefined(Long gradableObjectId) {
        if (gradableObjectId == null) {
            throw new IllegalArgumentException("null gradableObjectId passed to isGradableObjectDefined");
        }
        return this.isAssignmentDefined(gradableObjectId);
    }

    public Map getViewableSectionUuidToNameMap(String gradebookUid) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("Null gradebookUid passed to getViewableSectionIdToNameMap");
        }
        HashMap<String, String> sectionIdNameMap = new HashMap<String, String>();
        List viewableCourseSections = this.getAuthz().getViewableSections(gradebookUid);
        if (viewableCourseSections == null || viewableCourseSections.isEmpty()) {
            return sectionIdNameMap;
        }
        for (CourseSection section : viewableCourseSections) {
            if (section == null) continue;
            sectionIdNameMap.put(section.getUuid(), section.getTitle());
        }
        return sectionIdNameMap;
    }

    public boolean currentUserHasGradeAllPerm(String gradebookUid) {
        return this.authz.isUserAbleToGradeAll(gradebookUid);
    }

    public boolean isUserAllowedToGradeAll(String gradebookUid, String userUid) {
        return this.authz.isUserAbleToGradeAll(gradebookUid, userUid);
    }

    public boolean currentUserHasGradingPerm(String gradebookUid) {
        return this.authz.isUserAbleToGrade(gradebookUid);
    }

    public boolean isUserAllowedToGrade(String gradebookUid, String userUid) {
        return this.authz.isUserAbleToGrade(gradebookUid, userUid);
    }

    public boolean currentUserHasEditPerm(String gradebookUid) {
        return this.authz.isUserAbleToEditAssessments(gradebookUid);
    }

    public boolean currentUserHasViewOwnGradesPerm(String gradebookUid) {
        return this.authz.isUserAbleToViewOwnGrades(gradebookUid);
    }

    public boolean currentUserHasViewStudentNumbersPerm(String gradebookUid) {
        return this.authz.isUserAbleToViewStudentNumbers(gradebookUid);
    }

    public List<GradeDefinition> getGradesForStudentsForItem(String gradebookUid, Long gradableObjectId, List<String> studentIds) {
        GradebookAssignment gbItem;
        if (gradableObjectId == null) {
            throw new IllegalArgumentException("null gradableObjectId passed to getGradesForStudentsForItem");
        }
        ArrayList<GradeDefinition> studentGrades = new ArrayList<GradeDefinition>();
        if (studentIds != null && !studentIds.isEmpty() && (gbItem = this.getAssignmentWithoutStatsByID(gradebookUid, gradableObjectId)) != null) {
            Gradebook gradebook = gbItem.getGradebook();
            if (!this.authz.isUserAbleToGrade(gradebook.getUid())) {
                log.error("User {} attempted to access grade information without permission in gb {} using gradebookService.getGradesForStudentsForItem", (Object)this.authn.getUserUid(), (Object)gradebook.getUid());
                throw new GradebookSecurityException();
            }
            Long categoryId = gbItem.getCategory() != null ? gbItem.getCategory().getId() : null;
            Map enrRecFunctionMap = this.authz.findMatchingEnrollmentsForItem(gradebook.getUid(), categoryId, gradebook.getCategory_type(), null, null);
            Set enrRecs = enrRecFunctionMap.keySet();
            HashMap<String, EnrollmentRecord> studentIdEnrRecMap = new HashMap<String, EnrollmentRecord>();
            if (enrRecs != null) {
                for (EnrollmentRecord enr : enrRecs) {
                    if (enr == null) continue;
                    studentIdEnrRecMap.put(enr.getUser().getUserUid(), enr);
                }
            }
            studentIds.removeIf(studentId -> !studentIdEnrRecMap.containsKey(studentId));
            List<Comment> commentRecs = this.getComments(gbItem, studentIds);
            HashMap<String, String> studentIdCommentTextMap = new HashMap<String, String>();
            if (commentRecs != null) {
                for (Comment comment : commentRecs) {
                    if (comment == null) continue;
                    studentIdCommentTextMap.put(comment.getStudentId(), comment.getCommentText());
                }
            }
            ArrayList<String> studentsWithGradeRec = new ArrayList<String>();
            List gradeRecs = this.getAllAssignmentGradeRecordsForGbItem(gradableObjectId, studentIds);
            if (gradeRecs != null) {
                GradeDefinition gradeDef;
                if (gradebook.getGrade_type() == 3) {
                    this.convertPointsToLetterGrade(gradebook, gradeRecs);
                } else if (gradebook.getGrade_type() == 2) {
                    this.convertPointsToPercentage(gradebook, gradeRecs);
                }
                for (Object element : gradeRecs) {
                    AssignmentGradeRecord agr = (AssignmentGradeRecord)element;
                    if (agr == null) continue;
                    String commentText = (String)studentIdCommentTextMap.get(agr.getStudentId());
                    gradeDef = this.convertGradeRecordToGradeDefinition(agr, gbItem, gradebook, commentText);
                    studentGrades.add(gradeDef);
                    studentsWithGradeRec.add(agr.getStudentId());
                }
                if (studentsWithGradeRec.size() < studentIds.size()) {
                    for (String studentId2 : studentIdCommentTextMap.keySet()) {
                        if (studentsWithGradeRec.contains(studentId2)) continue;
                        String comment = (String)studentIdCommentTextMap.get(studentId2);
                        AssignmentGradeRecord emptyGradeRecord = new AssignmentGradeRecord(gbItem, studentId2, null);
                        gradeDef = this.convertGradeRecordToGradeDefinition(emptyGradeRecord, gbItem, gradebook, comment);
                        studentGrades.add(gradeDef);
                    }
                }
            }
        }
        return studentGrades;
    }

    public Map<Long, List<GradeDefinition>> getGradesWithoutCommentsForStudentsForItems(String gradebookUid, List<Long> gradableObjectIds, List<String> studentIds) {
        if (!this.authz.isUserAbleToGrade(gradebookUid)) {
            throw new GradebookSecurityException();
        }
        if (gradableObjectIds == null || gradableObjectIds.isEmpty()) {
            throw new IllegalArgumentException("null or empty gradableObjectIds passed to getGradesWithoutCommentsForStudentsForItems");
        }
        HashMap<Long, List<GradeDefinition>> gradesMap = new HashMap<Long, List<GradeDefinition>>();
        if (studentIds == null || studentIds.isEmpty()) {
            return gradesMap;
        }
        List<AssignmentGradeRecord> gradeRecords = this.getAllAssignmentGradeRecordsForGbItems(gradableObjectIds, studentIds);
        ArrayList gradeDefinitions = new ArrayList();
        for (AssignmentGradeRecord gradeRecord : gradeRecords) {
            GradebookAssignment gbo = (GradebookAssignment)gradeRecord.getGradableObject();
            Long gboId = gbo.getId();
            Gradebook gradebook = gbo.getGradebook();
            if (!gradebookUid.equals(gradebook.getUid())) {
                throw new IllegalArgumentException("gradableObjectIds must belong to grades within this gradebook");
            }
            GradeDefinition gradeDef = this.convertGradeRecordToGradeDefinition(gradeRecord, gbo, gradebook, null);
            ArrayList<GradeDefinition> gradeList = (ArrayList<GradeDefinition>)gradesMap.get(gboId);
            if (gradeList == null) {
                gradeList = new ArrayList<GradeDefinition>();
                gradesMap.put(gboId, gradeList);
            }
            gradeList.add(gradeDef);
        }
        return gradesMap;
    }

    private GradeDefinition convertGradeRecordToGradeDefinition(AssignmentGradeRecord gradeRecord, GradebookAssignment gbo, Gradebook gradebook, String commentText) {
        Double pointsEarned;
        Double percentEarned;
        GradeDefinition gradeDef = new GradeDefinition();
        gradeDef.setStudentUid(gradeRecord.getStudentId());
        gradeDef.setGraderUid(gradeRecord.getGraderId());
        gradeDef.setDateRecorded(gradeRecord.getDateRecorded());
        int gradeEntryType = gradebook.getGrade_type();
        gradeDef.setGradeEntryType(gradeEntryType);
        String grade = null;
        grade = gradeEntryType == 3 ? gradeRecord.getLetterEarned() : (gradeEntryType == 2 ? ((percentEarned = gradeRecord.getPercentEarned()) != null ? percentEarned.toString() : null) : ((pointsEarned = gradeRecord.getPointsEarned()) != null ? pointsEarned.toString() : null));
        gradeDef.setGrade(grade);
        gradeDef.setGradeReleased(gradebook.isAssignmentsDisplayed() && gbo.isReleased() != false);
        if (commentText != null) {
            gradeDef.setGradeComment(commentText);
        }
        gradeDef.setExcused(gradeRecord.isExcludedFromGrade());
        return gradeDef;
    }

    public boolean isGradeValid(String gradebookUuid, String grade) {
        Gradebook gradebook;
        if (gradebookUuid == null) {
            throw new IllegalArgumentException("Null gradebookUuid passed to isGradeValid");
        }
        try {
            gradebook = this.getGradebook(gradebookUuid);
        }
        catch (GradebookNotFoundException gnfe) {
            throw new GradebookNotFoundException("No gradebook exists with the given gradebookUid: " + gradebookUuid + "Error: " + gnfe.getMessage());
        }
        int gradeEntryType = gradebook.getGrade_type();
        LetterGradePercentMapping mapping = null;
        if (gradeEntryType == 3) {
            mapping = this.getLetterGradePercentMapping(gradebook);
        }
        return this.isGradeValid(grade, gradeEntryType, mapping);
    }

    public boolean isValidNumericGrade(String grade) {
        boolean gradeIsValid = false;
        try {
            NumberFormat nbFormat = NumberFormat.getInstance(new ResourceLoader().getLocale());
            Double gradeAsDouble = nbFormat.parse(grade).doubleValue();
            String decSeparator = ((DecimalFormat)nbFormat).getDecimalFormatSymbols().getDecimalSeparator() + "";
            if (gradeAsDouble >= 0.0) {
                String[] splitOnDecimal = grade.split("\\" + decSeparator);
                if (splitOnDecimal == null) {
                    gradeIsValid = true;
                } else if (grade.matches("[0-9]{0,10}(\\" + decSeparator + "[0-9]{0,2})?")) {
                    gradeIsValid = true;
                }
            }
        }
        catch (NumberFormatException | ParseException nfe) {
            log.debug("Passed grade is not a numeric value");
        }
        return gradeIsValid;
    }

    private boolean isGradeValid(String grade, int gradeEntryType, LetterGradePercentMapping gradeMapping) {
        boolean gradeIsValid;
        block13: {
            gradeIsValid = false;
            if (grade == null || "".equals(grade)) {
                gradeIsValid = true;
            } else if (gradeEntryType == 1 || gradeEntryType == 2) {
                try {
                    NumberFormat nbFormat = NumberFormat.getInstance(new ResourceLoader().getLocale());
                    Double gradeAsDouble = nbFormat.parse(grade).doubleValue();
                    String decSeparator = ((DecimalFormat)nbFormat).getDecimalFormatSymbols().getDecimalSeparator() + "";
                    if (!(gradeAsDouble >= 0.0)) break block13;
                    String[] splitOnDecimal = grade.split("\\" + decSeparator);
                    if (splitOnDecimal == null) {
                        gradeIsValid = true;
                    } else if (grade.matches("[0-9]{0,10}(\\" + decSeparator + "[0-9]{0,2})?")) {
                        gradeIsValid = true;
                    }
                }
                catch (NumberFormatException | ParseException nfe) {
                    log.debug("Passed grade is not a numeric value");
                }
            } else if (gradeEntryType == 3) {
                if (gradeMapping == null) {
                    throw new IllegalArgumentException("Null mapping passed to isGradeValid for a letter grade-based gradeook");
                }
                String standardizedGrade = gradeMapping.standardizeInputGrade(grade);
                if (standardizedGrade != null) {
                    gradeIsValid = true;
                }
            } else {
                throw new IllegalArgumentException("Invalid gradeEntryType passed to isGradeValid");
            }
        }
        return gradeIsValid;
    }

    public List<String> identifyStudentsWithInvalidGrades(String gradebookUid, Map<String, String> studentIdToGradeMap) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("null gradebookUid passed to identifyStudentsWithInvalidGrades");
        }
        ArrayList<String> studentsWithInvalidGrade = new ArrayList<String>();
        if (studentIdToGradeMap != null) {
            Gradebook gradebook;
            try {
                gradebook = this.getGradebook(gradebookUid);
            }
            catch (GradebookNotFoundException gnfe) {
                throw new GradebookNotFoundException("No gradebook exists with the given gradebookUid: " + gradebookUid + "Error: " + gnfe.getMessage());
            }
            LetterGradePercentMapping gradeMapping = null;
            if (gradebook.getGrade_type() == 3) {
                gradeMapping = this.getLetterGradePercentMapping(gradebook);
            }
            for (String studentId : studentIdToGradeMap.keySet()) {
                String grade = studentIdToGradeMap.get(studentId);
                if (this.isGradeValid(grade, gradebook.getGrade_type(), gradeMapping)) continue;
                studentsWithInvalidGrade.add(studentId);
            }
        }
        return studentsWithInvalidGrade;
    }

    public void saveGradeAndCommentForStudent(final String gradebookUid, final Long gradableObjectId, String studentUid, String grade, String comment) {
        if (gradebookUid == null || gradableObjectId == null || studentUid == null) {
            throw new IllegalArgumentException("Null gradebookUid or gradableObjectId or studentUid passed to saveGradeAndCommentForStudent");
        }
        GradeDefinition gradeDef = new GradeDefinition();
        gradeDef.setStudentUid(studentUid);
        gradeDef.setGrade(grade);
        gradeDef.setGradeComment(comment);
        ArrayList<GradeDefinition> gradeDefList = new ArrayList<GradeDefinition>();
        gradeDefList.add(gradeDef);
        GradebookAssignment assignment = (GradebookAssignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, gradableObjectId);
            }
        });
        AssignmentGradeRecord record = this.getAssignmentGradeRecord(assignment, studentUid);
        if (record != null) {
            gradeDef.setExcused(Boolean.valueOf(BooleanUtils.toBoolean((Boolean)record.isExcludedFromGrade())));
        } else {
            gradeDef.setExcused(Boolean.valueOf(false));
        }
        this.saveGradesAndComments(gradebookUid, gradableObjectId, gradeDefList);
    }

    public void saveGradeAndExcuseForStudent(String gradebookUid, Long gradableObjectId, String studentUid, String grade, boolean excuse) {
        if (gradebookUid == null || gradableObjectId == null || studentUid == null) {
            throw new IllegalArgumentException("Null gradebookUid, gradeableObjectId, or studentUid passed to saveGradeAndExcuseForStudent");
        }
        GradeDefinition gradeDef = new GradeDefinition();
        gradeDef.setStudentUid(studentUid);
        gradeDef.setGrade(grade);
        gradeDef.setExcused(Boolean.valueOf(excuse));
        CommentDefinition gradeComment = this.getAssignmentScoreComment(gradebookUid, gradableObjectId, studentUid);
        if (gradeComment != null) {
            gradeDef.setGradeComment(gradeComment.getCommentText());
        }
        ArrayList<GradeDefinition> gradeDefList = new ArrayList<GradeDefinition>();
        gradeDefList.add(gradeDef);
        this.saveGradesAndComments(gradebookUid, gradableObjectId, gradeDefList);
    }

    public void saveGradesAndComments(String gradebookUid, Long gradableObjectId, List<GradeDefinition> gradeDefList) {
        if (gradebookUid == null || gradableObjectId == null) {
            throw new IllegalArgumentException("Null gradebookUid or gradableObjectId passed to saveGradesAndComments");
        }
        if (CollectionUtils.isNotEmpty(gradeDefList)) {
            Gradebook gradebook;
            try {
                gradebook = this.getGradebook(gradebookUid);
            }
            catch (GradebookNotFoundException gnfe) {
                throw new GradebookNotFoundException("No gradebook exists with the given gradebookUid: " + gradebookUid + "Error: " + gnfe.getMessage());
            }
            GradebookAssignment assignment = this.getAssignmentWithoutStatsByID(gradebookUid, gradableObjectId);
            if (assignment == null) {
                throw new AssessmentNotFoundException("No gradebook item exists with gradable object id = " + gradableObjectId);
            }
            if (!this.currentUserHasGradingPerm(gradebookUid)) {
                log.warn("User attempted to save grades and comments without authorization");
                throw new GradebookSecurityException();
            }
            HashMap<String, GradeDefinition> studentIdGradeDefMap = new HashMap<String, GradeDefinition>();
            HashMap<String, String> studentIdToGradeMap = new HashMap<String, String>();
            for (GradeDefinition gradeDef : gradeDefList) {
                studentIdGradeDefMap.put(gradeDef.getStudentUid(), gradeDef);
                studentIdToGradeMap.put(gradeDef.getStudentUid(), gradeDef.getGrade());
            }
            List<String> invalidStudentUUIDs = this.identifyStudentsWithInvalidGrades(gradebookUid, studentIdToGradeMap);
            if (CollectionUtils.isNotEmpty(invalidStudentUUIDs)) {
                throw new InvalidGradeException("At least one grade passed to be updated is invalid. No grades or comments were updated.");
            }
            List existingGradeRecords = this.getAllAssignmentGradeRecordsForGbItem(gradableObjectId, studentIdGradeDefMap.keySet());
            HashMap<String, AssignmentGradeRecord> studentIdGradeRecordMap = new HashMap<String, AssignmentGradeRecord>();
            if (CollectionUtils.isNotEmpty((Collection)existingGradeRecords)) {
                for (AssignmentGradeRecord agr : existingGradeRecords) {
                    studentIdGradeRecordMap.put(agr.getStudentId(), agr);
                }
            }
            List<Comment> existingComments = this.getComments(assignment, studentIdGradeDefMap.keySet());
            HashMap<String, Comment> studentIdCommentMap = new HashMap<String, Comment>();
            if (CollectionUtils.isNotEmpty(existingComments)) {
                for (Comment comment : existingComments) {
                    studentIdCommentMap.put(comment.getStudentId(), comment);
                }
            }
            boolean userHasGradeAllPerm = this.currentUserHasGradeAllPerm(gradebookUid);
            String graderId = this.getAuthn().getUserUid();
            Date now = new Date();
            LetterGradePercentMapping mapping = null;
            if (gradebook.getGrade_type() == 3) {
                mapping = this.getLetterGradePercentMapping(gradebook);
            }
            ArrayList<Comment> commentsToUpdate = new ArrayList<Comment>();
            HashSet<GradingEvent> eventsToAdd = new HashSet<GradingEvent>();
            HashSet<AssignmentGradeRecord> gradeRecordsToUpdate = new HashSet<AssignmentGradeRecord>();
            for (GradeDefinition gradeDef : gradeDefList) {
                String studentId = gradeDef.getStudentUid();
                String graderUid = gradeDef.getGraderUid() != null ? gradeDef.getGraderUid() : graderId;
                Date gradedDate = gradeDef.getDateRecorded() != null ? gradeDef.getDateRecorded() : now;
                boolean excuse = gradeDef.isExcused();
                if (!userHasGradeAllPerm && !this.isUserAbleToGradeItemForStudent(gradebookUid, gradableObjectId, studentId)) {
                    log.warn("User {} attempted to save a grade for {} without authorization", (Object)graderId, (Object)studentId);
                    throw new GradebookSecurityException();
                }
                String newGrade = StringUtils.trimToEmpty((String)gradeDef.getGrade());
                Double convertedGrade = this.convertInputGradeToPoints(gradebook.getGrade_type(), mapping, assignment.getPointsPossible(), newGrade);
                AssignmentGradeRecord gradeRec = (AssignmentGradeRecord)studentIdGradeRecordMap.get(studentId);
                boolean currentExcuse = gradeRec == null ? false : BooleanUtils.toBoolean((Boolean)gradeRec.isExcludedFromGrade());
                if (gradeRec != null) {
                    Double pointsEarned = gradeRec.getPointsEarned();
                    if (convertedGrade == null && pointsEarned != null || convertedGrade != null && pointsEarned == null || convertedGrade != null && pointsEarned != null && !convertedGrade.equals(pointsEarned) || excuse != currentExcuse) {
                        gradeRec.setPointsEarned(convertedGrade);
                        gradeRec.setGraderId(graderUid);
                        gradeRec.setDateRecorded(gradedDate);
                        gradeRec.setExcludedFromGrade(Boolean.valueOf(excuse));
                        gradeRecordsToUpdate.add(gradeRec);
                        GradingEvent event = new GradingEvent((GradableObject)assignment, graderId, studentId, (Object)newGrade);
                        if (excuse != currentExcuse) {
                            event.setStatus(excuse ? GradingEventStatus.GRADE_EXCLUDED : GradingEventStatus.GRADE_INCLUDED);
                        }
                        eventsToAdd.add(event);
                    }
                } else if (StringUtils.isNotBlank((CharSequence)newGrade) && (StringUtils.isNotBlank((CharSequence)gradeDef.getGrade()) || excuse != currentExcuse)) {
                    gradeRec = new AssignmentGradeRecord(assignment, studentId, convertedGrade);
                    gradeRec.setGraderId(graderUid);
                    gradeRec.setDateRecorded(gradedDate);
                    gradeRecordsToUpdate.add(gradeRec);
                    gradeRec.setExcludedFromGrade(Boolean.valueOf(excuse));
                    GradingEvent event = new GradingEvent((GradableObject)assignment, graderId, studentId, (Object)newGrade);
                    if (excuse != currentExcuse) {
                        event.setStatus(excuse ? GradingEventStatus.GRADE_EXCLUDED : GradingEventStatus.GRADE_INCLUDED);
                    }
                    eventsToAdd.add(event);
                }
                Comment comment = (Comment)studentIdCommentMap.get(studentId);
                String newCommentText = StringUtils.trimToEmpty((String)gradeDef.getGradeComment());
                if (comment != null) {
                    String existingCommentText = StringUtils.trimToEmpty((String)comment.getCommentText());
                    boolean existingCommentTextIsEmpty = existingCommentText.isEmpty();
                    boolean newCommentTextIsEmpty = newCommentText.isEmpty();
                    if (!(existingCommentTextIsEmpty && !newCommentTextIsEmpty || !existingCommentTextIsEmpty && newCommentTextIsEmpty) && (existingCommentTextIsEmpty || newCommentTextIsEmpty || newCommentText.equals(existingCommentText))) continue;
                    comment.setCommentText(newCommentText);
                    comment.setGraderId(graderId);
                    comment.setDateRecorded(gradedDate);
                    commentsToUpdate.add(comment);
                    continue;
                }
                if (newCommentText.isEmpty()) continue;
                comment = new Comment(studentId, newCommentText, (GradableObject)assignment);
                comment.setGraderId(graderId);
                comment.setDateRecorded(gradedDate);
                commentsToUpdate.add(comment);
            }
            try {
                for (AssignmentGradeRecord assignmentGradeRecord : gradeRecordsToUpdate) {
                    this.getHibernateTemplate().saveOrUpdate((Object)assignmentGradeRecord);
                }
                for (Comment comment : commentsToUpdate) {
                    this.getHibernateTemplate().saveOrUpdate((Object)comment);
                }
                for (GradingEvent gradingEvent : eventsToAdd) {
                    this.getHibernateTemplate().saveOrUpdate((Object)gradingEvent);
                }
            }
            catch (StaleObjectStateException | HibernateOptimisticLockingFailureException holfe) {
                if (log.isInfoEnabled()) {
                    log.info("An optimistic locking failure occurred while attempting to save scores and comments for gb Item " + gradableObjectId);
                }
                throw new StaleObjectModificationException(holfe);
            }
        }
    }

    private GradebookAssignment getAssignmentWithoutStatsByID(final String gradebookUID, final Long gradeableObjectID) {
        return (GradebookAssignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUID, gradeableObjectID);
            }
        });
    }

    private Double convertInputGradeToPoints(int gradeEntryType, LetterGradePercentMapping mapping, Double gbItemPointsPossible, String grade) throws InvalidGradeException {
        Double convertedValue = null;
        if (grade != null && !"".equals(grade)) {
            if (gradeEntryType == 1) {
                try {
                    Double pointValue;
                    NumberFormat nbFormat = NumberFormat.getInstance(new ResourceLoader().getLocale());
                    convertedValue = pointValue = Double.valueOf(nbFormat.parse(grade).doubleValue());
                }
                catch (NumberFormatException | ParseException nfe) {
                    throw new InvalidGradeException("Invalid grade passed to convertInputGradeToPoints");
                }
            }
            if (gradeEntryType == 2 || gradeEntryType == 3) {
                if (gbItemPointsPossible == null) {
                    throw new IllegalArgumentException("Null points possible passed to convertInputGradeToPoints for letter or % based grading");
                }
                Double percentage = null;
                if (gradeEntryType == 3) {
                    String standardizedGrade;
                    if (mapping == null) {
                        throw new IllegalArgumentException("No mapping passed to convertInputGradeToPoints for a letter-based gb");
                    }
                    if (mapping.getGradeMap() != null && (percentage = mapping.getValue(standardizedGrade = mapping.standardizeInputGrade(grade))) == null) {
                        throw new IllegalArgumentException("Invalid grade passed to convertInputGradeToPoints");
                    }
                } else {
                    try {
                        NumberFormat nbFormat = NumberFormat.getInstance(new ResourceLoader().getLocale());
                        percentage = nbFormat.parse(grade).doubleValue();
                    }
                    catch (NumberFormatException | ParseException nfe) {
                        throw new IllegalArgumentException("Invalid % grade passed to convertInputGradeToPoints");
                    }
                }
                convertedValue = this.calculateEquivalentPointValueForPercent(gbItemPointsPossible, percentage);
            } else {
                throw new InvalidGradeException("invalid grade entry type passed to convertInputGradeToPoints");
            }
        }
        return convertedValue;
    }

    public int getGradeEntryType(String gradebookUid) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("null gradebookUid passed to getGradeEntryType");
        }
        try {
            Gradebook gradebook = this.getGradebook(gradebookUid);
            return gradebook.getGrade_type();
        }
        catch (GradebookNotFoundException gnfe) {
            throw new GradebookNotFoundException("No gradebook exists with the given gradebookUid: " + gradebookUid);
        }
    }

    public Map getEnteredCourseGrade(final String gradebookUid) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Gradebook thisGradebook = GradebookServiceHibernateImpl.this.getGradebook(gradebookUid);
                Long gradebookId = thisGradebook.getId();
                org.sakaiproject.tool.gradebook.CourseGrade courseGrade = GradebookServiceHibernateImpl.this.getCourseGrade(gradebookId);
                Map viewableEnrollmentsMap = GradebookServiceHibernateImpl.this.authz.findMatchingEnrollmentsForViewableCourseGrade(gradebookUid, thisGradebook.getCategory_type(), null, null);
                HashMap<String, EnrollmentRecord> enrollmentMap = new HashMap<String, EnrollmentRecord>();
                HashMap<String, EnrollmentRecord> enrollmentMapUid = new HashMap<String, EnrollmentRecord>();
                for (EnrollmentRecord enr : viewableEnrollmentsMap.keySet()) {
                    enrollmentMap.put(enr.getUser().getUserUid(), enr);
                    enrollmentMapUid.put(enr.getUser().getUserUid(), enr);
                }
                Query q = session.createQuery("from CourseGradeRecord as cgr where cgr.gradableObject.id=:gradableObjectId");
                q.setLong("gradableObjectId", courseGrade.getId().longValue());
                List records = GradebookServiceHibernateImpl.this.filterAndPopulateCourseGradeRecordsByStudents(courseGrade, q.list(), enrollmentMap.keySet());
                HashMap<String, String> returnMap = new HashMap<String, String>();
                for (int i = 0; i < records.size(); ++i) {
                    EnrollmentRecord enr;
                    CourseGradeRecord cgr = (CourseGradeRecord)records.get(i);
                    if (cgr.getEnteredGrade() == null || cgr.getEnteredGrade().equalsIgnoreCase("") || (enr = (EnrollmentRecord)enrollmentMapUid.get(cgr.getStudentId())) == null) continue;
                    returnMap.put(enr.getUser().getDisplayId(), cgr.getEnteredGrade());
                }
                return returnMap;
            }
        };
        return (Map)this.getHibernateTemplate().execute(hc);
    }

    public String getAssignmentScoreString(final String gradebookUid, final Long assignmentId, final String studentUid) throws GradebookNotFoundException, AssessmentNotFoundException {
        final boolean studentRequestingOwnScore = this.authn.getUserUid().equals(studentUid);
        if (gradebookUid == null || assignmentId == null || studentUid == null) {
            throw new IllegalArgumentException("null parameter passed to getAssignment. Values are gradebookUid:" + gradebookUid + " assignmentId:" + assignmentId + " studentUid:" + studentUid);
        }
        Double assignmentScore = (Double)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                GradebookAssignment assignment = GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentId);
                if (assignment == null) {
                    throw new AssessmentNotFoundException("There is no assignment with id " + assignmentId + " in gradebook " + gradebookUid);
                }
                if (!studentRequestingOwnScore && !GradebookServiceHibernateImpl.this.isUserAbleToViewItemForStudent(gradebookUid, assignmentId, studentUid)) {
                    log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to retrieve grade for student {} for assignment {}", new Object[]{GradebookServiceHibernateImpl.this.getUserUid(), gradebookUid, studentUid, assignment.getName()});
                    throw new GradebookSecurityException();
                }
                if (studentRequestingOwnScore && !assignment.isReleased().booleanValue()) {
                    log.error("AUTHORIZATION FAILURE: Student {} in gradebook {} attempted to retrieve score for unreleased assignment {}", new Object[]{GradebookServiceHibernateImpl.this.getUserUid(), gradebookUid, assignment.getName()});
                    throw new GradebookSecurityException();
                }
                AssignmentGradeRecord gradeRecord = GradebookServiceHibernateImpl.this.getAssignmentGradeRecord(assignment, studentUid);
                if (log.isDebugEnabled()) {
                    log.debug("gradeRecord=" + gradeRecord);
                }
                if (gradeRecord == null) {
                    return null;
                }
                return gradeRecord.getPointsEarned();
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("returning " + assignmentScore);
        }
        if (assignmentScore == null) {
            return null;
        }
        NumberFormat numberFormat = NumberFormat.getInstance(new ResourceLoader().getLocale());
        DecimalFormat df = (DecimalFormat)numberFormat;
        df.setGroupingUsed(false);
        return df.format(assignmentScore);
    }

    public String getAssignmentScoreString(final String gradebookUid, final String assignmentName, String studentUid) throws GradebookNotFoundException, AssessmentNotFoundException {
        if (gradebookUid == null || assignmentName == null || studentUid == null) {
            throw new IllegalArgumentException("null parameter passed to getAssignment. Values are gradebookUid:" + gradebookUid + " assignmentName:" + assignmentName + " studentUid:" + studentUid);
        }
        GradebookAssignment assignment = (GradebookAssignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName);
            }
        });
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assignment with name " + assignmentName + " in gradebook " + gradebookUid);
        }
        return this.getAssignmentScoreString(gradebookUid, assignment.getId(), studentUid);
    }

    public String getAssignmentScoreStringByNameOrId(String gradebookUid, String assignmentName, String studentUid) throws GradebookNotFoundException, AssessmentNotFoundException {
        String score = null;
        try {
            score = this.getAssignmentScoreString(gradebookUid, assignmentName, studentUid);
        }
        catch (AssessmentNotFoundException e) {
            log.debug("Assessment not found by name", (Throwable)e);
        }
        catch (GradebookSecurityException gse) {
            log.warn("User {} does not have permission to retrieve score for assignment {}", new Object[]{studentUid, assignmentName, gse});
            return null;
        }
        if (score == null && NumberUtils.isCreatable((String)assignmentName)) {
            Long assignmentId = NumberUtils.toLong((String)assignmentName, (long)-1L);
            try {
                score = this.getAssignmentScoreString(gradebookUid, assignmentId, studentUid);
            }
            catch (AssessmentNotFoundException anfe) {
                log.debug("Assessment could not be found for gradebook id {} and assignment id {} and student id {}", new Object[]{gradebookUid, assignmentName, studentUid});
            }
        }
        return score;
    }

    public void setAssignmentScoreString(final String gradebookUid, final Long assignmentId, final String studentUid, final String score, final String clientServiceDescription) throws GradebookNotFoundException, AssessmentNotFoundException {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                GradebookAssignment assignment = GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentId);
                if (assignment == null) {
                    throw new AssessmentNotFoundException("There is no assignment with id " + assignmentId + " in gradebook " + gradebookUid);
                }
                if (assignment.isExternallyMaintained()) {
                    log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to grade externally maintained assignment {} from {}", new Object[]{GradebookServiceHibernateImpl.this.getUserUid(), gradebookUid, assignmentId, clientServiceDescription});
                    throw new GradebookSecurityException();
                }
                if (!GradebookServiceHibernateImpl.this.isUserAbleToGradeItemForStudent(gradebookUid, assignment.getId(), studentUid)) {
                    log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to grade student {} from {} for item {}", new Object[]{GradebookServiceHibernateImpl.this.getUserUid(), gradebookUid, studentUid, clientServiceDescription, assignmentId});
                    throw new GradebookSecurityException();
                }
                Date now = new Date();
                String graderId = GradebookServiceHibernateImpl.this.getAuthn().getUserUid();
                AssignmentGradeRecord gradeRecord = GradebookServiceHibernateImpl.this.getAssignmentGradeRecord(assignment, studentUid);
                if (gradeRecord == null) {
                    gradeRecord = new AssignmentGradeRecord(assignment, studentUid, GradebookServiceHibernateImpl.this.convertStringToDouble(score));
                } else {
                    gradeRecord.setPointsEarned(GradebookServiceHibernateImpl.this.convertStringToDouble(score));
                }
                gradeRecord.setGraderId(graderId);
                gradeRecord.setDateRecorded(now);
                session.saveOrUpdate((Object)gradeRecord);
                session.save((Object)new GradingEvent((GradableObject)assignment, graderId, studentUid, (Object)score));
                session.flush();
                session.clear();
                GradebookServiceHibernateImpl.this.postUpdateGradeEvent(gradebookUid, assignment.getName(), studentUid, GradebookServiceHibernateImpl.this.convertStringToDouble(score));
                return null;
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Score updated in gradebookUid=" + gradebookUid + ", assignmentId=" + assignmentId + " by userUid=" + this.getUserUid() + " from client=" + clientServiceDescription + ", new score=" + score);
        }
    }

    public void setAssignmentScoreString(final String gradebookUid, final String assignmentName, String studentUid, String score, String clientServiceDescription) throws GradebookNotFoundException, AssessmentNotFoundException {
        GradebookAssignment assignment = (GradebookAssignment)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getAssignmentWithoutStats(gradebookUid, assignmentName);
            }
        });
        if (assignment == null) {
            throw new AssessmentNotFoundException("There is no assignment with name " + assignmentName + " in gradebook " + gradebookUid);
        }
        this.setAssignmentScoreString(gradebookUid, assignment.getId(), studentUid, score, clientServiceDescription);
    }

    public void finalizeGrades(String gradebookUid) throws GradebookNotFoundException {
        if (!this.getAuthz().isUserAbleToGradeAll(gradebookUid)) {
            log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to finalize grades", (Object)this.getUserUid(), (Object)gradebookUid);
            throw new GradebookSecurityException();
        }
        this.finalizeNullGradeRecords(this.getGradebook(gradebookUid));
    }

    public String getLowestPossibleGradeForGbItem(String gradebookUid, Long gradebookItemId) {
        if (gradebookUid == null || gradebookItemId == null) {
            throw new IllegalArgumentException("Null gradebookUid and/or gradebookItemId passed to getLowestPossibleGradeForGbItem. gradebookUid:" + gradebookUid + " gradebookItemId:" + gradebookItemId);
        }
        GradebookAssignment gbItem = this.getAssignmentWithoutStatsByID(gradebookUid, gradebookItemId);
        if (gbItem == null) {
            throw new AssessmentNotFoundException("No gradebook item found with id " + gradebookItemId);
        }
        Gradebook gradebook = gbItem.getGradebook();
        if (!this.isUserAbleToViewAssignments(gradebookUid) && !this.currentUserHasViewOwnGradesPerm(gradebookUid)) {
            throw new GradebookSecurityException();
        }
        String lowestPossibleGrade = null;
        if (gbItem.getUngraded()) {
            lowestPossibleGrade = null;
        } else if (gradebook.getGrade_type() == 2 || gradebook.getGrade_type() == 1) {
            lowestPossibleGrade = "0";
        } else if (gbItem.getGradebook().getGrade_type() == 3) {
            LetterGradePercentMapping mapping = this.getLetterGradePercentMapping(gradebook);
            lowestPossibleGrade = mapping.getGrade(Double.valueOf(0.0));
        }
        return lowestPossibleGrade;
    }

    public List<CategoryDefinition> getCategoryDefinitions(String gradebookUid) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("Null gradebookUid passed to getCategoryDefinitions");
        }
        if (!this.isUserAbleToViewAssignments(gradebookUid)) {
            log.warn("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to retrieve all categories without permission", (Object)this.getUserUid(), (Object)gradebookUid);
            throw new GradebookSecurityException();
        }
        ArrayList<CategoryDefinition> categoryDefList = new ArrayList<CategoryDefinition>();
        List gbCategories = this.getCategories(this.getGradebook(gradebookUid).getId());
        if (gbCategories != null) {
            for (Category category : gbCategories) {
                categoryDefList.add(this.getCategoryDefinition(category));
            }
        }
        return categoryDefList;
    }

    private CategoryDefinition getCategoryDefinition(Category category) {
        CategoryDefinition categoryDef = new CategoryDefinition();
        if (category != null) {
            categoryDef.setId(category.getId());
            categoryDef.setName(category.getName());
            categoryDef.setWeight(category.getWeight());
            categoryDef.setDropLowest(category.getDropLowest());
            categoryDef.setDropHighest(category.getDropHighest());
            categoryDef.setKeepHighest(category.getKeepHighest());
            categoryDef.setAssignmentList(this.getAssignments(category.getGradebook().getUid(), category.getName()));
            categoryDef.setDropKeepEnabled(Boolean.valueOf(category.isDropScores()));
            categoryDef.setExtraCredit(category.isExtraCredit());
            categoryDef.setEqualWeight(category.isEqualWeightAssignments());
            categoryDef.setCategoryOrder(category.getCategoryOrder());
        }
        return categoryDef;
    }

    protected Map<String, List<AssignmentGradeRecord>> getGradeRecordMapForStudents(Long gradebookId, Collection<String> studentUids) {
        List allGradeRecs;
        HashMap<String, List<AssignmentGradeRecord>> filteredGradeRecs = new HashMap<String, List<AssignmentGradeRecord>>();
        if (studentUids != null && (allGradeRecs = (List)this.getHibernateTemplate().execute(session -> session.createCriteria(AssignmentGradeRecord.class).createAlias("gradableObject", "go").createAlias("gradableObject.gradebook", "gb").add((Criterion)Restrictions.eq((String)"gb.id", (Object)gradebookId)).add((Criterion)Restrictions.eq((String)"go.removed", (Object)false)).add(HibernateCriterionUtils.CriterionInRestrictionSplitter((String)"studentId", (Collection)studentUids)).list())) != null) {
            for (AssignmentGradeRecord gradeRec : allGradeRecs) {
                if (!studentUids.contains(gradeRec.getStudentId())) continue;
                String studentId = gradeRec.getStudentId();
                ArrayList<AssignmentGradeRecord> gradeRecList = (ArrayList<AssignmentGradeRecord>)filteredGradeRecs.get(studentId);
                if (gradeRecList == null) {
                    gradeRecList = new ArrayList<AssignmentGradeRecord>();
                    gradeRecList.add(gradeRec);
                    filteredGradeRecs.put(studentId, gradeRecList);
                    continue;
                }
                gradeRecList.add(gradeRec);
                filteredGradeRecs.put(studentId, gradeRecList);
            }
        }
        return filteredGradeRecs;
    }

    protected List<GradebookAssignment> getCountedAssignments(Session session, Long gradebookId) {
        ArrayList<GradebookAssignment> assignList = new ArrayList<GradebookAssignment>();
        List results = session.createQuery("from GradebookAssignment as asn where asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false").setParameter("gbid", (Object)gradebookId).list();
        if (results != null) {
            for (GradebookAssignment a : results) {
                if (a.getPointsPossible() == null || !(a.getPointsPossible() > 0.0)) continue;
                assignList.add(a);
            }
        }
        return assignList;
    }

    public void applyDropScores(Collection<AssignmentGradeRecord> gradeRecords) {
        if (gradeRecords == null || gradeRecords.size() < 1) {
            return;
        }
        long start = System.currentTimeMillis();
        ArrayList<String> studentIds = new ArrayList<String>();
        ArrayList<Category> categories = new ArrayList<Category>();
        HashMap<String, ArrayList<AssignmentGradeRecord>> gradeRecordMap = new HashMap<String, ArrayList<AssignmentGradeRecord>>();
        for (AssignmentGradeRecord gradeRecord : gradeRecords) {
            ArrayList<AssignmentGradeRecord> gradeRecordsByCatAndStudent;
            Category cat;
            if (gradeRecord == null || gradeRecord.getPointsEarned() == null) continue;
            gradeRecord.setDroppedFromGrade(Boolean.valueOf(false));
            GradebookAssignment assignment = gradeRecord.getAssignment();
            if (assignment.getUngraded() || assignment.isNotCounted() || assignment.getItemType().equals(GradebookAssignment.item_type_adjustment) || assignment.isRemoved()) continue;
            String studentId = gradeRecord.getStudentId();
            if (!studentIds.contains(studentId)) {
                studentIds.add(studentId);
            }
            if ((cat = gradeRecord.getAssignment().getCategory()) == null) continue;
            if (!categories.contains(cat)) {
                categories.add(cat);
            }
            if ((gradeRecordsByCatAndStudent = (ArrayList<AssignmentGradeRecord>)gradeRecordMap.get(studentId + cat.getId())) == null) {
                gradeRecordsByCatAndStudent = new ArrayList<AssignmentGradeRecord>();
                gradeRecordsByCatAndStudent.add(gradeRecord);
                gradeRecordMap.put(studentId + cat.getId(), gradeRecordsByCatAndStudent);
                continue;
            }
            gradeRecordsByCatAndStudent.add(gradeRecord);
        }
        if (categories.size() < 1) {
            return;
        }
        for (Category cat : categories) {
            Integer dropHighest = cat.getDropHighest();
            Integer dropLowest = cat.getDropLowest();
            Integer keepHighest = cat.getKeepHighest();
            Long catId = cat.getId();
            if (!(dropHighest != null && dropHighest > 0 || dropLowest != null && dropLowest > 0) && (keepHighest == null || keepHighest <= 0)) continue;
            for (String studentId : studentIds) {
                ArrayList<AssignmentGradeRecord> gradesByCategory = new ArrayList<AssignmentGradeRecord>();
                List gradeRecordsByCatAndStudent = (List)gradeRecordMap.get(studentId + cat.getId());
                if (gradeRecordsByCatAndStudent == null) continue;
                for (AssignmentGradeRecord agr : gradeRecordsByCatAndStudent) {
                    if (BooleanUtils.toBoolean((Boolean)agr.isExcludedFromGrade())) continue;
                    gradesByCategory.add(agr);
                }
                int numGrades = gradesByCategory.size();
                if (dropHighest > 0 && numGrades > dropHighest + dropLowest) {
                    for (int i = 0; i < dropHighest; ++i) {
                        AssignmentGradeRecord highest = (AssignmentGradeRecord)Collections.max(gradesByCategory, AssignmentGradeRecord.numericComparator);
                        highest.setDroppedFromGrade(Boolean.valueOf(true));
                        gradesByCategory.remove(highest);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("dropHighest applied to " + highest);
                    }
                }
                if (keepHighest > 0 && numGrades > gradesByCategory.size() - keepHighest) {
                    dropLowest = gradesByCategory.size() - keepHighest;
                }
                if (dropLowest <= 0 || numGrades <= dropLowest + dropHighest) continue;
                for (int i = 0; i < dropLowest; ++i) {
                    AssignmentGradeRecord lowest = (AssignmentGradeRecord)Collections.min(gradesByCategory, AssignmentGradeRecord.numericComparator);
                    lowest.setDroppedFromGrade(Boolean.valueOf(true));
                    gradesByCategory.remove(lowest);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("dropLowest applied to " + lowest);
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("processed " + studentIds.size() + "students in category " + cat.getId());
        }
        if (log.isDebugEnabled()) {
            log.debug("GradebookManager.applyDropScores took " + (System.currentTimeMillis() - start) + " millis to execute");
        }
    }

    public GradebookService.PointsPossibleValidation isPointsPossibleValid(String gradebookUid, Assignment gradebookItem, Double pointsPossible) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("Null gradebookUid passed to isPointsPossibleValid");
        }
        if (gradebookItem == null) {
            throw new IllegalArgumentException("Null gradebookItem passed to isPointsPossibleValid");
        }
        if (pointsPossible == null) {
            return GradebookService.PointsPossibleValidation.INVALID_NULL_VALUE;
        }
        if (pointsPossible <= 0.0) {
            return GradebookService.PointsPossibleValidation.INVALID_NUMERIC_VALUE;
        }
        BigDecimal bd = new BigDecimal(pointsPossible);
        bd = bd.setScale(2, 4);
        double roundedVal = bd.doubleValue();
        double diff = pointsPossible - roundedVal;
        if (diff != 0.0) {
            return GradebookService.PointsPossibleValidation.INVALID_DECIMAL;
        }
        return GradebookService.PointsPossibleValidation.VALID;
    }

    private Double convertStringToDouble(String doubleAsString) {
        Double scoreAsDouble = null;
        if (doubleAsString != null && !"".equals(doubleAsString)) {
            try {
                NumberFormat numberFormat = NumberFormat.getInstance(new ResourceLoader().getLocale());
                Number numericScore = numberFormat.parse(doubleAsString.trim());
                scoreAsDouble = numericScore.doubleValue();
            }
            catch (ParseException e) {
                log.error(e.getMessage());
            }
        }
        return scoreAsDouble;
    }

    private List<Assignment> getAssignments(String gradebookUid, String categoryName) {
        List<Assignment> allAssignments = this.getAssignments(gradebookUid);
        ArrayList<Assignment> matchingAssignments = new ArrayList<Assignment>();
        for (Assignment assignment : allAssignments) {
            if (!StringUtils.equals((CharSequence)assignment.getCategoryName(), (CharSequence)categoryName)) continue;
            matchingAssignments.add(assignment);
        }
        return matchingAssignments;
    }

    private void postUpdateGradeEvent(String gradebookUid, String assignmentName, String studentUid, Double pointsEarned) {
        this.postEvent("gradebook.updateItemScore", "/gradebook/" + gradebookUid + "/" + assignmentName + "/" + studentUid + "/" + pointsEarned + "/student");
    }

    public String getAverageCourseGrade(String gradebookUid) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("Null gradebookUid passed to getAverageCourseGrade");
        }
        if (!this.currentUserHasGradeAllPerm(gradebookUid)) {
            StringBuilder sb = new StringBuilder().append("User ").append(this.authn.getUserUid()).append(" attempted to access the average course grade without permission in gb ").append(gradebookUid).append(" using gradebookService.getAverageCourseGrade");
            throw new GradebookSecurityException(sb.toString());
        }
        String courseGradeLetter = null;
        Gradebook gradebook = this.getGradebook(gradebookUid);
        if (gradebook != null) {
            org.sakaiproject.tool.gradebook.CourseGrade courseGrade = this.getCourseGrade(gradebook.getId());
            Set<String> studentUids = this.getAllStudentUids(gradebookUid);
            List courseGradeRecs = this.getPointsEarnedCourseGradeRecords(courseGrade, studentUids);
            if (courseGrade != null) {
                courseGrade.calculateStatistics((Collection)courseGradeRecs, studentUids.size());
                if (courseGrade.getMean() != null) {
                    courseGradeLetter = gradebook.getSelectedGradeMapping().getMappedGrade(courseGrade.getMean());
                }
            }
        }
        return courseGradeLetter;
    }

    public void updateAssignmentOrder(String gradebookUid, Long assignmentId, Integer order) {
        if (!this.getAuthz().isUserAbleToEditAssessments(gradebookUid)) {
            log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to change the order of assignment {}", new Object[]{this.getUserUid(), gradebookUid, assignmentId});
            throw new GradebookSecurityException();
        }
        if (order == null) {
            throw new IllegalArgumentException("Order cannot be null");
        }
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        List assignments = this.getAssignments(gradebookId, SortType.SORT_BY_SORTING, true);
        if (order < 0) {
            order = 0;
        } else if (order > assignments.size()) {
            order = assignments.size();
        }
        GradebookAssignment target = null;
        for (GradebookAssignment a : assignments) {
            if (!a.getId().equals(assignmentId)) continue;
            target = a;
            break;
        }
        assignments.add(null);
        assignments.remove(target);
        assignments.add(order, target);
        ArrayList<GradebookAssignment> assignmentsToUpdate = new ArrayList<GradebookAssignment>();
        int i = 0;
        for (GradebookAssignment a : assignments) {
            if (a == null) continue;
            if (a.getSortOrder() == null || !a.getSortOrder().equals(i)) {
                a.setSortOrder(Integer.valueOf(i));
                assignmentsToUpdate.add(a);
            }
            ++i;
        }
        for (final GradebookAssignment assignmentToUpdate : assignmentsToUpdate) {
            this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    GradebookServiceHibernateImpl.this.updateAssignment(assignmentToUpdate);
                    return null;
                }
            });
        }
    }

    public List<GradingEvent> getGradingEvents(String studentId, long assignmentId) {
        if (log.isDebugEnabled()) {
            log.debug("getGradingEvents called for studentId:" + studentId);
        }
        List<Object> rval = new ArrayList<GradingEvent>();
        if (studentId == null) {
            log.debug("No student id was specified.  Returning an empty GradingEvents object");
            return rval;
        }
        HibernateCallback hc = session -> {
            Query q = session.createQuery("from GradingEvent as ge where ge.studentId=:studentId and ge.gradableObject.id=:assignmentId order by date_graded desc");
            q.setParameter("studentId", (Object)studentId);
            q.setParameter("assignmentId", (Object)assignmentId);
            return q.list();
        };
        rval = (List)this.getHibernateTemplate().execute(hc);
        return rval;
    }

    public Optional<CategoryScoreData> calculateCategoryScore(Object gradebook, String studentUuid, CategoryDefinition category, List<Assignment> categoryAssignments, Map<Long, String> gradeMap, boolean includeNonReleasedItems) {
        Gradebook gb = (Gradebook)gradebook;
        Map gradingSchema = gb.getSelectedGradeMapping().getGradeMap();
        ArrayList<AssignmentGradeRecord> gradeRecords = new ArrayList<AssignmentGradeRecord>();
        for (Assignment assignment : categoryAssignments) {
            Long assignmentId = assignment.getId();
            String rawGrade = gradeMap.get(assignmentId);
            Double pointsPossible = assignment.getPoints();
            Double grade = gb.getGrade_type() == 2 ? this.calculateEquivalentPointValueForPercent(pointsPossible, NumberUtils.createDouble((String)rawGrade)) : (gb.getGrade_type() == 3 ? (Double)gradingSchema.get(rawGrade) : NumberUtils.createDouble((String)rawGrade));
            Category c = new Category();
            c.setId(category.getId());
            c.setDropHighest(category.getDropHighest());
            c.setDropLowest(category.getDropLowest());
            c.setKeepHighest(category.getKeepHighest());
            c.setEqualWeightAssignments(category.getEqualWeight());
            GradebookAssignment a = new GradebookAssignment();
            a.setPointsPossible(assignment.getPoints());
            a.setUngraded(Boolean.valueOf(assignment.isUngraded()));
            a.setCounted(assignment.isCounted());
            a.setExtraCredit(Boolean.valueOf(assignment.isExtraCredit()));
            a.setReleased(Boolean.valueOf(assignment.isReleased()));
            a.setRemoved(false);
            a.setGradebook(gb);
            a.setCategory(c);
            a.setId(assignment.getId());
            AssignmentGradeRecord gradeRecord = new AssignmentGradeRecord(a, studentUuid, grade);
            if (a.isNotCounted()) continue;
            gradeRecords.add(gradeRecord);
        }
        return this.calculateCategoryScore(studentUuid, category.getId(), gradeRecords, includeNonReleasedItems);
    }

    public Optional<CategoryScoreData> calculateCategoryScore(final Long gradebookId, final String studentUuid, Long categoryId, boolean includeNonReleasedItems) {
        Map gradeRecMap = (Map)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getGradeRecordMapForStudents(gradebookId, Collections.singletonList(studentUuid));
            }
        });
        List gradeRecords = (List)gradeRecMap.get(studentUuid);
        return this.calculateCategoryScore(studentUuid, categoryId, gradeRecords, includeNonReleasedItems);
    }

    private Optional<CategoryScoreData> calculateCategoryScore(String studentUuid, Long categoryId, List<AssignmentGradeRecord> gradeRecords, boolean includeNonReleasedItems) {
        if (gradeRecords == null) {
            log.debug("No grade records for student: {}. Nothing to do.", (Object)studentUuid);
            return Optional.empty();
        }
        if (categoryId == null) {
            log.debug("No category supplied, nothing to do.");
            return Optional.empty();
        }
        int numScored = 0;
        int numOfAssignments = 0;
        BigDecimal totalEarned = new BigDecimal("0");
        BigDecimal totalEarnedMean = new BigDecimal("0");
        BigDecimal totalPossible = new BigDecimal("0");
        Category category = this.getCategory(categoryId);
        this.applyDropScores(gradeRecords);
        List droppedItemIds = gradeRecords.stream().filter(AssignmentGradeRecord::getDroppedFromGrade).map(agr -> agr.getAssignment().getId()).collect(Collectors.toList());
        log.debug("categoryId: {}", (Object)categoryId);
        gradeRecords.removeIf(gradeRecord -> {
            GradebookAssignment assignment = gradeRecord.getAssignment();
            if (assignment.getCategory() == null) {
                return true;
            }
            if (categoryId.longValue() != assignment.getCategory().getId().longValue()) {
                return true;
            }
            boolean excluded = BooleanUtils.toBoolean((Boolean)gradeRecord.isExcludedFromGrade());
            return excluded || assignment.getPointsPossible() == null || gradeRecord.getPointsEarned() == null || !assignment.isCounted() || assignment.isReleased() == false && !includeNonReleasedItems || gradeRecord.getDroppedFromGrade() != false;
        });
        log.debug("gradeRecords.size(): {}", (Object)gradeRecords.size());
        if (gradeRecords.size() == 1 && gradeRecords.get(0).getAssignment().isExtraCredit().booleanValue()) {
            return Optional.empty();
        }
        for (AssignmentGradeRecord gradeRecord2 : gradeRecords) {
            GradebookAssignment assignment = gradeRecord2.getAssignment();
            BigDecimal possiblePoints = new BigDecimal(assignment.getPointsPossible().toString());
            if (!assignment.isExtraCredit().booleanValue()) {
                totalPossible = totalPossible.add(possiblePoints);
                ++numOfAssignments;
                ++numScored;
            }
            String gradeString = gradeRecord2.getPointsEarned() != null ? String.valueOf(gradeRecord2.getPointsEarned()) : "0";
            BigDecimal grade = new BigDecimal(gradeString);
            totalEarned = totalEarned.add(grade);
            totalEarnedMean = totalEarnedMean.add(grade.divide(possiblePoints, GradebookService.MATH_CONTEXT));
        }
        if (numScored == 0 || numOfAssignments == 0 || totalPossible.doubleValue() == 0.0) {
            return Optional.empty();
        }
        BigDecimal mean = totalEarned.divide(new BigDecimal(numScored), GradebookService.MATH_CONTEXT).divide(totalPossible.divide(new BigDecimal(numOfAssignments), GradebookService.MATH_CONTEXT), GradebookService.MATH_CONTEXT).multiply(new BigDecimal("100"));
        if (category.isEqualWeightAssignments().booleanValue()) {
            mean = totalEarnedMean.divide(new BigDecimal(numScored), GradebookService.MATH_CONTEXT).multiply(new BigDecimal("100"));
        }
        return Optional.of(new CategoryScoreData(mean.doubleValue(), droppedItemIds));
    }

    public CourseGrade getCourseGradeForStudent(String gradebookUid, String userUuid) {
        return this.getCourseGradeForStudents(gradebookUid, Collections.singletonList(userUuid)).get(userUuid);
    }

    public Map<String, CourseGrade> getCourseGradeForStudents(String gradebookUid, List<String> userUuids) {
        HashMap<String, CourseGrade> rval = new HashMap<String, CourseGrade>();
        try {
            Gradebook gradebook = this.getGradebook(gradebookUid);
            GradeMapping gradeMap = gradebook.getSelectedGradeMapping();
            rval.putAll(this.getCourseGradeForStudents(gradebookUid, userUuids, gradeMap.getGradeMap()));
        }
        catch (Exception e) {
            log.error("Error in getCourseGradeForStudents", (Throwable)e);
        }
        return rval;
    }

    public Map<String, CourseGrade> getCourseGradeForStudents(String gradebookUid, List<String> userUuids, Map<String, Double> gradeMap) {
        HashMap<String, CourseGrade> rval = new HashMap<String, CourseGrade>();
        try {
            Gradebook gradebook = this.getGradebook(gradebookUid);
            if (!(gradebook.isCourseGradeDisplayed() || this.currentUserHasEditPerm(gradebookUid) || this.currentUserHasGradingPerm(gradebookUid))) {
                return rval;
            }
            List<GradebookAssignment> assignments = this.getAssignmentsCounted(gradebook.getId());
            List gradeRecords = this.getPointsEarnedCourseGradeRecords(this.getCourseGrade(gradebook.getId()), userUuids);
            Map sortedGradeMap = GradeMappingDefinition.sortGradeMapping(gradeMap);
            gradeRecords.forEach(gr -> {
                CourseGrade cg = new CourseGrade();
                cg.setId(gr.getCourseGrade().getId());
                cg.setEnteredGrade(gr.getEnteredGrade());
                cg.setDateRecorded(gr.getDateRecorded());
                if (!assignments.isEmpty()) {
                    Double autoCalculatedGrade;
                    Double calculatedGrade;
                    Double d = calculatedGrade = gr.getPointsEarned() != null ? gr.getPointsEarned() : gr.getAutoCalculatedGrade();
                    if (calculatedGrade != null) {
                        cg.setCalculatedGrade(calculatedGrade.toString());
                    }
                    if ((autoCalculatedGrade = gr.getAutoCalculatedGrade()) != null) {
                        cg.setAutoCalculatedGrade(autoCalculatedGrade.toString());
                        BigDecimal bd = new BigDecimal(autoCalculatedGrade).setScale(10, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                        autoCalculatedGrade = bd.doubleValue();
                    }
                    String mappedGrade = GradeMapping.getMappedGrade((Map)sortedGradeMap, (Double)autoCalculatedGrade);
                    log.debug("calculatedGrade: {} -> mappedGrade: {}", (Object)autoCalculatedGrade, (Object)mappedGrade);
                    cg.setMappedGrade(mappedGrade);
                    cg.setPointsEarned(Double.valueOf(gr.getPointsEarned() != null ? gr.getPointsEarned() * gr.getTotalPointsPossible() / 100.0 : gr.getCalculatedPointsEarned()));
                    cg.setTotalPointsPossible(gr.getTotalPointsPossible());
                }
                rval.put(gr.getStudentId(), cg);
            });
        }
        catch (Exception e) {
            log.error("Error in getCourseGradeForStudents", (Throwable)e);
        }
        return rval;
    }

    public List<CourseSection> getViewableSections(String gradebookUid) {
        return this.getAuthz().getViewableSections(gradebookUid);
    }

    public void updateGradebookSettings(String gradebookUid, GradebookInformation gbInfo) {
        if (gradebookUid == null) {
            throw new IllegalArgumentException("null gradebookUid " + gradebookUid);
        }
        if (!this.currentUserHasEditPerm(gradebookUid)) {
            log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to edit gb information", (Object)this.getUserUid(), (Object)gradebookUid);
            throw new GradebookSecurityException("You do not have permission to edit gradebook information in site " + gradebookUid);
        }
        Gradebook gradebook = this.getGradebook(gradebookUid);
        if (gradebook == null) {
            throw new IllegalArgumentException("There is no gradebook associated with this id: " + gradebookUid);
        }
        Map bottomPercents = gbInfo.getSelectedGradingScaleBottomPercents();
        List courseGradeOverrides = (List)this.getHibernateTemplate().execute(session -> this.getCourseGradeOverrides(gradebook));
        courseGradeOverrides.forEach(cgr -> {
            if (!bottomPercents.containsKey(cgr.getEnteredGrade())) {
                throw new UnmappableCourseGradeOverrideException("The grading schema could not be updated as it would leave some course grade overrides in an unmappable state.");
            }
        });
        Set gradeMappings = gradebook.getGradeMappings();
        gradeMappings.forEach(gradeMapping -> {
            if (StringUtils.equals((CharSequence)Long.toString(gradeMapping.getId()), (CharSequence)gbInfo.getSelectedGradeMappingId())) {
                gradebook.setSelectedGradeMapping(gradeMapping);
                this.updateGradeMapping(gradeMapping.getId(), bottomPercents);
            }
        });
        boolean gradeTypeAvailForNonAdmins = this.serverConfigService.getBoolean("gradebook.settings.gradeEntry.showToNonAdmins", true);
        if (gradeTypeAvailForNonAdmins || SecurityService.isSuperUser()) {
            gradebook.setGrade_type(gbInfo.getGradeType());
        }
        gradebook.setCategory_type(gbInfo.getCategoryType());
        gradebook.setAssignmentsDisplayed(gbInfo.isDisplayReleasedGradeItemsToStudents());
        gradebook.setCourseGradeDisplayed(gbInfo.isCourseGradeDisplayed());
        gradebook.setCourseLetterGradeDisplayed(gbInfo.isCourseLetterGradeDisplayed());
        gradebook.setCoursePointsDisplayed(gbInfo.isCoursePointsDisplayed());
        gradebook.setCourseAverageDisplayed(gbInfo.isCourseAverageDisplayed());
        gradebook.setAssignmentStatsDisplayed(gbInfo.isAssignmentStatsDisplayed());
        gradebook.setCourseGradeStatsDisplayed(gbInfo.isCourseGradeStatsDisplayed());
        List newCategoryDefinitions = gbInfo.getCategories();
        if (gradebook.getCategory_type() == 3) {
            double totalWeight = 0.0;
            for (CategoryDefinition newDef : newCategoryDefinitions) {
                if (newDef.getWeight() == null) {
                    throw new IllegalArgumentException("No weight specified for a category, but weightings enabled");
                }
                totalWeight += newDef.getWeight().doubleValue();
            }
            if (Math.rint(totalWeight) != 1.0) {
                throw new IllegalArgumentException("Weightings for the categories do not equal 100%");
            }
        }
        List currentCategories = this.getCategories(gradebook.getId());
        HashMap<Long, Category> currentCategoryMap = new HashMap<Long, Category>();
        for (Category c : currentCategories) {
            currentCategoryMap.put(c.getId(), c);
        }
        Collections.sort(newCategoryDefinitions, CategoryDefinition.orderComparator);
        HashMap<CategoryDefinition, Integer> newCategories = new HashMap<CategoryDefinition, Integer>();
        int categoryIndex = 0;
        for (CategoryDefinition categoryDefinition : newCategoryDefinitions) {
            if (StringUtils.isBlank((CharSequence)categoryDefinition.getName())) continue;
            if (categoryDefinition.getId() == null) {
                newCategories.put(categoryDefinition, categoryIndex);
                ++categoryIndex;
                continue;
            }
            Category existing = (Category)currentCategoryMap.get(categoryDefinition.getId());
            existing.setName(categoryDefinition.getName());
            existing.setWeight(categoryDefinition.getWeight());
            existing.setDropLowest(categoryDefinition.getDropLowest());
            existing.setDropHighest(categoryDefinition.getDropHighest());
            existing.setKeepHighest(categoryDefinition.getKeepHighest());
            existing.setExtraCredit(categoryDefinition.getExtraCredit());
            existing.setEqualWeightAssignments(categoryDefinition.getEqualWeight());
            existing.setCategoryOrder(Integer.valueOf(categoryIndex));
            this.updateCategory(existing);
            currentCategoryMap.remove(categoryDefinition.getId());
            ++categoryIndex;
        }
        for (Map.Entry entry : currentCategoryMap.entrySet()) {
            this.removeCategory((Long)entry.getKey());
        }
        for (Map.Entry entry : newCategories.entrySet()) {
            CategoryDefinition newCat = (CategoryDefinition)entry.getKey();
            this.createCategory(gradebook.getId(), newCat.getName(), newCat.getWeight(), newCat.getDropLowest(), newCat.getDropHighest(), newCat.getKeepHighest(), newCat.getExtraCredit(), newCat.getEqualWeight(), (Integer)entry.getValue());
        }
        if (gradebook.getCategory_type() == 3) {
            this.excludeUncategorisedItemsFromCourseGradeCalculations(gradebook);
        }
        this.updateGradebook(gradebook);
    }

    public Authz getAuthz() {
        return this.authz;
    }

    public void setAuthz(Authz authz) {
        this.authz = authz;
    }

    public GradebookPermissionService getGradebookPermissionService() {
        return this.gradebookPermissionService;
    }

    public void setGradebookPermissionService(GradebookPermissionService gradebookPermissionService) {
        this.gradebookPermissionService = gradebookPermissionService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public Set getGradebookGradeMappings(final Long gradebookId) {
        return (Set)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Set doInHibernate(Session session) throws HibernateException {
                Gradebook gradebook = (Gradebook)session.load(Gradebook.class, (Serializable)gradebookId);
                Hibernate.initialize((Object)gradebook.getGradeMappings());
                return gradebook.getGradeMappings();
            }
        });
    }

    public Set getGradebookGradeMappings(String gradebookUid) {
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        return this.getGradebookGradeMappings(gradebookId);
    }

    public void updateCourseGradeForStudent(String gradebookUid, final String studentUuid, String grade, String gradeScale) {
        CourseGradeRecord courseGradeRecord;
        if (!this.currentUserHasEditPerm(gradebookUid)) {
            log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to update course grade for student: {}", new Object[]{this.getUserUid(), gradebookUid, studentUuid});
            throw new GradebookSecurityException("You do not have permission to update course grades in " + gradebookUid);
        }
        final Gradebook gradebook = this.getGradebook(gradebookUid);
        if (gradebook == null) {
            throw new IllegalArgumentException("There is no gradebook associated with this id: " + gradebookUid);
        }
        LetterGradePercentMapping mapping = null;
        if (gradebook.getGrade_type() == 3) {
            mapping = this.getLetterGradePercentMapping(gradebook);
        }
        if ((courseGradeRecord = (CourseGradeRecord)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return GradebookServiceHibernateImpl.this.getCourseGradeRecord(gradebook, studentUuid);
            }
        })) == null) {
            org.sakaiproject.tool.gradebook.CourseGrade courseGrade = this.getCourseGrade(gradebook.getId());
            courseGradeRecord = new CourseGradeRecord(courseGrade, studentUuid);
            courseGradeRecord.setGraderId(this.getUserUid());
        } else {
            Double cGrade = this.convertInputGradeToPoints(gradebook.getGrade_type(), mapping, courseGradeRecord.getTotalPointsPossible(), grade);
            if (courseGradeRecord.getPointsEarned() != null && cGrade != null && StringUtils.equals((CharSequence)courseGradeRecord.getPointsEarned().toString(), (CharSequence)cGrade.toString())) {
                return;
            }
        }
        courseGradeRecord.setEnteredGrade(gradeScale);
        Double convertedGrade = this.convertInputGradeToPoints(gradebook.getGrade_type(), mapping, courseGradeRecord.getTotalPointsPossible(), grade);
        courseGradeRecord.setPointsEarned(convertedGrade);
        courseGradeRecord.setDateRecorded(new Date());
        GradingEvent gradingEvent = new GradingEvent((GradableObject)courseGradeRecord.getCourseGrade(), this.getUserUid(), studentUuid, (Object)courseGradeRecord.getEnteredGrade());
        this.getHibernateTemplate().saveOrUpdate((Object)courseGradeRecord);
        this.getHibernateTemplate().saveOrUpdate((Object)gradingEvent);
    }

    private List<GradeMappingDefinition> getGradebookGradeMappings(Set<GradeMapping> gradeMappings) {
        ArrayList<GradeMappingDefinition> rval = new ArrayList<GradeMappingDefinition>();
        for (GradeMapping mapping : gradeMappings) {
            rval.add(new GradeMappingDefinition(mapping.getId(), mapping.getName(), GradeMappingDefinition.sortGradeMapping((Map)mapping.getGradeMap()), GradeMappingDefinition.sortGradeMapping((Map)mapping.getDefaultBottomPercents())));
        }
        return rval;
    }

    /*
     * WARNING - void declaration
     */
    public void updateAssignmentCategorizedOrder(String gradebookUid, Long categoryId, Long assignmentId, Integer order) {
        if (!this.getAuthz().isUserAbleToEditAssessments(gradebookUid)) {
            log.error("AUTHORIZATION FAILURE: User {} in gradebook {} attempted to change the order of assignment {}", new Object[]{this.getUserUid(), gradebookUid, assignmentId});
            throw new GradebookSecurityException();
        }
        if (order == null) {
            throw new IllegalArgumentException("Categorized Order cannot be null");
        }
        Long gradebookId = this.getGradebook(gradebookUid).getId();
        List assignments = this.getAssignments(gradebookId, SortType.SORT_BY_CATEGORY, true);
        ArrayList<Object> assignmentsInNewCategory = new ArrayList<Object>();
        for (Object assignment : assignments) {
            if (assignment.getCategory() == null) {
                if (categoryId != null) continue;
                assignmentsInNewCategory.add(assignment);
                continue;
            }
            if (!assignment.getCategory().getId().equals(categoryId)) continue;
            assignmentsInNewCategory.add(assignment);
        }
        if (order < 0) {
            order = 0;
        } else if (order > assignmentsInNewCategory.size()) {
            order = assignmentsInNewCategory.size();
        }
        GradebookAssignment target = null;
        for (GradebookAssignment gradebookAssignment : assignmentsInNewCategory) {
            if (!gradebookAssignment.getId().equals(assignmentId)) continue;
            target = gradebookAssignment;
            break;
        }
        assignmentsInNewCategory.add(null);
        assignmentsInNewCategory.remove(target);
        assignmentsInNewCategory.add(order, target);
        ArrayList<GradebookAssignment> assignmentsToUpdate = new ArrayList<GradebookAssignment>();
        boolean bl = false;
        for (GradebookAssignment gradebookAssignment : assignmentsInNewCategory) {
            void var10_12;
            if (gradebookAssignment == null) continue;
            if (gradebookAssignment.getCategorizedSortOrder() == null || !gradebookAssignment.getCategorizedSortOrder().equals((int)var10_12)) {
                gradebookAssignment.setCategorizedSortOrder(Integer.valueOf((int)var10_12));
                assignmentsToUpdate.add(gradebookAssignment);
            }
            ++var10_12;
        }
        for (final GradebookAssignment gradebookAssignment : assignmentsToUpdate) {
            this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    GradebookServiceHibernateImpl.this.updateAssignment(gradebookAssignment);
                    return null;
                }
            });
        }
    }

    public List<GradingEvent> getGradingEvents(List<Long> assignmentIds, Date since) {
        if (assignmentIds == null || assignmentIds.isEmpty() || since == null) {
            return new ArrayList<GradingEvent>();
        }
        return (List)this.getHibernateTemplate().execute(session -> session.createCriteria(GradingEvent.class).createAlias("gradableObject", "go").add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)"dateGraded", (Object)since), (Criterion)HibernateCriterionUtils.CriterionInRestrictionSplitter((String)"go.id", (Collection)assignmentIds))).list());
    }

    private void scaleGrades(Gradebook gradebook, GradebookAssignment assignment, Double originalPointsPossible) {
        if (gradebook == null || assignment == null || assignment.getPointsPossible() == null) {
            throw new IllegalArgumentException("null values found in convertGradePointsForUpdatedTotalPoints.");
        }
        List<String> studentUids = this.getStudentsForGradebook(gradebook);
        List gradeRecords = this.getAllAssignmentGradeRecordsForGbItem(assignment.getId(), studentUids);
        HashSet<GradingEvent> eventsToAdd = new HashSet<GradingEvent>();
        String currentUserUid = this.getAuthn().getUserUid();
        if (gradebook.getGrade_type() == 2 && assignment.getPointsPossible() != null) {
            log.debug("Scaling percentage grades");
            for (AssignmentGradeRecord gr : gradeRecords) {
                if (gr.getPointsEarned() == null) continue;
                BigDecimal scoreAsPercentage = new BigDecimal(gr.getPointsEarned()).divide(new BigDecimal(originalPointsPossible), GradebookService.MATH_CONTEXT).multiply(new BigDecimal(100));
                BigDecimal scaledScore = new BigDecimal(this.calculateEquivalentPointValueForPercent(assignment.getPointsPossible(), scoreAsPercentage.doubleValue()), GradebookService.MATH_CONTEXT).setScale(2, RoundingMode.HALF_UP);
                log.debug("scoreAsPercentage: {}, scaledScore: {}", (Object)scoreAsPercentage, (Object)scaledScore);
                gr.setPointsEarned(Double.valueOf(scaledScore.doubleValue()));
                eventsToAdd.add(new GradingEvent((GradableObject)assignment, currentUserUid, gr.getStudentId(), (Object)scaledScore));
            }
        } else if (gradebook.getGrade_type() == 1 && assignment.getPointsPossible() != null) {
            log.debug("Scaling point grades");
            BigDecimal previous = new BigDecimal(originalPointsPossible);
            BigDecimal current = new BigDecimal(assignment.getPointsPossible());
            BigDecimal factor = current.divide(previous, GradebookService.MATH_CONTEXT);
            log.debug("previous points possible: {}, current points possible: {}, factor: {}", new Object[]{previous, current, factor});
            for (AssignmentGradeRecord gr : gradeRecords) {
                if (gr.getPointsEarned() == null) continue;
                BigDecimal currentGrade = new BigDecimal(gr.getPointsEarned(), GradebookService.MATH_CONTEXT);
                BigDecimal scaledGrade = currentGrade.multiply(factor, GradebookService.MATH_CONTEXT).setScale(2, RoundingMode.HALF_UP);
                log.debug("currentGrade: {}, scaledGrade: {}", (Object)currentGrade, (Object)scaledGrade);
                gr.setPointsEarned(Double.valueOf(scaledGrade.doubleValue()));
                DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(new ResourceLoader().getLocale());
                df.setGroupingUsed(false);
                String pointsLocale = df.format(scaledGrade);
                eventsToAdd.add(new GradingEvent((GradableObject)assignment, currentUserUid, gr.getStudentId(), (Object)pointsLocale));
            }
        }
        this.batchPersistEntities(gradeRecords);
        for (GradingEvent ge : eventsToAdd) {
            this.getHibernateTemplate().persist((Object)ge);
        }
    }

    private List<String> getStudentsForGradebook(Gradebook gradebook) {
        List enrolments = this.getSectionAwareness().getSiteMembersInRole(gradebook.getUid(), Role.STUDENT);
        List<String> rval = enrolments.stream().map(ParticipationRecord::getUser).map(User::getUserUid).collect(Collectors.toList());
        return rval;
    }

    private void batchPersistEntities(List<?> entities) {
        Session session = this.getSessionFactory().getCurrentSession();
        entities.forEach(arg_0 -> ((Session)session).update(arg_0));
    }

    private boolean isCurrentUserFromGroup(String gradebookUid, String studentId) {
        boolean isFromGroup = false;
        try {
            Site s = this.siteService.getSite(gradebookUid);
            Group g = s.getGroup(studentId);
            isFromGroup = g != null && g.getMember(this.authn.getUserUid()) != null;
        }
        catch (Exception e) {
            log.error("Error in isCurrentUserFromGroup: ", (Throwable)e);
        }
        return isFromGroup;
    }

    private void excludeUncategorisedItemsFromCourseGradeCalculations(Gradebook gradebook) {
        List<GradebookAssignment> allAssignments = this.getAssignments(gradebook.getId());
        List<GradebookAssignment> assignments = allAssignments.stream().filter(a -> a.getCategory() == null).collect(Collectors.toList());
        assignments.forEach(a -> a.setCounted(false));
        this.batchPersistEntities(assignments);
    }

    public void setServerConfigService(ServerConfigurationService serverConfigService) {
        this.serverConfigService = serverConfigService;
    }

    public RubricsService getRubricsService() {
        return this.rubricsService;
    }

    public void setRubricsService(RubricsService rubricsService) {
        this.rubricsService = rubricsService;
    }
}

