/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook.facades.sakai2impl;

import java.util.List;
import org.sakaiproject.authz.cover.FunctionManager;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.section.api.facade.Role;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.gradebook.facades.Authz;
import org.sakaiproject.tool.gradebook.facades.sections.AuthzSectionsImpl;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzSakai2Impl
extends AuthzSectionsImpl
implements Authz {
    private static final Logger log = LoggerFactory.getLogger(AuthzSakai2Impl.class);

    public void init() {
        List registered = FunctionManager.getInstance().getRegisteredFunctions("gradebook");
        if (!registered.contains("gradebook.gradeAll")) {
            FunctionManager.registerFunction((String)"gradebook.gradeAll");
        }
        if (!registered.contains("gradebook.gradeSection")) {
            FunctionManager.registerFunction((String)"gradebook.gradeSection");
        }
        if (!registered.contains("gradebook.editAssignments")) {
            FunctionManager.registerFunction((String)"gradebook.editAssignments");
        }
        if (!registered.contains("gradebook.viewOwnGrades")) {
            FunctionManager.registerFunction((String)"gradebook.viewOwnGrades");
        }
        if (!registered.contains("gradebook.viewStudentNumbers")) {
            FunctionManager.registerFunction((String)"gradebook.viewStudentNumbers");
        }
    }

    @Override
    public boolean isUserAbleToGrade(String gradebookUid) {
        return this.hasPermission(gradebookUid, "gradebook.gradeAll") || this.hasPermission(gradebookUid, "gradebook.gradeSection");
    }

    @Override
    public boolean isUserAbleToGrade(String gradebookUid, String userUid) {
        try {
            User user = UserDirectoryService.getUser((String)userUid);
            return this.hasPermission(user, gradebookUid, "gradebook.gradeAll") || this.hasPermission(user, gradebookUid, "gradebook.gradeSection");
        }
        catch (UserNotDefinedException unde) {
            log.warn("User not found for userUid: " + userUid);
            return false;
        }
    }

    @Override
    public boolean isUserAbleToGradeAll(String gradebookUid) {
        return this.hasPermission(gradebookUid, "gradebook.gradeAll");
    }

    @Override
    public boolean isUserAbleToGradeAll(String gradebookUid, String userUid) {
        try {
            User user = UserDirectoryService.getUser((String)userUid);
            return this.hasPermission(user, gradebookUid, "gradebook.gradeAll");
        }
        catch (UserNotDefinedException unde) {
            log.warn("User not found for userUid: " + userUid);
            return false;
        }
    }

    public boolean isUserAbleToGradeSection(String sectionUid) {
        return this.getSectionAwareness().isSectionMemberInRole(sectionUid, this.getAuthn().getUserUid(), Role.TA);
    }

    @Override
    public boolean isUserAbleToEditAssessments(String gradebookUid) {
        return this.hasPermission(gradebookUid, "gradebook.editAssignments");
    }

    @Override
    public boolean isUserAbleToViewOwnGrades(String gradebookUid) {
        return this.hasPermission(gradebookUid, "gradebook.viewOwnGrades");
    }

    @Override
    public boolean isUserAbleToViewStudentNumbers(String gradebookUid) {
        return this.hasPermission(gradebookUid, "gradebook.viewStudentNumbers");
    }

    private boolean hasPermission(String gradebookUid, String permission) {
        return SecurityService.unlock((String)permission, (String)SiteService.siteReference((String)gradebookUid));
    }

    private boolean hasPermission(User user, String gradebookUid, String permission) {
        return SecurityService.unlock((User)user, (String)permission, (String)SiteService.siteReference((String)gradebookUid));
    }
}

