/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.emailtemplateservice.tool.producers;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.emailtemplateservice.model.EmailTemplate;
import org.sakaiproject.emailtemplateservice.service.EmailTemplateService;
import org.sakaiproject.emailtemplateservice.service.external.ExternalLogic;
import org.sakaiproject.emailtemplateservice.tool.params.EmailTemplateViewParams;
import uk.org.ponder.messageutil.TargettedMessage;
import uk.org.ponder.messageutil.TargettedMessageList;
import uk.org.ponder.rsf.components.UIBoundString;
import uk.org.ponder.rsf.components.UIBranchContainer;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIInternalLink;
import uk.org.ponder.rsf.components.UIMessage;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.DefaultView;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.ViewParameters;

public class MainViewProducer
implements ViewComponentProducer,
DefaultView {
    public static final String VIEW_ID = "main";
    private static Log log = LogFactory.getLog(MainViewProducer.class);
    private EmailTemplateService emailTemplateService;
    private ExternalLogic externalLogic;
    private TargettedMessageList messages;

    public String getViewID() {
        return VIEW_ID;
    }

    public void setEmailTemplateService(EmailTemplateService ets) {
        this.emailTemplateService = ets;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void setMessages(TargettedMessageList messages) {
        this.messages = messages;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker checker) {
        if (!this.externalLogic.isSuperUser()) {
            this.messages.addMessage(new TargettedMessage("tool.notAdmin", new Object[0], 1));
            return;
        }
        UIBranchContainer navIntra = UIBranchContainer.make((UIContainer)tofill, (String)"navintra:");
        UIInternalLink.make((UIContainer)navIntra, (String)"actions-add", (UIBoundString)UIMessage.make((String)"mainview.new"), (ViewParameters)new EmailTemplateViewParams("modify_email", null));
        UIBranchContainer table = UIBranchContainer.make((UIContainer)tofill, (String)"table:");
        List templates = this.emailTemplateService.getEmailTemplates(0, 0);
        for (int i = 0; i < templates.size(); ++i) {
            EmailTemplate template = (EmailTemplate)templates.get(i);
            log.debug((Object)("got template: " + template.getKey()));
            UIBranchContainer row = UIBranchContainer.make((UIContainer)table, (String)"template-row:", (String)template.getId().toString());
            UIOutput.make((UIContainer)row, (String)"template-key", (String)template.getKey());
            String locale = template.getLocale();
            if (locale == null) {
                locale = "";
            }
            UIOutput.make((UIContainer)row, (String)"template-locale", (String)locale);
            UIInternalLink.make((UIContainer)row, (String)"template-edit", (UIBoundString)UIMessage.make((String)"mainview.edit"), (ViewParameters)new EmailTemplateViewParams("modify_email", template.getId().toString()));
        }
    }
}

