/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.emailtemplateservice.tool.producers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.emailtemplateservice.model.EmailTemplate;
import org.sakaiproject.emailtemplateservice.service.EmailTemplateService;
import org.sakaiproject.emailtemplateservice.service.external.ExternalLogic;
import org.sakaiproject.emailtemplateservice.tool.params.EmailTemplateViewParams;
import org.sakaiproject.user.api.UserDirectoryService;
import uk.org.ponder.messageutil.TargettedMessage;
import uk.org.ponder.messageutil.TargettedMessageList;
import uk.org.ponder.rsf.components.UIBoundString;
import uk.org.ponder.rsf.components.UICommand;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIELBinding;
import uk.org.ponder.rsf.components.UIForm;
import uk.org.ponder.rsf.components.UIInput;
import uk.org.ponder.rsf.components.UIMessage;
import uk.org.ponder.rsf.components.UIVerbatim;
import uk.org.ponder.rsf.flow.ARIResult;
import uk.org.ponder.rsf.flow.ActionResultInterceptor;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.SimpleViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParamsReporter;

public class ModifyEmailProducer
implements ViewComponentProducer,
ViewParamsReporter,
ActionResultInterceptor {
    private static Log log = LogFactory.getLog(ModifyEmailProducer.class);
    public static final String VIEW_ID = "modify_email";
    private EmailTemplateService emailTemplateService;
    private ExternalLogic externalLogic;
    private UserDirectoryService userDirectoryService;
    private TargettedMessageList messages;
    private String emailTemplateLocator = "EmailTemplateLocator.";

    public String getViewID() {
        return VIEW_ID;
    }

    public void setEmailTemplateService(EmailTemplateService ets) {
        this.emailTemplateService = ets;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void setUserDirectoryService(UserDirectoryService uds) {
        this.userDirectoryService = uds;
    }

    public void setMessages(TargettedMessageList messages) {
        this.messages = messages;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker checker) {
        if (!this.externalLogic.isSuperUser()) {
            this.messages.addMessage(new TargettedMessage("tool.notAdmin", new Object[0], 1));
            return;
        }
        EmailTemplateViewParams emailViewParams = (EmailTemplateViewParams)viewparams;
        String actionBean = "EmailTemplateLocator.";
        EmailTemplate template = null;
        boolean newEmailTemplate = true;
        String emailTemplateId = "new 1";
        if (emailViewParams.id == null) {
            log.debug((Object)"this is a new tamplate");
            template = new EmailTemplate();
        } else {
            emailTemplateId = emailViewParams.id;
            template = this.emailTemplateService.getEmailTemplateById(Long.valueOf(emailTemplateId));
            newEmailTemplate = false;
        }
        String emailTemplateOTP = this.emailTemplateLocator + emailTemplateId + ".";
        String headerName = template.getKey();
        if (template.getLocale() != null && !template.getLocale().trim().equals("")) {
            headerName = headerName + " (" + template.getLocale() + ")";
        }
        if (!newEmailTemplate) {
            UIMessage.make((UIContainer)tofill, (String)"modify-template-header", (String)"modifyemail.modify.template.header", (Object[])new Object[]{headerName});
        } else {
            UIMessage.make((UIContainer)tofill, (String)"modify-template-header", (String)"modifyemail.new.template.header");
        }
        UIVerbatim.make((UIContainer)tofill, (String)"email_templates_fieldhints", (Object)UIMessage.make((String)"email.templates.field.names"));
        UIForm form = UIForm.make((UIContainer)tofill, (String)"emailTemplateForm");
        String actionBinding = null;
        actionBinding = actionBean + "saveAll";
        if (template.getId() != null) {
            // empty if block
        }
        UIMessage.make((UIContainer)tofill, (String)"closeWindow", (String)"general.close.window.button");
        if (!newEmailTemplate) {
            UICommand resetCommand = UICommand.make((UIContainer)form, (String)"resetEmailTemplate", (UIBoundString)UIMessage.make((String)"modifyemail.reset.to.default.link"), (String)(actionBean + "resetToDefaultEmailTemplate"));
        }
        UIInput.make((UIContainer)form, (String)"emailSubject", (String)(emailTemplateOTP + "subject"), (String)template.getSubject());
        UIInput.make((UIContainer)form, (String)"emailFrom", (String)(emailTemplateOTP + "from"), (String)template.getFrom());
        UIInput.make((UIContainer)form, (String)"emailKey", (String)(emailTemplateOTP + "key"), (String)template.getKey());
        UIInput.make((UIContainer)form, (String)"emailLocale", (String)(emailTemplateOTP + "locale"), (String)template.getLocale());
        UIInput.make((UIContainer)form, (String)"emailMessage", (String)(emailTemplateOTP + "message"), (String)template.getMessage());
        UIInput.make((UIContainer)form, (String)"emailHtmlMessage", (String)(emailTemplateOTP + "htmlMessage"), (String)template.getHtmlMessage());
        form.parameters.add((Object)new UIELBinding(emailTemplateOTP + "owner", (Object)this.userDirectoryService.getCurrentUser().getId()));
        UICommand.make((UIContainer)form, (String)"saveEmailTemplate", (UIBoundString)UIMessage.make((String)"modifyemail.save.changes.link"), (String)actionBinding);
    }

    public void interceptActionResult(ARIResult result, ViewParameters incoming, Object actionReturn) {
        EmailTemplateViewParams evp = (EmailTemplateViewParams)incoming;
        EmailTemplateViewParams outgoing = (EmailTemplateViewParams)evp.copyBase();
        result.resultingView = "success".equals(actionReturn) || "successAssign".equals(actionReturn) || "successReset".equals(actionReturn) ? outgoing : ("failure".equals(actionReturn) ? outgoing : new SimpleViewParameters("main"));
    }

    public ViewParameters getViewParameters() {
        return new EmailTemplateViewParams();
    }
}

