/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.emailtemplateservice.tool.locators;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.emailtemplateservice.model.EmailTemplate;
import org.sakaiproject.emailtemplateservice.service.EmailTemplateService;
import uk.org.ponder.beanutil.WriteableBeanLocator;
import uk.org.ponder.messageutil.TargettedMessage;
import uk.org.ponder.messageutil.TargettedMessageList;

public class EmailTemplateLocator
implements WriteableBeanLocator {
    private static Log log = LogFactory.getLog(EmailTemplateLocator.class);
    public static final String NEW_PREFIX = "new ";
    public static final String NEW_1 = "new 1";
    private Map delivered = new HashMap();
    private EmailTemplateService emailTemplateService;
    private TargettedMessageList messages;

    public void setEmailTemplateService(EmailTemplateService ets) {
        this.emailTemplateService = ets;
    }

    public void setMessages(TargettedMessageList messages) {
        this.messages = messages;
    }

    public Object locateBean(String name) {
        Object togo = this.delivered.get(name);
        if (togo == null) {
            if (name.startsWith(NEW_PREFIX)) {
                togo = new EmailTemplate();
            } else {
                log.info((Object)("looking for template: " + name));
                Long emailTemplateId = Long.valueOf(name);
                togo = this.emailTemplateService.getEmailTemplateById(emailTemplateId);
            }
            this.delivered.put(name, togo);
        }
        return togo;
    }

    public boolean remove(String beanname) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void set(String beanname, Object toset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String saveAll() {
        log.debug((Object)"Saving all!");
        for (String key : this.delivered.keySet()) {
            log.debug((Object)("got key: " + key));
            EmailTemplate emailTemplate = (EmailTemplate)this.delivered.get(key);
            if (key.startsWith(NEW_PREFIX) && emailTemplate.getLocale() == null) {
                emailTemplate.setLocale("");
            }
            if (emailTemplate.getKey() == null) {
                this.messages.addMessage(new TargettedMessage("error.nokey", new Object[0], 1));
            }
            if (emailTemplate.getSubject() == null) {
                this.messages.addMessage(new TargettedMessage("error.nosubject", new Object[0], 1));
            }
            if (emailTemplate.getMessage() == null) {
                this.messages.addMessage(new TargettedMessage("error.nomessage", new Object[0], 1));
            }
            if (this.messages.isError()) {
                return "failure";
            }
            this.emailTemplateService.saveTemplate(emailTemplate);
            this.messages.addMessage(new TargettedMessage("template.saved.message", new Object[]{emailTemplate.getKey(), emailTemplate.getLocale()}, 0));
        }
        return "success";
    }
}

