/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.endorsed.i18n.spi;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.util.Locale;
import org.sakaiproject.endorsed.i18n.spi.SakaiLocaleServiceProviderUtil;

public class SakaiDateFormatProvider
extends DateFormatProvider {
    @Override
    public Locale[] getAvailableLocales() {
        return SakaiLocaleServiceProviderUtil.getAvailableLocales();
    }

    @Override
    public DateFormat getDateInstance(int style, Locale locale) throws IllegalArgumentException, NullPointerException {
        return new SimpleDateFormat(this.getDateFormatString(style, locale), locale);
    }

    @Override
    public DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) throws IllegalArgumentException, NullPointerException {
        return new SimpleDateFormat(this.getDateFormatString(dateStyle, locale) + " " + this.getTimeFormatString(timeStyle, locale), locale);
    }

    @Override
    public DateFormat getTimeInstance(int style, Locale locale) throws IllegalArgumentException, NullPointerException {
        SimpleDateFormat dateFormat = null;
        String format = this.getTimeFormatString(style, locale);
        if (format != null) {
            dateFormat = new SimpleDateFormat(format, locale);
        }
        return dateFormat;
    }

    protected String getDateFormatString(int style, Locale locale) throws IllegalArgumentException, NullPointerException {
        String key;
        if (locale == null) {
            throw new NullPointerException("locale:null");
        }
        if (!SakaiLocaleServiceProviderUtil.isAvailableLocale(locale)) {
            throw new IllegalArgumentException("locale:" + locale.toString());
        }
        switch (style) {
            case 3: {
                key = "DateFormat.SHORT";
                break;
            }
            case 2: {
                key = "DateFormat.MEDIUM";
                break;
            }
            case 1: {
                key = "DateFormat.LONG";
                break;
            }
            case 0: {
                key = "DateFormat.FULL";
                break;
            }
            default: {
                throw new IllegalArgumentException("style:" + style);
            }
        }
        return SakaiLocaleServiceProviderUtil.getString(key, locale);
    }

    protected String getTimeFormatString(int style, Locale locale) throws IllegalArgumentException, NullPointerException {
        String key;
        if (locale == null) {
            throw new NullPointerException("locale:null");
        }
        if (!SakaiLocaleServiceProviderUtil.isAvailableLocale(locale)) {
            throw new IllegalArgumentException("locale:" + locale.toString());
        }
        switch (style) {
            case 3: {
                key = "TimeFormat.SHORT";
                break;
            }
            case 2: {
                key = "TimeFormat.MEDIUM";
                break;
            }
            case 1: {
                key = "TimeFormat.LONG";
                break;
            }
            case 0: {
                key = "TimeFormat.FULL";
                break;
            }
            default: {
                throw new IllegalArgumentException("style:" + style);
            }
        }
        return SakaiLocaleServiceProviderUtil.getString(key, locale);
    }
}

