/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.endorsed.i18n.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;

public final class SakaiLocaleServiceProviderUtil {
    private static final Logger log;
    private static final Set<Locale> LOCALES;

    private SakaiLocaleServiceProviderUtil() {
    }

    public static Locale[] getAvailableLocales() {
        return LOCALES.toArray(new Locale[0]);
    }

    public static boolean isAvailableLocale(Locale locale) {
        boolean isAvailable = false;
        if (SakaiLocaleServiceProviderUtil.getBundle(locale) != null) {
            isAvailable = true;
        }
        return isAvailable;
    }

    public static String getString(String key, Locale locale) {
        ResourceBundle rb;
        String value = null;
        if (key != null && (rb = SakaiLocaleServiceProviderUtil.getBundle(locale)) != null) {
            value = rb.getString(key);
        }
        return value;
    }

    public static char getChar(String key, Locale locale) {
        char value = '\u0000';
        String str = SakaiLocaleServiceProviderUtil.getString(key, locale);
        if (str != null && !str.isEmpty()) {
            value = str.charAt(0);
        }
        return value;
    }

    public static boolean containsKey(String key, Locale locale) {
        ResourceBundle rb;
        boolean contain = false;
        if (key != null && (rb = SakaiLocaleServiceProviderUtil.getBundle(locale)) != null) {
            contain = rb.containsKey(key);
        }
        return contain;
    }

    private static ResourceBundle getBundle(Locale locale) {
        ResourceBundle rb = null;
        if (locale != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                rb = ResourceBundle.getBundle("SakaiLocaleServiceProvider", locale, loader);
            }
            catch (MissingResourceException e) {
                log.warning(e.getMessage());
            }
        }
        return rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String value;
        log = Logger.getLogger("global");
        LOCALES = new HashSet<Locale>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream inStream = loader.getResourceAsStream("SakaiLocaleServiceProvider.config");
        Properties props = new Properties();
        if (inStream != null) {
            try {
                props.load(inStream);
            }
            catch (IOException e) {
                log.warning(e.getMessage());
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.warning(e.getMessage());
                }
            }
        }
        if ((value = props.getProperty("locales")) != null) {
            String[] locales;
            for (String localeStr : locales = value.split(",")) {
                String[] params = localeStr.trim().split("_", 3);
                Locale locale = null;
                if (params.length == 1) {
                    locale = new Locale(params[0]);
                } else if (params.length == 2) {
                    locale = new Locale(params[0], params[1]);
                } else if (params.length == 3) {
                    locale = new Locale(params[0], params[1], params[2]);
                }
                LOCALES.add(locale);
            }
        }
    }
}

