/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.endorsed.i18n.spi;

import java.text.DecimalFormatSymbols;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.util.Locale;
import org.sakaiproject.endorsed.i18n.spi.SakaiLocaleServiceProviderUtil;

public class SakaiDecimalFormatSymbolsProvider
extends DecimalFormatSymbolsProvider {
    @Override
    public Locale[] getAvailableLocales() {
        return SakaiLocaleServiceProviderUtil.getAvailableLocales();
    }

    @Override
    public DecimalFormatSymbols getInstance(Locale locale) throws IllegalArgumentException, NullPointerException {
        if (locale == null) {
            throw new NullPointerException("locale:null");
        }
        if (!SakaiLocaleServiceProviderUtil.isAvailableLocale(locale)) {
            throw new IllegalArgumentException("locale:" + locale.toString());
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(SakaiLocaleServiceProviderUtil.getChar("DecimalSeparator", locale));
        symbols.setDigit(SakaiLocaleServiceProviderUtil.getChar("Digit", locale));
        symbols.setExponentSeparator(SakaiLocaleServiceProviderUtil.getString("ExponentSeparator", locale));
        symbols.setGroupingSeparator(SakaiLocaleServiceProviderUtil.getChar("GroupingSeparator", locale));
        symbols.setInfinity(SakaiLocaleServiceProviderUtil.getString("Infinity", locale));
        symbols.setInternationalCurrencySymbol(SakaiLocaleServiceProviderUtil.getString("InternationalCurrencySymbol", locale));
        symbols.setCurrencySymbol(SakaiLocaleServiceProviderUtil.getString("CurrencySymbol", locale));
        symbols.setMinusSign(SakaiLocaleServiceProviderUtil.getChar("MinusSign", locale));
        symbols.setMonetaryDecimalSeparator(SakaiLocaleServiceProviderUtil.getChar("MonetaryDecimalSeparator", locale));
        symbols.setNaN(SakaiLocaleServiceProviderUtil.getString("NaN", locale));
        symbols.setPatternSeparator(SakaiLocaleServiceProviderUtil.getChar("PatternSeparator", locale));
        symbols.setPercent(SakaiLocaleServiceProviderUtil.getChar("Percent", locale));
        symbols.setPerMill(SakaiLocaleServiceProviderUtil.getChar("PerMill", locale));
        symbols.setZeroDigit(SakaiLocaleServiceProviderUtil.getChar("ZeroDigit", locale));
        return symbols;
    }
}

