/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.endorsed.i18n.spi;

import java.util.Locale;
import java.util.spi.LocaleNameProvider;
import org.sakaiproject.endorsed.i18n.spi.SakaiLocaleServiceProviderUtil;

public class SakaiLocaleNameProvider
extends LocaleNameProvider {
    @Override
    public Locale[] getAvailableLocales() {
        return SakaiLocaleServiceProviderUtil.getAvailableLocales();
    }

    @Override
    public String getDisplayCountry(String countryCode, Locale locale) throws IllegalArgumentException, NullPointerException {
        if (countryCode == null) {
            throw new NullPointerException("countryCode:null");
        }
        if (!countryCode.matches("^[A-Z][A-Z]$")) {
            throw new IllegalArgumentException("countryCode:" + countryCode);
        }
        if (locale == null) {
            throw new NullPointerException("locale:null");
        }
        if (!SakaiLocaleServiceProviderUtil.isAvailableLocale(locale)) {
            throw new IllegalArgumentException("locale:" + locale.toString());
        }
        String displayCountry = null;
        String key = "Country." + countryCode;
        if (SakaiLocaleServiceProviderUtil.containsKey(key, locale)) {
            displayCountry = SakaiLocaleServiceProviderUtil.getString(key, locale);
        }
        return displayCountry;
    }

    @Override
    public String getDisplayLanguage(String languageCode, Locale locale) throws IllegalArgumentException, NullPointerException {
        if (languageCode == null) {
            throw new NullPointerException("languageCode:null");
        }
        if (!languageCode.matches("^[a-z][a-z]$")) {
            throw new IllegalArgumentException("languageCode:" + languageCode);
        }
        if (locale == null) {
            throw new NullPointerException("locale:null");
        }
        if (!SakaiLocaleServiceProviderUtil.isAvailableLocale(locale)) {
            throw new IllegalArgumentException("locale:" + locale.toString());
        }
        String displayLanguage = null;
        String key = "Language." + languageCode;
        if (SakaiLocaleServiceProviderUtil.containsKey(key, locale)) {
            displayLanguage = SakaiLocaleServiceProviderUtil.getString(key, locale);
        }
        return displayLanguage;
    }

    @Override
    public String getDisplayVariant(String variant, Locale locale) throws IllegalArgumentException, NullPointerException {
        if (variant == null) {
            throw new NullPointerException("variant:null");
        }
        if (locale == null) {
            throw new NullPointerException("locale:null");
        }
        if (!SakaiLocaleServiceProviderUtil.isAvailableLocale(locale)) {
            throw new IllegalArgumentException("locale:" + locale.toString());
        }
        String displayVariant = null;
        String key = "Variant." + variant;
        if (SakaiLocaleServiceProviderUtil.containsKey(key, locale)) {
            displayVariant = SakaiLocaleServiceProviderUtil.getString(key, locale);
        }
        return displayVariant;
    }
}

