/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.endorsed.i18n.spi;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.spi.NumberFormatProvider;
import java.util.Locale;
import org.sakaiproject.endorsed.i18n.spi.SakaiLocaleServiceProviderUtil;

public class SakaiNumberFormatProvider
extends NumberFormatProvider {
    @Override
    public Locale[] getAvailableLocales() {
        return SakaiLocaleServiceProviderUtil.getAvailableLocales();
    }

    @Override
    public NumberFormat getCurrencyInstance(Locale locale) throws IllegalArgumentException, NullPointerException {
        return this.getInstance("CurrencyPattern", locale);
    }

    @Override
    public NumberFormat getIntegerInstance(Locale locale) throws IllegalArgumentException, NullPointerException {
        NumberFormat format = this.getInstance("IntegerPattern", locale);
        format.setParseIntegerOnly(true);
        return format;
    }

    @Override
    public NumberFormat getNumberInstance(Locale locale) throws IllegalArgumentException, NullPointerException {
        return this.getInstance("NumberPattern", locale);
    }

    @Override
    public NumberFormat getPercentInstance(Locale locale) throws IllegalArgumentException, NullPointerException {
        return this.getInstance("PercentPattern", locale);
    }

    protected NumberFormat getInstance(String key, Locale locale) throws IllegalArgumentException, NullPointerException {
        if (locale == null) {
            throw new NullPointerException("locale:null");
        }
        if (!SakaiLocaleServiceProviderUtil.isAvailableLocale(locale)) {
            throw new IllegalArgumentException("locale:" + locale.toString());
        }
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(locale));
        String pattern = SakaiLocaleServiceProviderUtil.getString(key, locale);
        format.applyLocalizedPattern(pattern);
        return format;
    }
}

