/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.entitybroker.EntityBrokerManager;
import org.sakaiproject.entitybroker.access.HttpServletAccessProviderManager;
import org.sakaiproject.entitybroker.providers.EntityRequestHandler;
import org.sakaiproject.entitybroker.rest.EntityBrokerRESTServiceManager;
import org.sakaiproject.entitybroker.rest.EntityHandlerImpl;
import org.sakaiproject.entitybroker.util.servlet.DirectServlet;
import org.sakaiproject.tool.api.ActiveTool;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.ToolException;
import org.sakaiproject.tool.cover.ActiveToolManager;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.BasicAuth;
import org.sakaiproject.util.Validator;
import org.sakaiproject.util.Web;

public class SakaiDirectServlet
extends DirectServlet {
    private static final long serialVersionUID = 1L;
    private transient EntityBrokerRESTServiceManager entityRESTServiceManager;
    private transient BasicAuth basicAuth;

    public void initialize() {
        super.initialize();
        try {
            this.basicAuth = new BasicAuth();
            this.basicAuth.init();
        }
        catch (Exception e) {
            throw new IllegalStateException("FAILURE during init direct servlet", e);
        }
    }

    public String getCurrentLoggedInUserId() {
        return SessionManager.getCurrentSessionUserId();
    }

    public EntityRequestHandler initializeEntityRequestHandler() {
        EntityBrokerManager ebm = (EntityBrokerManager)ComponentManager.get((String)EntityBrokerManager.class.getName());
        HttpServletAccessProviderManager hsapm = (HttpServletAccessProviderManager)ComponentManager.get((String)HttpServletAccessProviderManager.class.getName());
        this.entityRESTServiceManager = new EntityBrokerRESTServiceManager(ebm, hsapm);
        EntityHandlerImpl erh = this.entityRESTServiceManager.getEntityRequestHandler();
        if (erh == null) {
            throw new RuntimeException("FAILED to load EntityRequestHandler");
        }
        return erh;
    }

    public void handleUserLogin(HttpServletRequest req, HttpServletResponse res, String path) {
        try {
            if (this.basicAuth.doAuth(req, res)) {
                return;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO Exception intercepted during logon ", ioe);
        }
        Session session = SessionManager.getCurrentSession();
        boolean helperURLSet = false;
        if (path != null) {
            helperURLSet = true;
            String returnURL = Web.returnUrl((HttpServletRequest)req, (String)Validator.escapeUrl((String)path));
            System.out.println("INFO: Direct Login: Setting session (" + session.getId() + ") helper URL (" + "sakai.tool.helper.done.url" + ") to " + returnURL);
            session.setAttribute("sakai.tool.helper.done.url", (Object)returnURL);
        }
        if (!helperURLSet && session.getAttribute("sakai.tool.helper.done.url") == null) {
            session.setAttribute("sakai.tool.helper.done.url", (Object)"/direct/describe");
            System.out.println("INFO: doLogin - no HELPER_DONE_URL found, proceeding with default HELPER_DONE_URL: /direct/describe");
        }
        ActiveTool tool = ActiveToolManager.getActiveTool((String)"sakai.login");
        String context = req.getContextPath() + req.getServletPath() + "/login";
        try {
            tool.help(req, res, context, "/login");
        }
        catch (ToolException e) {
            throw new RuntimeException("Failure attempting to use Sakai login helper: " + e.getMessage(), e);
        }
    }

    public void dispatch(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            this.basicAuth.doLogin(req);
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO Exception intercepted during basic auth: " + ioe, ioe);
        }
        super.dispatch(req, res);
    }
}

